/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

// Used to wrap start_empty_path_class see:
// https://docs.oracle.com/javase/8/docs/api/java/util/function/LongToIntFunction.html
import java.util.function.LongToIntFunction;

/**
 *  Base class of the local search operators dedicated to path modifications<br>
 *  (a path is a set of nodes linked together by arcs).<br>
 *  This family of neighborhoods supposes they are handling next variables<br>
 *  representing the arcs (var[i] represents the node immediately after i on<br>
 *  a path).<br>
 *  Several services are provided:<br>
 *  - arc manipulators (SetNext(), ReverseChain(), MoveChain())<br>
 *  - path inspectors (Next(), Prev(), IsPathEnd())<br>
 *  - path iterators: operators need a given number of nodes to define a<br>
 *    neighbor; this class provides the iteration on a given number of (base)<br>
 *    nodes which can be used to define a neighbor (through the BaseNode method)<br>
 *  Subclasses only need to override MakeNeighbor to create neighbors using<br>
 *  the services above (no direct manipulation of assignments).
 */
public class PathOperator extends IntVarLocalSearchOperator {
  private transient long swigCPtr;

  protected PathOperator(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.PathOperator_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PathOperator obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(PathOperator obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_PathOperator(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  protected void swigDirectorDisconnect() {
    swigCMemOwn = false;
    delete();
  }

  public void swigReleaseOwnership() {
    swigCMemOwn = false;
    mainJNI.PathOperator_change_ownership(this, swigCPtr, false);
  }

  public void swigTakeOwnership() {
    swigCMemOwn = true;
    mainJNI.PathOperator_change_ownership(this, swigCPtr, true);
  }

  /**
   *  Builds an instance of PathOperator from next and path variables.
   */
  public PathOperator(IntVar[] next_vars, IntVar[] path_vars, SWIGTYPE_p_operations_research__PathOperator__IterationParameters iteration_parameters) {
    this(mainJNI.new_PathOperator__SWIG_0(next_vars, path_vars, SWIGTYPE_p_operations_research__PathOperator__IterationParameters.getCPtr(iteration_parameters)), true);
    mainJNI.PathOperator_director_connect(this, swigCPtr, true, true);
  }

  public PathOperator(IntVar[] next_vars, IntVar[] path_vars, int number_of_base_nodes, boolean skip_locally_optimal_paths, boolean accept_path_end_base, LongToIntFunction start_empty_path_class, SWIGTYPE_p_std__functionT_std__vectorT_int_t_const_Rfint_intF_t get_neighbors) {
    this(mainJNI.new_PathOperator__SWIG_1(next_vars, path_vars, number_of_base_nodes, skip_locally_optimal_paths, accept_path_end_base, start_empty_path_class, SWIGTYPE_p_std__functionT_std__vectorT_int_t_const_Rfint_intF_t.getCPtr(get_neighbors)), true);
    mainJNI.PathOperator_director_connect(this, swigCPtr, true, true);
  }

  public boolean neighbor() {
    return mainJNI.PathOperator_neighbor(swigCPtr, this);
  }

  public void reset() {
    if (getClass() == PathOperator.class) mainJNI.PathOperator_reset(swigCPtr, this); else mainJNI.PathOperator_resetSwigExplicitPathOperator(swigCPtr, this);
  }

  /**
   *  Returns the node before node in the current delta.
   */
  public long Prev(long node) {
    return mainJNI.PathOperator_Prev(swigCPtr, this, node);
  }

  /**
   *  This method should not be overridden. Override MakeNeighbor() instead.
   */
  protected boolean oneNeighbor() {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_oneNeighbor(swigCPtr, this) : mainJNI.PathOperator_oneNeighborSwigExplicitPathOperator(swigCPtr, this);
  }

  /**
   *  Called by OnStart() after initializing node information. Should be<br>
   *  overridden instead of OnStart() to avoid calling PathOperator::OnStart<br>
   *  explicitly.
   */
  protected void OnNodeInitialization() {
    if (getClass() == PathOperator.class) mainJNI.PathOperator_OnNodeInitialization(swigCPtr, this); else mainJNI.PathOperator_OnNodeInitializationSwigExplicitPathOperator(swigCPtr, this);
  }

  /**
   *  When the operator is being synchronized with a new solution (when Start()<br>
   *  is called), returns true to restart the exploration of the neighborhood<br>
   *  from the start of the last paths explored; returns false to restart the<br>
   *  exploration at the last nodes visited.<br>
   *  This is used to avoid restarting on base nodes which have changed paths,<br>
   *  leading to potentially skipping neighbors.
   */
  protected boolean restartAtPathStartOnSynchronize() {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_restartAtPathStartOnSynchronize(swigCPtr, this) : mainJNI.PathOperator_restartAtPathStartOnSynchronizeSwigExplicitPathOperator(swigCPtr, this);
  }

  /**
   *  Returns true if a base node has to be on the same path as the "previous"<br>
   *  base node (base node of index base_index - 1).<br>
   *  Useful to limit neighborhood exploration to nodes on the same path.<br>
   *  it's currently way more complicated to implement.
   */
  protected boolean onSamePathAsPreviousBase(long base_index) {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_onSamePathAsPreviousBase(swigCPtr, this, base_index) : mainJNI.PathOperator_onSamePathAsPreviousBaseSwigExplicitPathOperator(swigCPtr, this, base_index);
  }

  /**
   *  Returns the index of the node to which the base node of index base_index<br>
   *  must be set to when it reaches the end of a path.<br>
   *  By default, it is set to the start of the current path.<br>
   *  When this method is called, one can only assume that base nodes with<br>
   *  indices &lt; base_index have their final position.
   */
  protected long getBaseNodeRestartPosition(int base_index) {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_getBaseNodeRestartPosition(swigCPtr, this, base_index) : mainJNI.PathOperator_getBaseNodeRestartPositionSwigExplicitPathOperator(swigCPtr, this, base_index);
  }

  /**
   *  Set the next base to increment on next iteration. All base &gt; base_index<br>
   *  will be reset to their start value.
   */
  protected void setNextBaseToIncrement(long base_index) {
    if (getClass() == PathOperator.class) mainJNI.PathOperator_setNextBaseToIncrement(swigCPtr, this, base_index); else mainJNI.PathOperator_setNextBaseToIncrementSwigExplicitPathOperator(swigCPtr, this, base_index);
  }

  /**
   *  Indicates if alternatives should be considered when iterating over base<br>
   *  nodes.
   */
  protected boolean ConsiderAlternatives(long base_index) {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_ConsiderAlternatives(swigCPtr, this, base_index) : mainJNI.PathOperator_ConsiderAlternativesSwigExplicitPathOperator(swigCPtr, this, base_index);
  }

  /**
   *  Returns true if the operator needs to restart its initial position at each<br>
   *  call to Start()
   */
  protected boolean initPosition() {
    return (getClass() == PathOperator.class) ? mainJNI.PathOperator_initPosition(swigCPtr, this) : mainJNI.PathOperator_initPositionSwigExplicitPathOperator(swigCPtr, this);
  }

}
