/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

// Used to wrap std::function<int64_t(int64_t from_index, int64_t to_index)> group_delay
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongBinaryOperator.html
import java.util.function.LongBinaryOperator;

/**
 *  Dimensions represent quantities accumulated at nodes along the routes. They<br>
 *  represent quantities such as weights or volumes carried along the route, or<br>
 *  distance or times.<br>
 * <br>
 *  Quantities at a node are represented by "cumul" variables and the increase<br>
 *  or decrease of quantities between nodes are represented by "transit"<br>
 *  variables. These variables are linked as follows:<br>
 * <br>
 *  if j == next(i),<br>
 *  cumuls(j) = cumuls(i) + transits(i) + slacks(i) +<br>
 *              state_dependent_transits(i)<br>
 * <br>
 *  where slack is a positive slack variable (can represent waiting times for<br>
 *  a time dimension), and state_dependent_transits is a non-purely functional<br>
 *  version of transits_. Favour transits over state_dependent_transits when<br>
 *  possible, because purely functional callbacks allow more optimisations and<br>
 *  make the model faster and easier to solve.<br>
 *  for a given vehicle, it is passed as an external vector, it would be better<br>
 *  to have this information here.
 */
public class RoutingDimension {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public RoutingDimension(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(RoutingDimension obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public static long swigRelease(RoutingDimension obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_RoutingDimension(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  Returns the model on which the dimension was created.
   */
  public RoutingModel model() {
    long cPtr = mainJNI.RoutingDimension_model(swigCPtr, this);
    return (cPtr == 0) ? null : new RoutingModel(cPtr, false);
  }

  /**
   *  Returns the transition value for a given pair of nodes (as var index);<br>
   *  this value is the one taken by the corresponding transit variable when<br>
   *  the 'next' variable for 'from_index' is bound to 'to_index'.
   */
  public long getTransitValue(long from_index, long to_index, long vehicle) {
    return mainJNI.RoutingDimension_getTransitValue(swigCPtr, this, from_index, to_index, vehicle);
  }

  /**
   *  Same as above but taking a vehicle class of the dimension instead of a<br>
   *  vehicle (the class of a vehicle can be obtained with vehicle_to_class()).
   */
  public long getTransitValueFromClass(long from_index, long to_index, long vehicle_class) {
    return mainJNI.RoutingDimension_getTransitValueFromClass(swigCPtr, this, from_index, to_index, vehicle_class);
  }

  /**
   *  Get the cumul, transit and slack variables for the given node (given as<br>
   *  int64_t var index).
   */
  public IntVar cumulVar(long index) {
    long cPtr = mainJNI.RoutingDimension_cumulVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  public IntVar transitVar(long index) {
    long cPtr = mainJNI.RoutingDimension_transitVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  public IntVar fixedTransitVar(long index) {
    long cPtr = mainJNI.RoutingDimension_fixedTransitVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  public IntVar slackVar(long index) {
    long cPtr = mainJNI.RoutingDimension_slackVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Like CumulVar(), TransitVar(), SlackVar() but return the whole variable<br>
   *  vectors instead (indexed by int64_t var index).
   */
  public IntVar[] cumuls() {
  return mainJNI.RoutingDimension_cumuls(swigCPtr, this);
}

  public IntVar[] fixed_transits() {
  return mainJNI.RoutingDimension_fixed_transits(swigCPtr, this);
}

  public IntVar[] transits() {
  return mainJNI.RoutingDimension_transits(swigCPtr, this);
}

  public IntVar[] slacks() {
  return mainJNI.RoutingDimension_slacks(swigCPtr, this);
}

  /**
   *  Sets an upper bound on the dimension span on a given vehicle. This is the<br>
   *  preferred way to limit the "length" of the route of a vehicle according to<br>
   *  a dimension.
   */
  public void setSpanUpperBoundForVehicle(long upper_bound, int vehicle) {
    mainJNI.RoutingDimension_setSpanUpperBoundForVehicle(swigCPtr, this, upper_bound, vehicle);
  }

  /**
   *  Sets a cost proportional to the dimension span on a given vehicle,<br>
   *  or on all vehicles at once. "coefficient" must be nonnegative.<br>
   *  This is handy to model costs proportional to idle time when the dimension<br>
   *  represents time.<br>
   *  The cost for a vehicle is<br>
   *    span_cost = coefficient * (dimension end value - dimension start value).
   */
  public void setSpanCostCoefficientForVehicle(long coefficient, int vehicle) {
    mainJNI.RoutingDimension_setSpanCostCoefficientForVehicle(swigCPtr, this, coefficient, vehicle);
  }

  public void setSpanCostCoefficientForAllVehicles(long coefficient) {
    mainJNI.RoutingDimension_setSpanCostCoefficientForAllVehicles(swigCPtr, this, coefficient);
  }

  /**
   *  Sets a cost proportional to the *global* dimension span, that is the<br>
   *  difference between the largest value of route end cumul variables and<br>
   *  the smallest value of route start cumul variables.<br>
   *  In other words:<br>
   *  global_span_cost =<br>
   *    coefficient * (Max(dimension end value) - Min(dimension start value)).
   */
  public void setGlobalSpanCostCoefficient(long coefficient) {
    mainJNI.RoutingDimension_setGlobalSpanCostCoefficient(swigCPtr, this, coefficient);
  }

  /**
   *  Sets a soft upper bound to the cumul variable of a given variable index.<br>
   *  If the value of the cumul variable is greater than the bound, a cost<br>
   *  proportional to the difference between this value and the bound is added<br>
   *  to the cost function of the model:<br>
   *    cumulVar &lt;= upper_bound -&gt; cost = 0<br>
   *     cumulVar &gt; upper_bound -&gt; cost = coefficient * (cumulVar - upper_bound)<br>
   *  This is also handy to model tardiness costs when the dimension represents<br>
   *  time.
   */
  public void setCumulVarSoftUpperBound(long index, long upper_bound, long coefficient) {
    mainJNI.RoutingDimension_setCumulVarSoftUpperBound(swigCPtr, this, index, upper_bound, coefficient);
  }

  /**
   *  Returns true if a soft upper bound has been set for a given variable<br>
   *  index.
   */
  public boolean hasCumulVarSoftUpperBound(long index) {
    return mainJNI.RoutingDimension_hasCumulVarSoftUpperBound(swigCPtr, this, index);
  }

  /**
   *  Returns the soft upper bound of a cumul variable for a given variable<br>
   *  index. The "hard" upper bound of the variable is returned if no soft upper<br>
   *  bound has been set.
   */
  public long getCumulVarSoftUpperBound(long index) {
    return mainJNI.RoutingDimension_getCumulVarSoftUpperBound(swigCPtr, this, index);
  }

  /**
   *  Returns the cost coefficient of the soft upper bound of a cumul variable<br>
   *  for a given variable index. If no soft upper bound has been set, 0 is<br>
   *  returned.
   */
  public long getCumulVarSoftUpperBoundCoefficient(long index) {
    return mainJNI.RoutingDimension_getCumulVarSoftUpperBoundCoefficient(swigCPtr, this, index);
  }

  /**
   *  Sets a soft lower bound to the cumul variable of a given variable index.<br>
   *  If the value of the cumul variable is less than the bound, a cost<br>
   *  proportional to the difference between this value and the bound is added<br>
   *  to the cost function of the model:<br>
   *    cumulVar &gt; lower_bound -&gt; cost = 0<br>
   *    cumulVar &lt;= lower_bound -&gt; cost = coefficient * (lower_bound -<br>
   *                cumulVar).<br>
   *  This is also handy to model earliness costs when the dimension represents<br>
   *  time.
   */
  public void setCumulVarSoftLowerBound(long index, long lower_bound, long coefficient) {
    mainJNI.RoutingDimension_setCumulVarSoftLowerBound(swigCPtr, this, index, lower_bound, coefficient);
  }

  /**
   *  Returns true if a soft lower bound has been set for a given variable<br>
   *  index.
   */
  public boolean hasCumulVarSoftLowerBound(long index) {
    return mainJNI.RoutingDimension_hasCumulVarSoftLowerBound(swigCPtr, this, index);
  }

  /**
   *  Returns the soft lower bound of a cumul variable for a given variable<br>
   *  index. The "hard" lower bound of the variable is returned if no soft lower<br>
   *  bound has been set.
   */
  public long getCumulVarSoftLowerBound(long index) {
    return mainJNI.RoutingDimension_getCumulVarSoftLowerBound(swigCPtr, this, index);
  }

  /**
   *  Returns the cost coefficient of the soft lower bound of a cumul variable<br>
   *  for a given variable index. If no soft lower bound has been set, 0 is<br>
   *  returned.
   */
  public long getCumulVarSoftLowerBoundCoefficient(long index) {
    return mainJNI.RoutingDimension_getCumulVarSoftLowerBoundCoefficient(swigCPtr, this, index);
  }

  /**
   *  Sets the breaks for a given vehicle. Breaks are represented by<br>
   *  IntervalVars. They may interrupt transits between nodes and increase<br>
   *  the value of corresponding slack variables.<br>
   *  A break may take place before the start of a vehicle, after the end of<br>
   *  a vehicle, or during a travel i -&gt; j.<br>
   * <br>
   *  In that case, the interval [break.Start(), break.End()) must be a subset<br>
   *  of [CumulVar(i) + pre_travel(i, j), CumulVar(j) - post_travel(i, j)). In<br>
   *  other words, a break may not overlap any node n's visit, given by<br>
   *  [CumulVar(n) - post_travel(_, n), CumulVar(n) + pre_travel(n, _)).<br>
   *  This formula considers post_travel(_, start) and pre_travel(end, _) to be<br>
   *  0; pre_travel will never be called on any (_, start) and post_travel will<br>
   *  never we called on any (end, _). If pre_travel_evaluator or<br>
   *  post_travel_evaluator is -1, it will be taken as a function that always<br>
   *  returns 0.
   */
  public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, int pre_travel_evaluator, int post_travel_evaluator) {
    mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_0(swigCPtr, this, breaks, vehicle, pre_travel_evaluator, post_travel_evaluator);
  }

  /**
   *  Deprecated, sets pre_travel(i, j) = node_visit_transit[i].
   */
  public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, long[] node_visit_transits) {
    mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_1(swigCPtr, this, breaks, vehicle, node_visit_transits);
  }

  /**
   *  With breaks supposed to be consecutive, this forces the distance between<br>
   *  breaks of size at least minimum_break_duration to be at most distance.<br>
   *  This supposes that the time until route start and after route end are<br>
   *  infinite breaks.
   */
  public void setBreakDistanceDurationOfVehicle(long distance, long duration, int vehicle) {
    mainJNI.RoutingDimension_setBreakDistanceDurationOfVehicle(swigCPtr, this, distance, duration, vehicle);
  }

  /**
   *  Sets up vehicle_break_intervals_, vehicle_break_distance_duration_,<br>
   *  pre_travel_evaluators and post_travel_evaluators.
   */
  public void InitializeBreaks() {
    mainJNI.RoutingDimension_InitializeBreaks(swigCPtr, this);
  }

  /**
   *  Returns true if any break interval or break distance was defined.
   */
  public boolean HasBreakConstraints() {
    return mainJNI.RoutingDimension_HasBreakConstraints(swigCPtr, this);
  }

  /**
   *  Deprecated, sets pre_travel(i, j) = node_visit_transit[i]<br>
   *  and post_travel(i, j) = delays(i, j).
   */
  public void setBreakIntervalsOfVehicle(IntervalVar[] breaks, int vehicle, long[] node_visit_transits, LongBinaryOperator delays) {
    mainJNI.RoutingDimension_setBreakIntervalsOfVehicle__SWIG_2(swigCPtr, this, breaks, vehicle, node_visit_transits, delays);
  }

  /**
   *  Returns the break intervals set by SetBreakIntervalsOfVehicle().
   */
  public IntervalVar[] getBreakIntervalsOfVehicle(int vehicle) {
  return mainJNI.RoutingDimension_getBreakIntervalsOfVehicle(swigCPtr, this, vehicle);
}

  public int GetPreTravelEvaluatorOfVehicle(int vehicle) {
    return mainJNI.RoutingDimension_GetPreTravelEvaluatorOfVehicle(swigCPtr, this, vehicle);
  }

  public int GetPostTravelEvaluatorOfVehicle(int vehicle) {
    return mainJNI.RoutingDimension_GetPostTravelEvaluatorOfVehicle(swigCPtr, this, vehicle);
  }

  /**
   *  Returns the parent in the dependency tree if any or nullptr otherwise.
   */
  public RoutingDimension base_dimension() {
    long cPtr = mainJNI.RoutingDimension_base_dimension(swigCPtr, this);
    return (cPtr == 0) ? null : new RoutingDimension(cPtr, false);
  }

  /**
   *  It makes sense to use the function only for self-dependent dimension.<br>
   *  For such dimensions the value of the slack of a node determines the<br>
   *  transition cost of the next transit. Provided that<br>
   *    1. cumul[node] is fixed,<br>
   *    2. next[node] and next[next[node]] (if exists) are fixed,<br>
   *  the value of slack[node] for which cumul[next[node]] + transit[next[node]]<br>
   *  is minimized can be found in O(1) using this function.
   */
  public long shortestTransitionSlack(long node) {
    return mainJNI.RoutingDimension_shortestTransitionSlack(swigCPtr, this, node);
  }

  /**
   *  Returns the name of the dimension.
   */
  public String name() {
    return mainJNI.RoutingDimension_name(swigCPtr, this);
  }

  public void setPickupToDeliveryLimitFunctionForPair(IntIntToLongFunction limit_function, int pair_index) {
    mainJNI.RoutingDimension_setPickupToDeliveryLimitFunctionForPair(swigCPtr, this, limit_function, pair_index);
  }

  public boolean hasPickupToDeliveryLimits() {
    return mainJNI.RoutingDimension_hasPickupToDeliveryLimits(swigCPtr, this);
  }

  public void addNodePrecedence(long first_node, long second_node, long offset) {
    mainJNI.RoutingDimension_addNodePrecedence(swigCPtr, this, first_node, second_node, offset);
  }

  public long getSpanUpperBoundForVehicle(int vehicle) {
    return mainJNI.RoutingDimension_getSpanUpperBoundForVehicle(swigCPtr, this, vehicle);
  }

  public long getSpanCostCoefficientForVehicle(int vehicle) {
    return mainJNI.RoutingDimension_getSpanCostCoefficientForVehicle(swigCPtr, this, vehicle);
  }

  public long getGlobalSpanCostCoefficient() {
    return mainJNI.RoutingDimension_getGlobalSpanCostCoefficient(swigCPtr, this);
  }

  public long GetGlobalOptimizerOffset() {
    return mainJNI.RoutingDimension_GetGlobalOptimizerOffset(swigCPtr, this);
  }

  public long getLocalOptimizerOffsetForVehicle(int vehicle) {
    return mainJNI.RoutingDimension_getLocalOptimizerOffsetForVehicle(swigCPtr, this, vehicle);
  }

  /**
   *  If the span of vehicle on this dimension is larger than bound,<br>
   *  the cost will be increased by cost * (span - bound).
   */
  public void setSoftSpanUpperBoundForVehicle(BoundCost bound_cost, int vehicle) {
    mainJNI.RoutingDimension_setSoftSpanUpperBoundForVehicle(swigCPtr, this, BoundCost.getCPtr(bound_cost), bound_cost, vehicle);
  }

  public boolean hasSoftSpanUpperBounds() {
    return mainJNI.RoutingDimension_hasSoftSpanUpperBounds(swigCPtr, this);
  }

  public BoundCost getSoftSpanUpperBoundForVehicle(int vehicle) {
    return new BoundCost(mainJNI.RoutingDimension_getSoftSpanUpperBoundForVehicle(swigCPtr, this, vehicle), true);
  }

  /**
   *  If the span of vehicle on this dimension is larger than bound,<br>
   *  the cost will be increased by cost * (span - bound)^2.
   */
  public void setQuadraticCostSoftSpanUpperBoundForVehicle(BoundCost bound_cost, int vehicle) {
    mainJNI.RoutingDimension_setQuadraticCostSoftSpanUpperBoundForVehicle(swigCPtr, this, BoundCost.getCPtr(bound_cost), bound_cost, vehicle);
  }

  public boolean hasQuadraticCostSoftSpanUpperBounds() {
    return mainJNI.RoutingDimension_hasQuadraticCostSoftSpanUpperBounds(swigCPtr, this);
  }

  public BoundCost getQuadraticCostSoftSpanUpperBoundForVehicle(int vehicle) {
    return new BoundCost(mainJNI.RoutingDimension_getQuadraticCostSoftSpanUpperBoundForVehicle(swigCPtr, this, vehicle), true);
  }

}
