/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  Manager for any NodeIndex &lt;-&gt; variable index conversion. The routing solver<br>
 *  uses variable indices internally and through its API. These variable indices<br>
 *  are tricky to manage directly because one Node can correspond to a multitude<br>
 *  of variables, depending on the number of times they appear in the model, and<br>
 *  if they're used as start and/or end points. This class aims to simplify<br>
 *  variable index usage, allowing users to use NodeIndex instead.<br>
 * <br>
 *  Usage:<br>
 *    {@code 
   auto starts_ends = ...;  /// These are NodeIndex.
   RoutingIndexManager manager(10, 4, starts_ends);  // 10 nodes, 4 vehicles.
   RoutingModel model(manager);
   }<br>
 * <br>
 *  Then, use 'manager.NodeToIndex(node)' whenever model requires a variable<br>
 *  index.<br>
 * <br>
 *  Note: the mapping between node indices and variables indices is subject to<br>
 *  change so no assumption should be made on it. The only guarantee is that<br>
 *  indices range between 0 and n-1, where n = number of vehicles * 2 (for start<br>
 *  and end nodes) + number of non-start or end nodes.
 */
public class RoutingIndexManager {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected RoutingIndexManager(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RoutingIndexManager obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RoutingIndexManager obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_RoutingIndexManager(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  Creates a NodeIndex to variable index mapping for a problem containing<br>
   *  'num_nodes', 'num_vehicles' and the given starts and ends for each<br>
   *  vehicle. If used, any start/end arrays have to have exactly 'num_vehicles'<br>
   *  elements.
   */
  public RoutingIndexManager(int num_nodes, int num_vehicles, int depot) {
    this(mainJNI.new_RoutingIndexManager__SWIG_0(num_nodes, num_vehicles, depot), true);
  }

  public RoutingIndexManager(int num_nodes, int num_vehicles, int[] starts, int[] ends) {
    this(mainJNI.new_RoutingIndexManager__SWIG_1(num_nodes, num_vehicles, starts, ends), true);
  }

  public int getNumberOfNodes() {
    return mainJNI.RoutingIndexManager_getNumberOfNodes(swigCPtr, this);
  }

  public int getNumberOfVehicles() {
    return mainJNI.RoutingIndexManager_getNumberOfVehicles(swigCPtr, this);
  }

  public int getNumberOfIndices() {
    return mainJNI.RoutingIndexManager_getNumberOfIndices(swigCPtr, this);
  }

  public long getStartIndex(int vehicle) {
    return mainJNI.RoutingIndexManager_getStartIndex(swigCPtr, this, vehicle);
  }

  public long getEndIndex(int vehicle) {
    return mainJNI.RoutingIndexManager_getEndIndex(swigCPtr, this, vehicle);
  }

  public long nodeToIndex(int node) {
    return mainJNI.RoutingIndexManager_nodeToIndex(swigCPtr, this, node);
  }

  public long[] nodesToIndices(int[] nodes) {
  return mainJNI.RoutingIndexManager_nodesToIndices(swigCPtr, this, nodes);
}

  public int indexToNode(long index) {
  return mainJNI.RoutingIndexManager_indexToNode(swigCPtr, this, index);
}

}
