/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

// Used to wrap Domain
import com.google.ortools.util.Domain;
// Used to wrap RoutingTransitCallback2
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongBinaryOperator.html
import java.util.function.LongBinaryOperator;
// Used to wrap RoutingTransitCallback1
// see https://docs.oracle.com/javase/8/docs/api/java/util/function/LongUnaryOperator.html
import java.util.function.LongUnaryOperator;

public class RoutingModel {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public RoutingModel(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(RoutingModel obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  public static long swigRelease(RoutingModel obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_RoutingModel(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  Struct used to sort and store vehicles by their type. Two vehicles have<br>
   *  the same "vehicle type" iff they have the same cost class and start/end<br>
   *  nodes.
   */
  static public class VehicleTypeContainer {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public VehicleTypeContainer(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(VehicleTypeContainer obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    public static long swigRelease(VehicleTypeContainer obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          mainJNI.delete_RoutingModel_VehicleTypeContainer(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
      static public class VehicleClassEntry {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;
      
        public VehicleClassEntry(long cPtr, boolean cMemoryOwn) {
          swigCMemOwn = cMemoryOwn;
          swigCPtr = cPtr;
        }
      
        public static long getCPtr(VehicleClassEntry obj) {
          return (obj == null) ? 0 : obj.swigCPtr;
        }
      
        public static long swigRelease(VehicleClassEntry obj) {
          long ptr = 0;
          if (obj != null) {
            if (!obj.swigCMemOwn)
              throw new RuntimeException("Cannot release ownership as memory is not owned");
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
          }
          return ptr;
        }
      
        @SuppressWarnings("deprecation")
        protected void finalize() {
          delete();
        }
      
        public synchronized void delete() {
          if (swigCPtr != 0) {
            if (swigCMemOwn) {
              swigCMemOwn = false;
              mainJNI.delete_RoutingModel_VehicleTypeContainer_VehicleClassEntry(swigCPtr);
            }
            swigCPtr = 0;
          }
        }
      
        public void setVehicle_class(int value) {
          mainJNI.RoutingModel_VehicleTypeContainer_VehicleClassEntry_vehicle_class_set(swigCPtr, this, value);
        }
      
        public int getVehicle_class() {
          return mainJNI.RoutingModel_VehicleTypeContainer_VehicleClassEntry_vehicle_class_get(swigCPtr, this);
        }
      
        public void setFixed_cost(long value) {
          mainJNI.RoutingModel_VehicleTypeContainer_VehicleClassEntry_fixed_cost_set(swigCPtr, this, value);
        }
      
        public long getFixed_cost() {
          return mainJNI.RoutingModel_VehicleTypeContainer_VehicleClassEntry_fixed_cost_get(swigCPtr, this);
        }
      
        public VehicleClassEntry() {
          this(mainJNI.new_RoutingModel_VehicleTypeContainer_VehicleClassEntry(), true);
        }
      
      }
  
    public int NumTypes() {
      return mainJNI.RoutingModel_VehicleTypeContainer_NumTypes(swigCPtr, this);
    }
  
    public int Type(int vehicle) {
      return mainJNI.RoutingModel_VehicleTypeContainer_Type(swigCPtr, this, vehicle);
    }
  
    public void setType_index_of_vehicle(int[] value) {
      mainJNI.RoutingModel_VehicleTypeContainer_type_index_of_vehicle_set(swigCPtr, this, value);
    }
  
    public int[] getType_index_of_vehicle() {
    return mainJNI.RoutingModel_VehicleTypeContainer_type_index_of_vehicle_get(swigCPtr, this);
  }
  
    public void setSorted_vehicle_classes_per_type(SWIGTYPE_p_std__vectorT_std__setT_operations_research__RoutingModel__VehicleTypeContainer__VehicleClassEntry_t_t value) {
      mainJNI.RoutingModel_VehicleTypeContainer_sorted_vehicle_classes_per_type_set(swigCPtr, this, SWIGTYPE_p_std__vectorT_std__setT_operations_research__RoutingModel__VehicleTypeContainer__VehicleClassEntry_t_t.getCPtr(value));
    }
  
    public SWIGTYPE_p_std__vectorT_std__setT_operations_research__RoutingModel__VehicleTypeContainer__VehicleClassEntry_t_t getSorted_vehicle_classes_per_type() {
      long cPtr = mainJNI.RoutingModel_VehicleTypeContainer_sorted_vehicle_classes_per_type_get(swigCPtr, this);
      return (cPtr == 0) ? null : new SWIGTYPE_p_std__vectorT_std__setT_operations_research__RoutingModel__VehicleTypeContainer__VehicleClassEntry_t_t(cPtr, false);
    }
  
    public void setVehicles_per_vehicle_class(SWIGTYPE_p_std__vectorT_std__dequeT_int_t_t value) {
      mainJNI.RoutingModel_VehicleTypeContainer_vehicles_per_vehicle_class_set(swigCPtr, this, SWIGTYPE_p_std__vectorT_std__dequeT_int_t_t.getCPtr(value));
    }
  
    public SWIGTYPE_p_std__vectorT_std__dequeT_int_t_t getVehicles_per_vehicle_class() {
      return new SWIGTYPE_p_std__vectorT_std__dequeT_int_t_t(mainJNI.RoutingModel_VehicleTypeContainer_vehicles_per_vehicle_class_get(swigCPtr, this), true);
    }
  
    public VehicleTypeContainer() {
      this(mainJNI.new_RoutingModel_VehicleTypeContainer(), true);
    }
  
  }

  /**
   *  A ResourceGroup defines a set of available Resources with attributes on<br>
   *  one or multiple dimensions.<br>
   *  For every ResourceGroup in the model, each (used) vehicle in the solution<br>
   *  which requires a resource (see NotifyVehicleRequiresResource()) from this<br>
   *  group must be assigned to exactly 1 resource, and each resource can in<br>
   *  turn be assigned to at most 1 vehicle requiring it. This<br>
   *  vehicle-to-resource assignment will apply the corresponding Attributes to<br>
   *  the dimensions affected by the resource group. NOTE: As of 2021/07, each<br>
   *  ResourceGroup can only affect a single RoutingDimension at a time, i.e.<br>
   *  all Resources in a group must apply attributes to the same single<br>
   *  dimension.
   */
  static public class ResourceGroup {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public ResourceGroup(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(ResourceGroup obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    public static long swigRelease(ResourceGroup obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          mainJNI.delete_RoutingModel_ResourceGroup(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
      /**
       *  Attributes for a dimension.
       */
      static public class Attributes {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;
      
        public Attributes(long cPtr, boolean cMemoryOwn) {
          swigCMemOwn = cMemoryOwn;
          swigCPtr = cPtr;
        }
      
        public static long getCPtr(Attributes obj) {
          return (obj == null) ? 0 : obj.swigCPtr;
        }
      
        public static long swigRelease(Attributes obj) {
          long ptr = 0;
          if (obj != null) {
            if (!obj.swigCMemOwn)
              throw new RuntimeException("Cannot release ownership as memory is not owned");
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
          }
          return ptr;
        }
      
        @SuppressWarnings("deprecation")
        protected void finalize() {
          delete();
        }
      
        public synchronized void delete() {
          if (swigCPtr != 0) {
            if (swigCMemOwn) {
              swigCMemOwn = false;
              mainJNI.delete_RoutingModel_ResourceGroup_Attributes(swigCPtr);
            }
            swigCPtr = 0;
          }
        }
      
        public Attributes() {
          this(mainJNI.new_RoutingModel_ResourceGroup_Attributes__SWIG_0(), true);
        }
      
        public Attributes(Domain start_domain, Domain end_domain) {
          this(mainJNI.new_RoutingModel_ResourceGroup_Attributes__SWIG_1(Domain.getCPtr(start_domain), start_domain, Domain.getCPtr(end_domain), end_domain), true);
        }
      
        public Domain start_domain() {
          return new Domain(mainJNI.RoutingModel_ResourceGroup_Attributes_start_domain(swigCPtr, this), false);
        }
      
        public Domain end_domain() {
          return new Domain(mainJNI.RoutingModel_ResourceGroup_Attributes_end_domain(swigCPtr, this), false);
        }
      
      }
  
      /**
       *  A Resource sets attributes (costs/constraints) for a set of dimensions.
       */
      static public class Resource {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;
      
        public Resource(long cPtr, boolean cMemoryOwn) {
          swigCMemOwn = cMemoryOwn;
          swigCPtr = cPtr;
        }
      
        public static long getCPtr(Resource obj) {
          return (obj == null) ? 0 : obj.swigCPtr;
        }
      
        public static long swigRelease(Resource obj) {
          long ptr = 0;
          if (obj != null) {
            if (!obj.swigCMemOwn)
              throw new RuntimeException("Cannot release ownership as memory is not owned");
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
          }
          return ptr;
        }
      
        @SuppressWarnings("deprecation")
        protected void finalize() {
          delete();
        }
      
        public synchronized void delete() {
          if (swigCPtr != 0) {
            if (swigCMemOwn) {
              swigCMemOwn = false;
              mainJNI.delete_RoutingModel_ResourceGroup_Resource(swigCPtr);
            }
            swigCPtr = 0;
          }
        }
      
        public RoutingModel.ResourceGroup.Attributes GetDimensionAttributes(RoutingDimension dimension) {
          return new RoutingModel.ResourceGroup.Attributes(mainJNI.RoutingModel_ResourceGroup_Resource_GetDimensionAttributes(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension), false);
        }
      
      }
  
    public ResourceGroup(RoutingModel model) {
      this(mainJNI.new_RoutingModel_ResourceGroup(RoutingModel.getCPtr(model), model), true);
    }
  
    /**
     *  Adds a Resource with the given attributes for the corresponding<br>
     *  dimension. Returns the index of the added resource in resources_.
     */
    public int AddResource(RoutingModel.ResourceGroup.Attributes attributes, RoutingDimension dimension) {
      return mainJNI.RoutingModel_ResourceGroup_AddResource(swigCPtr, this, RoutingModel.ResourceGroup.Attributes.getCPtr(attributes), attributes, RoutingDimension.getCPtr(dimension), dimension);
    }
  
    /**
     *  Notifies that the given vehicle index requires a resource from this<br>
     *  group if the vehicle is used (i.e. if its route is non-empty or<br>
     *  vehicle_used_when_empty_[vehicle] is true).
     */
    public void NotifyVehicleRequiresAResource(int vehicle) {
      mainJNI.RoutingModel_ResourceGroup_NotifyVehicleRequiresAResource(swigCPtr, this, vehicle);
    }
  
    public int[] GetVehiclesRequiringAResource() {
    return mainJNI.RoutingModel_ResourceGroup_GetVehiclesRequiringAResource(swigCPtr, this);
  }
  
    public boolean VehicleRequiresAResource(int vehicle) {
      return mainJNI.RoutingModel_ResourceGroup_VehicleRequiresAResource(swigCPtr, this, vehicle);
    }
  
    public SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__ResourceGroup__Resource_t GetResources() {
      return new SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__ResourceGroup__Resource_t(mainJNI.RoutingModel_ResourceGroup_GetResources(swigCPtr, this), false);
    }
  
    public RoutingModel.ResourceGroup.Resource GetResource(int resource_index) {
      return new RoutingModel.ResourceGroup.Resource(mainJNI.RoutingModel_ResourceGroup_GetResource(swigCPtr, this, resource_index), false);
    }
  
    public SWIGTYPE_p_absl__flat_hash_setT_operations_research__RoutingModel__DimensionIndex_t GetAffectedDimensionIndices() {
      return new SWIGTYPE_p_absl__flat_hash_setT_operations_research__RoutingModel__DimensionIndex_t(mainJNI.RoutingModel_ResourceGroup_GetAffectedDimensionIndices(swigCPtr, this), false);
    }
  
    public int Size() {
      return mainJNI.RoutingModel_ResourceGroup_Size(swigCPtr, this);
    }
  
  }

  /**
   *  Constant used to express a hard constraint instead of a soft penalty.
   */
  public static long getKNoPenalty() {
    return mainJNI.RoutingModel_kNoPenalty_get();
  }

  /**
   *  Constant used to express the "no disjunction" index, returned when a node<br>
   *  does not appear in any disjunction.
   */
  public static int getKNoDisjunction() {
  return mainJNI.RoutingModel_kNoDisjunction_get();
}

  /**
   *  Constant used to express the "no dimension" index, returned when a<br>
   *  dimension name does not correspond to an actual dimension.
   */
  public static int getKNoDimension() {
  return mainJNI.RoutingModel_kNoDimension_get();
}

  /**
   *  Constructor taking an index manager. The version which does not take<br>
   *  RoutingModelParameters is equivalent to passing<br>
   *  DefaultRoutingModelParameters().
   */
  public RoutingModel(RoutingIndexManager index_manager) {
    this(mainJNI.new_RoutingModel__SWIG_0(RoutingIndexManager.getCPtr(index_manager), index_manager), true);
  }

  public RoutingModel(RoutingIndexManager index_manager, com.google.ortools.constraintsolver.RoutingModelParameters parameters) {
    this(mainJNI.new_RoutingModel__SWIG_1(RoutingIndexManager.getCPtr(index_manager), index_manager, parameters.toByteArray()), true);
  }

  /**
   *  Registers 'callback' and returns its index.<br>
   *  The sign parameter allows to notify the solver that the callback only<br>
   *  return values of the given sign. This can help the solver, but passing<br>
   *  an incorrect sign may crash in non-opt compilation mode, and yield<br>
   *  incorrect results in opt.
   */
  public int registerUnaryTransitVector(long[] values) {
    return mainJNI.RoutingModel_registerUnaryTransitVector(swigCPtr, this, values);
  }

  public int registerUnaryTransitCallback(LongUnaryOperator callback, int sign) {
    return mainJNI.RoutingModel_registerUnaryTransitCallback__SWIG_0(swigCPtr, this, callback, sign);
  }

  public int registerUnaryTransitCallback(LongUnaryOperator callback) {
    return mainJNI.RoutingModel_registerUnaryTransitCallback__SWIG_1(swigCPtr, this, callback);
  }

  public int registerTransitMatrix(long[][] values) {
    return mainJNI.RoutingModel_registerTransitMatrix(swigCPtr, this, values);
  }

  public int registerTransitCallback(LongBinaryOperator callback, int sign) {
    return mainJNI.RoutingModel_registerTransitCallback__SWIG_0(swigCPtr, this, callback, sign);
  }

  public int registerTransitCallback(LongBinaryOperator callback) {
    return mainJNI.RoutingModel_registerTransitCallback__SWIG_1(swigCPtr, this, callback);
  }

  /**
   *  Model creation<br>
   *  Methods to add dimensions to routes; dimensions represent quantities<br>
   *  accumulated at nodes along the routes. They represent quantities such as<br>
   *  weights or volumes carried along the route, or distance or times.<br>
   *  Quantities at a node are represented by "cumul" variables and the increase<br>
   *  or decrease of quantities between nodes are represented by "transit"<br>
   *  variables. These variables are linked as follows:<br>
   *  if j == next(i), cumul(j) = cumul(i) + transit(i, j) + slack(i)<br>
   *  where slack is a positive slack variable (can represent waiting times for<br>
   *  a time dimension).<br>
   *  Setting the value of fix_start_cumul_to_zero to true will force the<br>
   *  "cumul" variable of the start node of all vehicles to be equal to 0.<br>
   *  Creates a dimension where the transit variable is constrained to be<br>
   *  equal to evaluator(i, next(i)); 'slack_max' is the upper bound of the<br>
   *  slack variable and 'capacity' is the upper bound of the cumul variables.<br>
   *  'name' is the name used to reference the dimension; this name is used to<br>
   *  get cumul and transit variables from the routing model.<br>
   *  Returns false if a dimension with the same name has already been created<br>
   *  (and doesn't create the new dimension).<br>
   *  Takes ownership of the callback 'evaluator'.
   */
  public boolean addDimension(int evaluator_index, long slack_max, long capacity, boolean fix_start_cumul_to_zero, String name) {
    return mainJNI.RoutingModel_addDimension(swigCPtr, this, evaluator_index, slack_max, capacity, fix_start_cumul_to_zero, name);
  }

  public boolean addDimensionWithVehicleTransits(int[] evaluator_indices, long slack_max, long capacity, boolean fix_start_cumul_to_zero, String name) {
    return mainJNI.RoutingModel_addDimensionWithVehicleTransits(swigCPtr, this, evaluator_indices, slack_max, capacity, fix_start_cumul_to_zero, name);
  }

  public boolean addDimensionWithVehicleCapacity(int evaluator_index, long slack_max, long[] vehicle_capacities, boolean fix_start_cumul_to_zero, String name) {
    return mainJNI.RoutingModel_addDimensionWithVehicleCapacity(swigCPtr, this, evaluator_index, slack_max, vehicle_capacities, fix_start_cumul_to_zero, name);
  }

  public boolean addDimensionWithVehicleTransitAndCapacity(int[] evaluator_indices, long slack_max, long[] vehicle_capacities, boolean fix_start_cumul_to_zero, String name) {
    return mainJNI.RoutingModel_addDimensionWithVehicleTransitAndCapacity(swigCPtr, this, evaluator_indices, slack_max, vehicle_capacities, fix_start_cumul_to_zero, name);
  }

  /**
   *  Creates a dimension where the transit variable is constrained to be<br>
   *  equal to 'value'; 'capacity' is the upper bound of the cumul variables.<br>
   *  'name' is the name used to reference the dimension; this name is used to<br>
   *  get cumul and transit variables from the routing model.<br>
   *  Returns a pair consisting of an index to the registered unary transit<br>
   *  callback and a bool denoting whether the dimension has been created.<br>
   *  It is false if a dimension with the same name has already been created<br>
   *  (and doesn't create the new dimension but still register a new callback).
   */
  public IntBoolPair addConstantDimensionWithSlack(long value, long capacity, long slack_max, boolean fix_start_cumul_to_zero, String name) {
    return new IntBoolPair(mainJNI.RoutingModel_addConstantDimensionWithSlack(swigCPtr, this, value, capacity, slack_max, fix_start_cumul_to_zero, name), true);
  }

  public IntBoolPair addConstantDimension(long value, long capacity, boolean fix_start_cumul_to_zero, String name) {
    return new IntBoolPair(mainJNI.RoutingModel_addConstantDimension(swigCPtr, this, value, capacity, fix_start_cumul_to_zero, name), true);
  }

  /**
   *  Creates a dimension where the transit variable is constrained to be<br>
   *  equal to 'values[i]' for node i; 'capacity' is the upper bound of<br>
   *  the cumul variables. 'name' is the name used to reference the dimension;<br>
   *  this name is used to get cumul and transit variables from the routing<br>
   *  model.<br>
   *  Returns a pair consisting of an index to the registered unary transit<br>
   *  callback and a bool denoting whether the dimension has been created.<br>
   *  It is false if a dimension with the same name has already been created<br>
   *  (and doesn't create the new dimension but still register a new callback).
   */
  public IntBoolPair addVectorDimension(long[] values, long capacity, boolean fix_start_cumul_to_zero, String name) {
    return new IntBoolPair(mainJNI.RoutingModel_addVectorDimension(swigCPtr, this, values, capacity, fix_start_cumul_to_zero, name), true);
  }

  /**
   *  Creates a dimension where the transit variable is constrained to be<br>
   *  equal to 'values[i][next(i)]' for node i; 'capacity' is the upper bound of<br>
   *  the cumul variables. 'name' is the name used to reference the dimension;<br>
   *  this name is used to get cumul and transit variables from the routing<br>
   *  model.<br>
   *  Returns a pair consisting of an index to the registered transit callback<br>
   *  and a bool denoting whether the dimension has been created.<br>
   *  It is false if a dimension with the same name has already been created<br>
   *  (and doesn't create the new dimension but still register a new callback).
   */
  public IntBoolPair addMatrixDimension(long[][] values, long capacity, boolean fix_start_cumul_to_zero, String name) {
    return new IntBoolPair(mainJNI.RoutingModel_addMatrixDimension(swigCPtr, this, values, capacity, fix_start_cumul_to_zero, name), true);
  }

  /**
   *  Returns the dimensions which have [global|local]_dimension_optimizers_.
   */
  public SWIGTYPE_p_std__vectorT_operations_research__RoutingDimension_const_p_t GetDimensionsWithGlobalCumulOptimizers() {
    return new SWIGTYPE_p_std__vectorT_operations_research__RoutingDimension_const_p_t(mainJNI.RoutingModel_GetDimensionsWithGlobalCumulOptimizers(swigCPtr, this), true);
  }

  public SWIGTYPE_p_std__vectorT_operations_research__RoutingDimension_const_p_t GetDimensionsWithLocalCumulOptimizers() {
    return new SWIGTYPE_p_std__vectorT_operations_research__RoutingDimension_const_p_t(mainJNI.RoutingModel_GetDimensionsWithLocalCumulOptimizers(swigCPtr, this), true);
  }

  /**
   *  Returns whether the given dimension has global/local cumul optimizers.
   */
  public boolean HasGlobalCumulOptimizer(RoutingDimension dimension) {
    return mainJNI.RoutingModel_HasGlobalCumulOptimizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
  }

  public boolean HasLocalCumulOptimizer(RoutingDimension dimension) {
    return mainJNI.RoutingModel_HasLocalCumulOptimizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
  }

  /**
   *  Returns the global/local dimension cumul optimizer for a given dimension,<br>
   *  or nullptr if there is none.
   */
  public SWIGTYPE_p_operations_research__GlobalDimensionCumulOptimizer GetMutableGlobalCumulLPOptimizer(RoutingDimension dimension) {
    long cPtr = mainJNI.RoutingModel_GetMutableGlobalCumulLPOptimizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
    return (cPtr == 0) ? null : new SWIGTYPE_p_operations_research__GlobalDimensionCumulOptimizer(cPtr, false);
  }

  public SWIGTYPE_p_operations_research__GlobalDimensionCumulOptimizer GetMutableGlobalCumulMPOptimizer(RoutingDimension dimension) {
    long cPtr = mainJNI.RoutingModel_GetMutableGlobalCumulMPOptimizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
    return (cPtr == 0) ? null : new SWIGTYPE_p_operations_research__GlobalDimensionCumulOptimizer(cPtr, false);
  }

  public SWIGTYPE_p_operations_research__LocalDimensionCumulOptimizer GetMutableLocalCumulLPOptimizer(RoutingDimension dimension) {
    long cPtr = mainJNI.RoutingModel_GetMutableLocalCumulLPOptimizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
    return (cPtr == 0) ? null : new SWIGTYPE_p_operations_research__LocalDimensionCumulOptimizer(cPtr, false);
  }

  /**
   *  Returns true if a dimension exists for a given dimension name.
   */
  public boolean hasDimension(String dimension_name) {
    return mainJNI.RoutingModel_hasDimension(swigCPtr, this, dimension_name);
  }

  /**
   *  Returns a dimension from its name. Dies if the dimension does not exist.
   */
  public RoutingDimension getDimensionOrDie(String dimension_name) {
    return new RoutingDimension(mainJNI.RoutingModel_getDimensionOrDie(swigCPtr, this, dimension_name), false);
  }

  /**
   *  Returns a dimension from its name. Returns nullptr if the dimension does<br>
   *  not exist.
   */
  public RoutingDimension getMutableDimension(String dimension_name) {
    long cPtr = mainJNI.RoutingModel_getMutableDimension(swigCPtr, this, dimension_name);
    return (cPtr == 0) ? null : new RoutingDimension(cPtr, false);
  }

  /**
   *  Set the given dimension as "primary constrained". As of August 2013, this<br>
   *  is only used by ArcIsMoreConstrainedThanArc().<br>
   *  "dimension" must be the name of an existing dimension, or be empty, in<br>
   *  which case there will not be a primary dimension after this call.
   */
  public void setPrimaryConstrainedDimension(String dimension_name) {
    mainJNI.RoutingModel_setPrimaryConstrainedDimension(swigCPtr, this, dimension_name);
  }

  /**
   *  Get the primary constrained dimension, or an empty string if it is unset.
   */
  public String getPrimaryConstrainedDimension() {
    return mainJNI.RoutingModel_getPrimaryConstrainedDimension(swigCPtr, this);
  }

  /**
   *  Adds a resource group to the routing model. Returns its index in<br>
   *  resource_groups_.
   */
  public int AddResourceGroup() {
    return mainJNI.RoutingModel_AddResourceGroup(swigCPtr, this);
  }

  public SWIGTYPE_p_std__vectorT_std__unique_ptrT_operations_research__RoutingModel__ResourceGroup_t_t GetResourceGroups() {
    return new SWIGTYPE_p_std__vectorT_std__unique_ptrT_operations_research__RoutingModel__ResourceGroup_t_t(mainJNI.RoutingModel_GetResourceGroups(swigCPtr, this), false);
  }

  public RoutingModel.ResourceGroup GetResourceGroup(int rg_index) {
    long cPtr = mainJNI.RoutingModel_GetResourceGroup(swigCPtr, this, rg_index);
    return (cPtr == 0) ? null : new RoutingModel.ResourceGroup(cPtr, false);
  }

  /**
   *  Returns the indices of resource groups for this dimension. This method can<br>
   *  only be called after the model has been closed.
   */
  public int[] GetDimensionResourceGroupIndices(RoutingDimension dimension) {
  return mainJNI.RoutingModel_GetDimensionResourceGroupIndices(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
}

  /**
   *  Returns the index of the resource group attached to the dimension.<br>
   *  DCHECKS that there's exactly one resource group for this dimension.
   */
  public int GetDimensionResourceGroupIndex(RoutingDimension dimension) {
    return mainJNI.RoutingModel_GetDimensionResourceGroupIndex(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
  }

  /**
   *  Adds a disjunction constraint on the indices: exactly 'max_cardinality' of<br>
   *  the indices are active. Start and end indices of any vehicle cannot be<br>
   *  part of a disjunction.<br>
   * <br>
   *  If a penalty is given, at most 'max_cardinality' of the indices can be<br>
   *  active, and if less are active, 'penalty' is payed per inactive index.<br>
   *  This is equivalent to adding the constraint:<br>
   *      p + Sum(i)active[i] == max_cardinality<br>
   *  where p is an integer variable, and the following cost to the cost<br>
   *  function:<br>
   *      p * penalty.<br>
   *  'penalty' must be positive to make the disjunction optional; a negative<br>
   *  penalty will force 'max_cardinality' indices of the disjunction to be<br>
   *  performed, and therefore p == 0.<br>
   *  Note: passing a vector with a single index will model an optional index<br>
   *  with a penalty cost if it is not visited.
   */
  public int addDisjunction(long[] indices, long penalty, long max_cardinality) {
  return mainJNI.RoutingModel_addDisjunction__SWIG_0(swigCPtr, this, indices, penalty, max_cardinality);
}

  /**
   *  Adds a disjunction constraint on the indices: exactly 'max_cardinality' of<br>
   *  the indices are active. Start and end indices of any vehicle cannot be<br>
   *  part of a disjunction.<br>
   * <br>
   *  If a penalty is given, at most 'max_cardinality' of the indices can be<br>
   *  active, and if less are active, 'penalty' is payed per inactive index.<br>
   *  This is equivalent to adding the constraint:<br>
   *      p + Sum(i)active[i] == max_cardinality<br>
   *  where p is an integer variable, and the following cost to the cost<br>
   *  function:<br>
   *      p * penalty.<br>
   *  'penalty' must be positive to make the disjunction optional; a negative<br>
   *  penalty will force 'max_cardinality' indices of the disjunction to be<br>
   *  performed, and therefore p == 0.<br>
   *  Note: passing a vector with a single index will model an optional index<br>
   *  with a penalty cost if it is not visited.
   */
  public int addDisjunction(long[] indices, long penalty) {
  return mainJNI.RoutingModel_addDisjunction__SWIG_1(swigCPtr, this, indices, penalty);
}

  /**
   *  Adds a disjunction constraint on the indices: exactly 'max_cardinality' of<br>
   *  the indices are active. Start and end indices of any vehicle cannot be<br>
   *  part of a disjunction.<br>
   * <br>
   *  If a penalty is given, at most 'max_cardinality' of the indices can be<br>
   *  active, and if less are active, 'penalty' is payed per inactive index.<br>
   *  This is equivalent to adding the constraint:<br>
   *      p + Sum(i)active[i] == max_cardinality<br>
   *  where p is an integer variable, and the following cost to the cost<br>
   *  function:<br>
   *      p * penalty.<br>
   *  'penalty' must be positive to make the disjunction optional; a negative<br>
   *  penalty will force 'max_cardinality' indices of the disjunction to be<br>
   *  performed, and therefore p == 0.<br>
   *  Note: passing a vector with a single index will model an optional index<br>
   *  with a penalty cost if it is not visited.
   */
  public int addDisjunction(long[] indices) {
  return mainJNI.RoutingModel_addDisjunction__SWIG_2(swigCPtr, this, indices);
}

  /**
   *  Returns the indices of the disjunctions to which an index belongs.
   */
  public int[] getDisjunctionIndices(long index) {
  return mainJNI.RoutingModel_getDisjunctionIndices(swigCPtr, this, index);
}

  /**
   *  Returns the variable indices of the nodes in the disjunction of index<br>
   *  'index'.
   */
  public long[] GetDisjunctionNodeIndices(int index) {
  return mainJNI.RoutingModel_GetDisjunctionNodeIndices(swigCPtr, this, index);
}

  /**
   *  Returns the penalty of the node disjunction of index 'index'.
   */
  public long getDisjunctionPenalty(int index) {
    return mainJNI.RoutingModel_getDisjunctionPenalty(swigCPtr, this, index);
  }

  /**
   *  Returns the maximum number of possible active nodes of the node<br>
   *  disjunction of index 'index'.
   */
  public long getDisjunctionMaxCardinality(int index) {
    return mainJNI.RoutingModel_getDisjunctionMaxCardinality(swigCPtr, this, index);
  }

  /**
   *  Returns the number of node disjunctions in the model.
   */
  public int getNumberOfDisjunctions() {
    return mainJNI.RoutingModel_getNumberOfDisjunctions(swigCPtr, this);
  }

  /**
   *  Returns true if the model contains mandatory disjunctions (ones with<br>
   *  kNoPenalty as penalty).
   */
  public boolean HasMandatoryDisjunctions() {
    return mainJNI.RoutingModel_HasMandatoryDisjunctions(swigCPtr, this);
  }

  /**
   *  Returns true if the model contains at least one disjunction which is<br>
   *  constrained by its max_cardinality.
   */
  public boolean HasMaxCardinalityConstrainedDisjunctions() {
    return mainJNI.RoutingModel_HasMaxCardinalityConstrainedDisjunctions(swigCPtr, this);
  }

  /**
   *  SPECIAL: Makes the solver ignore all the disjunctions whose active<br>
   *  variables are all trivially zero (i.e. Max() == 0), by setting their<br>
   *  max_cardinality to 0.<br>
   *  This can be useful when using the BaseBinaryDisjunctionNeighborhood<br>
   *  operators, in the context of arc-based routing.
   */
  public void ignoreDisjunctionsAlreadyForcedToZero() {
    mainJNI.RoutingModel_ignoreDisjunctionsAlreadyForcedToZero(swigCPtr, this);
  }

  /**
   *  Adds a soft constraint to force a set of variable indices to be on the<br>
   *  same vehicle. If all nodes are not on the same vehicle, each extra vehicle<br>
   *  used adds 'cost' to the cost function.
   */
  public void addSoftSameVehicleConstraint(long[] indices, long cost) {
    mainJNI.RoutingModel_addSoftSameVehicleConstraint(swigCPtr, this, indices, cost);
  }

  /**
   *  Sets the vehicles which can visit a given node. If the node is in a<br>
   *  disjunction, this will not prevent it from being unperformed.<br>
   *  Specifying an empty vector of vehicles has no effect (all vehicles<br>
   *  will be allowed to visit the node).
   */
  public void setAllowedVehiclesForIndex(int[] vehicles, long index) {
    mainJNI.RoutingModel_setAllowedVehiclesForIndex(swigCPtr, this, vehicles, index);
  }

  /**
   *  Returns true if a vehicle is allowed to visit a given node.
   */
  public boolean isVehicleAllowedForIndex(int vehicle, long index) {
    return mainJNI.RoutingModel_isVehicleAllowedForIndex(swigCPtr, this, vehicle, index);
  }

  /**
   *  Notifies that index1 and index2 form a pair of nodes which should belong<br>
   *  to the same route. This methods helps the search find better solutions,<br>
   *  especially in the local search phase.<br>
   *  It should be called each time you have an equality constraint linking<br>
   *  the vehicle variables of two node (including for instance pickup and<br>
   *  delivery problems):<br>
   *      Solver* const solver = routing.solver();<br>
   *      int64_t index1 = manager.NodeToIndex(node1);<br>
   *      int64_t index2 = manager.NodeToIndex(node2);<br>
   *      solver-&gt;AddConstraint(solver-&gt;MakeEquality(<br>
   *          routing.VehicleVar(index1),<br>
   *          routing.VehicleVar(index2)));<br>
   *      routing.AddPickupAndDelivery(index1, index2);
   */
  public void addPickupAndDelivery(long pickup, long delivery) {
    mainJNI.RoutingModel_addPickupAndDelivery(swigCPtr, this, pickup, delivery);
  }

  /**
   *  Same as AddPickupAndDelivery but notifying that the performed node from<br>
   *  the disjunction of index 'pickup_disjunction' is on the same route as the<br>
   *  performed node from the disjunction of index 'delivery_disjunction'.
   */
  public void addPickupAndDeliverySets(int pickup_disjunction, int delivery_disjunction) {
    mainJNI.RoutingModel_addPickupAndDeliverySets(swigCPtr, this, pickup_disjunction, delivery_disjunction);
  }

  /**
   *  Sets the Pickup and delivery policy of all vehicles. It is equivalent to<br>
   *  calling SetPickupAndDeliveryPolicyOfVehicle on all vehicles.
   */
  public void setPickupAndDeliveryPolicyOfAllVehicles(int policy) {
    mainJNI.RoutingModel_setPickupAndDeliveryPolicyOfAllVehicles(swigCPtr, this, policy);
  }

  public void setPickupAndDeliveryPolicyOfVehicle(int policy, int vehicle) {
    mainJNI.RoutingModel_setPickupAndDeliveryPolicyOfVehicle(swigCPtr, this, policy, vehicle);
  }

  public int getPickupAndDeliveryPolicyOfVehicle(int vehicle) {
    return mainJNI.RoutingModel_getPickupAndDeliveryPolicyOfVehicle(swigCPtr, this, vehicle);
  }

  /**
   *  Returns the number of non-start/end nodes which do not appear in a<br>
   *  pickup/delivery pair.
   */
  public int getNumOfSingletonNodes() {
    return mainJNI.RoutingModel_getNumOfSingletonNodes(swigCPtr, this);
  }

  public void setVisitType(long index, int type, int type_policy) {
    mainJNI.RoutingModel_setVisitType(swigCPtr, this, index, type, type_policy);
  }

  public int getVisitType(long index) {
    return mainJNI.RoutingModel_getVisitType(swigCPtr, this, index);
  }

  public int[] GetSingleNodesOfType(int type) {
  return mainJNI.RoutingModel_GetSingleNodesOfType(swigCPtr, this, type);
}

  public int[] GetPairIndicesOfType(int type) {
  return mainJNI.RoutingModel_GetPairIndicesOfType(swigCPtr, this, type);
}

  public int GetVisitTypePolicy(long index) {
    return mainJNI.RoutingModel_GetVisitTypePolicy(swigCPtr, this, index);
  }

  /**
   *  This function should be called once all node visit types have been set and<br>
   *  prior to adding any incompatibilities/requirements.<br>
   *  "close" types.
   */
  public void closeVisitTypes() {
    mainJNI.RoutingModel_closeVisitTypes(swigCPtr, this);
  }

  public int getNumberOfVisitTypes() {
    return mainJNI.RoutingModel_getNumberOfVisitTypes(swigCPtr, this);
  }

  /**
   *  Incompatibilities:<br>
   *  Two nodes with "hard" incompatible types cannot share the same route at<br>
   *  all, while with a "temporal" incompatibility they can't be on the same<br>
   *  route at the same time.
   */
  public void addHardTypeIncompatibility(int type1, int type2) {
    mainJNI.RoutingModel_addHardTypeIncompatibility(swigCPtr, this, type1, type2);
  }

  public void addTemporalTypeIncompatibility(int type1, int type2) {
    mainJNI.RoutingModel_addTemporalTypeIncompatibility(swigCPtr, this, type1, type2);
  }

  public SWIGTYPE_p_absl__flat_hash_setT_int_t getTemporalTypeIncompatibilitiesOfType(int type) {
    return new SWIGTYPE_p_absl__flat_hash_setT_int_t(mainJNI.RoutingModel_getTemporalTypeIncompatibilitiesOfType(swigCPtr, this, type), false);
  }

  /**
   *  Returns true iff any hard (resp. temporal) type incompatibilities have<br>
   *  been added to the model.
   */
  public boolean hasHardTypeIncompatibilities() {
    return mainJNI.RoutingModel_hasHardTypeIncompatibilities(swigCPtr, this);
  }

  public boolean hasTemporalTypeIncompatibilities() {
    return mainJNI.RoutingModel_hasTemporalTypeIncompatibilities(swigCPtr, this);
  }

  /**
   *  If type_D depends on type_R when adding type_D, any node_D of type_D and<br>
   *  VisitTypePolicy TYPE_ADDED_TO_VEHICLE or<br>
   *  TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED requires at least one type_R on its<br>
   *  vehicle at the time node_D is visited.
   */
  public void addRequiredTypeAlternativesWhenAddingType(int dependent_type, SWIGTYPE_p_absl__flat_hash_setT_int_t required_type_alternatives) {
    mainJNI.RoutingModel_addRequiredTypeAlternativesWhenAddingType(swigCPtr, this, dependent_type, SWIGTYPE_p_absl__flat_hash_setT_int_t.getCPtr(required_type_alternatives));
  }

  /**
   *  The following requirements apply when visiting dependent nodes that remove<br>
   *  their type from the route, i.e. type_R must be on the vehicle when type_D<br>
   *  of VisitTypePolicy ADDED_TYPE_REMOVED_FROM_VEHICLE,<br>
   *  TYPE_ON_VEHICLE_UP_TO_VISIT or TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED is<br>
   *  visited.
   */
  public void addRequiredTypeAlternativesWhenRemovingType(int dependent_type, SWIGTYPE_p_absl__flat_hash_setT_int_t required_type_alternatives) {
    mainJNI.RoutingModel_addRequiredTypeAlternativesWhenRemovingType(swigCPtr, this, dependent_type, SWIGTYPE_p_absl__flat_hash_setT_int_t.getCPtr(required_type_alternatives));
  }

  /**
   *  Returns the set of requirement alternatives when adding the given type.
   */
  public SWIGTYPE_p_std__vectorT_absl__flat_hash_setT_int_t_t GetRequiredTypeAlternativesWhenAddingType(int type) {
    return new SWIGTYPE_p_std__vectorT_absl__flat_hash_setT_int_t_t(mainJNI.RoutingModel_GetRequiredTypeAlternativesWhenAddingType(swigCPtr, this, type), false);
  }

  /**
   *  Returns the set of requirement alternatives when removing the given type.
   */
  public SWIGTYPE_p_std__vectorT_absl__flat_hash_setT_int_t_t GetRequiredTypeAlternativesWhenRemovingType(int type) {
    return new SWIGTYPE_p_std__vectorT_absl__flat_hash_setT_int_t_t(mainJNI.RoutingModel_GetRequiredTypeAlternativesWhenRemovingType(swigCPtr, this, type), false);
  }

  /**
   *  Returns true iff any same-route (resp. temporal) type requirements have<br>
   *  been added to the model.
   */
  public boolean hasSameVehicleTypeRequirements() {
    return mainJNI.RoutingModel_hasSameVehicleTypeRequirements(swigCPtr, this);
  }

  public boolean hasTemporalTypeRequirements() {
    return mainJNI.RoutingModel_hasTemporalTypeRequirements(swigCPtr, this);
  }

  /**
   *  Get the "unperformed" penalty of a node. This is only well defined if the<br>
   *  node is only part of a single Disjunction, and that disjunction has a<br>
   *  penalty. For forced active nodes returns max int64_t. In all other cases,<br>
   *  this returns 0.
   */
  public long unperformedPenalty(long var_index) {
    return mainJNI.RoutingModel_unperformedPenalty(swigCPtr, this, var_index);
  }

  /**
   *  Same as above except that it returns default_value instead of 0 when<br>
   *  penalty is not well defined (default value is passed as first argument to<br>
   *  simplify the usage of the method in a callback).
   */
  public long unperformedPenaltyOrValue(long default_value, long var_index) {
    return mainJNI.RoutingModel_unperformedPenaltyOrValue(swigCPtr, this, default_value, var_index);
  }

  /**
   *  Returns the variable index of the first starting or ending node of all<br>
   *  routes. If all routes start  and end at the same node (single depot), this<br>
   *  is the node returned.
   */
  public long getDepot() {
    return mainJNI.RoutingModel_getDepot(swigCPtr, this);
  }

  /**
   *  Constrains the maximum number of active vehicles, aka the number of<br>
   *  vehicles which do not have an empty route. For instance, this can be used<br>
   *  to limit the number of routes in the case where there are fewer drivers<br>
   *  than vehicles and that the fleet of vehicle is heterogeneous.
   */
  public void SetMaximumNumberOfActiveVehicles(int max_active_vehicles) {
    mainJNI.RoutingModel_SetMaximumNumberOfActiveVehicles(swigCPtr, this, max_active_vehicles);
  }

  /**
   *  Returns the maximum number of active vehicles.
   */
  public int GetMaximumNumberOfActiveVehicles() {
    return mainJNI.RoutingModel_GetMaximumNumberOfActiveVehicles(swigCPtr, this);
  }

  /**
   *  Sets the cost function of the model such that the cost of a segment of a<br>
   *  route between node 'from' and 'to' is evaluator(from, to), whatever the<br>
   *  route or vehicle performing the route.
   */
  public void setArcCostEvaluatorOfAllVehicles(int evaluator_index) {
    mainJNI.RoutingModel_setArcCostEvaluatorOfAllVehicles(swigCPtr, this, evaluator_index);
  }

  /**
   *  Sets the cost function for a given vehicle route.
   */
  public void setArcCostEvaluatorOfVehicle(int evaluator_index, int vehicle) {
    mainJNI.RoutingModel_setArcCostEvaluatorOfVehicle(swigCPtr, this, evaluator_index, vehicle);
  }

  /**
   *  Sets the fixed cost of all vehicle routes. It is equivalent to calling<br>
   *  SetFixedCostOfVehicle on all vehicle routes.
   */
  public void setFixedCostOfAllVehicles(long cost) {
    mainJNI.RoutingModel_setFixedCostOfAllVehicles(swigCPtr, this, cost);
  }

  /**
   *  Sets the fixed cost of one vehicle route.
   */
  public void setFixedCostOfVehicle(long cost, int vehicle) {
    mainJNI.RoutingModel_setFixedCostOfVehicle(swigCPtr, this, cost, vehicle);
  }

  /**
   *  Returns the route fixed cost taken into account if the route of the<br>
   *  vehicle is not empty, aka there's at least one node on the route other<br>
   *  than the first and last nodes.
   */
  public long getFixedCostOfVehicle(int vehicle) {
    return mainJNI.RoutingModel_getFixedCostOfVehicle(swigCPtr, this, vehicle);
  }

  public void SetPathEnergyCostOfVehicle(String force, String distance, long unit_cost, int vehicle) {
    mainJNI.RoutingModel_SetPathEnergyCostOfVehicle(swigCPtr, this, force, distance, unit_cost, vehicle);
  }

  /**
   *  The following methods set the linear and quadratic cost factors of<br>
   *  vehicles (must be positive values). The default value of these parameters<br>
   *  is zero for all vehicles.<br>
   * <br>
   *  When set, the cost_ of the model will contain terms aiming at reducing the<br>
   *  number of vehicles used in the model, by adding the following to the<br>
   *  objective for every vehicle v:<br>
   *  INDICATOR(v used in the model) *<br>
   *    [linear_cost_factor_of_vehicle_[v]<br>
   *     - quadratic_cost_factor_of_vehicle_[v]*(square of length of route v)]<br>
   *  i.e. for every used vehicle, we add the linear factor as fixed cost, and<br>
   *  subtract the square of the route length multiplied by the quadratic<br>
   *  factor. This second term aims at making the routes as dense as possible.<br>
   * <br>
   *  Sets the linear and quadratic cost factor of all vehicles.
   */
  public void setAmortizedCostFactorsOfAllVehicles(long linear_cost_factor, long quadratic_cost_factor) {
    mainJNI.RoutingModel_setAmortizedCostFactorsOfAllVehicles(swigCPtr, this, linear_cost_factor, quadratic_cost_factor);
  }

  /**
   *  Sets the linear and quadratic cost factor of the given vehicle.
   */
  public void setAmortizedCostFactorsOfVehicle(long linear_cost_factor, long quadratic_cost_factor, int vehicle) {
    mainJNI.RoutingModel_setAmortizedCostFactorsOfVehicle(swigCPtr, this, linear_cost_factor, quadratic_cost_factor, vehicle);
  }

  public long[] getAmortizedLinearCostFactorOfVehicles() {
  return mainJNI.RoutingModel_getAmortizedLinearCostFactorOfVehicles(swigCPtr, this);
}

  public long[] getAmortizedQuadraticCostFactorOfVehicles() {
  return mainJNI.RoutingModel_getAmortizedQuadraticCostFactorOfVehicles(swigCPtr, this);
}

  public void SetVehicleUsedWhenEmpty(boolean is_used, int vehicle) {
    mainJNI.RoutingModel_SetVehicleUsedWhenEmpty(swigCPtr, this, is_used, vehicle);
  }

  public boolean IsVehicleUsedWhenEmpty(int vehicle) {
    return mainJNI.RoutingModel_IsVehicleUsedWhenEmpty(swigCPtr, this, vehicle);
  }

  /**
   *  Gets/sets the evaluator used during the search. Only relevant when<br>
   *  RoutingSearchParameters.first_solution_strategy = EVALUATOR_STRATEGY.<br>
   *  Takes ownership of evaluator.
   */
  public void setFirstSolutionEvaluator(LongBinaryOperator evaluator) {
    mainJNI.RoutingModel_setFirstSolutionEvaluator(swigCPtr, this, evaluator);
  }

  /**
   *  Adds a local search operator to the set of operators used to solve the<br>
   *  vehicle routing problem.
   */
  public void addLocalSearchOperator(LocalSearchOperator ls_operator) {
    mainJNI.RoutingModel_addLocalSearchOperator(swigCPtr, this, LocalSearchOperator.getCPtr(ls_operator), ls_operator);
  }

  /**
   *  Adds a search monitor to the search used to solve the routing model.
   */
  public void addSearchMonitor(SearchMonitor monitor) {
    mainJNI.RoutingModel_addSearchMonitor(swigCPtr, this, SearchMonitor.getCPtr(monitor), monitor);
  }

  /**
   *  Adds a callback called each time a solution is found during the search.<br>
   *  This is a shortcut to creating a monitor to call the callback on<br>
   *  AtSolution() and adding it with AddSearchMonitor.<br>
   *  If track_unchecked_neighbors is true, the callback will also be called on<br>
   *  AcceptUncheckedNeighbor() events, which is useful to grab solutions<br>
   *  obtained when solver_parameters.check_solution_period &gt; 1 (aka fastLS).
   */
  public void addAtSolutionCallback(Runnable callback, boolean track_unchecked_neighbors) {
    mainJNI.RoutingModel_addAtSolutionCallback__SWIG_0(swigCPtr, this, callback, track_unchecked_neighbors);
  }

  /**
   *  Adds a callback called each time a solution is found during the search.<br>
   *  This is a shortcut to creating a monitor to call the callback on<br>
   *  AtSolution() and adding it with AddSearchMonitor.<br>
   *  If track_unchecked_neighbors is true, the callback will also be called on<br>
   *  AcceptUncheckedNeighbor() events, which is useful to grab solutions<br>
   *  obtained when solver_parameters.check_solution_period &gt; 1 (aka fastLS).
   */
  public void addAtSolutionCallback(Runnable callback) {
    mainJNI.RoutingModel_addAtSolutionCallback__SWIG_1(swigCPtr, this, callback);
  }

  /**
   *  Adds a variable to minimize in the solution finalizer. The solution<br>
   *  finalizer is called each time a solution is found during the search and<br>
   *  allows to instantiate secondary variables (such as dimension cumul<br>
   *  variables).
   */
  public void addVariableMinimizedByFinalizer(IntVar var) {
    mainJNI.RoutingModel_addVariableMinimizedByFinalizer(swigCPtr, this, IntVar.getCPtr(var), var);
  }

  /**
   *  Adds a variable to maximize in the solution finalizer (see above for<br>
   *  information on the solution finalizer).
   */
  public void addVariableMaximizedByFinalizer(IntVar var) {
    mainJNI.RoutingModel_addVariableMaximizedByFinalizer(swigCPtr, this, IntVar.getCPtr(var), var);
  }

  /**
   *  Adds a variable to minimize in the solution finalizer, with a weighted<br>
   *  priority: the higher the more priority it has.
   */
  public void AddWeightedVariableMinimizedByFinalizer(IntVar var, long cost) {
    mainJNI.RoutingModel_AddWeightedVariableMinimizedByFinalizer(swigCPtr, this, IntVar.getCPtr(var), var, cost);
  }

  /**
   *  Adds a variable to maximize in the solution finalizer, with a weighted<br>
   *  priority: the higher the more priority it has.
   */
  public void AddWeightedVariableMaximizedByFinalizer(IntVar var, long cost) {
    mainJNI.RoutingModel_AddWeightedVariableMaximizedByFinalizer(swigCPtr, this, IntVar.getCPtr(var), var, cost);
  }

  /**
   *  Add a variable to set the closest possible to the target value in the<br>
   *  solution finalizer.
   */
  public void addVariableTargetToFinalizer(IntVar var, long target) {
    mainJNI.RoutingModel_addVariableTargetToFinalizer(swigCPtr, this, IntVar.getCPtr(var), var, target);
  }

  /**
   *  Same as above with a weighted priority: the higher the cost, the more<br>
   *  priority it has to be set close to the target value.
   */
  public void AddWeightedVariableTargetToFinalizer(IntVar var, long target, long cost) {
    mainJNI.RoutingModel_AddWeightedVariableTargetToFinalizer(swigCPtr, this, IntVar.getCPtr(var), var, target, cost);
  }

  /**
   *  Closes the current routing model; after this method is called, no<br>
   *  modification to the model can be done, but RoutesToAssignment becomes<br>
   *  available. Note that CloseModel() is automatically called by Solve() and<br>
   *  other methods that produce solution.<br>
   *  This is equivalent to calling<br>
   *  CloseModelWithParameters(DefaultRoutingSearchParameters()).
   */
  public void closeModel() {
    mainJNI.RoutingModel_closeModel(swigCPtr, this);
  }

  /**
   *  Same as above taking search parameters (as of 10/2015 some the parameters<br>
   *  have to be set when closing the model).
   */
  public void closeModelWithParameters(com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    mainJNI.RoutingModel_closeModelWithParameters(swigCPtr, this, search_parameters.toByteArray());
  }

  /**
   *  Solves the current routing model; closes the current model.<br>
   *  This is equivalent to calling<br>
   *  SolveWithParameters(DefaultRoutingSearchParameters())<br>
   *  or<br>
   *  SolveFromAssignmentWithParameters(assignment,<br>
   *                                    DefaultRoutingSearchParameters()).
   */
  public Assignment solve(Assignment assignment) {
    long cPtr = mainJNI.RoutingModel_solve__SWIG_0(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Solves the current routing model; closes the current model.<br>
   *  This is equivalent to calling<br>
   *  SolveWithParameters(DefaultRoutingSearchParameters())<br>
   *  or<br>
   *  SolveFromAssignmentWithParameters(assignment,<br>
   *                                    DefaultRoutingSearchParameters()).
   */
  public Assignment solve() {
    long cPtr = mainJNI.RoutingModel_solve__SWIG_1(swigCPtr, this);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Solves the current routing model with the given parameters. If 'solutions'<br>
   *  is specified, it will contain the k best solutions found during the search<br>
   *  (from worst to best, including the one returned by this method), where k<br>
   *  corresponds to the 'number_of_solutions_to_collect' in<br>
   *  'search_parameters'. Note that the Assignment returned by the method and<br>
   *  the ones in solutions are owned by the underlying solver and should not be<br>
   *  deleted.
   */
  public Assignment solveWithParameters(com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    long cPtr = mainJNI.RoutingModel_solveWithParameters(swigCPtr, this, search_parameters.toByteArray());
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Same as above, except that if assignment is not null, it will be used as<br>
   *  the initial solution.
   */
  public Assignment solveFromAssignmentWithParameters(Assignment assignment, com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    long cPtr = mainJNI.RoutingModel_solveFromAssignmentWithParameters(swigCPtr, this, Assignment.getCPtr(assignment), assignment, search_parameters.toByteArray());
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Same as above but will try all assignments in order as first solutions<br>
   *  until one succeeds.
   */
  public Assignment SolveFromAssignmentsWithParameters(SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t assignments, com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters, SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t solutions) {
    long cPtr = mainJNI.RoutingModel_SolveFromAssignmentsWithParameters__SWIG_0(swigCPtr, this, SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t.getCPtr(assignments), search_parameters.toByteArray(), SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t.getCPtr(solutions));
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Same as above but will try all assignments in order as first solutions<br>
   *  until one succeeds.
   */
  public Assignment SolveFromAssignmentsWithParameters(SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t assignments, com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    long cPtr = mainJNI.RoutingModel_SolveFromAssignmentsWithParameters__SWIG_1(swigCPtr, this, SWIGTYPE_p_std__vectorT_operations_research__Assignment_const_p_t.getCPtr(assignments), search_parameters.toByteArray());
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Given a "source_model" and its "source_assignment", resets<br>
   *  "target_assignment" with the IntVar variables (nexts_, and vehicle_vars_<br>
   *  if costs aren't homogeneous across vehicles) of "this" model, with the<br>
   *  values set according to those in "other_assignment".<br>
   *  The objective_element of target_assignment is set to this-&gt;cost_.
   */
  public void setAssignmentFromOtherModelAssignment(Assignment target_assignment, RoutingModel source_model, Assignment source_assignment) {
    mainJNI.RoutingModel_setAssignmentFromOtherModelAssignment(swigCPtr, this, Assignment.getCPtr(target_assignment), target_assignment, RoutingModel.getCPtr(source_model), source_model, Assignment.getCPtr(source_assignment), source_assignment);
  }

  /**
   *  Computes a lower bound to the routing problem solving a linear assignment<br>
   *  problem. The routing model must be closed before calling this method.<br>
   *  Note that problems with node disjunction constraints (including optional<br>
   *  nodes) and non-homogenous costs are not supported (the method returns 0 in<br>
   *  these cases).
   */
  public long computeLowerBound() {
    return mainJNI.RoutingModel_computeLowerBound(swigCPtr, this);
  }

  /**
   *  Returns the current status of the routing model.
   */
  public int status() {
    return mainJNI.RoutingModel_status(swigCPtr, this);
  }

  /**
   *  Returns the value of the internal enable_deep_serialization_ parameter.
   */
  public boolean enable_deep_serialization() {
    return mainJNI.RoutingModel_enable_deep_serialization(swigCPtr, this);
  }

  /**
   *  Applies a lock chain to the next search. 'locks' represents an ordered<br>
   *  vector of nodes representing a partial route which will be fixed during<br>
   *  the next search; it will constrain next variables such that:<br>
   *  next[locks[i]] == locks[i+1].<br>
   * <br>
   *  Returns the next variable at the end of the locked chain; this variable is<br>
   *  not locked. An assignment containing the locks can be obtained by calling<br>
   *  PreAssignment().
   */
  public IntVar applyLocks(long[] locks) {
    long cPtr = mainJNI.RoutingModel_applyLocks(swigCPtr, this, locks);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Applies lock chains to all vehicles to the next search, such that locks[p]<br>
   *  is the lock chain for route p. Returns false if the locks do not contain<br>
   *  valid routes; expects that the routes do not contain the depots,<br>
   *  i.e. there are empty vectors in place of empty routes.<br>
   *  If close_routes is set to true, adds the end nodes to the route of each<br>
   *  vehicle and deactivates other nodes.<br>
   *  An assignment containing the locks can be obtained by calling<br>
   *  PreAssignment().
   */
  public boolean applyLocksToAllVehicles(long[][] locks, boolean close_routes) {
    return mainJNI.RoutingModel_applyLocksToAllVehicles(swigCPtr, this, locks, close_routes);
  }

  /**
   *  Returns an assignment used to fix some of the variables of the problem.<br>
   *  In practice, this assignment locks partial routes of the problem. This<br>
   *  can be used in the context of locking the parts of the routes which have<br>
   *  already been driven in online routing problems.
   */
  public Assignment preAssignment() {
    long cPtr = mainJNI.RoutingModel_preAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  public Assignment mutablePreAssignment() {
    long cPtr = mainJNI.RoutingModel_mutablePreAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Writes the current solution to a file containing an AssignmentProto.<br>
   *  Returns false if the file cannot be opened or if there is no current<br>
   *  solution.
   */
  public boolean writeAssignment(String file_name) {
    return mainJNI.RoutingModel_writeAssignment(swigCPtr, this, file_name);
  }

  /**
   *  Reads an assignment from a file and returns the current solution.<br>
   *  Returns nullptr if the file cannot be opened or if the assignment is not<br>
   *  valid.
   */
  public Assignment readAssignment(String file_name) {
    long cPtr = mainJNI.RoutingModel_readAssignment(swigCPtr, this, file_name);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Restores an assignment as a solution in the routing model and returns the<br>
   *  new solution. Returns nullptr if the assignment is not valid.
   */
  public Assignment restoreAssignment(Assignment solution) {
    long cPtr = mainJNI.RoutingModel_restoreAssignment(swigCPtr, this, Assignment.getCPtr(solution), solution);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Restores the routes as the current solution. Returns nullptr if the<br>
   *  solution cannot be restored (routes do not contain a valid solution). Note<br>
   *  that calling this method will run the solver to assign values to the<br>
   *  dimension variables; this may take considerable amount of time, especially<br>
   *  when using dimensions with slack.
   */
  public Assignment readAssignmentFromRoutes(long[][] routes, boolean ignore_inactive_indices) {
    long cPtr = mainJNI.RoutingModel_readAssignmentFromRoutes(swigCPtr, this, routes, ignore_inactive_indices);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Fills an assignment from a specification of the routes of the<br>
   *  vehicles. The routes are specified as lists of variable indices that<br>
   *  appear on the routes of the vehicles. The indices of the outer vector in<br>
   *  'routes' correspond to vehicles IDs, the inner vector contains the<br>
   *  variable indices on the routes for the given vehicle. The inner vectors<br>
   *  must not contain the start and end indices, as these are determined by the<br>
   *  routing model.  Sets the value of NextVars in the assignment, adding the<br>
   *  variables to the assignment if necessary. The method does not touch other<br>
   *  variables in the assignment. The method can only be called after the model<br>
   *  is closed.  With ignore_inactive_indices set to false, this method will<br>
   *  fail (return nullptr) in case some of the route contain indices that are<br>
   *  deactivated in the model; when set to true, these indices will be<br>
   *  skipped.  Returns true if routes were successfully<br>
   *  loaded. However, such assignment still might not be a valid<br>
   *  solution to the routing problem due to more complex constraints;<br>
   *  it is advisible to call solver()-&gt;CheckSolution() afterwards.
   */
  public boolean routesToAssignment(long[][] routes, boolean ignore_inactive_indices, boolean close_routes, Assignment assignment) {
    return mainJNI.RoutingModel_routesToAssignment(swigCPtr, this, routes, ignore_inactive_indices, close_routes, Assignment.getCPtr(assignment), assignment);
  }

  /**
   *  Converts the solution in the given assignment to routes for all vehicles.<br>
   *  Expects that assignment contains a valid solution (i.e. routes for all<br>
   *  vehicles end with an end index for that vehicle).
   */
  public void assignmentToRoutes(Assignment assignment, long[][] routes) {
    mainJNI.RoutingModel_assignmentToRoutes(swigCPtr, this, Assignment.getCPtr(assignment), assignment, routes);
  }

  /**
   *  Converts the solution in the given assignment to routes for all vehicles.<br>
   *  If the returned vector is route_indices, route_indices[i][j] is the index<br>
   *  for jth location visited on route i. Note that contrary to<br>
   *  AssignmentToRoutes, the vectors do include start and end locations.<br>
   *  Returns a compacted version of the given assignment, in which all vehicles<br>
   *  with id lower or equal to some N have non-empty routes, and all vehicles<br>
   *  with id greater than N have empty routes. Does not take ownership of the<br>
   *  returned object.<br>
   *  If found, the cost of the compact assignment is the same as in the<br>
   *  original assignment and it preserves the values of 'active' variables.<br>
   *  Returns nullptr if a compact assignment was not found.<br>
   *  This method only works in homogenous mode, and it only swaps equivalent<br>
   *  vehicles (vehicles with the same start and end nodes). When creating the<br>
   *  compact assignment, the empty plan is replaced by the route assigned to<br>
   *  the compatible vehicle with the highest id. Note that with more complex<br>
   *  constraints on vehicle variables, this method might fail even if a compact<br>
   *  solution exists.<br>
   *  This method changes the vehicle and dimension variables as necessary.<br>
   *  While compacting the solution, only basic checks on vehicle variables are<br>
   *  performed; if one of these checks fails no attempts to repair it are made<br>
   *  (instead, the method returns nullptr).
   */
  public Assignment compactAssignment(Assignment assignment) {
    long cPtr = mainJNI.RoutingModel_compactAssignment(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Same as CompactAssignment() but also checks the validity of the final<br>
   *  compact solution; if it is not valid, no attempts to repair it are made<br>
   *  (instead, the method returns nullptr).
   */
  public Assignment compactAndCheckAssignment(Assignment assignment) {
    long cPtr = mainJNI.RoutingModel_compactAndCheckAssignment(swigCPtr, this, Assignment.getCPtr(assignment), assignment);
    return (cPtr == 0) ? null : new Assignment(cPtr, false);
  }

  /**
   *  Adds an extra variable to the vehicle routing assignment.
   */
  public void addToAssignment(IntVar var) {
    mainJNI.RoutingModel_addToAssignment(swigCPtr, this, IntVar.getCPtr(var), var);
  }

  public void addIntervalToAssignment(IntervalVar interval) {
    mainJNI.RoutingModel_addIntervalToAssignment(swigCPtr, this, IntervalVar.getCPtr(interval), interval);
  }

  /**
   *  Contains the information needed by the solver to optimize a dimension's<br>
   *  cumuls with travel-start dependent transit values.
   */
  static public class RouteDimensionTravelInfo {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public RouteDimensionTravelInfo(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(RouteDimensionTravelInfo obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    public static long swigRelease(RouteDimensionTravelInfo obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          mainJNI.delete_RoutingModel_RouteDimensionTravelInfo(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
      /**
       *  Contains the information for a single transition on the route.
       */
      static public class TransitionInfo {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;
      
        public TransitionInfo(long cPtr, boolean cMemoryOwn) {
          swigCMemOwn = cMemoryOwn;
          swigCPtr = cPtr;
        }
      
        public static long getCPtr(TransitionInfo obj) {
          return (obj == null) ? 0 : obj.swigCPtr;
        }
      
        public static long swigRelease(TransitionInfo obj) {
          long ptr = 0;
          if (obj != null) {
            if (!obj.swigCMemOwn)
              throw new RuntimeException("Cannot release ownership as memory is not owned");
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
          }
          return ptr;
        }
      
        @SuppressWarnings("deprecation")
        protected void finalize() {
          delete();
        }
      
        public synchronized void delete() {
          if (swigCPtr != 0) {
            if (swigCMemOwn) {
              swigCMemOwn = false;
              mainJNI.delete_RoutingModel_RouteDimensionTravelInfo_TransitionInfo(swigCPtr);
            }
            swigCPtr = 0;
          }
        }
      
            /**
             *  The following struct defines a piecewise linear formulation, with<br>
             *  int64_t values for the "anchor" x and y values, and potential double<br>
             *  values for the slope of each linear function.
             */
            static public class PiecewiseLinearFormulation {
              private transient long swigCPtr;
              protected transient boolean swigCMemOwn;
            
              public PiecewiseLinearFormulation(long cPtr, boolean cMemoryOwn) {
                swigCMemOwn = cMemoryOwn;
                swigCPtr = cPtr;
              }
            
              public static long getCPtr(PiecewiseLinearFormulation obj) {
                return (obj == null) ? 0 : obj.swigCPtr;
              }
            
              public static long swigRelease(PiecewiseLinearFormulation obj) {
                long ptr = 0;
                if (obj != null) {
                  if (!obj.swigCMemOwn)
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                  ptr = obj.swigCPtr;
                  obj.swigCMemOwn = false;
                  obj.delete();
                }
                return ptr;
              }
            
              @SuppressWarnings("deprecation")
              protected void finalize() {
                delete();
              }
            
              public synchronized void delete() {
                if (swigCPtr != 0) {
                  if (swigCMemOwn) {
                    swigCMemOwn = false;
                    mainJNI.delete_RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation(swigCPtr);
                  }
                  swigCPtr = 0;
                }
              }
            
              /**
               *  The set of *increasing* anchor cumul values for the interpolation.
               */
              public void setX_anchors(SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t value) {
                mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_x_anchors_set(swigCPtr, this, SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t.getCPtr(value));
              }
            
              /**
               *  The set of *increasing* anchor cumul values for the interpolation.
               */
              public SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t getX_anchors() {
                return new SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t(mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_x_anchors_get(swigCPtr, this), true);
              }
            
              /**
               *  The y values used for the interpolation:<br>
               *  For any x anchor value, let i be an index such that<br>
               *  x_anchors[i] ≤ x &lt; x_anchors[i+1], then the y value for x is<br>
               *  y_anchors[i] * (1-λ) + y_anchors[i+1] * λ, with<br>
               *  λ = (x - x_anchors[i]) / (x_anchors[i+1] - x_anchors[i]).
               */
              public void setY_anchors(SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t value) {
                mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_y_anchors_set(swigCPtr, this, SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t.getCPtr(value));
              }
            
              /**
               *  The y values used for the interpolation:<br>
               *  For any x anchor value, let i be an index such that<br>
               *  x_anchors[i] ≤ x &lt; x_anchors[i+1], then the y value for x is<br>
               *  y_anchors[i] * (1-λ) + y_anchors[i+1] * λ, with<br>
               *  λ = (x - x_anchors[i]) / (x_anchors[i+1] - x_anchors[i]).
               */
              public SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t getY_anchors() {
                return new SWIGTYPE_p_absl__InlinedVectorT_int64_t_8_t(mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_y_anchors_get(swigCPtr, this), true);
              }
            
              public String toString(String line_prefix) {
                return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_toString__SWIG_0(swigCPtr, this, line_prefix);
              }
            
              public String toString() {
                return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation_toString__SWIG_1(swigCPtr, this);
              }
            
              public PiecewiseLinearFormulation() {
                this(mainJNI.new_RoutingModel_RouteDimensionTravelInfo_TransitionInfo_PiecewiseLinearFormulation(), true);
              }
            
            }
      
        /**
         *  Models the (real) travel value Tᵣ, for this transition based on the<br>
         *  departure value of the travel.
         */
        public void setTravel_start_dependent_travel(RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_start_dependent_travel_set(swigCPtr, this, RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation.getCPtr(value), value);
        }
      
        /**
         *  Models the (real) travel value Tᵣ, for this transition based on the<br>
         *  departure value of the travel.
         */
        public RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation getTravel_start_dependent_travel() {
          long cPtr = mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_start_dependent_travel_get(swigCPtr, this);
          return (cPtr == 0) ? null : new RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation(cPtr, false);
        }
      
        /**
         *  travel_compression_cost models the cost of the difference between the<br>
         *  (real) travel value Tᵣ given by travel_start_dependent_travel and the<br>
         *  compressed travel value considered in the scheduling.
         */
        public void setTravel_compression_cost(RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_compression_cost_set(swigCPtr, this, RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation.getCPtr(value), value);
        }
      
        /**
         *  travel_compression_cost models the cost of the difference between the<br>
         *  (real) travel value Tᵣ given by travel_start_dependent_travel and the<br>
         *  compressed travel value considered in the scheduling.
         */
        public RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation getTravel_compression_cost() {
          long cPtr = mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_compression_cost_get(swigCPtr, this);
          return (cPtr == 0) ? null : new RoutingModel.RouteDimensionTravelInfo.TransitionInfo.PiecewiseLinearFormulation(cPtr, false);
        }
      
        /**
         *  The parts of the transit which occur pre/post travel between the<br>
         *  nodes. The total transit between the two nodes i and j is<br>
         *  = pre_travel_transit_value + travel(i, j) + post_travel_transit_value.
         */
        public void setPre_travel_transit_value(long value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_pre_travel_transit_value_set(swigCPtr, this, value);
        }
      
        /**
         *  The parts of the transit which occur pre/post travel between the<br>
         *  nodes. The total transit between the two nodes i and j is<br>
         *  = pre_travel_transit_value + travel(i, j) + post_travel_transit_value.
         */
        public long getPre_travel_transit_value() {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_pre_travel_transit_value_get(swigCPtr, this);
        }
      
        public void setPost_travel_transit_value(long value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_post_travel_transit_value_set(swigCPtr, this, value);
        }
      
        public long getPost_travel_transit_value() {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_post_travel_transit_value_get(swigCPtr, this);
        }
      
        /**
         *  The hard lower bound of the compressed travel value that will be<br>
         *  enforced by the scheduling module.
         */
        public void setCompressed_travel_value_lower_bound(long value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_compressed_travel_value_lower_bound_set(swigCPtr, this, value);
        }
      
        /**
         *  The hard lower bound of the compressed travel value that will be<br>
         *  enforced by the scheduling module.
         */
        public long getCompressed_travel_value_lower_bound() {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_compressed_travel_value_lower_bound_get(swigCPtr, this);
        }
      
        /**
         *  The hard upper bound of the (real) travel value Tᵣ (see<br>
         *  above). This value should be chosen so as to prevent<br>
         *  the overall cost of the model<br>
         *  (dimension costs + travel_compression_cost) to overflow.
         */
        public void setTravel_value_upper_bound(long value) {
          mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_value_upper_bound_set(swigCPtr, this, value);
        }
      
        /**
         *  The hard upper bound of the (real) travel value Tᵣ (see<br>
         *  above). This value should be chosen so as to prevent<br>
         *  the overall cost of the model<br>
         *  (dimension costs + travel_compression_cost) to overflow.
         */
        public long getTravel_value_upper_bound() {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_travel_value_upper_bound_get(swigCPtr, this);
        }
      
        public String toString(String line_prefix) {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_toString__SWIG_0(swigCPtr, this, line_prefix);
        }
      
        public String toString() {
          return mainJNI.RoutingModel_RouteDimensionTravelInfo_TransitionInfo_toString__SWIG_1(swigCPtr, this);
        }
      
        public TransitionInfo() {
          this(mainJNI.new_RoutingModel_RouteDimensionTravelInfo_TransitionInfo(), true);
        }
      
      }
  
    /**
     *  For each node #i on the route, transition_info[i] contains the relevant<br>
     *  information for the travel between nodes #i and #(i + 1) on the route.
     */
    public void setTransition_info(SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__RouteDimensionTravelInfo__TransitionInfo_t value) {
      mainJNI.RoutingModel_RouteDimensionTravelInfo_transition_info_set(swigCPtr, this, SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__RouteDimensionTravelInfo__TransitionInfo_t.getCPtr(value));
    }
  
    /**
     *  For each node #i on the route, transition_info[i] contains the relevant<br>
     *  information for the travel between nodes #i and #(i + 1) on the route.
     */
    public SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__RouteDimensionTravelInfo__TransitionInfo_t getTransition_info() {
      long cPtr = mainJNI.RoutingModel_RouteDimensionTravelInfo_transition_info_get(swigCPtr, this);
      return (cPtr == 0) ? null : new SWIGTYPE_p_std__vectorT_operations_research__RoutingModel__RouteDimensionTravelInfo__TransitionInfo_t(cPtr, false);
    }
  
    /**
     *  The cost per unit of travel for this vehicle.
     */
    public void setTravel_cost_coefficient(long value) {
      mainJNI.RoutingModel_RouteDimensionTravelInfo_travel_cost_coefficient_set(swigCPtr, this, value);
    }
  
    /**
     *  The cost per unit of travel for this vehicle.
     */
    public long getTravel_cost_coefficient() {
      return mainJNI.RoutingModel_RouteDimensionTravelInfo_travel_cost_coefficient_get(swigCPtr, this);
    }
  
    public String toString(String line_prefix) {
      return mainJNI.RoutingModel_RouteDimensionTravelInfo_toString__SWIG_0(swigCPtr, this, line_prefix);
    }
  
    public String toString() {
      return mainJNI.RoutingModel_RouteDimensionTravelInfo_toString__SWIG_1(swigCPtr, this);
    }
  
    public RouteDimensionTravelInfo() {
      this(mainJNI.new_RoutingModel_RouteDimensionTravelInfo(), true);
    }
  
  }

  static public class NodeNeighborsByCostClass {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public NodeNeighborsByCostClass(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(NodeNeighborsByCostClass obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    public static long swigRelease(NodeNeighborsByCostClass obj) {
      long ptr = 0;
      if (obj != null) {
        if (!obj.swigCMemOwn)
          throw new RuntimeException("Cannot release ownership as memory is not owned");
        ptr = obj.swigCPtr;
        obj.swigCMemOwn = false;
        obj.delete();
      }
      return ptr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          mainJNI.delete_RoutingModel_NodeNeighborsByCostClass(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public NodeNeighborsByCostClass() {
      this(mainJNI.new_RoutingModel_NodeNeighborsByCostClass(), true);
    }
  
    /**
     *  Computes num_neighbors neighbors of all nodes for every cost class in<br>
     *  routing_model.
     */
    public void ComputeNeighbors(RoutingModel routing_model, int num_neighbors, boolean add_vehicle_starts_to_neighbors) {
      mainJNI.RoutingModel_NodeNeighborsByCostClass_ComputeNeighbors(swigCPtr, this, RoutingModel.getCPtr(routing_model), routing_model, num_neighbors, add_vehicle_starts_to_neighbors);
    }
  
    /**
     *  Returns the neighbors of the given node for the given cost_class.
     */
    public int[] GetNeighborsOfNodeForCostClass(int cost_class, int node_index) {
    return mainJNI.RoutingModel_NodeNeighborsByCostClass_GetNeighborsOfNodeForCostClass(swigCPtr, this, cost_class, node_index);
  }
  
  }

  /**
   *  Returns neighbors of all nodes for every cost class. The result is cached<br>
   *  and is computed once. The number of neighbors considered is based on a<br>
   *  ratio of non-vehicle nodes, specified by neighbors_ratio, with a minimum<br>
   *  of min-neighbors node considered.
   */
  public RoutingModel.NodeNeighborsByCostClass GetOrCreateNodeNeighborsByCostClass(double neighbors_ratio, long min_neighbors, SWIGTYPE_p_double neighbors_ratio_used, boolean add_vehicle_starts_to_neighbors) {
    long cPtr = mainJNI.RoutingModel_GetOrCreateNodeNeighborsByCostClass__SWIG_0(swigCPtr, this, neighbors_ratio, min_neighbors, SWIGTYPE_p_double.getCPtr(neighbors_ratio_used), add_vehicle_starts_to_neighbors);
    return (cPtr == 0) ? null : new RoutingModel.NodeNeighborsByCostClass(cPtr, false);
  }

  /**
   *  Returns neighbors of all nodes for every cost class. The result is cached<br>
   *  and is computed once. The number of neighbors considered is based on a<br>
   *  ratio of non-vehicle nodes, specified by neighbors_ratio, with a minimum<br>
   *  of min-neighbors node considered.
   */
  public RoutingModel.NodeNeighborsByCostClass GetOrCreateNodeNeighborsByCostClass(double neighbors_ratio, long min_neighbors, SWIGTYPE_p_double neighbors_ratio_used) {
    long cPtr = mainJNI.RoutingModel_GetOrCreateNodeNeighborsByCostClass__SWIG_1(swigCPtr, this, neighbors_ratio, min_neighbors, SWIGTYPE_p_double.getCPtr(neighbors_ratio_used));
    return (cPtr == 0) ? null : new RoutingModel.NodeNeighborsByCostClass(cPtr, false);
  }

  /**
   *  Returns parameters.num_neighbors neighbors of all nodes for every cost<br>
   *  class. The result is cached and is computed once.
   */
  public RoutingModel.NodeNeighborsByCostClass GetOrCreateNodeNeighborsByCostClass(int num_neighbors, boolean add_vehicle_starts_to_neighbors) {
    long cPtr = mainJNI.RoutingModel_GetOrCreateNodeNeighborsByCostClass__SWIG_2(swigCPtr, this, num_neighbors, add_vehicle_starts_to_neighbors);
    return (cPtr == 0) ? null : new RoutingModel.NodeNeighborsByCostClass(cPtr, false);
  }

  /**
   *  Returns parameters.num_neighbors neighbors of all nodes for every cost<br>
   *  class. The result is cached and is computed once.
   */
  public RoutingModel.NodeNeighborsByCostClass GetOrCreateNodeNeighborsByCostClass(int num_neighbors) {
    long cPtr = mainJNI.RoutingModel_GetOrCreateNodeNeighborsByCostClass__SWIG_3(swigCPtr, this, num_neighbors);
    return (cPtr == 0) ? null : new RoutingModel.NodeNeighborsByCostClass(cPtr, false);
  }

  /**
   *  Adds a custom local search filter to the list of filters used to speed up<br>
   *  local search by pruning unfeasible variable assignments.<br>
   *  Calling this method after the routing model has been closed (CloseModel()<br>
   *  or Solve() has been called) has no effect.<br>
   *  The routing model does not take ownership of the filter.
   */
  public void addLocalSearchFilter(LocalSearchFilter filter) {
    mainJNI.RoutingModel_addLocalSearchFilter(swigCPtr, this, LocalSearchFilter.getCPtr(filter), filter);
  }

  /**
   *  Model inspection.<br>
   *  Returns the variable index of the starting node of a vehicle route.
   */
  public long start(int vehicle) {
    return mainJNI.RoutingModel_start(swigCPtr, this, vehicle);
  }

  /**
   *  Returns the variable index of the ending node of a vehicle route.
   */
  public long end(int vehicle) {
    return mainJNI.RoutingModel_end(swigCPtr, this, vehicle);
  }

  /**
   *  Returns true if 'index' represents the first node of a route.
   */
  public boolean isStart(long index) {
    return mainJNI.RoutingModel_isStart(swigCPtr, this, index);
  }

  /**
   *  Returns true if 'index' represents the last node of a route.
   */
  public boolean isEnd(long index) {
    return mainJNI.RoutingModel_isEnd(swigCPtr, this, index);
  }

  /**
   *  Returns the vehicle of the given start/end index, and -1 if the given<br>
   *  index is not a vehicle start/end.
   */
  public int VehicleIndex(long index) {
    return mainJNI.RoutingModel_VehicleIndex(swigCPtr, this, index);
  }

  /**
   *  Assignment inspection<br>
   *  Returns the variable index of the node directly after the node<br>
   *  corresponding to 'index' in 'assignment'.
   */
  public long next(Assignment assignment, long index) {
    return mainJNI.RoutingModel_next(swigCPtr, this, Assignment.getCPtr(assignment), assignment, index);
  }

  /**
   *  Returns true if the route of 'vehicle' is non empty in 'assignment'.
   */
  public boolean isVehicleUsed(Assignment assignment, int vehicle) {
    return mainJNI.RoutingModel_isVehicleUsed(swigCPtr, this, Assignment.getCPtr(assignment), assignment, vehicle);
  }

  /**
   *  Returns all next variables of the model, such that Nexts(i) is the next<br>
   *  variable of the node corresponding to i.
   */
  public IntVar[] nexts() {
  return mainJNI.RoutingModel_nexts(swigCPtr, this);
}

  /**
   *  Returns all vehicle variables of the model,  such that VehicleVars(i) is<br>
   *  the vehicle variable of the node corresponding to i.
   */
  public IntVar[] vehicleVars() {
  return mainJNI.RoutingModel_vehicleVars(swigCPtr, this);
}

  /**
   *  Returns vehicle resource variables for a given resource group, such that<br>
   *  ResourceVars(r_g)[v] is the resource variable for vehicle 'v' in resource<br>
   *  group 'r_g'.
   */
  public IntVar[] ResourceVars(int resource_group) {
  return mainJNI.RoutingModel_ResourceVars(swigCPtr, this, resource_group);
}

  /**
   *  Returns the next variable of the node corresponding to index. Note that<br>
   *  NextVar(index) == index is equivalent to ActiveVar(index) == 0.
   */
  public IntVar nextVar(long index) {
    long cPtr = mainJNI.RoutingModel_nextVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the active variable of the node corresponding to index.
   */
  public IntVar activeVar(long index) {
    long cPtr = mainJNI.RoutingModel_activeVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the active variable of the vehicle. It will be equal to 1 iff the<br>
   *  route of the vehicle is not empty, 0 otherwise.
   */
  public IntVar activeVehicleVar(int vehicle) {
    long cPtr = mainJNI.RoutingModel_activeVehicleVar(swigCPtr, this, vehicle);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the variable specifying whether or not the given vehicle route is<br>
   *  considered for costs and constraints. It will be equal to 1 iff the route<br>
   *  of the vehicle is not empty OR vehicle_used_when_empty_[vehicle] is true.
   */
  public IntVar VehicleRouteConsideredVar(int vehicle) {
    long cPtr = mainJNI.RoutingModel_VehicleRouteConsideredVar(swigCPtr, this, vehicle);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the vehicle variable of the node corresponding to index. Note that<br>
   *  VehicleVar(index) == -1 is equivalent to ActiveVar(index) == 0.
   */
  public IntVar vehicleVar(long index) {
    long cPtr = mainJNI.RoutingModel_vehicleVar(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the resource variable for the given vehicle index in the given<br>
   *  resource group. If a vehicle doesn't require a resource from the<br>
   *  corresponding resource group, then ResourceVar(v, r_g) == -1.
   */
  public IntVar ResourceVar(int vehicle, int resource_group) {
    long cPtr = mainJNI.RoutingModel_ResourceVar(swigCPtr, this, vehicle, resource_group);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the global cost variable which is being minimized.
   */
  public IntVar costVar() {
    long cPtr = mainJNI.RoutingModel_costVar(swigCPtr, this);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the cost of the transit arc between two nodes for a given vehicle.<br>
   *  Input are variable indices of node. This returns 0 if vehicle &lt; 0.
   */
  public long getArcCostForVehicle(long from_index, long to_index, long vehicle) {
    return mainJNI.RoutingModel_getArcCostForVehicle(swigCPtr, this, from_index, to_index, vehicle);
  }

  /**
   *  Whether costs are homogeneous across all vehicles.
   */
  public boolean costsAreHomogeneousAcrossVehicles() {
    return mainJNI.RoutingModel_costsAreHomogeneousAcrossVehicles(swigCPtr, this);
  }

  /**
   *  Returns the cost of the segment between two nodes supposing all vehicle<br>
   *  costs are the same (returns the cost for the first vehicle otherwise).
   */
  public long getHomogeneousCost(long from_index, long to_index) {
    return mainJNI.RoutingModel_getHomogeneousCost(swigCPtr, this, from_index, to_index);
  }

  /**
   *  Returns the cost of the arc in the context of the first solution strategy.<br>
   *  This is typically a simplification of the actual cost; see the .cc.
   */
  public long getArcCostForFirstSolution(long from_index, long to_index) {
    return mainJNI.RoutingModel_getArcCostForFirstSolution(swigCPtr, this, from_index, to_index);
  }

  /**
   *  Returns the cost of the segment between two nodes for a given cost<br>
   *  class. Input are variable indices of nodes and the cost class.<br>
   *  Unlike GetArcCostForVehicle(), if cost_class is kNoCost, then the<br>
   *  returned cost won't necessarily be zero: only some of the components<br>
   *  of the cost that depend on the cost class will be omited. See the code<br>
   *  for details.
   */
  public long getArcCostForClass(long from_index, long to_index, long cost_class_index) {
    return mainJNI.RoutingModel_getArcCostForClass(swigCPtr, this, from_index, to_index, cost_class_index);
  }

  /**
   *  Get the cost class index of the given vehicle.
   */
  public int getCostClassIndexOfVehicle(long vehicle) {
  return mainJNI.RoutingModel_getCostClassIndexOfVehicle(swigCPtr, this, vehicle);
}

  /**
   *  Returns true iff the model contains a vehicle with the given<br>
   *  cost_class_index.
   */
  public boolean hasVehicleWithCostClassIndex(int cost_class_index) {
    return mainJNI.RoutingModel_hasVehicleWithCostClassIndex(swigCPtr, this, cost_class_index);
  }

  /**
   *  Returns the number of different cost classes in the model.
   */
  public int getCostClassesCount() {
    return mainJNI.RoutingModel_getCostClassesCount(swigCPtr, this);
  }

  /**
   *  Ditto, minus the 'always zero', built-in cost class.
   */
  public int getNonZeroCostClassesCount() {
    return mainJNI.RoutingModel_getNonZeroCostClassesCount(swigCPtr, this);
  }

  public int getVehicleClassIndexOfVehicle(long vehicle) {
  return mainJNI.RoutingModel_getVehicleClassIndexOfVehicle(swigCPtr, this, vehicle);
}

  /**
   *  Returns a vehicle of the given vehicle class, and -1 if there are no<br>
   *  vehicles for this class.
   */
  public int GetVehicleOfClass(int vehicle_class) {
    return mainJNI.RoutingModel_GetVehicleOfClass(swigCPtr, this, vehicle_class);
  }

  /**
   *  Returns the number of different vehicle classes in the model.
   */
  public int getVehicleClassesCount() {
    return mainJNI.RoutingModel_getVehicleClassesCount(swigCPtr, this);
  }

  /**
   *  Returns variable indices of nodes constrained to be on the same route.
   */
  public int[] getSameVehicleIndicesOfIndex(int node) {
  return mainJNI.RoutingModel_getSameVehicleIndicesOfIndex(swigCPtr, this, node);
}

  public RoutingModel.VehicleTypeContainer GetVehicleTypeContainer() {
    return new RoutingModel.VehicleTypeContainer(mainJNI.RoutingModel_GetVehicleTypeContainer(swigCPtr, this), false);
  }

  /**
   *  Returns whether the arc from-&gt;to1 is more constrained than from-&gt;to2,<br>
   *  taking into account, in order:<br>
   *  - whether the destination node isn't an end node<br>
   *  - whether the destination node is mandatory<br>
   *  - whether the destination node is bound to the same vehicle as the source<br>
   *  - the "primary constrained" dimension (see SetPrimaryConstrainedDimension)<br>
   *  It then breaks ties using, in order:<br>
   *  - the arc cost (taking unperformed penalties into account)<br>
   *  - the size of the vehicle vars of "to1" and "to2" (lowest size wins)<br>
   *  - the value: the lowest value of the indices to1 and to2 wins.<br>
   *  See the .cc for details.<br>
   *  The more constrained arc is typically preferable when building a<br>
   *  first solution. This method is intended to be used as a callback for the<br>
   *  BestValueByComparisonSelector value selector.<br>
   *  Args:<br>
   *    from: the variable index of the source node<br>
   *    to1: the variable index of the first candidate destination node.<br>
   *    to2: the variable index of the second candidate destination node.
   */
  public boolean arcIsMoreConstrainedThanArc(long from, long to1, long to2) {
    return mainJNI.RoutingModel_arcIsMoreConstrainedThanArc(swigCPtr, this, from, to1, to2);
  }

  /**
   *  Print some debugging information about an assignment, including the<br>
   *  feasible intervals of the CumulVar for dimension "dimension_to_print"<br>
   *  at each step of the routes.<br>
   *  If "dimension_to_print" is omitted, all dimensions will be printed.
   */
  public String debugOutputAssignment(Assignment solution_assignment, String dimension_to_print) {
    return mainJNI.RoutingModel_debugOutputAssignment(swigCPtr, this, Assignment.getCPtr(solution_assignment), solution_assignment, dimension_to_print);
  }

  /**
   *  Returns a vector cumul_bounds, for which cumul_bounds[i][j] is a pair<br>
   *  containing the minimum and maximum of the CumulVar of the jth node on<br>
   *  route i.<br>
   *  - cumul_bounds[i][j].first is the minimum.<br>
   *  - cumul_bounds[i][j].second is the maximum.<br>
   *  Returns the underlying constraint solver. Can be used to add extra<br>
   *  constraints and/or modify search algorithms.
   */
  public Solver solver() {
    long cPtr = mainJNI.RoutingModel_solver(swigCPtr, this);
    return (cPtr == 0) ? null : new Solver(cPtr, false);
  }

  /**
   *  Returns true if the search limit has been crossed with the given time<br>
   *  offset.
   */
  public boolean checkLimit(SWIGTYPE_p_absl__Duration offset) {
    return mainJNI.RoutingModel_checkLimit__SWIG_0(swigCPtr, this, SWIGTYPE_p_absl__Duration.getCPtr(offset));
  }

  /**
   *  Returns true if the search limit has been crossed with the given time<br>
   *  offset.
   */
  public boolean checkLimit() {
    return mainJNI.RoutingModel_checkLimit__SWIG_1(swigCPtr, this);
  }

  /**
   *  Returns the time buffer to safely return a solution.
   */
  public SWIGTYPE_p_absl__Duration TimeBuffer() {
    return new SWIGTYPE_p_absl__Duration(mainJNI.RoutingModel_TimeBuffer(swigCPtr, this), true);
  }

  /**
   *  Sizes and indices<br>
   *  Returns the number of nodes in the model.
   */
  public int nodes() {
    return mainJNI.RoutingModel_nodes(swigCPtr, this);
  }

  /**
   *  Returns the number of vehicle routes in the model.
   */
  public int vehicles() {
    return mainJNI.RoutingModel_vehicles(swigCPtr, this);
  }

  /**
   *  Returns the number of next variables in the model.
   */
  public long size() {
    return mainJNI.RoutingModel_size(swigCPtr, this);
  }

  /**
   *  Returns statistics on first solution search, number of decisions sent to<br>
   *  filters, number of decisions rejected by filters.
   */
  public long getNumberOfDecisionsInFirstSolution(com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    return mainJNI.RoutingModel_getNumberOfDecisionsInFirstSolution(swigCPtr, this, search_parameters.toByteArray());
  }

  public long getNumberOfRejectsInFirstSolution(com.google.ortools.constraintsolver.RoutingSearchParameters search_parameters) {
    return mainJNI.RoutingModel_getNumberOfRejectsInFirstSolution(swigCPtr, this, search_parameters.toByteArray());
  }

  /**
   *  Returns true if a vehicle/node matching problem is detected.
   */
  public boolean isMatchingModel() {
    return mainJNI.RoutingModel_isMatchingModel(swigCPtr, this);
  }

  /**
   *  Returns true if routes are interdependent. This means that any<br>
   *  modification to a route might impact another.
   */
  public boolean AreRoutesInterdependent(SWIGTYPE_p_operations_research__RoutingSearchParameters parameters) {
    return mainJNI.RoutingModel_AreRoutesInterdependent(swigCPtr, this, SWIGTYPE_p_operations_research__RoutingSearchParameters.getCPtr(parameters));
  }

  /**
   *  The next few members are in the public section only for testing purposes.<br>
   * <br>
   *  MakeGuidedSlackFinalizer creates a DecisionBuilder for the slacks of a<br>
   *  dimension using a callback to choose which values to start with.<br>
   *  The finalizer works only when all next variables in the model have<br>
   *  been fixed. It has the following two characteristics:<br>
   *  1. It follows the routes defined by the nexts variables when choosing a<br>
   *     variable to make a decision on.<br>
   *  2. When it comes to choose a value for the slack of node i, the decision<br>
   *     builder first calls the callback with argument i, and supposingly the<br>
   *     returned value is x it creates decisions slack[i] = x, slack[i] = x +<br>
   *     1, slack[i] = x - 1, slack[i] = x + 2, etc.
   */
  public DecisionBuilder makeGuidedSlackFinalizer(RoutingDimension dimension, LongUnaryOperator initializer) {
    long cPtr = mainJNI.RoutingModel_makeGuidedSlackFinalizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension, initializer);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  /**
   *  MakeSelfDependentDimensionFinalizer is a finalizer for the slacks of a<br>
   *  self-dependent dimension. It makes an extensive use of the caches of the<br>
   *  state dependent transits.<br>
   *  In detail, MakeSelfDependentDimensionFinalizer returns a composition of a<br>
   *  local search decision builder with a greedy descent operator for the cumul<br>
   *  of the start of each route and a guided slack finalizer. Provided there<br>
   *  are no time windows and the maximum slacks are large enough, once the<br>
   *  cumul of the start of route is fixed, the guided finalizer can find<br>
   *  optimal values of the slacks for the rest of the route in time<br>
   *  proportional to the length of the route. Therefore the composed finalizer<br>
   *  generally works in time O(log(t)*n*m), where t is the latest possible<br>
   *  departute time, n is the number of nodes in the network and m is the<br>
   *  number of vehicles.
   */
  public DecisionBuilder makeSelfDependentDimensionFinalizer(RoutingDimension dimension) {
    long cPtr = mainJNI.RoutingModel_makeSelfDependentDimensionFinalizer(swigCPtr, this, RoutingDimension.getCPtr(dimension), dimension);
    return (cPtr == 0) ? null : new DecisionBuilder(cPtr, false);
  }

  // Status 
  /**
   *  Status of the search.
   */

  /**
   *  Problem not solved yet (before calling RoutingModel::Solve()).
   */
  public final static int ROUTING_NOT_SOLVED = mainJNI.RoutingModel_ROUTING_NOT_SOLVED_get();
  /**
   *  Problem solved successfully after calling RoutingModel::Solve().
   */
  public final static int ROUTING_SUCCESS = mainJNI.RoutingModel_ROUTING_SUCCESS_get();
  /**
   *  Problem solved successfully after calling RoutingModel::Solve(), except<br>
   *  that a local optimum has not been reached. Leaving more time would allow<br>
   *  improving the solution.
   */
  public final static int ROUTING_PARTIAL_SUCCESS_LOCAL_OPTIMUM_NOT_REACHED = mainJNI.RoutingModel_ROUTING_PARTIAL_SUCCESS_LOCAL_OPTIMUM_NOT_REACHED_get();
  /**
   *  No solution found to the problem after calling RoutingModel::Solve().
   */
  public final static int ROUTING_FAIL = mainJNI.RoutingModel_ROUTING_FAIL_get();
  /**
   *  Time limit reached before finding a solution with RoutingModel::Solve().
   */
  public final static int ROUTING_FAIL_TIMEOUT = mainJNI.RoutingModel_ROUTING_FAIL_TIMEOUT_get();
  /**
   *  Model, model parameters or flags are not valid.
   */
  public final static int ROUTING_INVALID = mainJNI.RoutingModel_ROUTING_INVALID_get();
  /**
   *  Problem proven to be infeasible.
   */
  public final static int ROUTING_INFEASIBLE = mainJNI.RoutingModel_ROUTING_INFEASIBLE_get();

  // PickupAndDeliveryPolicy 
  /**
   *  Types of precedence policy applied to pickup and delivery pairs.
   */

  /**
   *  Any precedence is accepted.
   */
  public final static int PICKUP_AND_DELIVERY_NO_ORDER = mainJNI.RoutingModel_PICKUP_AND_DELIVERY_NO_ORDER_get();
  /**
   *  Deliveries must be performed in reverse order of pickups.
   */
  public final static int PICKUP_AND_DELIVERY_LIFO = mainJNI.RoutingModel_PICKUP_AND_DELIVERY_LIFO_get();
  /**
   *  Deliveries must be performed in the same order as pickups.
   */
  public final static int PICKUP_AND_DELIVERY_FIFO = mainJNI.RoutingModel_PICKUP_AND_DELIVERY_FIFO_get();

  // TransitEvaluatorSign 
  /**
   *  Represents the sign of values returned by a transit evaluator.
   */

  public final static int kTransitEvaluatorSignUnknown = mainJNI.RoutingModel_kTransitEvaluatorSignUnknown_get();
  public final static int kTransitEvaluatorSignPositiveOrZero = mainJNI.RoutingModel_kTransitEvaluatorSignPositiveOrZero_get();
  public final static int kTransitEvaluatorSignNegativeOrZero = mainJNI.RoutingModel_kTransitEvaluatorSignNegativeOrZero_get();

  // VisitTypePolicy 
  /**
   *  Set the node visit types and incompatibilities/requirements between the<br>
   *  types (see below).<br>
   * <br>
   *  NOTE: Before adding any incompatibilities and/or requirements on types:<br>
   *        1) All corresponding node types must have been set.<br>
   *        2) CloseVisitTypes() must be called so all containers are resized<br>
   *           accordingly.<br>
   * <br>
   *  The following enum is used to describe how a node with a given type 'T'<br>
   *  impacts the number of types 'T' on the route when visited, and thus<br>
   *  determines how temporal incompatibilities and requirements take effect.
   */

  /**
   *  When visited, the number of types 'T' on the vehicle increases by one.
   */
  public final static int TYPE_ADDED_TO_VEHICLE = mainJNI.RoutingModel_TYPE_ADDED_TO_VEHICLE_get();
  /**
   *  When visited, one instance of type 'T' previously added to the route<br>
   *  (TYPE_ADDED_TO_VEHICLE), if any, is removed from the vehicle.<br>
   *  If the type was not previously added to the route or all added instances<br>
   *  have already been removed, this visit has no effect on the types.
   */
  public final static int ADDED_TYPE_REMOVED_FROM_VEHICLE = mainJNI.RoutingModel_ADDED_TYPE_REMOVED_FROM_VEHICLE_get();
  /**
   *  With the following policy, the visit enforces that type 'T' is<br>
   *  considered on the route from its start until this node is visited.
   */
  public final static int TYPE_ON_VEHICLE_UP_TO_VISIT = mainJNI.RoutingModel_TYPE_ON_VEHICLE_UP_TO_VISIT_get();
  /**
   *  The visit doesn't have an impact on the number of types 'T' on the<br>
   *  route, as it's (virtually) added and removed directly.<br>
   *  This policy can be used for visits which are part of an incompatibility<br>
   *  or requirement set without affecting the type count on the route.
   */
  public final static int TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED = mainJNI.RoutingModel_TYPE_SIMULTANEOUSLY_ADDED_AND_REMOVED_get();

}
