/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.constraintsolver;

/**
 *  A sequence variable is a variable whose domain is a set of possible<br>
 *  orderings of the interval variables. It allows ordering of tasks. It<br>
 *  has two sets of methods: ComputePossibleFirstsAndLasts(), which<br>
 *  returns the list of interval variables that can be ranked first or<br>
 *  last; and RankFirst/RankNotFirst/RankLast/RankNotLast, which can be<br>
 *  used to create the search decision.
 */
public class SequenceVar extends PropagationBaseObject {
  private transient long swigCPtr;

  protected SequenceVar(long cPtr, boolean cMemoryOwn) {
    super(mainJNI.SequenceVar_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SequenceVar obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SequenceVar obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_SequenceVar(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  public SequenceVar(Solver s, IntervalVar[] intervals, IntVar[] nexts, String name) {
    this(mainJNI.new_SequenceVar(Solver.getCPtr(s), s, intervals, nexts, name), true);
  }

  public String toString() {
    return mainJNI.SequenceVar_toString(swigCPtr, this);
  }

  /**
   *  Ranks the index_th interval var first of all unranked interval<br>
   *  vars. After that, it will no longer be considered ranked.
   */
  public void rankFirst(int index) {
    mainJNI.SequenceVar_rankFirst(swigCPtr, this, index);
  }

  /**
   *  Indicates that the index_th interval var will not be ranked first<br>
   *  of all currently unranked interval vars.
   */
  public void rankNotFirst(int index) {
    mainJNI.SequenceVar_rankNotFirst(swigCPtr, this, index);
  }

  /**
   *  Ranks the index_th interval var first of all unranked interval<br>
   *  vars. After that, it will no longer be considered ranked.
   */
  public void rankLast(int index) {
    mainJNI.SequenceVar_rankLast(swigCPtr, this, index);
  }

  /**
   *  Indicates that the index_th interval var will not be ranked first<br>
   *  of all currently unranked interval vars.
   */
  public void rankNotLast(int index) {
    mainJNI.SequenceVar_rankNotLast(swigCPtr, this, index);
  }

  /**
   *  Applies the following sequence of ranks, ranks first, then rank<br>
   *  last.  rank_first and rank_last represents different directions.<br>
   *  rank_first[0] corresponds to the first interval of the sequence.<br>
   *  rank_last[0] corresponds to the last interval of the sequence.<br>
   *  All intervals in the unperformed vector will be marked as such.
   */
  public void rankSequence(int[] rank_first, int[] rank_last, int[] unperformed) {
    mainJNI.SequenceVar_rankSequence(swigCPtr, this, rank_first, rank_last, unperformed);
  }

  /**
   *  Returns the index_th interval of the sequence.
   */
  public IntervalVar interval(int index) {
    long cPtr = mainJNI.SequenceVar_interval(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntervalVar(cPtr, false);
  }

  /**
   *  Returns the next of the index_th interval of the sequence.
   */
  public IntVar next(int index) {
    long cPtr = mainJNI.SequenceVar_next(swigCPtr, this, index);
    return (cPtr == 0) ? null : new IntVar(cPtr, false);
  }

  /**
   *  Returns the number of interval vars in the sequence.
   */
  public long size() {
    return mainJNI.SequenceVar_size(swigCPtr, this);
  }

  /**
   *  Accepts the given visitor.
   */
  public void accept(ModelVisitor visitor) {
    mainJNI.SequenceVar_accept(swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
  }

}
