/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */


#define SWIG_VERSION 0x040101
#define SWIGJAVA
#define SWIG_DIRECTORS

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) do { if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } } while (0)

/* SWIG Errors applicable to all language modules, values are reserved from -1 to -99 */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13


/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
#include <pthread.h>
#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
    static void detach(void *jvm) {
      static_cast<JavaVM *>(jvm)->DetachCurrentThread();
    }

    static void make_detach_key() {
      pthread_key_create(&detach_key_, detach);
    }

    /* thread-local key to register a destructor */
    static pthread_key_t detach_key_;
#endif

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
  pthread_key_t JObjectWrapper::detach_key_;
#endif

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
        // At least on Android 6, detaching after every call causes a memory leak.
        // Instead, register a thread desructor and detach only when the thread ends.
        // See https://developer.android.com/training/articles/perf-jni#threads
        static pthread_once_t once = PTHREAD_ONCE_INIT;

        pthread_once(&once, JObjectWrapper::make_detach_key);
        pthread_setspecific(JObjectWrapper::detach_key_, director->swig_jvm_);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_DETACH_ON_THREAD_END) && !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    struct SwigDirectorMethod {
      const char *name;
      const char *desc;
      jmethodID methid;
      SwigDirectorMethod(JNIEnv *jenv, jclass baseclass, const char *name, const char *desc) : name(name), desc(desc) {
        methid = jenv->GetMethodID(baseclass, name, desc);
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

    jclass swig_new_global_ref(JNIEnv *jenv, const char *classname) {
      jclass clz = jenv->FindClass(classname);
      return clz ? (jclass)jenv->NewGlobalRef(clz) : 0;
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(0));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(0), throwable_(0), classname_(0), msg_(msg ? copystr(msg) : 0) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = 0;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = 0;
          jclass throwableclass = 0;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_mainJNI = NULL;
    jmethodID director_method_ids[117];
  }
}

#ifdef __cplusplus
#include <utility>
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigSmartPointer {
    T *ptr;
    SwigSmartPointer(T *p) : ptr(p) { }
    ~SwigSmartPointer() { delete ptr; }
    SwigSmartPointer& operator=(SwigSmartPointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
    void reset(T *p) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = p; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigSmartPointer tmp(new T(t)); pointer = tmp; return *this; }
#if __cplusplus >=201103L
  SwigValueWrapper& operator=(T&& t) { SwigSmartPointer tmp(new T(std::move(t))); pointer = tmp; return *this; }
  operator T&&() const { return std::move(*pointer.ptr); }
#else
  operator T&() const { return *pointer.ptr; }
#endif
  T *operator&() const { return pointer.ptr; }
  static void reset(SwigValueWrapper& t, T *p) { t.pointer.reset(p); }
};

/*
 * SwigValueInit() is a generic initialisation solution as the following approach:
 * 
 *       T c_result = T();
 * 
 * doesn't compile for all types for example:
 * 
 *       unsigned int c_result = unsigned int();
 */
template <typename T> T SwigValueInit() {
  return T();
}

#if __cplusplus >=201103L
# define SWIG_STD_MOVE(OBJ) std::move(OBJ)
#else
# define SWIG_STD_MOVE(OBJ) OBJ
#endif

#endif


#include <typeinfo>
#include <stdexcept>


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <utility>


#include <cstdint>
#include <string>
#include <vector>

#include "ortools/base/integral_types.h"


#include <stdint.h>		// Use the C99 official header


#define SWIGWORDSIZE64
#ifndef LONG_MAX
#include <limits.h>
#endif
#if (__WORDSIZE == 32) || (LONG_MAX == INT_MAX)
# error "SWIG wrapped code invalid in 32 bit architecture, regenerate code using -DSWIGWORDSIZE32"
#endif


#include <string>


#include <vector>
#include "ortools/base/integral_types.h"


// TODO(user): see if we can remove <vector>
#include <vector>
#include "ortools/base/integral_types.h"
#include "ortools/util/tuple_set.h"


#include "ortools/base/integral_types.h"


#include "ortools/constraint_solver/constraint_solver.h"
#include "ortools/constraint_solver/constraint_solveri.h"
#include "ortools/constraint_solver/java/javawrapcp_util.h"
#include "ortools/constraint_solver/search_limit.pb.h"
#include "ortools/constraint_solver/solver_parameters.pb.h"

// Supporting structure for the PROTECT_FROM_FAILURE macro.
#include "setjmp.h"
struct FailureProtect {
  jmp_buf exception_buffer;
  void JumpBack() { longjmp(exception_buffer, 1); }
};

/* Global JNI reference deleter */
class GlobalRefGuard {
  JavaVM *jvm_;
  jobject jref_;
  // non-copyable
  GlobalRefGuard(const GlobalRefGuard &) = delete;
  GlobalRefGuard &operator=(const GlobalRefGuard &) = delete;
  public:
  GlobalRefGuard(JavaVM *jvm, jobject jref): jvm_(jvm), jref_(jref) {}
  ~GlobalRefGuard() {
    JNIEnv *jenv = NULL;
    JavaVMAttachArgs args;
    args.version = JNI_VERSION_1_2;
    args.name = NULL;
    args.group = NULL;
    jvm_->AttachCurrentThread((void**)&jenv, &args);
    jenv->DeleteGlobalRef(jref_);
    jvm_->DetachCurrentThread();
  }
};


#include <setjmp.h>
#include <vector>

#include "ortools/base/integral_types.h"
#include "ortools/constraint_solver/constraint_solver.h"
#include "ortools/constraint_solver/constraint_solveri.h"


#include <memory> // std::make_shared<GlobalRefGuard>

SWIGINTERN int operations_research_IntVarLocalSearchFilter_index(operations_research::IntVarLocalSearchFilter *self,operations_research::IntVar *const var){
    int64_t index = -1;
    self->FindIndex(var, &index);
    return index;
  }

#include "ortools/constraint_solver/routing_types.h"


#include "ortools/constraint_solver/routing_index_manager.h"


#include "ortools/constraint_solver/routing_types.h"
#include "ortools/constraint_solver/routing_parameters.pb.h"
#include "ortools/constraint_solver/routing_parameters.h"
#include "ortools/constraint_solver/routing.h"
#include <memory>



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "routingJAVA_wrap.h"

SwigDirector_Decision::SwigDirector_Decision(JNIEnv *jenv) : operations_research::Decision(), Swig::Director(jenv) {
}

SwigDirector_Decision::~SwigDirector_Decision() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_Decision::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::Decision::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[0], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::Decision::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Decision::Apply(operations_research::Solver *s) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong js = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::Decision::Apply.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Solver **)&js) = (operations_research::Solver *) s; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[1], swigjobj, js);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::Decision::Apply ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Decision::Refute(operations_research::Solver *s) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong js = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::Decision::Refute.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Solver **)&js) = (operations_research::Solver *) s; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[2], swigjobj, js);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::Decision::Refute ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Decision::Accept(operations_research::DecisionVisitor *visitor) const {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvisitor = 0 ;
  
  if (!swig_override[3]) {
    operations_research::Decision::Accept(visitor);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::DecisionVisitor **)&jvisitor) = (operations_research::DecisionVisitor *) visitor; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[3], swigjobj, jvisitor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::Decision::Accept ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Decision::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/Decision");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "apply", "(Lcom/google/ortools/constraintsolver/Solver;)V"),
    SwigDirectorMethod(jenv, baseclass, "refute", "(Lcom/google/ortools/constraintsolver/Solver;)V"),
    SwigDirectorMethod(jenv, baseclass, "accept", "(Lcom/google/ortools/constraintsolver/DecisionVisitor;)V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_DecisionVisitor::SwigDirector_DecisionVisitor(JNIEnv *jenv) : operations_research::DecisionVisitor(), Swig::Director(jenv) {
}

SwigDirector_DecisionVisitor::~SwigDirector_DecisionVisitor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_DecisionVisitor::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[4], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_DecisionVisitor::VisitSetVariableValue(operations_research::IntVar *var,int64_t value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jvalue  ;
  
  if (!swig_override[1]) {
    operations_research::DecisionVisitor::VisitSetVariableValue(var,value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntVar **)&jvar) = (operations_research::IntVar *) var; 
    jvalue = (jlong) value;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[5], swigjobj, jvar, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitSetVariableValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitSplitVariableDomain(operations_research::IntVar *var,int64_t value,bool start_with_lower_half) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jvalue  ;
  jboolean jstart_with_lower_half  ;
  
  if (!swig_override[2]) {
    operations_research::DecisionVisitor::VisitSplitVariableDomain(var,value,start_with_lower_half);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntVar **)&jvar) = (operations_research::IntVar *) var; 
    jvalue = (jlong) value;
    jstart_with_lower_half = (jboolean) start_with_lower_half;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[6], swigjobj, jvar, jvalue, jstart_with_lower_half);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitSplitVariableDomain ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitScheduleOrPostpone(operations_research::IntervalVar *var,int64_t est) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jest  ;
  
  if (!swig_override[3]) {
    operations_research::DecisionVisitor::VisitScheduleOrPostpone(var,est);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntervalVar **)&jvar) = (operations_research::IntervalVar *) var; 
    jest = (jlong) est;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[7], swigjobj, jvar, jest);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitScheduleOrPostpone ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitScheduleOrExpedite(operations_research::IntervalVar *var,int64_t est) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jest  ;
  
  if (!swig_override[4]) {
    operations_research::DecisionVisitor::VisitScheduleOrExpedite(var,est);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntervalVar **)&jvar) = (operations_research::IntervalVar *) var; 
    jest = (jlong) est;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[8], swigjobj, jvar, jest);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitScheduleOrExpedite ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitRankFirstInterval(operations_research::SequenceVar *sequence,int index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsequence = 0 ;
  jint jindex  ;
  
  if (!swig_override[5]) {
    operations_research::DecisionVisitor::VisitRankFirstInterval(sequence,index);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::SequenceVar **)&jsequence) = (operations_research::SequenceVar *) sequence; 
    jindex = (jint) index;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[9], swigjobj, jsequence, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitRankFirstInterval ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitRankLastInterval(operations_research::SequenceVar *sequence,int index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsequence = 0 ;
  jint jindex  ;
  
  if (!swig_override[6]) {
    operations_research::DecisionVisitor::VisitRankLastInterval(sequence,index);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::SequenceVar **)&jsequence) = (operations_research::SequenceVar *) sequence; 
    jindex = (jint) index;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[10], swigjobj, jsequence, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitRankLastInterval ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::VisitUnknownDecision() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    operations_research::DecisionVisitor::VisitUnknownDecision();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[11], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionVisitor::VisitUnknownDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_DecisionVisitor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/DecisionVisitor");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "visitSetVariableValue", "(Lcom/google/ortools/constraintsolver/IntVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitSplitVariableDomain", "(Lcom/google/ortools/constraintsolver/IntVar;JZ)V"),
    SwigDirectorMethod(jenv, baseclass, "visitScheduleOrPostpone", "(Lcom/google/ortools/constraintsolver/IntervalVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitScheduleOrExpedite", "(Lcom/google/ortools/constraintsolver/IntervalVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitRankFirstInterval", "(Lcom/google/ortools/constraintsolver/SequenceVar;I)V"),
    SwigDirectorMethod(jenv, baseclass, "visitRankLastInterval", "(Lcom/google/ortools/constraintsolver/SequenceVar;I)V"),
    SwigDirectorMethod(jenv, baseclass, "visitUnknownDecision", "()V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 8; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_DecisionBuilder::SwigDirector_DecisionBuilder(JNIEnv *jenv) : operations_research::DecisionBuilder(), Swig::Director(jenv) {
}

SwigDirector_DecisionBuilder::~SwigDirector_DecisionBuilder() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_DecisionBuilder::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::DecisionBuilder::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[12], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionBuilder::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

operations_research::Decision *SwigDirector_DecisionBuilder::Next(operations_research::Solver *s) {
  operations_research::Decision *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong js = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::DecisionBuilder::Next.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Solver **)&js) = (operations_research::Solver *) s; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[13], swigjobj, js);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = *(operations_research::Decision **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::DecisionBuilder::Next ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_DecisionBuilder::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/DecisionBuilder");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "nextWrap", "(Lcom/google/ortools/constraintsolver/Solver;)Lcom/google/ortools/constraintsolver/Decision;")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_SearchMonitor::SwigDirector_SearchMonitor(JNIEnv *jenv,operations_research::Solver *const s) : operations_research::SearchMonitor(s), Swig::Director(jenv) {
}

SwigDirector_SearchMonitor::~SwigDirector_SearchMonitor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_SearchMonitor::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[14], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SearchMonitor::EnterSearch() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    operations_research::SearchMonitor::EnterSearch();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[15], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::EnterSearch ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::RestartSearch() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    operations_research::SearchMonitor::RestartSearch();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[16], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::RestartSearch ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::ExitSearch() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    operations_research::SearchMonitor::ExitSearch();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[17], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::ExitSearch ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::BeginNextDecision(operations_research::DecisionBuilder *b) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jb = 0 ;
  
  if (!swig_override[4]) {
    operations_research::SearchMonitor::BeginNextDecision(b);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::DecisionBuilder **)&jb) = (operations_research::DecisionBuilder *) b; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[18], swigjobj, jb);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::BeginNextDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::EndNextDecision(operations_research::DecisionBuilder *b,operations_research::Decision *d) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jb = 0 ;
  jlong jd = 0 ;
  
  if (!swig_override[5]) {
    operations_research::SearchMonitor::EndNextDecision(b,d);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::DecisionBuilder **)&jb) = (operations_research::DecisionBuilder *) b; 
    *((operations_research::Decision **)&jd) = (operations_research::Decision *) d; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[19], swigjobj, jb, jd);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::EndNextDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::ApplyDecision(operations_research::Decision *d) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jd = 0 ;
  
  if (!swig_override[6]) {
    operations_research::SearchMonitor::ApplyDecision(d);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Decision **)&jd) = (operations_research::Decision *) d; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[20], swigjobj, jd);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::ApplyDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::RefuteDecision(operations_research::Decision *d) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jd = 0 ;
  
  if (!swig_override[7]) {
    operations_research::SearchMonitor::RefuteDecision(d);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Decision **)&jd) = (operations_research::Decision *) d; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[21], swigjobj, jd);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::RefuteDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::AfterDecision(operations_research::Decision *d,bool apply) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jd = 0 ;
  jboolean japply  ;
  
  if (!swig_override[8]) {
    operations_research::SearchMonitor::AfterDecision(d,apply);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Decision **)&jd) = (operations_research::Decision *) d; 
    japply = (jboolean) apply;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[22], swigjobj, jd, japply);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AfterDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::BeginFail() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    operations_research::SearchMonitor::BeginFail();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[23], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::BeginFail ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::EndFail() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[10]) {
    operations_research::SearchMonitor::EndFail();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[24], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::EndFail ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::BeginInitialPropagation() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[11]) {
    operations_research::SearchMonitor::BeginInitialPropagation();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[25], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::BeginInitialPropagation ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::EndInitialPropagation() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[12]) {
    operations_research::SearchMonitor::EndInitialPropagation();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[26], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::EndInitialPropagation ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_SearchMonitor::AcceptSolution() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[13]) {
    return operations_research::SearchMonitor::AcceptSolution();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[27], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AcceptSolution ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_SearchMonitor::AtSolution() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[14]) {
    return operations_research::SearchMonitor::AtSolution();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[28], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AtSolution ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SearchMonitor::NoMoreSolutions() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[15]) {
    operations_research::SearchMonitor::NoMoreSolutions();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[29], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::NoMoreSolutions ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_SearchMonitor::LocalOptimum() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[16]) {
    return operations_research::SearchMonitor::LocalOptimum();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[30], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::LocalOptimum ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_SearchMonitor::AcceptDelta(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[17]) {
    return operations_research::SearchMonitor::AcceptDelta(delta,deltadelta);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[31], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AcceptDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SearchMonitor::AcceptNeighbor() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[18]) {
    operations_research::SearchMonitor::AcceptNeighbor();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[32], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AcceptNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::AcceptUncheckedNeighbor() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[19]) {
    operations_research::SearchMonitor::AcceptUncheckedNeighbor();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[33], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::AcceptUncheckedNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_SearchMonitor::IsUncheckedSolutionLimitReached() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[20]) {
    return operations_research::SearchMonitor::IsUncheckedSolutionLimitReached();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[34], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::IsUncheckedSolutionLimitReached ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SearchMonitor::PeriodicCheck() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[21]) {
    operations_research::SearchMonitor::PeriodicCheck();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[35], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::PeriodicCheck ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int SwigDirector_SearchMonitor::ProgressPercent() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[22]) {
    return operations_research::SearchMonitor::ProgressPercent();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_mainJNI, Swig::director_method_ids[36], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::ProgressPercent ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SearchMonitor::Accept(operations_research::ModelVisitor *visitor) const {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvisitor = 0 ;
  
  if (!swig_override[23]) {
    operations_research::SearchMonitor::Accept(visitor);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::ModelVisitor **)&jvisitor) = (operations_research::ModelVisitor *) visitor; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[37], swigjobj, jvisitor);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::Accept ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::Install() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[24]) {
    operations_research::SearchMonitor::Install();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[38], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SearchMonitor::Install ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SearchMonitor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/SearchMonitor");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "enterSearch", "()V"),
    SwigDirectorMethod(jenv, baseclass, "restartSearch", "()V"),
    SwigDirectorMethod(jenv, baseclass, "exitSearch", "()V"),
    SwigDirectorMethod(jenv, baseclass, "beginNextDecision", "(Lcom/google/ortools/constraintsolver/DecisionBuilder;)V"),
    SwigDirectorMethod(jenv, baseclass, "endNextDecision", "(Lcom/google/ortools/constraintsolver/DecisionBuilder;Lcom/google/ortools/constraintsolver/Decision;)V"),
    SwigDirectorMethod(jenv, baseclass, "applyDecision", "(Lcom/google/ortools/constraintsolver/Decision;)V"),
    SwigDirectorMethod(jenv, baseclass, "refuteDecision", "(Lcom/google/ortools/constraintsolver/Decision;)V"),
    SwigDirectorMethod(jenv, baseclass, "afterDecision", "(Lcom/google/ortools/constraintsolver/Decision;Z)V"),
    SwigDirectorMethod(jenv, baseclass, "beginFail", "()V"),
    SwigDirectorMethod(jenv, baseclass, "endFail", "()V"),
    SwigDirectorMethod(jenv, baseclass, "beginInitialPropagation", "()V"),
    SwigDirectorMethod(jenv, baseclass, "endInitialPropagation", "()V"),
    SwigDirectorMethod(jenv, baseclass, "acceptSolution", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "atSolution", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "noMoreSolutions", "()V"),
    SwigDirectorMethod(jenv, baseclass, "localOptimum", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "acceptDelta", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)Z"),
    SwigDirectorMethod(jenv, baseclass, "acceptNeighbor", "()V"),
    SwigDirectorMethod(jenv, baseclass, "AcceptUncheckedNeighbor", "()V"),
    SwigDirectorMethod(jenv, baseclass, "IsUncheckedSolutionLimitReached", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "periodicCheck", "()V"),
    SwigDirectorMethod(jenv, baseclass, "progressPercent", "()I"),
    SwigDirectorMethod(jenv, baseclass, "accept", "(Lcom/google/ortools/constraintsolver/ModelVisitor;)V"),
    SwigDirectorMethod(jenv, baseclass, "install", "()V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 25; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_LocalSearchOperator::SwigDirector_LocalSearchOperator(JNIEnv *jenv) : operations_research::LocalSearchOperator(), Swig::Director(jenv) {
}

SwigDirector_LocalSearchOperator::~SwigDirector_LocalSearchOperator() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_LocalSearchOperator::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[39], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_LocalSearchOperator::MakeNextNeighbor(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::LocalSearchOperator::MakeNextNeighbor.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[40], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::MakeNextNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchOperator::Start(operations_research::Assignment const *assignment) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::LocalSearchOperator::Start.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[41], swigjobj, jassignment);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::Start ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_LocalSearchOperator::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    operations_research::LocalSearchOperator::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[42], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_LocalSearchOperator::HasFragments() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::LocalSearchOperator::HasFragments();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[43], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::HasFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_LocalSearchOperator::HoldsDelta() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return operations_research::LocalSearchOperator::HoldsDelta();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[44], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchOperator::HoldsDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchOperator::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/LocalSearchOperator");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "nextNeighbor", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)Z"),
    SwigDirectorMethod(jenv, baseclass, "start", "(Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "HasFragments", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "HoldsDelta", "()Z")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 6; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_IntVarLocalSearchOperator::SwigDirector_IntVarLocalSearchOperator(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &vars,bool keep_inverse_values) : operations_research::IntVarLocalSearchOperator(vars, keep_inverse_values), Swig::Director(jenv) {
}

SwigDirector_IntVarLocalSearchOperator::~SwigDirector_IntVarLocalSearchOperator() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_IntVarLocalSearchOperator::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[45], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_IntVarLocalSearchOperator::MakeNextNeighbor(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  return operations_research::IntVarLocalSearchOperator::MakeNextNeighbor(delta,deltadelta);
}

void SwigDirector_IntVarLocalSearchOperator::Start(operations_research::Assignment const *assignment) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  
  if (!swig_override[1]) {
    operations_research::IntVarLocalSearchOperator::Start(assignment);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[46], swigjobj, jassignment);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::Start ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_IntVarLocalSearchOperator::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    operations_research::LocalSearchOperator::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[47], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_IntVarLocalSearchOperator::HasFragments() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return operations_research::LocalSearchOperator::HasFragments();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[48], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::HasFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_IntVarLocalSearchOperator::HoldsDelta() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::IntVarLocalSearchOperator::HoldsDelta();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[49], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::HoldsDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_IntVarLocalSearchOperator::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return operations_research::IntVarLocalSearchOperator::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[50], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_IntVarLocalSearchOperator::SkipUnchanged(int index) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jindex  ;
  
  if (!swig_override[6]) {
    return operations_research::IntVarLocalSearchOperator::SkipUnchanged(index);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jindex = (jint) index;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[51], swigjobj, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::SkipUnchanged ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_IntVarLocalSearchOperator::OnStart() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    operations_research::IntVarLocalSearchOperator::OnStart();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[52], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::OnStart ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_IntVarLocalSearchOperator::MakeOneNeighbor() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return operations_research::IntVarLocalSearchOperator::MakeOneNeighbor();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[53], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchOperator::MakeOneNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_IntVarLocalSearchOperator::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/IntVarLocalSearchOperator");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "start", "(Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "HasFragments", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "HoldsDelta", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "SkipUnchanged", "(I)Z"),
    SwigDirectorMethod(jenv, baseclass, "onStart", "()V"),
    SwigDirectorMethod(jenv, baseclass, "oneNeighbor", "()Z")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 9; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_BaseLns::SwigDirector_BaseLns(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &vars) : operations_research::BaseLns(vars), Swig::Director(jenv) {
}

SwigDirector_BaseLns::~SwigDirector_BaseLns() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_BaseLns::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[54], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_BaseLns::MakeNextNeighbor(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  return operations_research::IntVarLocalSearchOperator::MakeNextNeighbor(delta,deltadelta);
}

void SwigDirector_BaseLns::Start(operations_research::Assignment const *assignment) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  
  if (!swig_override[1]) {
    operations_research::IntVarLocalSearchOperator::Start(assignment);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[55], swigjobj, jassignment);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::Start ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_BaseLns::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    operations_research::LocalSearchOperator::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[56], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_BaseLns::HasFragments() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return operations_research::BaseLns::HasFragments();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[57], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::HasFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_BaseLns::HoldsDelta() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::IntVarLocalSearchOperator::HoldsDelta();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[58], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::HoldsDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_BaseLns::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return operations_research::IntVarLocalSearchOperator::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[59], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseLns::InitFragments() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    operations_research::BaseLns::InitFragments();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[60], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::InitFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_BaseLns::NextFragment() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::BaseLns::NextFragment.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[61], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::BaseLns::NextFragment ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_BaseLns::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/BaseLns");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "start", "(Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "HasFragments", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "HoldsDelta", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "initFragments", "()V"),
    SwigDirectorMethod(jenv, baseclass, "nextFragment", "()Z")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 8; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ChangeValue::SwigDirector_ChangeValue(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &vars) : operations_research::ChangeValue(vars), Swig::Director(jenv) {
}

SwigDirector_ChangeValue::~SwigDirector_ChangeValue() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_ChangeValue::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[62], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ChangeValue::MakeNextNeighbor(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  return operations_research::IntVarLocalSearchOperator::MakeNextNeighbor(delta,deltadelta);
}

void SwigDirector_ChangeValue::Start(operations_research::Assignment const *assignment) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  
  if (!swig_override[1]) {
    operations_research::IntVarLocalSearchOperator::Start(assignment);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[63], swigjobj, jassignment);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::Start ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ChangeValue::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    operations_research::LocalSearchOperator::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[64], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_ChangeValue::HasFragments() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return operations_research::LocalSearchOperator::HasFragments();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[65], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::HasFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ChangeValue::HoldsDelta() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::IntVarLocalSearchOperator::HoldsDelta();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[66], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::HoldsDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ChangeValue::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return operations_research::IntVarLocalSearchOperator::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[67], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ChangeValue::SkipUnchanged(int index) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jindex  ;
  
  if (!swig_override[6]) {
    return operations_research::IntVarLocalSearchOperator::SkipUnchanged(index);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jindex = (jint) index;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[68], swigjobj, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::SkipUnchanged ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ChangeValue::OnStart() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    operations_research::IntVarLocalSearchOperator::OnStart();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[69], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::OnStart ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_ChangeValue::MakeOneNeighbor() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return operations_research::ChangeValue::MakeOneNeighbor();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[70], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::MakeOneNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int64_t SwigDirector_ChangeValue::ModifyValue(int64_t index,int64_t value) {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jindex  ;
  jlong jvalue  ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::ChangeValue::ModifyValue.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jindex = (jlong) index;
    jvalue = (jlong) value;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[71], swigjobj, jindex, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::ChangeValue::ModifyValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ChangeValue::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/ChangeValue");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "start", "(Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "HasFragments", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "HoldsDelta", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "SkipUnchanged", "(I)Z"),
    SwigDirectorMethod(jenv, baseclass, "onStart", "()V"),
    SwigDirectorMethod(jenv, baseclass, "oneNeighbor", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "modifyValue", "(JJ)J")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 10; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_PathOperator::SwigDirector_PathOperator(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &next_vars,std::vector< operations_research::IntVar * > const &path_vars,operations_research::PathOperator::IterationParameters iteration_parameters) : operations_research::PathOperator(next_vars, path_vars, iteration_parameters), Swig::Director(jenv) {
}

SwigDirector_PathOperator::SwigDirector_PathOperator(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &next_vars,std::vector< operations_research::IntVar * > const &path_vars,int number_of_base_nodes,bool skip_locally_optimal_paths,bool accept_path_end_base,std::function< int (int64_t) > start_empty_path_class,std::function< std::vector< int > const &(int,int) > get_neighbors) : operations_research::PathOperator(next_vars, path_vars, number_of_base_nodes, skip_locally_optimal_paths, accept_path_end_base, start_empty_path_class, get_neighbors), Swig::Director(jenv) {
}

SwigDirector_PathOperator::~SwigDirector_PathOperator() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_PathOperator::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[72], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::MakeNextNeighbor(operations_research::Assignment *delta,operations_research::Assignment *deltadelta) {
  return operations_research::IntVarLocalSearchOperator::MakeNextNeighbor(delta,deltadelta);
}

void SwigDirector_PathOperator::Start(operations_research::Assignment const *assignment) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  
  if (!swig_override[1]) {
    operations_research::IntVarLocalSearchOperator::Start(assignment);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[73], swigjobj, jassignment);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::Start ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_PathOperator::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    operations_research::PathOperator::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[74], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PathOperator::HasFragments() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return operations_research::LocalSearchOperator::HasFragments();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[75], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::HasFragments ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::HoldsDelta() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::IntVarLocalSearchOperator::HoldsDelta();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[76], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::HoldsDelta ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    return operations_research::IntVarLocalSearchOperator::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[77], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::SkipUnchanged(int index) const {
  return operations_research::PathOperator::SkipUnchanged(index);
}

void SwigDirector_PathOperator::OnStart() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    operations_research::IntVarLocalSearchOperator::OnStart();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[78], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::OnStart ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PathOperator::MakeOneNeighbor() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    return operations_research::PathOperator::MakeOneNeighbor();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[79], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::MakeOneNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::MakeNeighbor() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::PathOperator::MakeNeighbor.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[80], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::MakeNeighbor ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PathOperator::OnNodeInitialization() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    operations_research::PathOperator::OnNodeInitialization();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[81], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::OnNodeInitialization ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PathOperator::RestartAtPathStartOnSynchronize() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[10]) {
    return operations_research::PathOperator::RestartAtPathStartOnSynchronize();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[82], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::RestartAtPathStartOnSynchronize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::OnSamePathAsPreviousBase(int64_t base_index) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbase_index  ;
  
  if (!swig_override[11]) {
    return operations_research::PathOperator::OnSamePathAsPreviousBase(base_index);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbase_index = (jlong) base_index;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[83], swigjobj, jbase_index);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::OnSamePathAsPreviousBase ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int64_t SwigDirector_PathOperator::GetBaseNodeRestartPosition(int base_index) {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jbase_index  ;
  
  if (!swig_override[12]) {
    return operations_research::PathOperator::GetBaseNodeRestartPosition(base_index);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbase_index = (jint) base_index;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[84], swigjobj, jbase_index);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::GetBaseNodeRestartPosition ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PathOperator::SetNextBaseToIncrement(int64_t base_index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbase_index  ;
  
  if (!swig_override[13]) {
    operations_research::PathOperator::SetNextBaseToIncrement(base_index);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbase_index = (jlong) base_index;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[85], swigjobj, jbase_index);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::SetNextBaseToIncrement ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PathOperator::ConsiderAlternatives(int64_t base_index) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbase_index  ;
  
  if (!swig_override[14]) {
    return operations_research::PathOperator::ConsiderAlternatives(base_index);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbase_index = (jlong) base_index;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[86], swigjobj, jbase_index);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::ConsiderAlternatives ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PathOperator::InitPosition() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[15]) {
    return operations_research::PathOperator::InitPosition();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[87], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::PathOperator::InitPosition ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PathOperator::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/PathOperator");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "start", "(Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "HasFragments", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "HoldsDelta", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "onStart", "()V"),
    SwigDirectorMethod(jenv, baseclass, "oneNeighbor", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "neighbor", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "OnNodeInitialization", "()V"),
    SwigDirectorMethod(jenv, baseclass, "restartAtPathStartOnSynchronize", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "onSamePathAsPreviousBase", "(J)Z"),
    SwigDirectorMethod(jenv, baseclass, "getBaseNodeRestartPosition", "(I)J"),
    SwigDirectorMethod(jenv, baseclass, "setNextBaseToIncrement", "(J)V"),
    SwigDirectorMethod(jenv, baseclass, "ConsiderAlternatives", "(J)Z"),
    SwigDirectorMethod(jenv, baseclass, "initPosition", "()Z")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 16; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_LocalSearchFilter::SwigDirector_LocalSearchFilter(JNIEnv *jenv) : operations_research::LocalSearchFilter(), Swig::Director(jenv) {
}

SwigDirector_LocalSearchFilter::~SwigDirector_LocalSearchFilter() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_LocalSearchFilter::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[88], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchFilter::Relax(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[1]) {
    operations_research::LocalSearchFilter::Relax(delta,deltadelta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[89], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Relax ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_LocalSearchFilter::Commit(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[2]) {
    operations_research::LocalSearchFilter::Commit(delta,deltadelta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[90], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Commit ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_LocalSearchFilter::Accept(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta,int64_t objective_min,int64_t objective_max) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  jlong jobjective_min  ;
  jlong jobjective_max  ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::LocalSearchFilter::Accept.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jobjective_min = (jlong) objective_min;
    jobjective_max = (jlong) objective_max;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[91], swigjobj, jdelta, jdeltadelta, jobjective_min, jobjective_max);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Accept ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_LocalSearchFilter::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::LocalSearchFilter::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[92], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchFilter::Synchronize(operations_research::Assignment const *assignment,operations_research::Assignment const *delta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jassignment = 0 ;
  jlong jdelta = 0 ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::LocalSearchFilter::Synchronize.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jassignment) = (operations_research::Assignment *) assignment; 
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[93], swigjobj, jassignment, jdelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Synchronize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_LocalSearchFilter::Revert() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    operations_research::LocalSearchFilter::Revert();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[94], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Revert ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_LocalSearchFilter::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    operations_research::LocalSearchFilter::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[95], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int64_t SwigDirector_LocalSearchFilter::GetSynchronizedObjectiveValue() const {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return operations_research::LocalSearchFilter::GetSynchronizedObjectiveValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[96], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::GetSynchronizedObjectiveValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int64_t SwigDirector_LocalSearchFilter::GetAcceptedObjectiveValue() const {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    return operations_research::LocalSearchFilter::GetAcceptedObjectiveValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[97], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilter::GetAcceptedObjectiveValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchFilter::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/LocalSearchFilter");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "Relax", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "Commit", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "accept", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;JJ)Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "synchronize", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "Revert", "()V"),
    SwigDirectorMethod(jenv, baseclass, "Reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "getSynchronizedObjectiveValue", "()J"),
    SwigDirectorMethod(jenv, baseclass, "getAcceptedObjectiveValue", "()J")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 10; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_LocalSearchFilterManager::SwigDirector_LocalSearchFilterManager(JNIEnv *jenv,std::vector< operations_research::LocalSearchFilterManager::FilterEvent > filter_events) : operations_research::LocalSearchFilterManager(filter_events), Swig::Director(jenv) {
}

SwigDirector_LocalSearchFilterManager::SwigDirector_LocalSearchFilterManager(JNIEnv *jenv,std::vector< operations_research::LocalSearchFilter * > filters) : operations_research::LocalSearchFilterManager(filters), Swig::Director(jenv) {
}

SwigDirector_LocalSearchFilterManager::~SwigDirector_LocalSearchFilterManager() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_LocalSearchFilterManager::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::LocalSearchFilterManager::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[98], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::LocalSearchFilterManager::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_LocalSearchFilterManager::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/LocalSearchFilterManager");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_IntVarLocalSearchFilter::SwigDirector_IntVarLocalSearchFilter(JNIEnv *jenv,std::vector< operations_research::IntVar * > const &vars) : operations_research::IntVarLocalSearchFilter(vars), Swig::Director(jenv) {
}

SwigDirector_IntVarLocalSearchFilter::~SwigDirector_IntVarLocalSearchFilter() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_IntVarLocalSearchFilter::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[99], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_IntVarLocalSearchFilter::Relax(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[1]) {
    operations_research::LocalSearchFilter::Relax(delta,deltadelta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[100], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::Relax ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_IntVarLocalSearchFilter::Commit(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  
  if (!swig_override[2]) {
    operations_research::LocalSearchFilter::Commit(delta,deltadelta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[101], swigjobj, jdelta, jdeltadelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::Commit ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_IntVarLocalSearchFilter::Accept(operations_research::Assignment const *delta,operations_research::Assignment const *deltadelta,int64_t objective_min,int64_t objective_max) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  jlong jdeltadelta = 0 ;
  jlong jobjective_min  ;
  jlong jobjective_max  ;
  
  if (!swig_override[3]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method operations_research::IntVarLocalSearchFilter::Accept.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    *((operations_research::Assignment **)&jdeltadelta) = (operations_research::Assignment *) deltadelta; 
    jobjective_min = (jlong) objective_min;
    jobjective_max = (jlong) objective_max;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[102], swigjobj, jdelta, jdeltadelta, jobjective_min, jobjective_max);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::Accept ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_IntVarLocalSearchFilter::IsIncremental() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return operations_research::LocalSearchFilter::IsIncremental();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_mainJNI, Swig::director_method_ids[103], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::IsIncremental ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_IntVarLocalSearchFilter::Revert() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[5]) {
    operations_research::LocalSearchFilter::Revert();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[104], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::Revert ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_IntVarLocalSearchFilter::Reset() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    operations_research::LocalSearchFilter::Reset();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[105], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::Reset ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

int64_t SwigDirector_IntVarLocalSearchFilter::GetSynchronizedObjectiveValue() const {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    return operations_research::LocalSearchFilter::GetSynchronizedObjectiveValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[106], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::GetSynchronizedObjectiveValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int64_t SwigDirector_IntVarLocalSearchFilter::GetAcceptedObjectiveValue() const {
  int64_t c_result = SwigValueInit< int64_t >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return operations_research::LocalSearchFilter::GetAcceptedObjectiveValue();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_mainJNI, Swig::director_method_ids[107], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    c_result = (int64_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::GetAcceptedObjectiveValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_IntVarLocalSearchFilter::OnSynchronize(operations_research::Assignment const *delta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdelta = 0 ;
  
  if (!swig_override[9]) {
    operations_research::IntVarLocalSearchFilter::OnSynchronize(delta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::Assignment **)&jdelta) = (operations_research::Assignment *) delta; 
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[108], swigjobj, jdelta);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::IntVarLocalSearchFilter::OnSynchronize ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_IntVarLocalSearchFilter::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/IntVarLocalSearchFilter");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "Relax", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "Commit", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;)V"),
    SwigDirectorMethod(jenv, baseclass, "accept", "(Lcom/google/ortools/constraintsolver/Assignment;Lcom/google/ortools/constraintsolver/Assignment;JJ)Z"),
    SwigDirectorMethod(jenv, baseclass, "isIncremental", "()Z"),
    SwigDirectorMethod(jenv, baseclass, "Revert", "()V"),
    SwigDirectorMethod(jenv, baseclass, "Reset", "()V"),
    SwigDirectorMethod(jenv, baseclass, "getSynchronizedObjectiveValue", "()J"),
    SwigDirectorMethod(jenv, baseclass, "getAcceptedObjectiveValue", "()J"),
    SwigDirectorMethod(jenv, baseclass, "onSynchronize", "(Lcom/google/ortools/constraintsolver/Assignment;)V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 10; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_SymmetryBreaker::SwigDirector_SymmetryBreaker(JNIEnv *jenv) : operations_research::SymmetryBreaker(), Swig::Director(jenv) {
}

SwigDirector_SymmetryBreaker::~SwigDirector_SymmetryBreaker() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_SymmetryBreaker::DebugString() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return operations_research::BaseObject::DebugString();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_mainJNI, Swig::director_method_ids[109], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::DebugString ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_SymmetryBreaker::VisitSetVariableValue(operations_research::IntVar *var,int64_t value) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jvalue  ;
  
  if (!swig_override[1]) {
    operations_research::DecisionVisitor::VisitSetVariableValue(var,value);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntVar **)&jvar) = (operations_research::IntVar *) var; 
    jvalue = (jlong) value;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[110], swigjobj, jvar, jvalue);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitSetVariableValue ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitSplitVariableDomain(operations_research::IntVar *var,int64_t value,bool start_with_lower_half) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jvalue  ;
  jboolean jstart_with_lower_half  ;
  
  if (!swig_override[2]) {
    operations_research::DecisionVisitor::VisitSplitVariableDomain(var,value,start_with_lower_half);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntVar **)&jvar) = (operations_research::IntVar *) var; 
    jvalue = (jlong) value;
    jstart_with_lower_half = (jboolean) start_with_lower_half;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[111], swigjobj, jvar, jvalue, jstart_with_lower_half);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitSplitVariableDomain ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitScheduleOrPostpone(operations_research::IntervalVar *var,int64_t est) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jest  ;
  
  if (!swig_override[3]) {
    operations_research::DecisionVisitor::VisitScheduleOrPostpone(var,est);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntervalVar **)&jvar) = (operations_research::IntervalVar *) var; 
    jest = (jlong) est;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[112], swigjobj, jvar, jest);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitScheduleOrPostpone ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitScheduleOrExpedite(operations_research::IntervalVar *var,int64_t est) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jvar = 0 ;
  jlong jest  ;
  
  if (!swig_override[4]) {
    operations_research::DecisionVisitor::VisitScheduleOrExpedite(var,est);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::IntervalVar **)&jvar) = (operations_research::IntervalVar *) var; 
    jest = (jlong) est;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[113], swigjobj, jvar, jest);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitScheduleOrExpedite ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitRankFirstInterval(operations_research::SequenceVar *sequence,int index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsequence = 0 ;
  jint jindex  ;
  
  if (!swig_override[5]) {
    operations_research::DecisionVisitor::VisitRankFirstInterval(sequence,index);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::SequenceVar **)&jsequence) = (operations_research::SequenceVar *) sequence; 
    jindex = (jint) index;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[114], swigjobj, jsequence, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitRankFirstInterval ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitRankLastInterval(operations_research::SequenceVar *sequence,int index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jsequence = 0 ;
  jint jindex  ;
  
  if (!swig_override[6]) {
    operations_research::DecisionVisitor::VisitRankLastInterval(sequence,index);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((operations_research::SequenceVar **)&jsequence) = (operations_research::SequenceVar *) sequence; 
    jindex = (jint) index;
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[115], swigjobj, jsequence, jindex);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitRankLastInterval ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::VisitUnknownDecision() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    operations_research::DecisionVisitor::VisitUnknownDecision();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_mainJNI, Swig::director_method_ids[116], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in operations_research::SymmetryBreaker::VisitUnknownDecision ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_SymmetryBreaker::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "com/google/ortools/constraintsolver/SymmetryBreaker");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "toString", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "visitSetVariableValue", "(Lcom/google/ortools/constraintsolver/IntVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitSplitVariableDomain", "(Lcom/google/ortools/constraintsolver/IntVar;JZ)V"),
    SwigDirectorMethod(jenv, baseclass, "visitScheduleOrPostpone", "(Lcom/google/ortools/constraintsolver/IntervalVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitScheduleOrExpedite", "(Lcom/google/ortools/constraintsolver/IntervalVar;J)V"),
    SwigDirectorMethod(jenv, baseclass, "visitRankFirstInterval", "(Lcom/google/ortools/constraintsolver/SequenceVar;I)V"),
    SwigDirectorMethod(jenv, baseclass, "visitRankLastInterval", "(Lcom/google/ortools/constraintsolver/SequenceVar;I)V"),
    SwigDirectorMethod(jenv, baseclass, "visitUnknownDecision", "()V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 8; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1IntBoolPair_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::pair< int,bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::pair< int,bool > *)new std::pair< int,bool >();
  *(std::pair< int,bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1IntBoolPair_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  bool arg2 ;
  std::pair< int,bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (std::pair< int,bool > *)new std::pair< int,bool >(arg1,arg2);
  *(std::pair< int,bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1IntBoolPair_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::pair< int,bool > *arg1 = 0 ;
  std::pair< int,bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< int,bool > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::pair< int,bool > const & is null");
    return 0;
  } 
  result = (std::pair< int,bool > *)new std::pair< int,bool >((std::pair< int,bool > const &)*arg1);
  *(std::pair< int,bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntBoolPair_1first_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::pair< int,bool > *arg1 = (std::pair< int,bool > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< int,bool > **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->first = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntBoolPair_1first_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::pair< int,bool > *arg1 = (std::pair< int,bool > *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< int,bool > **)&jarg1; 
  result = (int) ((arg1)->first);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntBoolPair_1second_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  std::pair< int,bool > *arg1 = (std::pair< int,bool > *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< int,bool > **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->second = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntBoolPair_1second_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::pair< int,bool > *arg1 = (std::pair< int,bool > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::pair< int,bool > **)&jarg1; 
  result = (bool) ((arg1)->second);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1IntBoolPair(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::pair< int,bool > *arg1 = (std::pair< int,bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::pair< int,bool > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1IntTupleSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  operations_research::IntTupleSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (operations_research::IntTupleSet *)new operations_research::IntTupleSet(arg1);
  *(operations_research::IntTupleSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1IntTupleSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::IntTupleSet *arg1 = 0 ;
  operations_research::IntTupleSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::IntTupleSet const & is null");
    return 0;
  } 
  result = (operations_research::IntTupleSet *)new operations_research::IntTupleSet((operations_research::IntTupleSet const &)*arg1);
  *(operations_research::IntTupleSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1IntTupleSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  (arg1)->Clear();
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insert_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< int > *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (int)(arg1)->Insert((std::vector< int > const &)*arg2);
  jresult = (jint)result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insert_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (int)(arg1)->Insert((std::vector< int64_t > const &)*arg2);
  jresult = (jint)result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insert2(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (int)(arg1)->Insert2(arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insert3(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (int)(arg1)->Insert3(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insert4(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (int)(arg1)->Insert4(arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insertAll_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< std::vector< int64_t > > *arg2 = 0 ;
  std::vector< std::vector< int64_t > > result2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    const int size = jenv->GetArrayLength(jarg2);
    result2.clear();
    result2.resize(size);
    for (int index1 = 0; index1 < size; ++index1) {
      jlongArray inner_array =
      (jlongArray)jenv->GetObjectArrayElement(jarg2, index1);
      const int inner_size = jenv->GetArrayLength(inner_array);
      result2[index1].reserve(inner_size);
      jlong * const values =
      jenv->GetLongArrayElements((jlongArray)inner_array, NULL);
      for (int index2 = 0; index2 < inner_size; ++index2) {
        result2[index1].emplace_back(values[index2]);
      }
      jenv->ReleaseLongArrayElements((jlongArray)inner_array, values, JNI_ABORT);
      jenv->DeleteLocalRef(inner_array);
    }
    arg2 = &result2;
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return ;
  }
  
  (arg1)->InsertAll((std::vector< std::vector< int64_t > > const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1insertAll_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< std::vector< int > > *arg2 = 0 ;
  std::vector< std::vector< int > > result2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    const int size = jenv->GetArrayLength(jarg2);
    result2.clear();
    result2.resize(size);
    for (int index1 = 0; index1 < size; ++index1) {
      jintArray inner_array =
      (jintArray)jenv->GetObjectArrayElement(jarg2, index1);
      const int inner_size = jenv->GetArrayLength(inner_array);
      result2[index1].reserve(inner_size);
      jint * const values =
      jenv->GetIntArrayElements((jintArray)inner_array, NULL);
      for (int index2 = 0; index2 < inner_size; ++index2) {
        result2[index1].emplace_back(values[index2]);
      }
      jenv->ReleaseIntArrayElements((jintArray)inner_array, values, JNI_ABORT);
      jenv->DeleteLocalRef(inner_array);
    }
    arg2 = &result2;
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return ;
  }
  
  (arg1)->InsertAll((std::vector< std::vector< int > > const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  jboolean jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< int > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (bool)((operations_research::IntTupleSet const *)arg1)->Contains((std::vector< int > const &)*arg2);
  jresult = (jboolean)result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  jboolean jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (bool)((operations_research::IntTupleSet const *)arg1)->Contains((std::vector< int64_t > const &)*arg2);
  jresult = (jboolean)result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1numTuples(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  result = (int)((operations_research::IntTupleSet const *)arg1)->NumTuples();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int arg2 ;
  int arg3 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int64_t)((operations_research::IntTupleSet const *)arg1)->Value(arg2,arg3);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1arity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  result = (int)((operations_research::IntTupleSet const *)arg1)->Arity();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1numDifferentValuesInColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (int)((operations_research::IntTupleSet const *)arg1)->NumDifferentValuesInColumn(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1sortedByColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  int arg2 ;
  SwigValueWrapper< operations_research::IntTupleSet > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  arg2 = (int)jarg2; 
  result = ((operations_research::IntTupleSet const *)arg1)->SortedByColumn(arg2);
  *(operations_research::IntTupleSet **)&jresult = new operations_research::IntTupleSet(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_IntTupleSet_1sortedLexicographically(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::IntTupleSet *arg1 = (operations_research::IntTupleSet *) 0 ;
  SwigValueWrapper< operations_research::IntTupleSet > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::IntTupleSet **)&jarg1; 
  result = ((operations_research::IntTupleSet const *)arg1)->SortedLexicographically();
  *(operations_research::IntTupleSet **)&jresult = new operations_research::IntTupleSet(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_CpRandomSeed(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int64_t)operations_research::CpRandomSeed();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1CHOOSE_1MAX_1SUM_1IMPACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::VariableSelection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::VariableSelection)operations_research::DefaultPhaseParameters::CHOOSE_MAX_SUM_IMPACT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1CHOOSE_1MAX_1AVERAGE_1IMPACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::VariableSelection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::VariableSelection)operations_research::DefaultPhaseParameters::CHOOSE_MAX_AVERAGE_IMPACT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1CHOOSE_1MAX_1VALUE_1IMPACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::VariableSelection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::VariableSelection)operations_research::DefaultPhaseParameters::CHOOSE_MAX_VALUE_IMPACT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1SELECT_1MIN_1IMPACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::ValueSelection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::ValueSelection)operations_research::DefaultPhaseParameters::SELECT_MIN_IMPACT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1SELECT_1MAX_1IMPACT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::ValueSelection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::ValueSelection)operations_research::DefaultPhaseParameters::SELECT_MAX_IMPACT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1NONE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::DisplayLevel result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::DisplayLevel)operations_research::DefaultPhaseParameters::NONE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1NORMAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::DisplayLevel result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::DisplayLevel)operations_research::DefaultPhaseParameters::NORMAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1VERBOSE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters::DisplayLevel result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters::DisplayLevel)operations_research::DefaultPhaseParameters::VERBOSE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1varSelectionSchema_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::VariableSelection arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (operations_research::DefaultPhaseParameters::VariableSelection)jarg2; 
  if (arg1) (arg1)->var_selection_schema = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1varSelectionSchema_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::VariableSelection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (operations_research::DefaultPhaseParameters::VariableSelection) ((arg1)->var_selection_schema);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1valueSelectionSchema_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::ValueSelection arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (operations_research::DefaultPhaseParameters::ValueSelection)jarg2; 
  if (arg1) (arg1)->value_selection_schema = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1valueSelectionSchema_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::ValueSelection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (operations_research::DefaultPhaseParameters::ValueSelection) ((arg1)->value_selection_schema);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1initializationSplits_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->initialization_splits = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1initializationSplits_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (int) ((arg1)->initialization_splits);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1runAllHeuristics_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->run_all_heuristics = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1runAllHeuristics_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (bool) ((arg1)->run_all_heuristics);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1heuristicPeriod_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->heuristic_period = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1heuristicPeriod_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (int) ((arg1)->heuristic_period);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1heuristicNumFailuresLimit_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->heuristic_num_failures_limit = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1heuristicNumFailuresLimit_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (int) ((arg1)->heuristic_num_failures_limit);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1persistentImpact_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->persistent_impact = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1persistentImpact_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (bool) ((arg1)->persistent_impact);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1randomSeed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->random_seed = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1randomSeed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (int) ((arg1)->random_seed);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1displayLevel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::DisplayLevel arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = (operations_research::DefaultPhaseParameters::DisplayLevel)jarg2; 
  if (arg1) (arg1)->display_level = arg2;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1displayLevel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DefaultPhaseParameters::DisplayLevel result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (operations_research::DefaultPhaseParameters::DisplayLevel) ((arg1)->display_level);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1useLastConflict_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->use_last_conflict = arg2;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1useLastConflict_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (bool) ((arg1)->use_last_conflict);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1decisionBuilder_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  if (arg1) (arg1)->decision_builder = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DefaultPhaseParameters_1decisionBuilder_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  result = (operations_research::DecisionBuilder *) ((arg1)->decision_builder);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1DefaultPhaseParameters(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::DefaultPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DefaultPhaseParameters *)new operations_research::DefaultPhaseParameters();
  *(operations_research::DefaultPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1DefaultPhaseParameters(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::DefaultPhaseParameters *arg1 = (operations_research::DefaultPhaseParameters *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::DefaultPhaseParameters **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1Solver_1IntegerCastInfo_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::Solver::IntegerCastInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntegerCastInfo *)new operations_research::Solver::IntegerCastInfo();
  *(operations_research::Solver::IntegerCastInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1Solver_1IntegerCastInfo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::IntVar *arg1 = (operations_research::IntVar *) (operations_research::IntVar *)0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) (operations_research::IntExpr *)0 ;
  operations_research::Constraint *arg3 = (operations_research::Constraint *) (operations_research::Constraint *)0 ;
  operations_research::Solver::IntegerCastInfo *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::IntVar **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::Constraint **)&jarg3; 
  result = (operations_research::Solver::IntegerCastInfo *)new operations_research::Solver::IntegerCastInfo(arg1,arg2,arg3);
  *(operations_research::Solver::IntegerCastInfo **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1variable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  if (arg1) (arg1)->variable = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1variable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  result = (operations_research::IntVar *) ((arg1)->variable);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1expression_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  if (arg1) (arg1)->expression = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1expression_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  result = (operations_research::IntExpr *) ((arg1)->expression);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1maintainer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  if (arg1) (arg1)->maintainer = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IntegerCastInfo_1maintainer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  result = (operations_research::Constraint *) ((arg1)->maintainer);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1Solver_1IntegerCastInfo(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::Solver::IntegerCastInfo *arg1 = (operations_research::Solver::IntegerCastInfo *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::Solver::IntegerCastInfo **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1kNumPriorities_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)operations_research::Solver::kNumPriorities;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INT_1VAR_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::INT_VAR_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INT_1VAR_1SIMPLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::INT_VAR_SIMPLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1FIRST_1UNBOUND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_FIRST_UNBOUND;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1RANDOM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_RANDOM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SIZE_1LOWEST_1MIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MIN_SIZE_LOWEST_MIN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SIZE_1HIGHEST_1MIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MIN_SIZE_HIGHEST_MIN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SIZE_1LOWEST_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MIN_SIZE_LOWEST_MAX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SIZE_1HIGHEST_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MIN_SIZE_HIGHEST_MAX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1LOWEST_1MIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_LOWEST_MIN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1HIGHEST_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_HIGHEST_MAX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MIN_SIZE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MAX_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MAX_SIZE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MAX_1REGRET_1ON_1MIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_MAX_REGRET_ON_MIN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1PATH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntVarStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntVarStrategy)operations_research::Solver::CHOOSE_PATH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INT_1VALUE_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::INT_VALUE_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INT_1VALUE_1SIMPLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::INT_VALUE_SIMPLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ASSIGN_1MIN_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::ASSIGN_MIN_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ASSIGN_1MAX_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::ASSIGN_MAX_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ASSIGN_1RANDOM_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::ASSIGN_RANDOM_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ASSIGN_1CENTER_1VALUE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::ASSIGN_CENTER_VALUE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SPLIT_1LOWER_1HALF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::SPLIT_LOWER_HALF;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SPLIT_1UPPER_1HALF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntValueStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntValueStrategy)operations_research::Solver::SPLIT_UPPER_HALF;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1STATIC_1GLOBAL_1BEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::EvaluatorStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::EvaluatorStrategy)operations_research::Solver::CHOOSE_STATIC_GLOBAL_BEST;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1DYNAMIC_1GLOBAL_1BEST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::EvaluatorStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::EvaluatorStrategy)operations_research::Solver::CHOOSE_DYNAMIC_GLOBAL_BEST;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SEQUENCE_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SequenceStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SequenceStrategy)operations_research::Solver::SEQUENCE_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SEQUENCE_1SIMPLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SequenceStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SequenceStrategy)operations_research::Solver::SEQUENCE_SIMPLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1MIN_1SLACK_1RANK_1FORWARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SequenceStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SequenceStrategy)operations_research::Solver::CHOOSE_MIN_SLACK_RANK_FORWARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOOSE_1RANDOM_1RANK_1FORWARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SequenceStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SequenceStrategy)operations_research::Solver::CHOOSE_RANDOM_RANK_FORWARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INTERVAL_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntervalStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntervalStrategy)operations_research::Solver::INTERVAL_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INTERVAL_1SIMPLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntervalStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntervalStrategy)operations_research::Solver::INTERVAL_SIMPLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INTERVAL_1SET_1TIMES_1FORWARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntervalStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntervalStrategy)operations_research::Solver::INTERVAL_SET_TIMES_FORWARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INTERVAL_1SET_1TIMES_1BACKWARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::IntervalStrategy result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::IntervalStrategy)operations_research::Solver::INTERVAL_SET_TIMES_BACKWARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1TWOOPT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::TWOOPT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1OROPT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::OROPT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1RELOCATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::RELOCATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1EXCHANGE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::EXCHANGE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CROSS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::CROSS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MAKEACTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::MAKEACTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MAKEINACTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::MAKEINACTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MAKECHAININACTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::MAKECHAININACTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SWAPACTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::SWAPACTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1EXTENDEDSWAPACTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::EXTENDEDSWAPACTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1PATHLNS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::PATHLNS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1FULLPATHLNS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::FULLPATHLNS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1UNACTIVELNS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::UNACTIVELNS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1INCREMENT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::INCREMENT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1DECREMENT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::DECREMENT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SIMPLELNS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchOperators)operations_research::Solver::SIMPLELNS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1LK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::EvaluatorLocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::EvaluatorLocalSearchOperators)operations_research::Solver::LK;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1TSPOPT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::EvaluatorLocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::EvaluatorLocalSearchOperators)operations_research::Solver::TSPOPT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1TSPLNS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::EvaluatorLocalSearchOperators result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::EvaluatorLocalSearchOperators)operations_research::Solver::TSPLNS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1GE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchFilterBound result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchFilterBound)operations_research::Solver::GE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1LE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchFilterBound result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchFilterBound)operations_research::Solver::LE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1EQ_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::LocalSearchFilterBound result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::LocalSearchFilterBound)operations_research::Solver::EQ;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1DELAYED_1PRIORITY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DemonPriority result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DemonPriority)operations_research::Solver::DELAYED_PRIORITY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1VAR_1PRIORITY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DemonPriority result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DemonPriority)operations_research::Solver::VAR_PRIORITY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1NORMAL_1PRIORITY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DemonPriority result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DemonPriority)operations_research::Solver::NORMAL_PRIORITY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AFTER_1END_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::ENDS_AFTER_END;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AFTER_1START_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::ENDS_AFTER_START;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AT_1END_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::ENDS_AT_END;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AT_1START_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::ENDS_AT_START;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AFTER_1END_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::STARTS_AFTER_END;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AFTER_1START_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::STARTS_AFTER_START;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AT_1END_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::STARTS_AT_END;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AT_1START_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::STARTS_AT_START;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STAYS_1IN_1SYNC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::BinaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::BinaryIntervalRelation)operations_research::Solver::STAYS_IN_SYNC;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AFTER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::ENDS_AFTER;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1AT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::ENDS_AT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ENDS_1BEFORE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::ENDS_BEFORE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AFTER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::STARTS_AFTER;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1AT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::STARTS_AT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1STARTS_1BEFORE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::STARTS_BEFORE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CROSS_1DATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::CROSS_DATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1AVOID_1DATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::UnaryIntervalRelation result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::UnaryIntervalRelation)operations_research::Solver::AVOID_DATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1NO_1CHANGE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DecisionModification result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DecisionModification)operations_research::Solver::NO_CHANGE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1KEEP_1LEFT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DecisionModification result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DecisionModification)operations_research::Solver::KEEP_LEFT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1KEEP_1RIGHT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DecisionModification result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DecisionModification)operations_research::Solver::KEEP_RIGHT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1KILL_1BOTH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DecisionModification result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DecisionModification)operations_research::Solver::KILL_BOTH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SWITCH_1BRANCHES_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::DecisionModification result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::DecisionModification)operations_research::Solver::SWITCH_BRANCHES;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SENTINEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::MarkerType result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::MarkerType)operations_research::Solver::SENTINEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SIMPLE_1MARKER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::MarkerType result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::MarkerType)operations_research::Solver::SIMPLE_MARKER;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1CHOICE_1POINT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::MarkerType result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::MarkerType)operations_research::Solver::CHOICE_POINT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1REVERSIBLE_1ACTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::MarkerType result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::MarkerType)operations_research::Solver::REVERSIBLE_ACTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1OUTSIDE_1SEARCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::OUTSIDE_SEARCH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IN_1ROOT_1NODE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::IN_ROOT_NODE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IN_1SEARCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::IN_SEARCH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1AT_1SOLUTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::AT_SOLUTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1NO_1MORE_1SOLUTIONS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::NO_MORE_SOLUTIONS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1PROBLEM_1INFEASIBLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::SolverState)operations_research::Solver::PROBLEM_INFEASIBLE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1NOT_1SET_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::OptimizationDirection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::OptimizationDirection)operations_research::Solver::NOT_SET;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MAXIMIZATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::OptimizationDirection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::OptimizationDirection)operations_research::Solver::MAXIMIZATION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MINIMIZATION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  operations_research::Solver::OptimizationDirection result;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Solver::OptimizationDirection)operations_research::Solver::MINIMIZATION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1Solver_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  operations_research::Solver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (operations_research::Solver *)new operations_research::Solver((std::string const &)*arg1);
  *(operations_research::Solver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1Solver_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jbyteArray jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  operations_research::ConstraintSolverParameters *arg2 = 0 ;
  operations_research::ConstraintSolverParameters temp2 ;
  operations_research::Solver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    const int proto_size = jenv->GetArrayLength(jarg2);
    std::unique_ptr<jbyte[]> proto_buffer(new jbyte[proto_size]);
    jenv->GetByteArrayRegion(jarg2, 0, proto_size, proto_buffer.get());
    bool parsed_ok = temp2.ParseFromArray(proto_buffer.get(), proto_size);
    if (!parsed_ok) {
      SWIG_JavaThrowException(jenv,
        SWIG_JavaRuntimeException,
        "Unable to parse operations_research::ConstraintSolverParameters protocol message.");
    }
    arg2 = &temp2;
  }
  result = (operations_research::Solver *)new operations_research::Solver((std::string const &)*arg1,(operations_research::ConstraintSolverParameters const &)*arg2);
  *(operations_research::Solver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1Solver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::Solver **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jbyteArray JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1parameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ConstraintSolverParameters result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = ((operations_research::Solver const *)arg1)->parameters();
  {
    const long size = (&result)->ByteSizeLong();
    std::unique_ptr<jbyte[]> buf(new jbyte[size]);
    (&result)->SerializeWithCachedSizesToArray(reinterpret_cast<uint8_t*>(buf.get()));
    jresult = jenv->NewByteArray(size);
    jenv->SetByteArrayRegion(jresult, 0, size, buf.get());
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1const_1parameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ConstraintSolverParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::ConstraintSolverParameters *) &((operations_research::Solver const *)arg1)->const_parameters();
  *(operations_research::ConstraintSolverParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1defaultSolverParameters(JNIEnv *jenv, jclass jcls) {
  jbyteArray jresult = 0 ;
  operations_research::ConstraintSolverParameters result;
  
  (void)jenv;
  (void)jcls;
  result = operations_research::Solver::DefaultSolverParameters();
  {
    const long size = (&result)->ByteSizeLong();
    std::unique_ptr<jbyte[]> buf(new jbyte[size]);
    (&result)->SerializeWithCachedSizesToArray(reinterpret_cast<uint8_t*>(buf.get()));
    jresult = jenv->NewByteArray(size);
    jenv->SetByteArrayRegion(jresult, 0, size, buf.get());
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1addConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  (arg1)->AddConstraint(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1addCastConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::CastConstraint *arg2 = (operations_research::CastConstraint *) 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *arg4 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::CastConstraint **)&jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntExpr **)&jarg4; 
  (arg1)->AddCastConstraint(arg2,arg3,arg4);
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  std::vector< operations_research::SearchMonitor * > *arg3 = 0 ;
  std::vector< operations_research::SearchMonitor * > result3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SearchMonitor";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SearchMonitor*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (bool)(arg1)->Solve(arg2,(std::vector< operations_research::SearchMonitor * > const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  result = (bool)(arg1)->Solve(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  result = (bool)(arg1)->Solve(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  result = (bool)(arg1)->Solve(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  result = (bool)(arg1)->Solve(arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solve_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  result = (bool)(arg1)->Solve(arg2,arg3,arg4,arg5,arg6);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  std::vector< operations_research::SearchMonitor * > *arg3 = 0 ;
  std::vector< operations_research::SearchMonitor * > result3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SearchMonitor";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return ;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SearchMonitor*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  (arg1)->NewSearch(arg2,(std::vector< operations_research::SearchMonitor * > const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  (arg1)->NewSearch(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  (arg1)->NewSearch(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  (arg1)->NewSearch(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  (arg1)->NewSearch(arg2,arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1newSearch_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  (arg1)->NewSearch(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1nextSolution(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)(arg1)->NextSolution();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1restartSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->RestartSearch();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1endSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->EndSearch();
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveAndCommit_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  std::vector< operations_research::SearchMonitor * > *arg3 = 0 ;
  std::vector< operations_research::SearchMonitor * > result3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SearchMonitor";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SearchMonitor*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (bool)(arg1)->SolveAndCommit(arg2,(std::vector< operations_research::SearchMonitor * > const &)*arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveAndCommit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  result = (bool)(arg1)->SolveAndCommit(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveAndCommit_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  result = (bool)(arg1)->SolveAndCommit(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveAndCommit_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  result = (bool)(arg1)->SolveAndCommit(arg2,arg3,arg4);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveAndCommit_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  result = (bool)(arg1)->SolveAndCommit(arg2,arg3,arg4,arg5);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1checkAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (bool)(arg1)->CheckAssignment(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1checkConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  result = (bool)(arg1)->CheckConstraint(arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1state(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::SolverState result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Solver::SolverState)((operations_research::Solver const *)arg1)->state();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1fail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    operations_research::Solver* const solver = arg1;
    FailureProtect protect;
    solver->set_fail_intercept([&protect]() {
      protect.JumpBack(); 
    });
    if (setjmp(protect.exception_buffer) == 0) {
      (arg1)->Fail();
      solver->clear_fail_intercept();
    } else {
      solver->clear_fail_intercept();
      jclass fail_class = jenv->FindClass(
        "com/google/ortools/constraintsolver/"
        "Solver$FailException");
      jenv->ThrowNew(fail_class, "fail");
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = ((operations_research::Solver const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1memoryUsage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int64_t)operations_research::Solver::MemoryUsage();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1wallTime(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->wall_time();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1branches(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->branches();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solutions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->solutions();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1unchecked_1solutions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->unchecked_solutions();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1demon_1runs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::DemonPriority arg2 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (operations_research::Solver::DemonPriority)jarg2; 
  result = (int64_t)((operations_research::Solver const *)arg1)->demon_runs(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1failures(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->failures();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1neighbors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->neighbors();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ClearNeighbors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->ClearNeighbors();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1IncrementNeighbors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->IncrementNeighbors();
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1filteredNeighbors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->filtered_neighbors();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1acceptedNeighbors(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int64_t)((operations_research::Solver const *)arg1)->accepted_neighbors();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1stamp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (uint64_t)((operations_research::Solver const *)arg1)->stamp();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1fail_1stamp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (uint64_t)((operations_research::Solver const *)arg1)->fail_stamp();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1set_1context(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->set_context((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1context(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (std::string *) &((operations_research::Solver const *)arg1)->context();
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1optimization_1direction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::OptimizationDirection result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Solver::OptimizationDirection)((operations_research::Solver const *)arg1)->optimization_direction();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1set_1optimization_1direction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::OptimizationDirection arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (operations_research::Solver::OptimizationDirection)jarg2; 
  (arg1)->set_optimization_direction(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  std::string *arg4 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  result = (operations_research::IntVar *)(arg1)->MakeIntVar(arg2,arg3,(std::string const &)*arg4);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  std::string *arg3 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (operations_research::IntVar *)(arg1)->MakeIntVar((std::vector< int64_t > const &)*arg2,(std::string const &)*arg3);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int > *arg2 = 0 ;
  std::string *arg3 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (operations_research::IntVar *)(arg1)->MakeIntVar((std::vector< int > const &)*arg2,(std::string const &)*arg3);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIntVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntVar *)(arg1)->MakeIntVar((std::vector< int64_t > const &)*arg2);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntVar_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int > *arg2 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntVar *)(arg1)->MakeIntVar((std::vector< int > const &)*arg2);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBoolVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (operations_research::IntVar *)(arg1)->MakeBoolVar((std::string const &)*arg2);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBoolVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::IntVar *)(arg1)->MakeBoolVar();
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntConst_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  std::string *arg3 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (operations_research::IntVar *)(arg1)->MakeIntConst(arg2,(std::string const &)*arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntConst_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (operations_research::IntVar *)(arg1)->MakeIntConst(arg2);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSum_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeSum(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSum_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeSum(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSum_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::IntExpr *)(arg1)->MakeSum((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntExpr *)(arg1)->MakeScalProd((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntExpr *)(arg1)->MakeScalProd((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDifference_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeDifference(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDifference_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeDifference(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOpposite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  result = (operations_research::IntExpr *)(arg1)->MakeOpposite(arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeProd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeProd(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeProd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeProd(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDiv_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeDiv(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDiv_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeDiv(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAbs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  result = (operations_research::IntExpr *)(arg1)->MakeAbs(arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSquare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  result = (operations_research::IntExpr *)(arg1)->MakeSquare(arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePower(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakePower(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElement_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeElement((std::vector< int64_t > const &)*arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElement_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeElement((std::vector< int > const &)*arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElement_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::IndexEvaluator1 arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "applyAsLong", "(J)J");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard](long t) -> long {
    return jenv->CallLongMethod(jarg2_object, jarg2_method_id, (jlong)t);
  };
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeElement(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMonotonicElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jboolean jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::IndexEvaluator1 arg2 ;
  bool arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "applyAsLong", "(J)J");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard](long t) -> long {
    return jenv->CallLongMethod(jarg2_object, jarg2_method_id, (jlong)t);
  };
  
  arg3 = jarg3 ? true : false; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::IntExpr *)(arg1)->MakeMonotonicElement(arg2,arg3,arg4);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElement_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::IndexEvaluator2 arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "applyAsLong", "(JJ)J");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg2_object, jarg2_method_id, (jlong)t,(jlong)u);
  };
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::IntExpr *)(arg1)->MakeElement(arg2,arg3,arg4);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElement_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeElement((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIndexExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeIndexExpression((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIfThenElseCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg4 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg5 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntExpr **)&jarg4; 
  arg5 = *(operations_research::IntVar **)&jarg5; 
  result = (operations_research::Constraint *)(arg1)->MakeIfThenElseCt(arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::IntExpr *)(arg1)->MakeMin((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMin(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMin_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMin(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMin_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMin(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMax_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::IntExpr *)(arg1)->MakeMax((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMax_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMax(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMax_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMax(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMax_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeMax(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeConvexPiecewiseExpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  int64_t arg6 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = (int64_t)jarg6; 
  result = (operations_research::IntExpr *)(arg1)->MakeConvexPiecewiseExpr(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSemiContinuousExpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntExpr *)(arg1)->MakeSemiContinuousExpr(arg2,arg3,arg4);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeModulo_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeModulo(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeModulo_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntExpr *)(arg1)->MakeModulo(arg2,arg3);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeConditionalExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  int64_t arg4 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntExpr *)(arg1)->MakeConditionalExpression(arg2,arg3,arg4);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTrueConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Constraint *)(arg1)->MakeTrueConstraint();
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFalseConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Constraint *)(arg1)->MakeFalseConstraint();
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFalseConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeFalseConstraint((std::string const &)*arg2);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsEqualCstCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsEqualCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsEqualCstVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsEqualCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsEqualVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsEqualCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsEqualVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsEqualVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeEquality_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeEquality_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeEquality_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsDifferentCstCt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsDifferentCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsDifferentCstVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsDifferentCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsDifferentCstVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsDifferentVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsDifferentCstCt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsDifferentCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonEquality_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeNonEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonEquality_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeNonEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonEquality_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeNonEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessOrEqualCstCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsLessOrEqualCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessOrEqualCstVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsLessOrEqualCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessOrEqualVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsLessOrEqualVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessOrEqualCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsLessOrEqualCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLessOrEqual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLessOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLessOrEqual_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLessOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLessOrEqual_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLessOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterOrEqualCstCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsGreaterOrEqualCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterOrEqualCstVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsGreaterOrEqualCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterOrEqualVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsGreaterOrEqualVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterOrEqualCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsGreaterOrEqualCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreaterOrEqual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreaterOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreaterOrEqual_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreaterOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreaterOrEqual_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreaterOrEqual(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterCstCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsGreaterCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterCstVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsGreaterCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsGreaterVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsGreaterCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsGreaterCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreater_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreater(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreater_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreater(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGreater_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeGreater(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessCstCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsLessCstCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessCstVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsLessCstVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::IntVar *)(arg1)->MakeIsLessVar(arg2,arg3);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsLessCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsLessCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLess_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLess(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLess_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLess(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLess_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int arg3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeLess(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumLessOrEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeSumLessOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumGreaterOrEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeSumGreaterOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumEquality_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeSumEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumEquality_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeSumEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdEquality_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdEquality((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdEquality_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdEquality((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdEquality_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdEquality((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdEquality_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdEquality((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdGreaterOrEqual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdGreaterOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdGreaterOrEqual_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdGreaterOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdLessOrEqual_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdLessOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScalProdLessOrEqual_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeScalProdLessOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMinEquality(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeMinEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMaxEquality(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeMaxEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElementEquality_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeElementEquality((std::vector< int64_t > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElementEquality_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    arg2 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg2);
    arg2->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      arg2->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeElementEquality((std::vector< int > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg2;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElementEquality_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeElementEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeElementEquality_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeElementEquality((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAbsEquality(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeAbsEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIndexOfConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIndexOfConstraint((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeConstraintInitialPropagateCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  operations_research::Demon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  result = (operations_research::Demon *)(arg1)->MakeConstraintInitialPropagateCallback(arg2);
  *(operations_research::Demon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDelayedConstraintInitialPropagateCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  operations_research::Demon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  result = (operations_research::Demon *)(arg1)->MakeDelayedConstraintInitialPropagateCallback(arg2);
  *(operations_research::Demon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeClosureDemon(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Solver::Closure arg2 ;
  operations_research::Demon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "run", "()V");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard]() -> void {
    return jenv->CallVoidMethod(jarg2_object, jarg2_method_id);
  };
  
  result = (operations_research::Demon *)(arg1)->MakeClosureDemon(arg2);
  *(operations_research::Demon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBetweenCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeBetweenCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNotBetweenCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeNotBetweenCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsBetweenCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntVar *arg5 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = *(operations_research::IntVar **)&jarg5; 
  result = (operations_research::Constraint *)(arg1)->MakeIsBetweenCt(arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsBetweenVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntVar *)(arg1)->MakeIsBetweenVar(arg2,arg3,arg4);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMemberCt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeMemberCt(arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMemberCt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jintArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeMemberCt(arg2,(std::vector< int > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNotMemberCt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNotMemberCt(arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNotMemberCt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jintArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNotMemberCt(arg2,(std::vector< int > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNotMemberCt_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlongArray jarg3, jlongArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int64_t > arg3 ;
  std::vector< int64_t > arg4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    const int size = jenv->GetArrayLength(jarg3);
    (&arg3)->clear();
    (&arg3)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg3)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNotMemberCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNotMemberCt_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jintArray jarg3, jintArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int > arg3 ;
  std::vector< int > arg4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    const int size = jenv->GetArrayLength(jarg3);
    (&arg3)->clear();
    (&arg3)->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg3)->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNotMemberCt(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsMemberCt_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlongArray jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsMemberCt(arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsMemberCt_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jintArray jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIsMemberCt(arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsMemberVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntVar *)(arg1)->MakeIsMemberVar(arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIsMemberVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jintArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::IntVar *)(arg1)->MakeIsMemberVar(arg2,(std::vector< int > const &)*arg3);
  *(operations_research::IntVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCount_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeCount((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCount_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeCount((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jobjectArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jobjectArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlongArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< int64_t > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    arg4 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,(std::vector< int64_t > const &)*arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  {
    delete arg4;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jintArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  std::vector< int > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    arg4 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,(std::vector< int > const &)*arg4);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  {
    delete arg4;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlongArray jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< int64_t > *arg4 = 0 ;
  std::vector< int64_t > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    arg4 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,(std::vector< int64_t > const &)*arg4,(std::vector< int64_t > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDistribute_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jintArray jarg4, jintArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  std::vector< int > *arg4 = 0 ;
  std::vector< int > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    arg4 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeDistribute((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,(std::vector< int > const &)*arg4,(std::vector< int > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDeviation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeDeviation((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllDifferent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::Constraint *)(arg1)->MakeAllDifferent((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllDifferent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  bool arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = jarg3 ? true : false; 
  result = (operations_research::Constraint *)(arg1)->MakeAllDifferent((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllDifferentExcept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int64_t arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeAllDifferentExcept((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSortingConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeSortingConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLexicalLess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeLexicalLess((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLexicalLessOrEqual(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeLexicalLessOrEqual((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeLexicalLessOrEqualWithOffsets(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlongArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg2 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  std::vector< int64_t > arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeLexicalLessOrEqualWithOffsets(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeIsLexicalLessOrEqualWithOffsetsCt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlongArray jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg2 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  std::vector< int64_t > arg4 ;
  operations_research::IntVar *arg5 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg5 = *(operations_research::IntVar **)&jarg5; 
  result = (operations_research::Constraint *)(arg1)->MakeIsLexicalLessOrEqualWithOffsetsCt(arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeInversePermutationConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeInversePermutationConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIndexOfFirstMaxValueConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeIndexOfFirstMaxValueConstraint(arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIndexOfFirstMinValueConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeIndexOfFirstMinValueConstraint(arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNullIntersect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeNullIntersect((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNullIntersectExcept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeNullIntersectExcept((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNoCycle_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::IndexFilter1 arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "test", "(J)Z");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t) -> bool {
    return jenv->CallBooleanMethod(jarg4_object, jarg4_method_id, (jlong)t);
  };
  
  result = (operations_research::Constraint *)(arg1)->MakeNoCycle((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNoCycle_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeNoCycle((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNoCycle_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobject jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::IndexFilter1 arg4 ;
  bool arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "test", "(J)Z");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t) -> bool {
    return jenv->CallBooleanMethod(jarg4_object, jarg4_method_id, (jlong)t);
  };
  
  arg5 = jarg5 ? true : false; 
  result = (operations_research::Constraint *)(arg1)->MakeNoCycle((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCircuit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::Constraint *)(arg1)->MakeCircuit((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSubCircuit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::Constraint *)(arg1)->MakeSubCircuit((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePathCumul_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobjectArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  result = (operations_research::Constraint *)(arg1)->MakePathCumul((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,(std::vector< operations_research::IntVar * > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDelayedPathCumul(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobjectArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  result = (operations_research::Constraint *)(arg1)->MakeDelayedPathCumul((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,(std::vector< operations_research::IntVar * > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePathCumul_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  operations_research::Solver::IndexEvaluator2 arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  
  jclass jarg5_object_class = jenv->GetObjectClass(jarg5);
  if (nullptr == jarg5_object_class) return 0;
  jmethodID jarg5_method_id = jenv->GetMethodID(
    jarg5_object_class, "applyAsLong", "(JJ)J");
  assert(jarg5_method_id != nullptr);
  // jarg5 will be deleted once this function return.
  jobject jarg5_object = jenv->NewGlobalRef(jarg5);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg5_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg5_guard = std::make_shared<GlobalRefGuard>(jvm, jarg5_object);
  }
  arg5 = [jenv, jarg5_object, jarg5_method_id, jarg5_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg5_object, jarg5_method_id, (jlong)t,(jlong)u);
  };
  
  result = (operations_research::Constraint *)(arg1)->MakePathCumul((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePathCumul_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobjectArray jarg5, jobject jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  operations_research::Solver::IndexEvaluator2 arg6 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  
  jclass jarg6_object_class = jenv->GetObjectClass(jarg6);
  if (nullptr == jarg6_object_class) return 0;
  jmethodID jarg6_method_id = jenv->GetMethodID(
    jarg6_object_class, "applyAsLong", "(JJ)J");
  assert(jarg6_method_id != nullptr);
  // jarg6 will be deleted once this function return.
  jobject jarg6_object = jenv->NewGlobalRef(jarg6);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg6_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg6_guard = std::make_shared<GlobalRefGuard>(jvm, jarg6_object);
  }
  arg6 = [jenv, jarg6_object, jarg6_method_id, jarg6_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg6_object, jarg6_method_id, (jlong)t,(jlong)u);
  };
  
  result = (operations_research::Constraint *)(arg1)->MakePathCumul((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,(std::vector< operations_research::IntVar * > const &)*arg5,arg6);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePathConnected(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlongArray jarg4, jobjectArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg2 ;
  std::vector< int64_t > arg3 ;
  std::vector< int64_t > arg4 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = result2;
  }
  
  if(jarg3) {
    const int size = jenv->GetArrayLength(jarg3);
    (&arg3)->clear();
    (&arg3)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg3)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = result5;
  }
  result = (operations_research::Constraint *)(arg1)->MakePathConnected(arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMapDomain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::Constraint *)(arg1)->MakeMapDomain(arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllowedAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntTupleSet *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntTupleSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::IntTupleSet const & is null");
    return 0;
  } 
  result = (operations_research::Constraint *)(arg1)->MakeAllowedAssignments((std::vector< operations_research::IntVar * > const &)*arg2,(operations_research::IntTupleSet const &)*arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTransitionConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntTupleSet *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< int64_t > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntTupleSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::IntTupleSet const & is null");
    return 0;
  } 
  arg4 = (int64_t)jarg4; 
  
  if(jarg5) {
    arg5 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeTransitionConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(operations_research::IntTupleSet const &)*arg3,arg4,(std::vector< int64_t > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTransitionConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jintArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::IntTupleSet *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< int > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntTupleSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::IntTupleSet const & is null");
    return 0;
  } 
  arg4 = (int64_t)jarg4; 
  
  if(jarg5) {
    arg5 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeTransitionConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(operations_research::IntTupleSet const &)*arg3,arg4,(std::vector< int > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingBoxesConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobjectArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,(std::vector< operations_research::IntVar * > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingBoxesConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlongArray jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int64_t > *arg4 = 0 ;
  std::vector< int64_t > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int64_t > const &)*arg4,(std::vector< int64_t > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingBoxesConstraint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jintArray jarg4, jintArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int > *arg4 = 0 ;
  std::vector< int > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int > const &)*arg4,(std::vector< int > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingNonStrictBoxesConstraint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobjectArray jarg4, jobjectArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result4 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingNonStrictBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< operations_research::IntVar * > const &)*arg4,(std::vector< operations_research::IntVar * > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingNonStrictBoxesConstraint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlongArray jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int64_t > *arg4 = 0 ;
  std::vector< int64_t > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingNonStrictBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int64_t > const &)*arg4,(std::vector< int64_t > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNonOverlappingNonStrictBoxesConstraint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jintArray jarg4, jintArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int > *arg4 = 0 ;
  std::vector< int > *arg5 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    arg5 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg5);
    arg5->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      arg5->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Constraint *)(arg1)->MakeNonOverlappingNonStrictBoxesConstraint((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int > const &)*arg4,(std::vector< int > const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg4;
  }
  {
    delete arg5;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Pack *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int)jarg3; 
  result = (operations_research::Pack *)(arg1)->MakePack((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::Pack **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationIntervalVar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jboolean jarg5, jstring jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  bool arg5 ;
  std::string *arg6 = 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = jarg5 ? true : false; 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationIntervalVar(arg2,arg3,arg4,arg5,(std::string const &)*arg6);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationIntervalVar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  std::string *arg4 = 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationIntervalVar(arg2,arg3,(std::string const &)*arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationIntervalVar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::string *arg5 = 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationIntervalVar(arg2,arg3,arg4,(std::string const &)*arg5);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  std::string *arg4 = 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedInterval(arg2,arg3,(std::string const &)*arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jboolean jarg8, jstring jarg9) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  int64_t arg6 ;
  int64_t arg7 ;
  bool arg8 ;
  std::string *arg9 = 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = jarg8 ? true : false; 
  if(!jarg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg9_pstr = (const char *)jenv->GetStringUTFChars(jarg9, 0); 
  if (!arg9_pstr) return 0;
  std::string arg9_str(arg9_pstr);
  arg9 = &arg9_str;
  jenv->ReleaseStringUTFChars(jarg9, arg9_pstr); 
  result = (operations_research::IntervalVar *)(arg1)->MakeIntervalVar(arg2,arg3,arg4,arg5,arg6,arg7,arg8,(std::string const &)*arg9);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMirrorInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  result = (operations_research::IntervalVar *)(arg1)->MakeMirrorInterval(arg2);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationStartSyncedOnStartIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationStartSyncedOnStartIntervalVar(arg2,arg3,arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationStartSyncedOnEndIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationStartSyncedOnEndIntervalVar(arg2,arg3,arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationEndSyncedOnStartIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationEndSyncedOnStartIntervalVar(arg2,arg3,arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFixedDurationEndSyncedOnEndIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t arg4 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::IntervalVar *)(arg1)->MakeFixedDurationEndSyncedOnEndIntervalVar(arg2,arg3,arg4);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalRelaxedMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  result = (operations_research::IntervalVar *)(arg1)->MakeIntervalRelaxedMin(arg2);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalRelaxedMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  result = (operations_research::IntervalVar *)(arg1)->MakeIntervalRelaxedMax(arg2);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalVarRelation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::Solver::UnaryIntervalRelation arg3 ;
  int64_t arg4 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (operations_research::Solver::UnaryIntervalRelation)jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIntervalVarRelation(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalVarRelation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::Solver::BinaryIntervalRelation arg3 ;
  operations_research::IntervalVar *arg4 = (operations_research::IntervalVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (operations_research::Solver::BinaryIntervalRelation)jarg3; 
  arg4 = *(operations_research::IntervalVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeIntervalVarRelation(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeIntervalVarRelationWithDelay(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4, jobject jarg4_, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::Solver::BinaryIntervalRelation arg3 ;
  operations_research::IntervalVar *arg4 = (operations_research::IntervalVar *) 0 ;
  int64_t arg5 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (operations_research::Solver::BinaryIntervalRelation)jarg3; 
  arg4 = *(operations_research::IntervalVar **)&jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::Constraint *)(arg1)->MakeIntervalVarRelationWithDelay(arg2,arg3,arg4,arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTemporalDisjunction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *arg3 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = *(operations_research::IntervalVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  result = (operations_research::Constraint *)(arg1)->MakeTemporalDisjunction(arg2,arg3,arg4);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTemporalDisjunction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *arg3 = (operations_research::IntervalVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = *(operations_research::IntervalVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeTemporalDisjunction(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDisjunctiveConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::DisjunctiveConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (operations_research::DisjunctiveConstraint *)(arg1)->MakeDisjunctiveConstraint((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::string const &)*arg3);
  *(operations_research::DisjunctiveConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeStrictDisjunctiveConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::DisjunctiveConstraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = (operations_research::DisjunctiveConstraint *)(arg1)->MakeStrictDisjunctiveConstraint((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::string const &)*arg3);
  *(operations_research::DisjunctiveConstraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = *(operations_research::IntVar **)&jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlong jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  int64_t arg4 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  arg4 = (int64_t)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCumulative_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  std::string *arg5 = 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  arg4 = *(operations_research::IntVar **)&jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  result = (operations_research::Constraint *)(arg1)->MakeCumulative((std::vector< operations_research::IntervalVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,(std::string const &)*arg5);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCover(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  operations_research::IntervalVar *arg3 = (operations_research::IntervalVar *) 0 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::IntervalVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeCover((std::vector< operations_research::IntervalVar * > const &)*arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeEquality_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *arg3 = (operations_research::IntervalVar *) 0 ;
  operations_research::Constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = *(operations_research::IntervalVar **)&jarg3; 
  result = (operations_research::Constraint *)(arg1)->MakeEquality(arg2,arg3);
  *(operations_research::Constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAssignment_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Assignment *)(arg1)->MakeAssignment();
  *(operations_research::Assignment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAssignment_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::Assignment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::Assignment *)(arg1)->MakeAssignment((operations_research::Assignment const *)arg2);
  *(operations_research::Assignment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFirstSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeFirstSolutionCollector((operations_research::Assignment const *)arg2);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFirstSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeFirstSolutionCollector();
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLastSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeLastSolutionCollector((operations_research::Assignment const *)arg2);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLastSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeLastSolutionCollector();
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBestValueSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  bool arg3 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeBestValueSolutionCollector((operations_research::Assignment const *)arg2,arg3);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeBestLexicographicValueSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  std::vector< bool > arg3 ;
  std::vector< bool > *argp3 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  argp3 = *(std::vector< bool > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg3 = *argp3; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeBestLexicographicValueSolutionCollector((operations_research::Assignment const *)arg2,arg3);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBestValueSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeBestValueSolutionCollector(arg2);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeBestLexicographicValueSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< bool > arg2 ;
  std::vector< bool > *argp2 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(std::vector< bool > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg2 = *argp2; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeBestLexicographicValueSolutionCollector(arg2);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNBestValueSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  int arg3 ;
  bool arg4 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeNBestValueSolutionCollector((operations_research::Assignment const *)arg2,arg3,arg4);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNBestValueSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  bool arg3 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeNBestValueSolutionCollector(arg2,arg3);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeNBestLexicographicValueSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  int arg3 ;
  std::vector< bool > arg4 ;
  std::vector< bool > *argp4 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  arg3 = (int)jarg3; 
  argp4 = *(std::vector< bool > **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg4 = *argp4; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeNBestLexicographicValueSolutionCollector((operations_research::Assignment const *)arg2,arg3,arg4);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeNBestLexicographicValueSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  std::vector< bool > arg3 ;
  std::vector< bool > *argp3 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  argp3 = *(std::vector< bool > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg3 = *argp3; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeNBestLexicographicValueSolutionCollector(arg2,arg3);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllSolutionCollector_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeAllSolutionCollector((operations_research::Assignment const *)arg2);
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAllSolutionCollector_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SolutionCollector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::SolutionCollector *)(arg1)->MakeAllSolutionCollector();
  *(operations_research::SolutionCollector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMinimize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeMinimize(arg2,arg3);
  *(operations_research::OptimizeVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMaximize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeMaximize(arg2,arg3);
  *(operations_research::OptimizeVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOptimize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeOptimize(arg2,arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedMinimize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedMinimize((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedMinimize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedMinimize((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedMaximize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedMaximize((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedMaximize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int > *arg3 = 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg4 = (int64_t)jarg4; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedMaximize((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int > const &)*arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedOptimize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jobjectArray jarg3, jlongArray jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int64_t > *arg4 = 0 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg5 = (int64_t)jarg5; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedOptimize(arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int64_t > const &)*arg4,arg5);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg4;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeWeightedOptimize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jobjectArray jarg3, jintArray jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< int > *arg4 = 0 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  if(jarg4) {
    arg4 = new std::vector<int>;
    const int size = jenv->GetArrayLength(jarg4);
    arg4->reserve(size);
    jint *values = jenv->GetIntArrayElements((jintArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      arg4->emplace_back(values[i]);
    }
    jenv->ReleaseIntArrayElements((jintArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg5 = (int64_t)jarg5; 
  result = (operations_research::OptimizeVar *)(arg1)->MakeWeightedOptimize(arg2,(std::vector< operations_research::IntVar * > const &)*arg3,(std::vector< int > const &)*arg4,arg5);
  *(operations_research::OptimizeVar **)&jresult = result; 
  {
    delete arg4;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeLexicographicOptimize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobjectArray jarg3, jlongArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< bool > arg2 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  std::vector< int64_t > arg4 ;
  std::vector< bool > *argp2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::OptimizeVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(std::vector< bool > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg2 = *argp2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::OptimizeVar *)(arg1)->MakeLexicographicOptimize(arg2,arg3,arg4);
  *(operations_research::OptimizeVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTabuSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobjectArray jarg5, jlong jarg6, jlong jarg7, jdouble jarg8) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  int64_t arg6 ;
  int64_t arg7 ;
  double arg8 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (double)jarg8; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeTabuSearch(arg2,arg3,arg4,(std::vector< operations_research::IntVar * > const &)*arg5,arg6,arg7,arg8);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeLexicographicTabuSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobjectArray jarg3, jlongArray jarg4, jobjectArray jarg5, jlong jarg6, jlong jarg7, jdouble jarg8) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< bool > *arg2 = 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  std::vector< int64_t > arg4 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  int64_t arg6 ;
  int64_t arg7 ;
  double arg8 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(std::vector< bool > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > const & is null");
    return 0;
  } 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (double)jarg8; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeLexicographicTabuSearch((std::vector< bool > const &)*arg2,arg3,arg4,(std::vector< operations_research::IntVar * > const &)*arg5,arg6,arg7,arg8);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGenericTabuSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobjectArray jarg5, jlong jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  std::vector< operations_research::IntVar * > *arg5 = 0 ;
  int64_t arg6 ;
  std::vector< operations_research::IntVar * > result5 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg5); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg5, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result5.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg5 = &result5;
  }
  arg6 = (int64_t)jarg6; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeGenericTabuSearch(arg2,arg3,arg4,(std::vector< operations_research::IntVar * > const &)*arg5,arg6);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSimulatedAnnealing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  int64_t arg4 ;
  int64_t arg5 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeSimulatedAnnealing(arg2,arg3,arg4,arg5);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeLexicographicSimulatedAnnealing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobjectArray jarg3, jlongArray jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< bool > *arg2 = 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  std::vector< int64_t > arg4 ;
  std::vector< int64_t > arg5 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(std::vector< bool > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > const & is null");
    return 0;
  } 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    const int size = jenv->GetArrayLength(jarg5);
    (&arg5)->clear();
    (&arg5)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg5)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeLexicographicSimulatedAnnealing((std::vector< bool > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGuidedLocalSearch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jlong jarg5, jobjectArray jarg6, jdouble jarg7, jboolean jarg8) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > *arg6 = 0 ;
  double arg7 ;
  bool arg8 ;
  std::vector< operations_research::IntVar * > result6 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  arg5 = (int64_t)jarg5; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg6); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg6, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result6.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg6 = &result6;
  }
  arg7 = (double)jarg7; 
  arg8 = jarg8 ? true : false; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeGuidedLocalSearch(arg2,arg3,arg4,arg5,(std::vector< operations_research::IntVar * > const &)*arg6,arg7,arg8);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGuidedLocalSearch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jlong jarg5, jobjectArray jarg6, jdouble jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > *arg6 = 0 ;
  double arg7 ;
  std::vector< operations_research::IntVar * > result6 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  arg5 = (int64_t)jarg5; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg6); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg6, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result6.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg6 = &result6;
  }
  arg7 = (double)jarg7; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeGuidedLocalSearch(arg2,arg3,arg4,arg5,(std::vector< operations_research::IntVar * > const &)*arg6,arg7);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGuidedLocalSearch_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jlong jarg5, jobjectArray jarg6, jobjectArray jarg7, jdouble jarg8, jboolean jarg9) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IndexEvaluator3 arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > *arg6 = 0 ;
  std::vector< operations_research::IntVar * > *arg7 = 0 ;
  double arg8 ;
  bool arg9 ;
  std::vector< operations_research::IntVar * > result6 ;
  std::vector< operations_research::IntVar * > result7 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u,long v) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  arg5 = (int64_t)jarg5; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg6); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg6, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result6.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg6 = &result6;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg7); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg7, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result7.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg7 = &result7;
  }
  arg8 = (double)jarg8; 
  arg9 = jarg9 ? true : false; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeGuidedLocalSearch(arg2,arg3,arg4,arg5,(std::vector< operations_research::IntVar * > const &)*arg6,(std::vector< operations_research::IntVar * > const &)*arg7,arg8,arg9);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeGuidedLocalSearch_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jlong jarg3, jobject jarg3_, jobject jarg4, jlong jarg5, jobjectArray jarg6, jobjectArray jarg7, jdouble jarg8) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IndexEvaluator3 arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::IntVar * > *arg6 = 0 ;
  std::vector< operations_research::IntVar * > *arg7 = 0 ;
  double arg8 ;
  std::vector< operations_research::IntVar * > result6 ;
  std::vector< operations_research::IntVar * > result7 ;
  operations_research::ObjectiveMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u,long v) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  arg5 = (int64_t)jarg5; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg6); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg6, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result6.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg6 = &result6;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg7); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg7, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result7.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg7 = &result7;
  }
  arg8 = (double)jarg8; 
  result = (operations_research::ObjectiveMonitor *)(arg1)->MakeGuidedLocalSearch(arg2,arg3,arg4,arg5,(std::vector< operations_research::IntVar * > const &)*arg6,(std::vector< operations_research::IntVar * > const &)*arg7,arg8);
  *(operations_research::ObjectiveMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLubyRestart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeLubyRestart(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeConstantRestart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeConstantRestart(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTimeLimit_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  absl::Duration arg2 ;
  absl::Duration *argp2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(absl::Duration **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null absl::Duration");
    return 0;
  }
  arg2 = *argp2; 
  result = (operations_research::RegularLimit *)(arg1)->MakeTimeLimit(arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeTimeLimit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (operations_research::RegularLimit *)(arg1)->MakeTimeLimit(arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeBranchesLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (operations_research::RegularLimit *)(arg1)->MakeBranchesLimit(arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFailuresLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (operations_research::RegularLimit *)(arg1)->MakeFailuresLimit(arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolutionsLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (operations_research::RegularLimit *)(arg1)->MakeSolutionsLimit(arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jboolean jarg6, jboolean jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  absl::Duration arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  bool arg6 ;
  bool arg7 ;
  absl::Duration *argp2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(absl::Duration **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null absl::Duration");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = jarg6 ? true : false; 
  arg7 = jarg7 ? true : false; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  absl::Duration arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  bool arg6 ;
  absl::Duration *argp2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(absl::Duration **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null absl::Duration");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = jarg6 ? true : false; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  absl::Duration arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  absl::Duration *argp2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  argp2 = *(absl::Duration **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null absl::Duration");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::RegularLimitParameters *arg2 = 0 ;
  operations_research::RegularLimitParameters temp2 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    const int proto_size = jenv->GetArrayLength(jarg2);
    std::unique_ptr<jbyte[]> proto_buffer(new jbyte[proto_size]);
    jenv->GetByteArrayRegion(jarg2, 0, proto_size, proto_buffer.get());
    bool parsed_ok = temp2.ParseFromArray(proto_buffer.get(), proto_size);
    if (!parsed_ok) {
      SWIG_JavaThrowException(jenv,
        SWIG_JavaRuntimeException,
        "Unable to parse operations_research::RegularLimitParameters protocol message.");
    }
    arg2 = &temp2;
  }
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit((operations_research::RegularLimitParameters const &)*arg2);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jboolean jarg6, jboolean jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  bool arg6 ;
  bool arg7 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = jarg6 ? true : false; 
  arg7 = jarg7 ? true : false; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jboolean jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  bool arg6 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = jarg6 ? true : false; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t arg3 ;
  int64_t arg4 ;
  int64_t arg5 ;
  operations_research::RegularLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::RegularLimit *)(arg1)->MakeLimit(arg2,arg3,arg4,arg5);
  *(operations_research::RegularLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDefaultRegularLimitParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::RegularLimitParameters result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = ((operations_research::Solver const *)arg1)->MakeDefaultRegularLimitParameters();
  {
    const long size = (&result)->ByteSizeLong();
    std::unique_ptr<jbyte[]> buf(new jbyte[size]);
    (&result)->SerializeWithCachedSizesToArray(reinterpret_cast<uint8_t*>(buf.get()));
    jresult = jenv->NewByteArray(size);
    jenv->SetByteArrayRegion(jresult, 0, size, buf.get());
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLimit_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SearchLimit *arg2 = (operations_research::SearchLimit *) 0 ;
  operations_research::SearchLimit *arg3 = (operations_research::SearchLimit *) 0 ;
  operations_research::SearchLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SearchLimit **)&jarg2; 
  arg3 = *(operations_research::SearchLimit **)&jarg3; 
  result = (operations_research::SearchLimit *)(arg1)->MakeLimit(arg2,arg3);
  *(operations_research::SearchLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeImprovementLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jint jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  bool arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  int arg7 ;
  operations_research::ImprovementSearchLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (int)jarg7; 
  result = (operations_research::ImprovementSearchLimit *)(arg1)->MakeImprovementLimit(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::ImprovementSearchLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeLexicographicImprovementLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jdoubleArray jarg4, jdoubleArray jarg5, jdouble jarg6, jint jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg2 ;
  std::vector< bool > arg3 ;
  std::vector< double > arg4 ;
  std::vector< double > arg5 ;
  double arg6 ;
  int arg7 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< bool > *argp3 ;
  operations_research::ImprovementSearchLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = result2;
  }
  argp3 = *(std::vector< bool > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< bool >");
    return 0;
  }
  arg3 = *argp3; 
  
  if(jarg4) {
    const int size = jenv->GetArrayLength(jarg4);
    (&arg4)->clear();
    (&arg4)->reserve(size);
    jdouble *values = jenv->GetDoubleArrayElements((jdoubleArray)jarg4, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg4)->emplace_back(values[i]);
    }
    jenv->ReleaseDoubleArrayElements((jdoubleArray)jarg4, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  
  if(jarg5) {
    const int size = jenv->GetArrayLength(jarg5);
    (&arg5)->clear();
    (&arg5)->reserve(size);
    jdouble *values = jenv->GetDoubleArrayElements((jdoubleArray)jarg5, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg5)->emplace_back(values[i]);
    }
    jenv->ReleaseDoubleArrayElements((jdoubleArray)jarg5, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  arg6 = (double)jarg6; 
  arg7 = (int)jarg7; 
  result = (operations_research::ImprovementSearchLimit *)(arg1)->MakeLexicographicImprovementLimit(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::ImprovementSearchLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeCustomLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::function< bool () > arg2 ;
  operations_research::SearchLimit *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "getAsBoolean", "()Z");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard]() -> bool {
    return jenv->CallBooleanMethod(jarg2_object, jarg2_method_id);
  };
  
  result = (operations_research::SearchLimit *)(arg1)->MakeCustomLimit(arg2);
  *(operations_research::SearchLimit **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  SwigValueWrapper< std::function< std::string () > > arg3 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "get", "()Ljava/lang/Object;");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard]() -> std::string {
    jstring js = (jstring) jenv->CallObjectMethod(jarg3_object, jarg3_method_id);
    // convert the Java String to const char* C string.
    const char* c_str(jenv->GetStringUTFChars(js, 0));
    // copy the C string to std::string
    std::string str(c_str);
    // release the C string.
    jenv->ReleaseStringUTFChars(js, c_str);
    return str;
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  SwigValueWrapper< std::function< std::string () > > arg4 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "get", "()Ljava/lang/Object;");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard]() -> std::string {
    jstring js = (jstring) jenv->CallObjectMethod(jarg4_object, jarg4_method_id);
    // convert the Java String to const char* C string.
    const char* c_str(jenv->GetStringUTFChars(js, 0));
    // copy the C string to std::string
    std::string str(c_str);
    // release the C string.
    jenv->ReleaseStringUTFChars(js, c_str);
    return str;
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3,arg4);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobjectArray jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  SwigValueWrapper< std::vector< operations_research::IntVar * > > arg3 ;
  SwigValueWrapper< std::function< std::string () > > arg4 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(object_class,
      "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = result3;
  }
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "get", "()Ljava/lang/Object;");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard]() -> std::string {
    jstring js = (jstring) jenv->CallObjectMethod(jarg4_object, jarg4_method_id);
    // convert the Java String to const char* C string.
    const char* c_str(jenv->GetStringUTFChars(js, 0));
    // copy the C string to std::string
    std::string str(c_str);
    // release the C string.
    jenv->ReleaseStringUTFChars(js, c_str);
    return str;
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3,arg4);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::OptimizeVar *arg3 = (operations_research::OptimizeVar *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(operations_research::OptimizeVar **)&jarg3; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchLog_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int arg2 ;
  operations_research::OptimizeVar *arg3 = (operations_research::OptimizeVar *) 0 ;
  SwigValueWrapper< std::function< std::string () > > arg4 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(operations_research::OptimizeVar **)&jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "get", "()Ljava/lang/Object;");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard]() -> std::string {
    jstring js = (jstring) jenv->CallObjectMethod(jarg4_object, jarg4_method_id);
    // convert the Java String to const char* C string.
    const char* c_str(jenv->GetStringUTFChars(js, 0));
    // copy the C string to std::string
    std::string str(c_str);
    // release the C string.
    jenv->ReleaseStringUTFChars(js, c_str);
    return str;
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchLog(arg2,arg3,arg4);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSearchTrace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSearchTrace((std::string const &)*arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeEnterSearchCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::function< void () > arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "run", "()V");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard]() -> void {
    return jenv->CallVoidMethod(jarg2_object, jarg2_method_id);
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeEnterSearchCallback(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeExitSearchCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::function< void () > arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "run", "()V");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard]() -> void {
    return jenv->CallVoidMethod(jarg2_object, jarg2_method_id);
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeExitSearchCallback(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAtSolutionCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::function< void () > arg2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "run", "()V");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id, jarg2_guard]() -> void {
    return jenv->CallVoidMethod(jarg2_object, jarg2_method_id);
  };
  
  result = (operations_research::SearchMonitor *)(arg1)->MakeAtSolutionCallback(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePrintModelVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ModelVisitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::ModelVisitor *)(arg1)->MakePrintModelVisitor();
  *(operations_research::ModelVisitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeStatisticsModelVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ModelVisitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::ModelVisitor *)(arg1)->MakeStatisticsModelVisitor();
  *(operations_research::ModelVisitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSymmetryManager_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::SymmetryBreaker * > *arg2 = 0 ;
  std::vector< operations_research::SymmetryBreaker * > result2 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SymmetryBreaker";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SymmetryBreaker*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::SearchMonitor *)(arg1)->MakeSymmetryManager((std::vector< operations_research::SymmetryBreaker * > const &)*arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSymmetryManager_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SymmetryBreaker *arg2 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SymmetryBreaker **)&jarg2; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSymmetryManager(arg2);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSymmetryManager_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SymmetryBreaker *arg2 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg3 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SymmetryBreaker **)&jarg2; 
  arg3 = *(operations_research::SymmetryBreaker **)&jarg3; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSymmetryManager(arg2,arg3);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSymmetryManager_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SymmetryBreaker *arg2 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg3 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg4 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SymmetryBreaker **)&jarg2; 
  arg3 = *(operations_research::SymmetryBreaker **)&jarg3; 
  arg4 = *(operations_research::SymmetryBreaker **)&jarg4; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSymmetryManager(arg2,arg3,arg4);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSymmetryManager_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SymmetryBreaker *arg2 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg3 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg4 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SymmetryBreaker *arg5 = (operations_research::SymmetryBreaker *) 0 ;
  operations_research::SearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SymmetryBreaker **)&jarg2; 
  arg3 = *(operations_research::SymmetryBreaker **)&jarg3; 
  arg4 = *(operations_research::SymmetryBreaker **)&jarg4; 
  arg5 = *(operations_research::SymmetryBreaker **)&jarg5; 
  result = (operations_research::SearchMonitor *)(arg1)->MakeSymmetryManager(arg2,arg3,arg4,arg5);
  *(operations_research::SearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAssignVariableValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeAssignVariableValue(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeVariableLessOrEqualValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeVariableLessOrEqualValue(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeVariableGreaterOrEqualValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeVariableGreaterOrEqualValue(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSplitVariableDomain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  bool arg4 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  result = (operations_research::Decision *)(arg1)->MakeSplitVariableDomain(arg2,arg3,arg4);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAssignVariableValueOrFail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeAssignVariableValueOrFail(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeAssignVariableValueOrDoNothing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeAssignVariableValueOrDoNothing(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeAssignVariablesValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Decision *)(arg1)->MakeAssignVariablesValues((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::Decision **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeAssignVariablesValuesOrDoNothing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Decision *)(arg1)->MakeAssignVariablesValuesOrDoNothing((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::Decision **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeAssignVariablesValuesOrFail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::Decision *)(arg1)->MakeAssignVariablesValuesOrFail((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::Decision **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeFailDecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Decision *)(arg1)->MakeFailDecision();
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  SwigValueWrapper< std::function< void (operations_research::Solver *) > > arg2 ;
  SwigValueWrapper< std::function< void (operations_research::Solver *) > > arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  jclass jarg2_object_class = jenv->GetObjectClass(jarg2);
  if (nullptr == jarg2_object_class) return 0;
  jmethodID jarg2_method_id = jenv->GetMethodID(
    jarg2_object_class, "accept", "(Ljava/lang/Object;)V");
  assert(jarg2_method_id != nullptr);
  // jarg2 will be deleted once this function return.
  jobject jarg2_object = jenv->NewGlobalRef(jarg2);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg2_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg2_guard = std::make_shared<GlobalRefGuard>(jvm, jarg2_object);
  }
  arg2 = [jenv, jarg2_object, jarg2_method_id,
  jarg2_guard](operations_research::Solver* solver) -> void {
    jclass solver_class = jenv->FindClass(
      "com/google/ortools/constraintsolver/Solver");
    assert(nullptr != solver_class);
    jmethodID solver_constructor = jenv->GetMethodID(solver_class, "<init>", "(JZ)V");
    assert(nullptr != solver_constructor);
    
    // Create a Java Solver class from the C++ Solver*
    jobject solver_object = jenv->NewObject(
      solver_class, solver_constructor, solver, /*OwnMemory=*/false);
    
    // Call the java Callback passing the Java Solver object.
    jenv->CallVoidMethod(jarg2_object, jarg2_method_id, solver_object);
  };
  
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "accept", "(Ljava/lang/Object;)V");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id,
  jarg3_guard](operations_research::Solver* solver) -> void {
    jclass solver_class = jenv->FindClass(
      "com/google/ortools/constraintsolver/Solver");
    assert(nullptr != solver_class);
    jmethodID solver_constructor = jenv->GetMethodID(solver_class, "<init>", "(JZ)V");
    assert(nullptr != solver_constructor);
    
    // Create a Java Solver class from the C++ Solver*
    jobject solver_object = jenv->NewObject(
      solver_class, solver_constructor, solver, /*OwnMemory=*/false);
    
    // Call the java Callback passing the Java Solver object.
    jenv->CallVoidMethod(jarg3_object, jarg3_method_id, solver_object);
  };
  
  result = (operations_research::Decision *)(arg1)->MakeDecision(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1compose_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->Compose(arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1compose_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->Compose(arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1compose_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg5 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  arg5 = *(operations_research::DecisionBuilder **)&jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->Compose(arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1compose_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::DecisionBuilder * > *arg2 = 0 ;
  std::vector< operations_research::DecisionBuilder * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""DecisionBuilder";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::DecisionBuilder*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->Compose((std::vector< operations_research::DecisionBuilder * > const &)*arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tryDecisions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->Try(arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tryDecisions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->Try(arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tryDecisions_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg5 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  arg5 = *(operations_research::DecisionBuilder **)&jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->Try(arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tryDecisions_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::DecisionBuilder * > *arg2 = 0 ;
  std::vector< operations_research::DecisionBuilder * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""DecisionBuilder";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::DecisionBuilder*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->Try((std::vector< operations_research::DecisionBuilder * > const &)*arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IntVarStrategy arg3 ;
  operations_research::Solver::IntValueStrategy arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::IntVarStrategy)jarg3; 
  arg4 = (operations_research::Solver::IntValueStrategy)jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator1 arg3 ;
  operations_research::Solver::IntValueStrategy arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(J)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t);
  };
  
  arg4 = (operations_research::Solver::IntValueStrategy)jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IntVarStrategy arg3 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::IntVarStrategy)jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IntVarStrategy arg3 ;
  operations_research::Solver::VariableValueComparator arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::IntVarStrategy)jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "test", "(JJJ)Z");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u,long v) -> bool {
    return jenv->CallBooleanMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jobject jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator1 arg3 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(J)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t);
  };
  
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IntVarStrategy arg3 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  operations_research::Solver::IndexEvaluator1 arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::IntVarStrategy)jarg3; 
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  
  jclass jarg5_object_class = jenv->GetObjectClass(jarg5);
  if (nullptr == jarg5_object_class) return 0;
  jmethodID jarg5_method_id = jenv->GetMethodID(
    jarg5_object_class, "applyAsLong", "(J)J");
  assert(jarg5_method_id != nullptr);
  // jarg5 will be deleted once this function return.
  jobject jarg5_object = jenv->NewGlobalRef(jarg5);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg5_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg5_guard = std::make_shared<GlobalRefGuard>(jvm, jarg5_object);
  }
  arg5 = [jenv, jarg5_object, jarg5_method_id, jarg5_guard](long t) -> long {
    return jenv->CallLongMethod(jarg5_object, jarg5_method_id, (jlong)t);
  };
  
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator1 arg3 ;
  operations_research::Solver::IndexEvaluator2 arg4 ;
  operations_research::Solver::IndexEvaluator1 arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(J)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t);
  };
  
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u);
  };
  
  
  jclass jarg5_object_class = jenv->GetObjectClass(jarg5);
  if (nullptr == jarg5_object_class) return 0;
  jmethodID jarg5_method_id = jenv->GetMethodID(
    jarg5_object_class, "applyAsLong", "(J)J");
  assert(jarg5_method_id != nullptr);
  // jarg5 will be deleted once this function return.
  jobject jarg5_object = jenv->NewGlobalRef(jarg5);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg5_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg5_guard = std::make_shared<GlobalRefGuard>(jvm, jarg5_object);
  }
  arg5 = [jenv, jarg5_object, jarg5_method_id, jarg5_guard](long t) -> long {
    return jenv->CallLongMethod(jarg5_object, jarg5_method_id, (jlong)t);
  };
  
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDefaultPhase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->MakeDefaultPhase((std::vector< operations_research::IntVar * > const &)*arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDefaultPhase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::DefaultPhaseParameters *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::DefaultPhaseParameters **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::DefaultPhaseParameters const & is null");
    return 0;
  } 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeDefaultPhase((std::vector< operations_research::IntVar * > const &)*arg2,(operations_research::DefaultPhaseParameters const &)*arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IntVarStrategy arg3 ;
  operations_research::Solver::IntValueStrategy arg4 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (operations_research::Solver::IntVarStrategy)jarg3; 
  arg4 = (operations_research::Solver::IntValueStrategy)jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase(arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IntVarStrategy arg4 ;
  operations_research::Solver::IntValueStrategy arg5 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = (operations_research::Solver::IntVarStrategy)jarg4; 
  arg5 = (operations_research::Solver::IntValueStrategy)jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase(arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IntVarStrategy arg5 ;
  operations_research::Solver::IntValueStrategy arg6 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  arg5 = (operations_research::Solver::IntVarStrategy)jarg5; 
  arg6 = (operations_research::Solver::IntValueStrategy)jarg6; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jint jarg6, jint jarg7) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg3 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg4 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *arg5 = (operations_research::IntVar *) 0 ;
  operations_research::Solver::IntVarStrategy arg6 ;
  operations_research::Solver::IntValueStrategy arg7 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntVar **)&jarg3; 
  arg4 = *(operations_research::IntVar **)&jarg4; 
  arg5 = *(operations_research::IntVar **)&jarg5; 
  arg6 = (operations_research::Solver::IntVarStrategy)jarg6; 
  arg7 = (operations_research::Solver::IntValueStrategy)jarg7; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScheduleOrPostpone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t *arg4 = (int64_t *) 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(int64_t **)&jarg4; 
  result = (operations_research::Decision *)(arg1)->MakeScheduleOrPostpone(arg2,arg3,arg4);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeScheduleOrExpedite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  int64_t *arg4 = (int64_t *) 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = *(int64_t **)&jarg4; 
  result = (operations_research::Decision *)(arg1)->MakeScheduleOrExpedite(arg2,arg3,arg4);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeRankFirstInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeRankFirstInterval(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeRankLastInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  result = (operations_research::Decision *)(arg1)->MakeRankLastInterval(arg2,arg3);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator2 arg3 ;
  operations_research::Solver::EvaluatorStrategy arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(JJ)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t,(jlong)u);
  };
  
  arg4 = (operations_research::Solver::EvaluatorStrategy)jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_112(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator2 arg3 ;
  operations_research::Solver::IndexEvaluator1 arg4 ;
  operations_research::Solver::EvaluatorStrategy arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(JJ)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t,(jlong)u);
  };
  
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(J)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t);
  };
  
  arg5 = (operations_research::Solver::EvaluatorStrategy)jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_113(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntervalVar * > *arg2 = 0 ;
  operations_research::Solver::IntervalStrategy arg3 ;
  std::vector< operations_research::IntervalVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::IntervalStrategy)jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::IntervalVar * > const &)*arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makePhase_1_1SWIG_114(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::SequenceVar * > *arg2 = 0 ;
  operations_research::Solver::SequenceStrategy arg3 ;
  std::vector< operations_research::SequenceVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SequenceVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SequenceVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::SequenceStrategy)jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakePhase((std::vector< operations_research::SequenceVar * > const &)*arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDecisionBuilderFromAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jobjectArray jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  std::vector< operations_research::IntVar * > *arg4 = 0 ;
  std::vector< operations_research::IntVar * > result4 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg4); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg4, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result4.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg4 = &result4;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->MakeDecisionBuilderFromAssignment(arg2,arg3,(std::vector< operations_research::IntVar * > const &)*arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeConstraintAdder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Constraint *arg2 = (operations_research::Constraint *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Constraint **)&jarg2; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeConstraintAdder(arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::SearchMonitor *arg3 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg4 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg5 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::SearchMonitor **)&jarg3; 
  arg4 = *(operations_research::SearchMonitor **)&jarg4; 
  arg5 = *(operations_research::SearchMonitor **)&jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSolveOnce_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobjectArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  std::vector< operations_research::SearchMonitor * > *arg3 = 0 ;
  std::vector< operations_research::SearchMonitor * > result3 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SearchMonitor";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SearchMonitor*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->MakeSolveOnce(arg2,(std::vector< operations_research::SearchMonitor * > const &)*arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg7 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  arg7 = *(operations_research::SearchMonitor **)&jarg7; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg7 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg8 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  arg7 = *(operations_research::SearchMonitor **)&jarg7; 
  arg8 = *(operations_research::SearchMonitor **)&jarg8; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_, jlong jarg8, jobject jarg8_, jlong jarg9, jobject jarg9_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  operations_research::SearchMonitor *arg6 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg7 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg8 = (operations_research::SearchMonitor *) 0 ;
  operations_research::SearchMonitor *arg9 = (operations_research::SearchMonitor *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg6_;
  (void)jarg7_;
  (void)jarg8_;
  (void)jarg9_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(operations_research::SearchMonitor **)&jarg6; 
  arg7 = *(operations_research::SearchMonitor **)&jarg7; 
  arg8 = *(operations_research::SearchMonitor **)&jarg8; 
  arg9 = *(operations_research::SearchMonitor **)&jarg9; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNestedOptimize_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5, jobjectArray jarg6) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Assignment *arg3 = (operations_research::Assignment *) 0 ;
  bool arg4 ;
  int64_t arg5 ;
  std::vector< operations_research::SearchMonitor * > *arg6 = 0 ;
  std::vector< operations_research::SearchMonitor * > result6 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  arg3 = *(operations_research::Assignment **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int64_t)jarg5; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SearchMonitor";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg6); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg6, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result6.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SearchMonitor*>(ptr_value)
        /*@SWIG@*/);
    }
    arg6 = &result6;
  }
  result = (operations_research::DecisionBuilder *)(arg1)->MakeNestedOptimize(arg2,arg3,arg4,arg5,(std::vector< operations_research::SearchMonitor * > const &)*arg6);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeRestoreAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeRestoreAssignment(arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeStoreAssignment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeStoreAssignment(arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::LocalSearchOperators arg3 ;
  std::function< std::vector< int > const &(int,int) > arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::function< std::vector< int > const &(int,int) > *argp4 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::LocalSearchOperators)jarg3; 
  argp4 = *(std::function< std::vector< int > const &(int,int) > **)&jarg4; 
  if (!argp4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::function< std::vector< int > const &(int,int) >");
    return 0;
  }
  arg4 = *argp4; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::LocalSearchOperators arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (operations_research::Solver::LocalSearchOperators)jarg3; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jint jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::LocalSearchOperators arg4 ;
  std::function< std::vector< int > const &(int,int) > arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  std::function< std::vector< int > const &(int,int) > *argp5 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  arg4 = (operations_research::Solver::LocalSearchOperators)jarg4; 
  argp5 = *(std::function< std::vector< int > const &(int,int) > **)&jarg5; 
  if (!argp5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::function< std::vector< int > const &(int,int) >");
    return 0;
  }
  arg5 = *argp5; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,arg5);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::LocalSearchOperators arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  arg4 = (operations_research::Solver::LocalSearchOperators)jarg4; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator3 arg3 ;
  operations_research::Solver::EvaluatorLocalSearchOperators arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(JJJ)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t,long u,long v) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  arg4 = (operations_research::Solver::EvaluatorLocalSearchOperators)jarg4; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeOperator_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::IndexEvaluator3 arg4 ;
  operations_research::Solver::EvaluatorLocalSearchOperators arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u,long v) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  arg5 = (operations_research::Solver::EvaluatorLocalSearchOperators)jarg5; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeOperator((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,arg5);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeRandomLnsOperator_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int arg3 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int)jarg3; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeRandomLnsOperator((std::vector< operations_research::IntVar * > const &)*arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeRandomLnsOperator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  int arg3 ;
  int32_t arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int)jarg3; 
  arg4 = (int32_t)jarg4; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeRandomLnsOperator((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMoveTowardTargetOperator_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = 0 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::Assignment const & is null");
    return 0;
  } 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeMoveTowardTargetOperator((operations_research::Assignment const &)*arg2);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeMoveTowardTargetOperator_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlongArray jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return 0;
  }
  
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeMoveTowardTargetOperator((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< int64_t > const &)*arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  {
    delete arg3;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1concatenateOperators_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::LocalSearchOperator *)(arg1)->ConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1concatenateOperators_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  bool arg3 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = jarg3 ? true : false; 
  result = (operations_research::LocalSearchOperator *)(arg1)->ConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1concatenateOperators_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  std::function< int64_t (int,int) > arg3 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(II)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](int t,int u) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jint)t,(jint)u);
  };
  
  result = (operations_research::LocalSearchOperator *)(arg1)->ConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1randomConcatenateOperators_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  result = (operations_research::LocalSearchOperator *)(arg1)->RandomConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1randomConcatenateOperators_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  int32_t arg3 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (int32_t)jarg3; 
  result = (operations_research::LocalSearchOperator *)(arg1)->RandomConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MultiArmedBanditConcatenateOperators(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jdouble jarg3, jdouble jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::LocalSearchOperator * > *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  bool arg5 ;
  std::vector< operations_research::LocalSearchOperator * > result2 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""LocalSearchOperator";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::LocalSearchOperator*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = jarg5 ? true : false; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MultiArmedBanditConcatenateOperators((std::vector< operations_research::LocalSearchOperator * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeNeighborhoodLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchOperator *arg2 = (operations_research::LocalSearchOperator *) 0 ;
  int64_t arg3 ;
  operations_research::LocalSearchOperator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::LocalSearchOperator **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  result = (operations_research::LocalSearchOperator *)(arg1)->MakeNeighborhoodLimit(arg2,arg3);
  *(operations_research::LocalSearchOperator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *arg2 = (operations_research::Assignment *) 0 ;
  operations_research::LocalSearchPhaseParameters *arg3 = (operations_research::LocalSearchPhaseParameters *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Assignment **)&jarg2; 
  arg3 = *(operations_research::LocalSearchPhaseParameters **)&jarg3; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeLocalSearchPhase(arg2,arg3);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::LocalSearchPhaseParameters *arg4 = (operations_research::LocalSearchPhaseParameters *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::LocalSearchPhaseParameters **)&jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeLocalSearchPhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhase_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::LocalSearchPhaseParameters *arg5 = (operations_research::LocalSearchPhaseParameters *) 0 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  arg5 = *(operations_research::LocalSearchPhaseParameters **)&jarg5; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeLocalSearchPhase((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4,arg5);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhase_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::SequenceVar * > *arg2 = 0 ;
  operations_research::DecisionBuilder *arg3 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::LocalSearchPhaseParameters *arg4 = (operations_research::LocalSearchPhaseParameters *) 0 ;
  std::vector< operations_research::SequenceVar * > result2 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SequenceVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SequenceVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  arg3 = *(operations_research::DecisionBuilder **)&jarg3; 
  arg4 = *(operations_research::LocalSearchPhaseParameters **)&jarg4; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeLocalSearchPhase((std::vector< operations_research::SequenceVar * > const &)*arg2,arg3,arg4);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeDefaultSolutionPool(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::SolutionPool *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::SolutionPool *)(arg1)->MakeDefaultSolutionPool();
  *(operations_research::SolutionPool **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::LocalSearchOperator *arg3 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::LocalSearchOperator **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::LocalSearchOperator *arg3 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::RegularLimit *arg5 = (operations_research::RegularLimit *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::LocalSearchOperator **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  arg5 = *(operations_research::RegularLimit **)&jarg5; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4,arg5);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::LocalSearchOperator *arg3 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg4 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::RegularLimit *arg5 = (operations_research::RegularLimit *) 0 ;
  operations_research::LocalSearchFilterManager *arg6 = (operations_research::LocalSearchFilterManager *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::LocalSearchOperator **)&jarg3; 
  arg4 = *(operations_research::DecisionBuilder **)&jarg4; 
  arg5 = *(operations_research::RegularLimit **)&jarg5; 
  arg6 = *(operations_research::LocalSearchFilterManager **)&jarg6; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::SolutionPool *arg3 = (operations_research::SolutionPool *) 0 ;
  operations_research::LocalSearchOperator *arg4 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg5 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::SolutionPool **)&jarg3; 
  arg4 = *(operations_research::LocalSearchOperator **)&jarg4; 
  arg5 = *(operations_research::DecisionBuilder **)&jarg5; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4,arg5);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::SolutionPool *arg3 = (operations_research::SolutionPool *) 0 ;
  operations_research::LocalSearchOperator *arg4 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg5 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::RegularLimit *arg6 = (operations_research::RegularLimit *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::SolutionPool **)&jarg3; 
  arg4 = *(operations_research::LocalSearchOperator **)&jarg4; 
  arg5 = *(operations_research::DecisionBuilder **)&jarg5; 
  arg6 = *(operations_research::RegularLimit **)&jarg6; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4,arg5,arg6);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeLocalSearchPhaseParameters_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_, jlong jarg7, jobject jarg7_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::SolutionPool *arg3 = (operations_research::SolutionPool *) 0 ;
  operations_research::LocalSearchOperator *arg4 = (operations_research::LocalSearchOperator *) 0 ;
  operations_research::DecisionBuilder *arg5 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::RegularLimit *arg6 = (operations_research::RegularLimit *) 0 ;
  operations_research::LocalSearchFilterManager *arg7 = (operations_research::LocalSearchFilterManager *) 0 ;
  operations_research::LocalSearchPhaseParameters *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  (void)jarg6_;
  (void)jarg7_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::SolutionPool **)&jarg3; 
  arg4 = *(operations_research::LocalSearchOperator **)&jarg4; 
  arg5 = *(operations_research::DecisionBuilder **)&jarg5; 
  arg6 = *(operations_research::RegularLimit **)&jarg6; 
  arg7 = *(operations_research::LocalSearchFilterManager **)&jarg7; 
  result = (operations_research::LocalSearchPhaseParameters *)(arg1)->MakeLocalSearchPhaseParameters(arg2,arg3,arg4,arg5,arg6,arg7);
  *(operations_research::LocalSearchPhaseParameters **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeAcceptFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchFilter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::LocalSearchFilter *)(arg1)->MakeAcceptFilter();
  *(operations_research::LocalSearchFilter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeRejectFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchFilter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::LocalSearchFilter *)(arg1)->MakeRejectFilter();
  *(operations_research::LocalSearchFilter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeVariableDomainFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchFilter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::LocalSearchFilter *)(arg1)->MakeVariableDomainFilter();
  *(operations_research::LocalSearchFilter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumObjectiveFilter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  operations_research::Solver::IndexEvaluator2 arg3 ;
  operations_research::Solver::LocalSearchFilterBound arg4 ;
  std::vector< operations_research::IntVar * > result2 ;
  operations_research::IntVarLocalSearchFilter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  
  jclass jarg3_object_class = jenv->GetObjectClass(jarg3);
  if (nullptr == jarg3_object_class) return 0;
  jmethodID jarg3_method_id = jenv->GetMethodID(
    jarg3_object_class, "applyAsLong", "(JJ)J");
  assert(jarg3_method_id != nullptr);
  // jarg3 will be deleted once this function return.
  jobject jarg3_object = jenv->NewGlobalRef(jarg3);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg3_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg3_guard = std::make_shared<GlobalRefGuard>(jvm, jarg3_object);
  }
  arg3 = [jenv, jarg3_object, jarg3_method_id, jarg3_guard](long t,long u) -> long {
    return jenv->CallLongMethod(jarg3_object, jarg3_method_id, (jlong)t,(jlong)u);
  };
  
  arg4 = (operations_research::Solver::LocalSearchFilterBound)jarg4; 
  result = (operations_research::IntVarLocalSearchFilter *)(arg1)->MakeSumObjectiveFilter((std::vector< operations_research::IntVar * > const &)*arg2,arg3,arg4);
  *(operations_research::IntVarLocalSearchFilter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1makeSumObjectiveFilter_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jobjectArray jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< operations_research::IntVar * > *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  operations_research::Solver::IndexEvaluator3 arg4 ;
  operations_research::Solver::LocalSearchFilterBound arg5 ;
  std::vector< operations_research::IntVar * > result2 ;
  std::vector< operations_research::IntVar * > result3 ;
  operations_research::IntVarLocalSearchFilter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg2); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg2, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result2.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg2 = &result2;
  }
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return 0;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  
  jclass jarg4_object_class = jenv->GetObjectClass(jarg4);
  if (nullptr == jarg4_object_class) return 0;
  jmethodID jarg4_method_id = jenv->GetMethodID(
    jarg4_object_class, "applyAsLong", "(JJJ)J");
  assert(jarg4_method_id != nullptr);
  // jarg4 will be deleted once this function return.
  jobject jarg4_object = jenv->NewGlobalRef(jarg4);
  
  // Global JNI reference deleter
  std::shared_ptr<GlobalRefGuard> jarg4_guard;
  {
    JavaVM* jvm;
    jenv->GetJavaVM(&jvm);
    jarg4_guard = std::make_shared<GlobalRefGuard>(jvm, jarg4_object);
  }
  arg4 = [jenv, jarg4_object, jarg4_method_id, jarg4_guard](long t,long u,long v) -> long {
    return jenv->CallLongMethod(jarg4_object, jarg4_method_id, (jlong)t,(jlong)u,(jlong)v);
  };
  
  arg5 = (operations_research::Solver::LocalSearchFilterBound)jarg5; 
  result = (operations_research::IntVarLocalSearchFilter *)(arg1)->MakeSumObjectiveFilter((std::vector< operations_research::IntVar * > const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3,arg4,arg5);
  *(operations_research::IntVarLocalSearchFilter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1topPeriodicCheck(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->TopPeriodicCheck();
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1topProgressPercent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int)(arg1)->TopProgressPercent();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1pushState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->PushState();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1popState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->PopState();
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1searchDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int)((operations_research::Solver const *)arg1)->SearchDepth();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1searchLeftDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int)((operations_research::Solver const *)arg1)->SearchLeftDepth();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1solveDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int)((operations_research::Solver const *)arg1)->SolveDepth();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1rand64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int64_t arg2 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (int64_t)(arg1)->Rand64(arg2);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1rand32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int32_t arg2 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  result = (int32_t)(arg1)->Rand32(arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1reSeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  (arg1)->ReSeed(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1exportProfilingOverview(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->ExportProfilingOverview((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1localSearchProfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = ((operations_research::Solver const *)arg1)->LocalSearchProfile();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1currentlyInSolve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->CurrentlyInSolve();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1constraints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (int)((operations_research::Solver const *)arg1)->constraints();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ModelVisitor *arg2 = (operations_research::ModelVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::ModelVisitor **)&jarg2; 
  ((operations_research::Solver const *)arg1)->Accept(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1balancing_1decision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Decision *)((operations_research::Solver const *)arg1)->balancing_decision();
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1clear_1fail_1intercept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->clear_fail_intercept();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1SetUseFastLocalSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  (arg1)->SetUseFastLocalSearch(arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1UseFastLocalSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->UseFastLocalSearch();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1hasName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::PropagationBaseObject *arg2 = (operations_research::PropagationBaseObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::PropagationBaseObject **)&jarg2; 
  result = (bool)((operations_research::Solver const *)arg1)->HasName((operations_research::PropagationBaseObject const *)arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1registerDemon(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Demon *arg2 = (operations_research::Demon *) 0 ;
  operations_research::Demon *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::Demon **)&jarg2; 
  result = (operations_research::Demon *)(arg1)->RegisterDemon(arg2);
  *(operations_research::Demon **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1registerIntExpr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntExpr *arg2 = (operations_research::IntExpr *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntExpr **)&jarg2; 
  result = (operations_research::IntExpr *)(arg1)->RegisterIntExpr(arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1registerIntVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  result = (operations_research::IntVar *)(arg1)->RegisterIntVar(arg2);
  *(operations_research::IntVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1registerIntervalVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  operations_research::IntervalVar *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  result = (operations_research::IntervalVar *)(arg1)->RegisterIntervalVar(arg2);
  *(operations_research::IntervalVar **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1cache(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::ModelCache *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::ModelCache *)((operations_research::Solver const *)arg1)->Cache();
  *(operations_research::ModelCache **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1instrumentsDemons(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->InstrumentsDemons();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1isProfilingEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->IsProfilingEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1isLocalSearchProfilingEnabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->IsLocalSearchProfilingEnabled();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1instrumentsVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->InstrumentsVariables();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1nameAllVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (bool)((operations_research::Solver const *)arg1)->NameAllVariables();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1model_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = ((operations_research::Solver const *)arg1)->model_name();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1getPropagationMonitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::PropagationMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::PropagationMonitor *)((operations_research::Solver const *)arg1)->GetPropagationMonitor();
  *(operations_research::PropagationMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1addPropagationMonitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::PropagationMonitor *arg2 = (operations_research::PropagationMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::PropagationMonitor **)&jarg2; 
  (arg1)->AddPropagationMonitor(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1getLocalSearchMonitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchMonitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::LocalSearchMonitor *)((operations_research::Solver const *)arg1)->GetLocalSearchMonitor();
  *(operations_research::LocalSearchMonitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1addLocalSearchMonitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::LocalSearchMonitor *arg2 = (operations_research::LocalSearchMonitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::LocalSearchMonitor **)&jarg2; 
  (arg1)->AddLocalSearchMonitor(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1GetOrCreateLocalSearchState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::Assignment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::Assignment *)(arg1)->GetOrCreateLocalSearchState();
  *(operations_research::Assignment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1ClearLocalSearchState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->ClearLocalSearchState();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tmpVector_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  
  if(jarg2) {
    const int size = jenv->GetArrayLength(jarg2);
    (&arg2)->clear();
    (&arg2)->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg2, NULL);
    for (int i = 0; i < size; ++i) {
      (&arg2)->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg2, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return ;
  }
  
  if (arg1) (arg1)->tmp_vector_ = arg2;
}


SWIGEXPORT jlongArray JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1tmpVector_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  std::vector< int64_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result =  ((arg1)->tmp_vector_);
  
  const std::vector<int64_t>& vec = result;
  jresult = jenv->NewLongArray(vec.size());
  jenv->SetLongArrayRegion(jresult, 0, vec.size(), reinterpret_cast<const jlong*>(vec.data()));
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1castExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  result = (operations_research::IntExpr *)((operations_research::Solver const *)arg1)->CastExpression((operations_research::IntVar const *)arg2);
  *(operations_research::IntExpr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1finishCurrentSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->FinishCurrentSearch();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1restartCurrentSearch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->RestartCurrentSearch();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1shouldFail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->ShouldFail();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1checkFail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  (arg1)->CheckFail();
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Solver_1MakeProfiledDecisionBuilderWrapper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) 0 ;
  operations_research::DecisionBuilder *arg2 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  arg2 = *(operations_research::DecisionBuilder **)&jarg2; 
  result = (operations_research::DecisionBuilder *)(arg1)->MakeProfiledDecisionBuilderWrapper(arg2);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_zero(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int64_t)operations_research::Zero();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_One(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  result = (int64_t)operations_research::One();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1BaseObject(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::BaseObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::BaseObject *)new operations_research::BaseObject();
  *(operations_research::BaseObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1BaseObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::BaseObject *arg1 = (operations_research::BaseObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::BaseObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_BaseObject_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::BaseObject *arg1 = (operations_research::BaseObject *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::BaseObject **)&jarg1; 
  result = ((operations_research::BaseObject const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1PropagationBaseObject(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::Solver *arg1 = (operations_research::Solver *) (operations_research::Solver *)0 ;
  operations_research::PropagationBaseObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Solver **)&jarg1; 
  result = (operations_research::PropagationBaseObject *)new operations_research::PropagationBaseObject(arg1);
  *(operations_research::PropagationBaseObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1PropagationBaseObject(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  result = ((operations_research::PropagationBaseObject const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1solver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  operations_research::Solver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  result = (operations_research::Solver *)((operations_research::PropagationBaseObject const *)arg1)->solver();
  *(operations_research::Solver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1freezeQueue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  (arg1)->FreezeQueue();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1unfreezeQueue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  (arg1)->UnfreezeQueue();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1enqueueDelayedDemon(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  operations_research::Demon *arg2 = (operations_research::Demon *) (operations_research::Demon *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  arg2 = *(operations_research::Demon **)&jarg2; 
  (arg1)->EnqueueDelayedDemon(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1enqueueVar(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  operations_research::Demon *arg2 = (operations_research::Demon *) (operations_research::Demon *)0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  arg2 = *(operations_research::Demon **)&jarg2; 
  (arg1)->EnqueueVar(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1reset_1action_1on_1fail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  (arg1)->reset_action_on_fail();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1set_1variable_1to_1clean_1on_1fail(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  (arg1)->set_variable_to_clean_on_fail(arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  result = ((operations_research::PropagationBaseObject const *)arg1)->name();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->set_name((std::string const &)*arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1hasName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  result = (bool)((operations_research::PropagationBaseObject const *)arg1)->HasName();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_PropagationBaseObject_1baseName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::PropagationBaseObject *arg1 = (operations_research::PropagationBaseObject *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::PropagationBaseObject **)&jarg1; 
  result = ((operations_research::PropagationBaseObject const *)arg1)->BaseName();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1Decision(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::Decision *)new SwigDirector_Decision(jenv);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1Decision(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::Decision **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  (arg1)->Apply(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1refute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  (arg1)->Refute(arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  result = ((operations_research::Decision const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1toStringSwigExplicitDecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  result = ((operations_research::Decision const *)arg1)->operations_research::Decision::DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  operations_research::DecisionVisitor *arg2 = (operations_research::DecisionVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  arg2 = *(operations_research::DecisionVisitor **)&jarg2; 
  ((operations_research::Decision const *)arg1)->Accept(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1acceptSwigExplicitDecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Decision *arg1 = (operations_research::Decision *) 0 ;
  operations_research::DecisionVisitor *arg2 = (operations_research::DecisionVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Decision **)&jarg1; 
  arg2 = *(operations_research::DecisionVisitor **)&jarg2; 
  ((operations_research::Decision const *)arg1)->operations_research::Decision::Accept(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  operations_research::Decision *obj = *((operations_research::Decision **)&objarg);
  (void)jcls;
  SwigDirector_Decision *director = static_cast<SwigDirector_Decision *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Decision_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  operations_research::Decision *obj = *((operations_research::Decision **)&objarg);
  SwigDirector_Decision *director = dynamic_cast<SwigDirector_Decision *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1DecisionVisitor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::DecisionVisitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DecisionVisitor *)new SwigDirector_DecisionVisitor(jenv);
  *(operations_research::DecisionVisitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1DecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitSetVariableValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->VisitSetVariableValue(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitSetVariableValueSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->operations_research::DecisionVisitor::VisitSetVariableValue(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitSplitVariableDomain(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jboolean jarg4) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->VisitSplitVariableDomain(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitSplitVariableDomainSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jboolean jarg4) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  int64_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  (arg1)->operations_research::DecisionVisitor::VisitSplitVariableDomain(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitScheduleOrPostpone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->VisitScheduleOrPostpone(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitScheduleOrPostponeSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->operations_research::DecisionVisitor::VisitScheduleOrPostpone(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitScheduleOrExpedite(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->VisitScheduleOrExpedite(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitScheduleOrExpediteSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  arg3 = (int64_t)jarg3; 
  (arg1)->operations_research::DecisionVisitor::VisitScheduleOrExpedite(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitRankFirstInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->VisitRankFirstInterval(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitRankFirstIntervalSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->operations_research::DecisionVisitor::VisitRankFirstInterval(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitRankLastInterval(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->VisitRankLastInterval(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitRankLastIntervalSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  arg3 = (int)jarg3; 
  (arg1)->operations_research::DecisionVisitor::VisitRankLastInterval(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitUnknownDecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  (arg1)->VisitUnknownDecision();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1visitUnknownDecisionSwigExplicitDecisionVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_research::DecisionVisitor *arg1 = (operations_research::DecisionVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionVisitor **)&jarg1; 
  (arg1)->operations_research::DecisionVisitor::VisitUnknownDecision();
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  operations_research::DecisionVisitor *obj = *((operations_research::DecisionVisitor **)&objarg);
  (void)jcls;
  SwigDirector_DecisionVisitor *director = static_cast<SwigDirector_DecisionVisitor *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionVisitor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  operations_research::DecisionVisitor *obj = *((operations_research::DecisionVisitor **)&objarg);
  SwigDirector_DecisionVisitor *director = dynamic_cast<SwigDirector_DecisionVisitor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1DecisionBuilder(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::DecisionBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::DecisionBuilder *)new SwigDirector_DecisionBuilder(jenv);
  *(operations_research::DecisionBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1DecisionBuilder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1nextWrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  operations_research::Decision *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  result = (operations_research::Decision *)(arg1)->Next(arg2);
  *(operations_research::Decision **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  result = ((operations_research::DecisionBuilder const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1toStringSwigExplicitDecisionBuilder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  result = ((operations_research::DecisionBuilder const *)arg1)->operations_research::DecisionBuilder::DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1set_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->set_name((std::string const &)*arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::DecisionBuilder *arg1 = (operations_research::DecisionBuilder *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::DecisionBuilder **)&jarg1; 
  result = ((operations_research::DecisionBuilder const *)arg1)->GetName();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  operations_research::DecisionBuilder *obj = *((operations_research::DecisionBuilder **)&objarg);
  (void)jcls;
  SwigDirector_DecisionBuilder *director = static_cast<SwigDirector_DecisionBuilder *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_DecisionBuilder_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  operations_research::DecisionBuilder *obj = *((operations_research::DecisionBuilder **)&objarg);
  SwigDirector_DecisionBuilder *director = dynamic_cast<SwigDirector_DecisionBuilder *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1Demon(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::Demon **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Demon_1run(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Demon **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  (arg1)->Run(arg2);
}


SWIGEXPORT jint JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Demon_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  operations_research::Solver::DemonPriority result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Demon **)&jarg1; 
  result = (operations_research::Solver::DemonPriority)((operations_research::Demon const *)arg1)->priority();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Demon_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::Demon **)&jarg1; 
  result = ((operations_research::Demon const *)arg1)->DebugString();
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Demon_1inhibit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Demon **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  (arg1)->inhibit(arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Demon_1desinhibit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::Demon *arg1 = (operations_research::Demon *) 0 ;
  operations_research::Solver *arg2 = (operations_research::Solver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::Demon **)&jarg1; 
  arg2 = *(operations_research::Solver **)&jarg2; 
  (arg1)->desinhibit(arg2);
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAbs_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAbs;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAbsEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAbsEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAllDifferent_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAllDifferent;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAllowedAssignments_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAllowedAssignments;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAtMost_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAtMost;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIndexOf_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIndexOf;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kBetween_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kBetween;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kConditionalExpr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kConditionalExpr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCircuit_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCircuit;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kConvexPiecewise_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kConvexPiecewise;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCountEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCountEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCover_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCover;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCumulative_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCumulative;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDeviation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDeviation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDifference_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDifference;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDisjunctive_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDisjunctive;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDistribute_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDistribute;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDivide_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDivide;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDurationExpr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDurationExpr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kElement_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kElement;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLightElementEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLightElementEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kElementEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kElementEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEndExpr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEndExpr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEquality_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEquality;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kFalseConstraint_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kFalseConstraint;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kGlobalCardinality_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kGlobalCardinality;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kGreater_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kGreater;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kGreaterOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kGreaterOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntegerVariable_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntegerVariable;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalBinaryRelation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalBinaryRelation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalDisjunction_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalDisjunction;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalUnaryRelation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalUnaryRelation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalVariable_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalVariable;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kInversePermutation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kInversePermutation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsBetween_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsBetween;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsDifferent_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsDifferent;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsGreater_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsGreater;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsGreaterOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsGreaterOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsLess_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsLess;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsLessOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsLessOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIsMember_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIsMember;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLess_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLess;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLessOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLessOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLexLess_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLexLess;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLinkExprVar_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLinkExprVar;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMapDomain_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMapDomain;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMax_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMax;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMaxEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMaxEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMember_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMember;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMin_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMin;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMinEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMinEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kModulo_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kModulo;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNoCycle_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNoCycle;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNonEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNonEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNotBetween_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNotBetween;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNotMember_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNotMember;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNullIntersect_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNullIntersect;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kOpposite_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kOpposite;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPack_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPack;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPathCumul_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPathCumul;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDelayedPathCumul_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDelayedPathCumul;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPerformedExpr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPerformedExpr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPower_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPower;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kProduct_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kProduct;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kScalProd_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kScalProd;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kScalProdEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kScalProdEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kScalProdGreaterOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kScalProdGreaterOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kScalProdLessOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kScalProdLessOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSemiContinuous_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSemiContinuous;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSequenceVariable_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSequenceVariable;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSortingConstraint_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSortingConstraint;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSquare_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSquare;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartExpr_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartExpr;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSum_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSum;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSumEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSumEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSumGreaterOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSumGreaterOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSumLessOrEqual_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSumLessOrEqual;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTrace_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTrace;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTransition_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTransition;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTrueConstraint_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTrueConstraint;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVarBoundWatcher_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVarBoundWatcher;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVarValueWatcher_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVarValueWatcher;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCountAssignedItemsExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCountAssignedItemsExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCountUsedBinsExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCountUsedBinsExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kInt64ToBoolExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kInt64ToBoolExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kInt64ToInt64Extension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kInt64ToInt64Extension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kObjectiveExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kObjectiveExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSearchLimitExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSearchLimitExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kUsageEqualVariableExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kUsageEqualVariableExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kUsageLessConstantExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kUsageLessConstantExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVariableGroupExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVariableGroupExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVariableUsageLessConstantExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVariableUsageLessConstantExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kWeightedSumOfAssignedEqualVariableExtension_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kWeightedSumOfAssignedEqualVariableExtension;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kActiveArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kActiveArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kAssumePathsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kAssumePathsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kBranchesLimitArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kBranchesLimitArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCapacityArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCapacityArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCardsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCardsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCoefficientsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCoefficientsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCountArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCountArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCumulativeArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCumulativeArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kCumulsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kCumulsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDemandsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDemandsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDurationMaxArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDurationMaxArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDurationMinArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDurationMinArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEarlyCostArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEarlyCostArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEarlyDateArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEarlyDateArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEndMaxArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEndMaxArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEndMinArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEndMinArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEndsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEndsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kExpressionArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kExpressionArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kFailuresLimitArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kFailuresLimitArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kFinalStatesArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kFinalStatesArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kFixedChargeArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kFixedChargeArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIndex2Argument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIndex2Argument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIndexArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIndexArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kInitialState_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kInitialState;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kIntervalsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kIntervalsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLateCostArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLateCostArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLateDateArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLateDateArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kLeftArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kLeftArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMaxArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMaxArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMaximizeArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMaximizeArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMinArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMinArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kModuloArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kModuloArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kNextsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kNextsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kOptionalArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kOptionalArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPartialArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPartialArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPositionXArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPositionXArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kPositionYArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kPositionYArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kRangeArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kRangeArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kRelationArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kRelationArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kRightArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kRightArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSequenceArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSequenceArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSequencesArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSequencesArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSizeArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSizeArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSizeXArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSizeXArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSizeYArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSizeYArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSmartTimeCheckArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSmartTimeCheckArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSolutionLimitArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSolutionLimitArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartMaxArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartMaxArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartMinArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartMinArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStepArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStepArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTargetArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTargetArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTimeLimitArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTimeLimitArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTransitsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTransitsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTuplesArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTuplesArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kValueArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kValueArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kValuesArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kValuesArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVariableArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVariableArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kVarsArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kVarsArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kEvaluatorArgument_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kEvaluatorArgument;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kMirrorOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kMirrorOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kRelaxedMaxOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kRelaxedMaxOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kRelaxedMinOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kRelaxedMinOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kSumOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kSumOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kDifferenceOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kDifferenceOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kProductOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kProductOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartSyncOnStartOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartSyncOnStartOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kStartSyncOnEndOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kStartSyncOnEndOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1kTraceOperation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)operations_research::ModelVisitor::kTraceOperation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1ModelVisitor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1beginVisitModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->BeginVisitModel((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1endVisitModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->EndVisitModel((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1beginVisitConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::Constraint *arg3 = (operations_research::Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::Constraint **)&jarg3; 
  (arg1)->BeginVisitConstraint((std::string const &)*arg2,(operations_research::Constraint const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1endVisitConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::Constraint *arg3 = (operations_research::Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::Constraint **)&jarg3; 
  (arg1)->EndVisitConstraint((std::string const &)*arg2,(operations_research::Constraint const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1beginVisitExtension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->BeginVisitExtension((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1endVisitExtension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  (arg1)->EndVisitExtension((std::string const &)*arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1beginVisitIntegerExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  (arg1)->BeginVisitIntegerExpression((std::string const &)*arg2,(operations_research::IntExpr const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1endVisitIntegerExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  (arg1)->EndVisitIntegerExpression((std::string const &)*arg2,(operations_research::IntExpr const *)arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerVariable_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  (arg1)->VisitIntegerVariable((operations_research::IntVar const *)arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerVariable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  operations_research::IntVar *arg2 = (operations_research::IntVar *) 0 ;
  std::string *arg3 = 0 ;
  int64_t arg4 ;
  operations_research::IntVar *arg5 = (operations_research::IntVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  arg2 = *(operations_research::IntVar **)&jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = (int64_t)jarg4; 
  arg5 = *(operations_research::IntVar **)&jarg5; 
  (arg1)->VisitIntegerVariable((operations_research::IntVar const *)arg2,(std::string const &)*arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntervalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  operations_research::IntervalVar *arg2 = (operations_research::IntervalVar *) 0 ;
  std::string *arg3 = 0 ;
  int64_t arg4 ;
  operations_research::IntervalVar *arg5 = (operations_research::IntervalVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg5_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  arg2 = *(operations_research::IntervalVar **)&jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = (int64_t)jarg4; 
  arg5 = *(operations_research::IntervalVar **)&jarg5; 
  (arg1)->VisitIntervalVariable((operations_research::IntervalVar const *)arg2,(std::string const &)*arg3,arg4,arg5);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitSequenceVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  operations_research::SequenceVar *arg2 = (operations_research::SequenceVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  arg2 = *(operations_research::SequenceVar **)&jarg2; 
  (arg1)->VisitSequenceVariable((operations_research::SequenceVar const *)arg2);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (int64_t)jarg3; 
  (arg1)->VisitIntegerArgument((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerArrayArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlongArray jarg3) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  
  if(jarg3) {
    arg3 = new std::vector<int64_t>;
    const int size = jenv->GetArrayLength(jarg3);
    arg3->reserve(size);
    jlong *values = jenv->GetLongArrayElements((jlongArray)jarg3, NULL);
    for (int i = 0; i < size; ++i) {
      arg3->emplace_back(values[i]);
    }
    jenv->ReleaseLongArrayElements((jlongArray)jarg3, values, JNI_ABORT);
  }
  else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null table");
    return ;
  }
  
  (arg1)->VisitIntegerArrayArgument((std::string const &)*arg2,(std::vector< int64_t > const &)*arg3);
  {
    delete arg3;
  }
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerMatrixArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntTupleSet *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::IntTupleSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "operations_research::IntTupleSet const & is null");
    return ;
  } 
  (arg1)->VisitIntegerMatrixArgument((std::string const &)*arg2,(operations_research::IntTupleSet const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerExpressionArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntExpr *arg3 = (operations_research::IntExpr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::IntExpr **)&jarg3; 
  (arg1)->VisitIntegerExpressionArgument((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntegerVariableArrayArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobjectArray jarg3) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< operations_research::IntVar * > *arg3 = 0 ;
  std::vector< operations_research::IntVar * > result3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return ;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  (arg1)->VisitIntegerVariableArrayArgument((std::string const &)*arg2,(std::vector< operations_research::IntVar * > const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntervalArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::IntervalVar *arg3 = (operations_research::IntervalVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::IntervalVar **)&jarg3; 
  (arg1)->VisitIntervalArgument((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitIntervalArrayArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobjectArray jarg3) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< operations_research::IntervalVar * > *arg3 = 0 ;
  std::vector< operations_research::IntervalVar * > result3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""IntervalVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return ;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::IntervalVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  (arg1)->VisitIntervalArrayArgument((std::string const &)*arg2,(std::vector< operations_research::IntervalVar * > const &)*arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitSequenceArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  operations_research::SequenceVar *arg3 = (operations_research::SequenceVar *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(operations_research::SequenceVar **)&jarg3; 
  (arg1)->VisitSequenceArgument((std::string const &)*arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_ModelVisitor_1visitSequenceArrayArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jobjectArray jarg3) {
  operations_research::ModelVisitor *arg1 = (operations_research::ModelVisitor *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< operations_research::SequenceVar * > *arg3 = 0 ;
  std::vector< operations_research::SequenceVar * > result3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(operations_research::ModelVisitor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    std::string java_class_path ="com/google/ortools/constraintsolver" "/""SequenceVar";
    jclass object_class = jenv->FindClass(java_class_path.c_str());
    if (nullptr == object_class)
    return ;
    jmethodID method_id =
    jenv->GetStaticMethodID(
      object_class, "getCPtr",
      std::string("(L" + java_class_path + ";)J").c_str());
    assert(method_id != nullptr);
    for (int i = 0; i < jenv->GetArrayLength(jarg3); i++) {
      jobject elem = jenv->GetObjectArrayElement(jarg3, i);
      jlong ptr_value = jenv->CallStaticLongMethod(object_class, method_id, elem);
      result3.push_back(/*@SWIG:/home/mizux/work/main/ortools/util/java/vector.i,285,REINTERPRET_CAST@*/
        reinterpret_cast<operations_research::SequenceVar*>(ptr_value)
        /*@SWIG@*/);
    }
    arg3 = &result3;
  }
  (arg1)->VisitSequenceArrayArgument((std::string const &)*arg2,(std::vector< operations_research::SequenceVar * > const &)*arg3);
}


SWIGEXPORT jlong JNICALL Java_com_google_ortools_constraintsolver_mainJNI_new_1ModelVisitor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  operations_research::ModelVisitor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (operations_research::ModelVisitor *)new operations_research::ModelVisitor();
  *(operations_research::ModelVisitor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_delete_1Constraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  operations_research::Constraint *arg1 = (operations_research::Constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(operations_research::Constraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_google_ortools_constraintsolver_mainJNI_Constraint_1post(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  operations_