/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.google.ortools.linearsolver;

import java.lang.reflect.*;

/**
 *  A class to express a linear objective.
 */
public class MPObjective {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected MPObjective(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MPObjective obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MPObjective obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        mainJNI.delete_MPObjective(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   *  Clears the offset, all variables and coefficients, and the optimization<br>
   * direction.
   */
  public void clear() {
    mainJNI.MPObjective_clear(swigCPtr, this);
  }

  /**
   * Sets the coefficient of the variable in the objective.<br>
   * <br>
   * If the variable does not belong to the solver, the function just returns,<br>
   * or crashes in non-opt mode.
   */
  public void setCoefficient(MPVariable var, double coeff) {
    mainJNI.MPObjective_setCoefficient(swigCPtr, this, MPVariable.getCPtr(var), var, coeff);
  }

  /**
   *  Gets the coefficient of a given variable in the objective<br>
   * <br>
   * It returns 0 if the variable does not appear in the objective).
   */
  public double getCoefficient(MPVariable var) {
    return mainJNI.MPObjective_getCoefficient(swigCPtr, this, MPVariable.getCPtr(var), var);
  }

  /**
   *  Sets the constant term in the objective.
   */
  public void setOffset(double value) {
    mainJNI.MPObjective_setOffset(swigCPtr, this, value);
  }

  /**
   *  Gets the constant term in the objective.
   */
  public double offset() {
    return mainJNI.MPObjective_offset(swigCPtr, this);
  }

  /**
   *  Sets the optimization direction (maximize: true or minimize: false).
   */
  public void setOptimizationDirection(boolean maximize) {
    mainJNI.MPObjective_setOptimizationDirection(swigCPtr, this, maximize);
  }

  /**
   *  Sets the optimization direction to minimize.
   */
  public void setMinimization() {
    mainJNI.MPObjective_setMinimization(swigCPtr, this);
  }

  /**
   *  Sets the optimization direction to maximize.
   */
  public void setMaximization() {
    mainJNI.MPObjective_setMaximization(swigCPtr, this);
  }

  /**
   *  Is the optimization direction set to maximize?
   */
  public boolean maximization() {
    return mainJNI.MPObjective_maximization(swigCPtr, this);
  }

  /**
   *  Is the optimization direction set to minimize?
   */
  public boolean minimization() {
    return mainJNI.MPObjective_minimization(swigCPtr, this);
  }

  /**
   * Returns the objective value of the best solution found so far.<br>
   * <br>
   * It is the optimal objective value if the problem has been solved to<br>
   * optimality.<br>
   * <br>
   * Note: the objective value may be slightly different than what you could<br>
   * compute yourself using <code>MPVariable::solution_value();</code> please use the<br>
   * --verify_solution flag to gain confidence about the numerical stability of<br>
   * your solution.
   */
  public double value() {
    return mainJNI.MPObjective_value(swigCPtr, this);
  }

  /**
   * Returns the best objective bound.<br>
   * <br>
   * In case of minimization, it is a lower bound on the objective value of the<br>
   * optimal integer solution. Only available for discrete problems.
   */
  public double bestBound() {
    return mainJNI.MPObjective_bestBound(swigCPtr, this);
  }

}
