// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/linear_solver/linear_solver.proto

package com.google.ortools.linearsolver;

/**
 * <pre>
 * Next id: 12.
 * </pre>
 *
 * Protobuf type {@code operations_research.MPSolutionResponse}
 */
public final class MPSolutionResponse extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.MPSolutionResponse)
    MPSolutionResponseOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MPSolutionResponse.newBuilder() to construct.
  private MPSolutionResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MPSolutionResponse() {
    status_ = 99;
    statusStr_ = "";
    variableValue_ = emptyDoubleList();
    solverSpecificInfo_ = com.google.protobuf.ByteString.EMPTY;
    dualValue_ = emptyDoubleList();
    reducedCost_ = emptyDoubleList();
    additionalSolutions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new MPSolutionResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSolutionResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.linearsolver.MPSolutionResponse.class, com.google.ortools.linearsolver.MPSolutionResponse.Builder.class);
  }

  private int bitField0_;
  public static final int STATUS_FIELD_NUMBER = 1;
  private int status_ = 99;
  /**
   * <pre>
   * Result of the optimization.
   * </pre>
   *
   * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
   * @return Whether the status field is set.
   */
  @java.lang.Override public boolean hasStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Result of the optimization.
   * </pre>
   *
   * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ortools.linearsolver.MPSolverResponseStatus getStatus() {
    com.google.ortools.linearsolver.MPSolverResponseStatus result = com.google.ortools.linearsolver.MPSolverResponseStatus.forNumber(status_);
    return result == null ? com.google.ortools.linearsolver.MPSolverResponseStatus.MPSOLVER_UNKNOWN_STATUS : result;
  }

  public static final int STATUS_STR_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private volatile java.lang.Object statusStr_ = "";
  /**
   * <pre>
   * Human-readable string giving more details about the status. For example,
   * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
   * why the model is invalid.
   * This isn't always filled: don't depend on its value or even its presence.
   * </pre>
   *
   * <code>optional string status_str = 7;</code>
   * @return Whether the statusStr field is set.
   */
  @java.lang.Override
  public boolean hasStatusStr() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Human-readable string giving more details about the status. For example,
   * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
   * why the model is invalid.
   * This isn't always filled: don't depend on its value or even its presence.
   * </pre>
   *
   * <code>optional string status_str = 7;</code>
   * @return The statusStr.
   */
  @java.lang.Override
  public java.lang.String getStatusStr() {
    java.lang.Object ref = statusStr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        statusStr_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Human-readable string giving more details about the status. For example,
   * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
   * why the model is invalid.
   * This isn't always filled: don't depend on its value or even its presence.
   * </pre>
   *
   * <code>optional string status_str = 7;</code>
   * @return The bytes for statusStr.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStatusStrBytes() {
    java.lang.Object ref = statusStr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      statusStr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBJECTIVE_VALUE_FIELD_NUMBER = 2;
  private double objectiveValue_ = 0D;
  /**
   * <pre>
   * Objective value corresponding to the "variable_value" below, taking into
   * account the source "objective_offset" and "objective_coefficient".
   * This is set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>optional double objective_value = 2;</code>
   * @return Whether the objectiveValue field is set.
   */
  @java.lang.Override
  public boolean hasObjectiveValue() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Objective value corresponding to the "variable_value" below, taking into
   * account the source "objective_offset" and "objective_coefficient".
   * This is set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>optional double objective_value = 2;</code>
   * @return The objectiveValue.
   */
  @java.lang.Override
  public double getObjectiveValue() {
    return objectiveValue_;
  }

  public static final int BEST_OBJECTIVE_BOUND_FIELD_NUMBER = 5;
  private double bestObjectiveBound_ = 0D;
  /**
   * <pre>
   * This field is only filled for MIP problems. For a minimization problem,
   * this is a lower bound on the optimal objective value. For a maximization
   * problem, it is an upper bound. It is only filled if the status is OPTIMAL
   * or FEASIBLE. In the former case, best_objective_bound should be equal to
   * objective_value (modulo numerical errors).
   * </pre>
   *
   * <code>optional double best_objective_bound = 5;</code>
   * @return Whether the bestObjectiveBound field is set.
   */
  @java.lang.Override
  public boolean hasBestObjectiveBound() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * This field is only filled for MIP problems. For a minimization problem,
   * this is a lower bound on the optimal objective value. For a maximization
   * problem, it is an upper bound. It is only filled if the status is OPTIMAL
   * or FEASIBLE. In the former case, best_objective_bound should be equal to
   * objective_value (modulo numerical errors).
   * </pre>
   *
   * <code>optional double best_objective_bound = 5;</code>
   * @return The bestObjectiveBound.
   */
  @java.lang.Override
  public double getBestObjectiveBound() {
    return bestObjectiveBound_;
  }

  public static final int VARIABLE_VALUE_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList variableValue_;
  /**
   * <pre>
   * Variable values in the same order as the MPModelProto::variable field.
   * This is a dense representation. These are set iff 'status' is OPTIMAL or
   * FEASIBLE.
   * </pre>
   *
   * <code>repeated double variable_value = 3 [packed = true];</code>
   * @return A list containing the variableValue.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getVariableValueList() {
    return variableValue_;
  }
  /**
   * <pre>
   * Variable values in the same order as the MPModelProto::variable field.
   * This is a dense representation. These are set iff 'status' is OPTIMAL or
   * FEASIBLE.
   * </pre>
   *
   * <code>repeated double variable_value = 3 [packed = true];</code>
   * @return The count of variableValue.
   */
  public int getVariableValueCount() {
    return variableValue_.size();
  }
  /**
   * <pre>
   * Variable values in the same order as the MPModelProto::variable field.
   * This is a dense representation. These are set iff 'status' is OPTIMAL or
   * FEASIBLE.
   * </pre>
   *
   * <code>repeated double variable_value = 3 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The variableValue at the given index.
   */
  public double getVariableValue(int index) {
    return variableValue_.getDouble(index);
  }
  private int variableValueMemoizedSerializedSize = -1;

  public static final int SOLVE_INFO_FIELD_NUMBER = 10;
  private com.google.ortools.linearsolver.MPSolveInfo solveInfo_;
  /**
   * <pre>
   * Contains extra information about the solve, populated if the underlying
   * solver (and its interface) supports it. As of 2021/07/19 this is supported
   * by SCIP and Gurobi proto solves.
   * </pre>
   *
   * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
   * @return Whether the solveInfo field is set.
   */
  @java.lang.Override
  public boolean hasSolveInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Contains extra information about the solve, populated if the underlying
   * solver (and its interface) supports it. As of 2021/07/19 this is supported
   * by SCIP and Gurobi proto solves.
   * </pre>
   *
   * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
   * @return The solveInfo.
   */
  @java.lang.Override
  public com.google.ortools.linearsolver.MPSolveInfo getSolveInfo() {
    return solveInfo_ == null ? com.google.ortools.linearsolver.MPSolveInfo.getDefaultInstance() : solveInfo_;
  }
  /**
   * <pre>
   * Contains extra information about the solve, populated if the underlying
   * solver (and its interface) supports it. As of 2021/07/19 this is supported
   * by SCIP and Gurobi proto solves.
   * </pre>
   *
   * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
   */
  @java.lang.Override
  public com.google.ortools.linearsolver.MPSolveInfoOrBuilder getSolveInfoOrBuilder() {
    return solveInfo_ == null ? com.google.ortools.linearsolver.MPSolveInfo.getDefaultInstance() : solveInfo_;
  }

  public static final int SOLVER_SPECIFIC_INFO_FIELD_NUMBER = 11;
  private com.google.protobuf.ByteString solverSpecificInfo_ = com.google.protobuf.ByteString.EMPTY;
  /**
   * <pre>
   * Opaque solver-specific information.
   * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
   * </pre>
   *
   * <code>optional bytes solver_specific_info = 11;</code>
   * @return Whether the solverSpecificInfo field is set.
   */
  @java.lang.Override
  public boolean hasSolverSpecificInfo() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Opaque solver-specific information.
   * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
   * </pre>
   *
   * <code>optional bytes solver_specific_info = 11;</code>
   * @return The solverSpecificInfo.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSolverSpecificInfo() {
    return solverSpecificInfo_;
  }

  public static final int DUAL_VALUE_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList dualValue_;
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the dual variables values in the same order as the
   * MPModelProto::constraint field. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if
   * it is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double dual_value = 4 [packed = true];</code>
   * @return A list containing the dualValue.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getDualValueList() {
    return dualValue_;
  }
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the dual variables values in the same order as the
   * MPModelProto::constraint field. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if
   * it is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double dual_value = 4 [packed = true];</code>
   * @return The count of dualValue.
   */
  public int getDualValueCount() {
    return dualValue_.size();
  }
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the dual variables values in the same order as the
   * MPModelProto::constraint field. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if
   * it is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double dual_value = 4 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The dualValue at the given index.
   */
  public double getDualValue(int index) {
    return dualValue_.getDouble(index);
  }
  private int dualValueMemoizedSerializedSize = -1;

  public static final int REDUCED_COST_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList reducedCost_;
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the reduced cost of the variables in the same order as the
   * MPModelProto::variable. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if it
   * is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double reduced_cost = 6 [packed = true];</code>
   * @return A list containing the reducedCost.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double>
      getReducedCostList() {
    return reducedCost_;
  }
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the reduced cost of the variables in the same order as the
   * MPModelProto::variable. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if it
   * is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double reduced_cost = 6 [packed = true];</code>
   * @return The count of reducedCost.
   */
  public int getReducedCostCount() {
    return reducedCost_.size();
  }
  /**
   * <pre>
   * [Advanced usage.]
   * Values of the reduced cost of the variables in the same order as the
   * MPModelProto::variable. This is a dense representation.
   * These are not set if the problem was solved with a MIP solver (even if it
   * is actually a linear program).
   * These are set iff 'status' is OPTIMAL or FEASIBLE.
   * </pre>
   *
   * <code>repeated double reduced_cost = 6 [packed = true];</code>
   * @param index The index of the element to return.
   * @return The reducedCost at the given index.
   */
  public double getReducedCost(int index) {
    return reducedCost_.getDouble(index);
  }
  private int reducedCostMemoizedSerializedSize = -1;

  public static final int ADDITIONAL_SOLUTIONS_FIELD_NUMBER = 8;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ortools.linearsolver.MPSolution> additionalSolutions_;
  /**
   * <pre>
   * [Advanced usage.]
   * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
   * number of additional solutions may be populated here, if available. These
   * additional solutions are different than the main solution described by the
   * above fields `objective_value` and `variable_value`.
   * </pre>
   *
   * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.linearsolver.MPSolution> getAdditionalSolutionsList() {
    return additionalSolutions_;
  }
  /**
   * <pre>
   * [Advanced usage.]
   * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
   * number of additional solutions may be populated here, if available. These
   * additional solutions are different than the main solution described by the
   * above fields `objective_value` and `variable_value`.
   * </pre>
   *
   * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ortools.linearsolver.MPSolutionOrBuilder> 
      getAdditionalSolutionsOrBuilderList() {
    return additionalSolutions_;
  }
  /**
   * <pre>
   * [Advanced usage.]
   * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
   * number of additional solutions may be populated here, if available. These
   * additional solutions are different than the main solution described by the
   * above fields `objective_value` and `variable_value`.
   * </pre>
   *
   * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
   */
  @java.lang.Override
  public int getAdditionalSolutionsCount() {
    return additionalSolutions_.size();
  }
  /**
   * <pre>
   * [Advanced usage.]
   * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
   * number of additional solutions may be populated here, if available. These
   * additional solutions are different than the main solution described by the
   * above fields `objective_value` and `variable_value`.
   * </pre>
   *
   * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
   */
  @java.lang.Override
  public com.google.ortools.linearsolver.MPSolution getAdditionalSolutions(int index) {
    return additionalSolutions_.get(index);
  }
  /**
   * <pre>
   * [Advanced usage.]
   * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
   * number of additional solutions may be populated here, if available. These
   * additional solutions are different than the main solution described by the
   * above fields `objective_value` and `variable_value`.
   * </pre>
   *
   * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
   */
  @java.lang.Override
  public com.google.ortools.linearsolver.MPSolutionOrBuilder getAdditionalSolutionsOrBuilder(
      int index) {
    return additionalSolutions_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(1, status_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeDouble(2, objectiveValue_);
    }
    if (getVariableValueList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(variableValueMemoizedSerializedSize);
    }
    for (int i = 0; i < variableValue_.size(); i++) {
      output.writeDoubleNoTag(variableValue_.getDouble(i));
    }
    if (getDualValueList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(dualValueMemoizedSerializedSize);
    }
    for (int i = 0; i < dualValue_.size(); i++) {
      output.writeDoubleNoTag(dualValue_.getDouble(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeDouble(5, bestObjectiveBound_);
    }
    if (getReducedCostList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(reducedCostMemoizedSerializedSize);
    }
    for (int i = 0; i < reducedCost_.size(); i++) {
      output.writeDoubleNoTag(reducedCost_.getDouble(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, statusStr_);
    }
    for (int i = 0; i < additionalSolutions_.size(); i++) {
      output.writeMessage(8, additionalSolutions_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getSolveInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBytes(11, solverSpecificInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, status_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, objectiveValue_);
    }
    {
      int dataSize = 0;
      dataSize = 8 * getVariableValueList().size();
      size += dataSize;
      if (!getVariableValueList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      variableValueMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 8 * getDualValueList().size();
      size += dataSize;
      if (!getDualValueList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      dualValueMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(5, bestObjectiveBound_);
    }
    {
      int dataSize = 0;
      dataSize = 8 * getReducedCostList().size();
      size += dataSize;
      if (!getReducedCostList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      reducedCostMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, statusStr_);
    }
    for (int i = 0; i < additionalSolutions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, additionalSolutions_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getSolveInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(11, solverSpecificInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.linearsolver.MPSolutionResponse)) {
      return super.equals(obj);
    }
    com.google.ortools.linearsolver.MPSolutionResponse other = (com.google.ortools.linearsolver.MPSolutionResponse) obj;

    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (status_ != other.status_) return false;
    }
    if (hasStatusStr() != other.hasStatusStr()) return false;
    if (hasStatusStr()) {
      if (!getStatusStr()
          .equals(other.getStatusStr())) return false;
    }
    if (hasObjectiveValue() != other.hasObjectiveValue()) return false;
    if (hasObjectiveValue()) {
      if (java.lang.Double.doubleToLongBits(getObjectiveValue())
          != java.lang.Double.doubleToLongBits(
              other.getObjectiveValue())) return false;
    }
    if (hasBestObjectiveBound() != other.hasBestObjectiveBound()) return false;
    if (hasBestObjectiveBound()) {
      if (java.lang.Double.doubleToLongBits(getBestObjectiveBound())
          != java.lang.Double.doubleToLongBits(
              other.getBestObjectiveBound())) return false;
    }
    if (!getVariableValueList()
        .equals(other.getVariableValueList())) return false;
    if (hasSolveInfo() != other.hasSolveInfo()) return false;
    if (hasSolveInfo()) {
      if (!getSolveInfo()
          .equals(other.getSolveInfo())) return false;
    }
    if (hasSolverSpecificInfo() != other.hasSolverSpecificInfo()) return false;
    if (hasSolverSpecificInfo()) {
      if (!getSolverSpecificInfo()
          .equals(other.getSolverSpecificInfo())) return false;
    }
    if (!getDualValueList()
        .equals(other.getDualValueList())) return false;
    if (!getReducedCostList()
        .equals(other.getReducedCostList())) return false;
    if (!getAdditionalSolutionsList()
        .equals(other.getAdditionalSolutionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
    }
    if (hasStatusStr()) {
      hash = (37 * hash) + STATUS_STR_FIELD_NUMBER;
      hash = (53 * hash) + getStatusStr().hashCode();
    }
    if (hasObjectiveValue()) {
      hash = (37 * hash) + OBJECTIVE_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getObjectiveValue()));
    }
    if (hasBestObjectiveBound()) {
      hash = (37 * hash) + BEST_OBJECTIVE_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getBestObjectiveBound()));
    }
    if (getVariableValueCount() > 0) {
      hash = (37 * hash) + VARIABLE_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getVariableValueList().hashCode();
    }
    if (hasSolveInfo()) {
      hash = (37 * hash) + SOLVE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSolveInfo().hashCode();
    }
    if (hasSolverSpecificInfo()) {
      hash = (37 * hash) + SOLVER_SPECIFIC_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSolverSpecificInfo().hashCode();
    }
    if (getDualValueCount() > 0) {
      hash = (37 * hash) + DUAL_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getDualValueList().hashCode();
    }
    if (getReducedCostCount() > 0) {
      hash = (37 * hash) + REDUCED_COST_FIELD_NUMBER;
      hash = (53 * hash) + getReducedCostList().hashCode();
    }
    if (getAdditionalSolutionsCount() > 0) {
      hash = (37 * hash) + ADDITIONAL_SOLUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalSolutionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.linearsolver.MPSolutionResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.linearsolver.MPSolutionResponse parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.linearsolver.MPSolutionResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.linearsolver.MPSolutionResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Next id: 12.
   * </pre>
   *
   * Protobuf type {@code operations_research.MPSolutionResponse}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.MPSolutionResponse)
      com.google.ortools.linearsolver.MPSolutionResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSolutionResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.linearsolver.MPSolutionResponse.class, com.google.ortools.linearsolver.MPSolutionResponse.Builder.class);
    }

    // Construct using com.google.ortools.linearsolver.MPSolutionResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getSolveInfoFieldBuilder();
        getAdditionalSolutionsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      status_ = 99;
      statusStr_ = "";
      objectiveValue_ = 0D;
      bestObjectiveBound_ = 0D;
      variableValue_ = emptyDoubleList();
      solveInfo_ = null;
      if (solveInfoBuilder_ != null) {
        solveInfoBuilder_.dispose();
        solveInfoBuilder_ = null;
      }
      solverSpecificInfo_ = com.google.protobuf.ByteString.EMPTY;
      dualValue_ = emptyDoubleList();
      reducedCost_ = emptyDoubleList();
      if (additionalSolutionsBuilder_ == null) {
        additionalSolutions_ = java.util.Collections.emptyList();
      } else {
        additionalSolutions_ = null;
        additionalSolutionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.linearsolver.LinearSolver.internal_static_operations_research_MPSolutionResponse_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSolutionResponse getDefaultInstanceForType() {
      return com.google.ortools.linearsolver.MPSolutionResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSolutionResponse build() {
      com.google.ortools.linearsolver.MPSolutionResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.linearsolver.MPSolutionResponse buildPartial() {
      com.google.ortools.linearsolver.MPSolutionResponse result = new com.google.ortools.linearsolver.MPSolutionResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.linearsolver.MPSolutionResponse result) {
      if (((bitField0_ & 0x00000010) != 0)) {
        variableValue_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.variableValue_ = variableValue_;
      if (((bitField0_ & 0x00000080) != 0)) {
        dualValue_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.dualValue_ = dualValue_;
      if (((bitField0_ & 0x00000100) != 0)) {
        reducedCost_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.reducedCost_ = reducedCost_;
      if (additionalSolutionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          additionalSolutions_ = java.util.Collections.unmodifiableList(additionalSolutions_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.additionalSolutions_ = additionalSolutions_;
      } else {
        result.additionalSolutions_ = additionalSolutionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ortools.linearsolver.MPSolutionResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.statusStr_ = statusStr_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.objectiveValue_ = objectiveValue_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.bestObjectiveBound_ = bestObjectiveBound_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.solveInfo_ = solveInfoBuilder_ == null
            ? solveInfo_
            : solveInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.solverSpecificInfo_ = solverSpecificInfo_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.linearsolver.MPSolutionResponse) {
        return mergeFrom((com.google.ortools.linearsolver.MPSolutionResponse)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.linearsolver.MPSolutionResponse other) {
      if (other == com.google.ortools.linearsolver.MPSolutionResponse.getDefaultInstance()) return this;
      if (other.hasStatus()) {
        setStatus(other.getStatus());
      }
      if (other.hasStatusStr()) {
        statusStr_ = other.statusStr_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasObjectiveValue()) {
        setObjectiveValue(other.getObjectiveValue());
      }
      if (other.hasBestObjectiveBound()) {
        setBestObjectiveBound(other.getBestObjectiveBound());
      }
      if (!other.variableValue_.isEmpty()) {
        if (variableValue_.isEmpty()) {
          variableValue_ = other.variableValue_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureVariableValueIsMutable();
          variableValue_.addAll(other.variableValue_);
        }
        onChanged();
      }
      if (other.hasSolveInfo()) {
        mergeSolveInfo(other.getSolveInfo());
      }
      if (other.hasSolverSpecificInfo()) {
        setSolverSpecificInfo(other.getSolverSpecificInfo());
      }
      if (!other.dualValue_.isEmpty()) {
        if (dualValue_.isEmpty()) {
          dualValue_ = other.dualValue_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureDualValueIsMutable();
          dualValue_.addAll(other.dualValue_);
        }
        onChanged();
      }
      if (!other.reducedCost_.isEmpty()) {
        if (reducedCost_.isEmpty()) {
          reducedCost_ = other.reducedCost_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureReducedCostIsMutable();
          reducedCost_.addAll(other.reducedCost_);
        }
        onChanged();
      }
      if (additionalSolutionsBuilder_ == null) {
        if (!other.additionalSolutions_.isEmpty()) {
          if (additionalSolutions_.isEmpty()) {
            additionalSolutions_ = other.additionalSolutions_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureAdditionalSolutionsIsMutable();
            additionalSolutions_.addAll(other.additionalSolutions_);
          }
          onChanged();
        }
      } else {
        if (!other.additionalSolutions_.isEmpty()) {
          if (additionalSolutionsBuilder_.isEmpty()) {
            additionalSolutionsBuilder_.dispose();
            additionalSolutionsBuilder_ = null;
            additionalSolutions_ = other.additionalSolutions_;
            bitField0_ = (bitField0_ & ~0x00000200);
            additionalSolutionsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getAdditionalSolutionsFieldBuilder() : null;
          } else {
            additionalSolutionsBuilder_.addAllMessages(other.additionalSolutions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int tmpRaw = input.readEnum();
              com.google.ortools.linearsolver.MPSolverResponseStatus tmpValue =
                  com.google.ortools.linearsolver.MPSolverResponseStatus.forNumber(tmpRaw);
              if (tmpValue == null) {
                mergeUnknownVarintField(1, tmpRaw);
              } else {
                status_ = tmpRaw;
                bitField0_ |= 0x00000001;
              }
              break;
            } // case 8
            case 17: {
              objectiveValue_ = input.readDouble();
              bitField0_ |= 0x00000004;
              break;
            } // case 17
            case 25: {
              double v = input.readDouble();
              ensureVariableValueIsMutable();
              variableValue_.addDouble(v);
              break;
            } // case 25
            case 26: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureVariableValueIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                variableValue_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 26
            case 33: {
              double v = input.readDouble();
              ensureDualValueIsMutable();
              dualValue_.addDouble(v);
              break;
            } // case 33
            case 34: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureDualValueIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                dualValue_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 34
            case 41: {
              bestObjectiveBound_ = input.readDouble();
              bitField0_ |= 0x00000008;
              break;
            } // case 41
            case 49: {
              double v = input.readDouble();
              ensureReducedCostIsMutable();
              reducedCost_.addDouble(v);
              break;
            } // case 49
            case 50: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureReducedCostIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                reducedCost_.addDouble(input.readDouble());
              }
              input.popLimit(limit);
              break;
            } // case 50
            case 58: {
              statusStr_ = input.readBytes();
              bitField0_ |= 0x00000002;
              break;
            } // case 58
            case 66: {
              com.google.ortools.linearsolver.MPSolution m =
                  input.readMessage(
                      com.google.ortools.linearsolver.MPSolution.PARSER,
                      extensionRegistry);
              if (additionalSolutionsBuilder_ == null) {
                ensureAdditionalSolutionsIsMutable();
                additionalSolutions_.add(m);
              } else {
                additionalSolutionsBuilder_.addMessage(m);
              }
              break;
            } // case 66
            case 82: {
              input.readMessage(
                  getSolveInfoFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000020;
              break;
            } // case 82
            case 90: {
              solverSpecificInfo_ = input.readBytes();
              bitField0_ |= 0x00000040;
              break;
            } // case 90
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int status_ = 99;
    /**
     * <pre>
     * Result of the optimization.
     * </pre>
     *
     * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
     * @return Whether the status field is set.
     */
    @java.lang.Override public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Result of the optimization.
     * </pre>
     *
     * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ortools.linearsolver.MPSolverResponseStatus getStatus() {
      com.google.ortools.linearsolver.MPSolverResponseStatus result = com.google.ortools.linearsolver.MPSolverResponseStatus.forNumber(status_);
      return result == null ? com.google.ortools.linearsolver.MPSolverResponseStatus.MPSOLVER_UNKNOWN_STATUS : result;
    }
    /**
     * <pre>
     * Result of the optimization.
     * </pre>
     *
     * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ortools.linearsolver.MPSolverResponseStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Result of the optimization.
     * </pre>
     *
     * <code>optional .operations_research.MPSolverResponseStatus status = 1 [default = MPSOLVER_UNKNOWN_STATUS];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000001);
      status_ = 99;
      onChanged();
      return this;
    }

    private java.lang.Object statusStr_ = "";
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @return Whether the statusStr field is set.
     */
    public boolean hasStatusStr() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @return The statusStr.
     */
    public java.lang.String getStatusStr() {
      java.lang.Object ref = statusStr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          statusStr_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @return The bytes for statusStr.
     */
    public com.google.protobuf.ByteString
        getStatusStrBytes() {
      java.lang.Object ref = statusStr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        statusStr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @param value The statusStr to set.
     * @return This builder for chaining.
     */
    public Builder setStatusStr(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      statusStr_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatusStr() {
      statusStr_ = getDefaultInstance().getStatusStr();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Human-readable string giving more details about the status. For example,
     * when the status is MPSOLVER_INVALID_MODE, this can hold a description of
     * why the model is invalid.
     * This isn't always filled: don't depend on its value or even its presence.
     * </pre>
     *
     * <code>optional string status_str = 7;</code>
     * @param value The bytes for statusStr to set.
     * @return This builder for chaining.
     */
    public Builder setStatusStrBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      statusStr_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private double objectiveValue_ ;
    /**
     * <pre>
     * Objective value corresponding to the "variable_value" below, taking into
     * account the source "objective_offset" and "objective_coefficient".
     * This is set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>optional double objective_value = 2;</code>
     * @return Whether the objectiveValue field is set.
     */
    @java.lang.Override
    public boolean hasObjectiveValue() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Objective value corresponding to the "variable_value" below, taking into
     * account the source "objective_offset" and "objective_coefficient".
     * This is set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>optional double objective_value = 2;</code>
     * @return The objectiveValue.
     */
    @java.lang.Override
    public double getObjectiveValue() {
      return objectiveValue_;
    }
    /**
     * <pre>
     * Objective value corresponding to the "variable_value" below, taking into
     * account the source "objective_offset" and "objective_coefficient".
     * This is set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>optional double objective_value = 2;</code>
     * @param value The objectiveValue to set.
     * @return This builder for chaining.
     */
    public Builder setObjectiveValue(double value) {

      objectiveValue_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Objective value corresponding to the "variable_value" below, taking into
     * account the source "objective_offset" and "objective_coefficient".
     * This is set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>optional double objective_value = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearObjectiveValue() {
      bitField0_ = (bitField0_ & ~0x00000004);
      objectiveValue_ = 0D;
      onChanged();
      return this;
    }

    private double bestObjectiveBound_ ;
    /**
     * <pre>
     * This field is only filled for MIP problems. For a minimization problem,
     * this is a lower bound on the optimal objective value. For a maximization
     * problem, it is an upper bound. It is only filled if the status is OPTIMAL
     * or FEASIBLE. In the former case, best_objective_bound should be equal to
     * objective_value (modulo numerical errors).
     * </pre>
     *
     * <code>optional double best_objective_bound = 5;</code>
     * @return Whether the bestObjectiveBound field is set.
     */
    @java.lang.Override
    public boolean hasBestObjectiveBound() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * This field is only filled for MIP problems. For a minimization problem,
     * this is a lower bound on the optimal objective value. For a maximization
     * problem, it is an upper bound. It is only filled if the status is OPTIMAL
     * or FEASIBLE. In the former case, best_objective_bound should be equal to
     * objective_value (modulo numerical errors).
     * </pre>
     *
     * <code>optional double best_objective_bound = 5;</code>
     * @return The bestObjectiveBound.
     */
    @java.lang.Override
    public double getBestObjectiveBound() {
      return bestObjectiveBound_;
    }
    /**
     * <pre>
     * This field is only filled for MIP problems. For a minimization problem,
     * this is a lower bound on the optimal objective value. For a maximization
     * problem, it is an upper bound. It is only filled if the status is OPTIMAL
     * or FEASIBLE. In the former case, best_objective_bound should be equal to
     * objective_value (modulo numerical errors).
     * </pre>
     *
     * <code>optional double best_objective_bound = 5;</code>
     * @param value The bestObjectiveBound to set.
     * @return This builder for chaining.
     */
    public Builder setBestObjectiveBound(double value) {

      bestObjectiveBound_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * This field is only filled for MIP problems. For a minimization problem,
     * this is a lower bound on the optimal objective value. For a maximization
     * problem, it is an upper bound. It is only filled if the status is OPTIMAL
     * or FEASIBLE. In the former case, best_objective_bound should be equal to
     * objective_value (modulo numerical errors).
     * </pre>
     *
     * <code>optional double best_objective_bound = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearBestObjectiveBound() {
      bitField0_ = (bitField0_ & ~0x00000008);
      bestObjectiveBound_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList variableValue_ = emptyDoubleList();
    private void ensureVariableValueIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        variableValue_ = mutableCopy(variableValue_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @return A list containing the variableValue.
     */
    public java.util.List<java.lang.Double>
        getVariableValueList() {
      return ((bitField0_ & 0x00000010) != 0) ?
               java.util.Collections.unmodifiableList(variableValue_) : variableValue_;
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @return The count of variableValue.
     */
    public int getVariableValueCount() {
      return variableValue_.size();
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The variableValue at the given index.
     */
    public double getVariableValue(int index) {
      return variableValue_.getDouble(index);
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The variableValue to set.
     * @return This builder for chaining.
     */
    public Builder setVariableValue(
        int index, double value) {

      ensureVariableValueIsMutable();
      variableValue_.setDouble(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @param value The variableValue to add.
     * @return This builder for chaining.
     */
    public Builder addVariableValue(double value) {

      ensureVariableValueIsMutable();
      variableValue_.addDouble(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @param values The variableValue to add.
     * @return This builder for chaining.
     */
    public Builder addAllVariableValue(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureVariableValueIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, variableValue_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Variable values in the same order as the MPModelProto::variable field.
     * This is a dense representation. These are set iff 'status' is OPTIMAL or
     * FEASIBLE.
     * </pre>
     *
     * <code>repeated double variable_value = 3 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearVariableValue() {
      variableValue_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    private com.google.ortools.linearsolver.MPSolveInfo solveInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.linearsolver.MPSolveInfo, com.google.ortools.linearsolver.MPSolveInfo.Builder, com.google.ortools.linearsolver.MPSolveInfoOrBuilder> solveInfoBuilder_;
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     * @return Whether the solveInfo field is set.
     */
    public boolean hasSolveInfo() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     * @return The solveInfo.
     */
    public com.google.ortools.linearsolver.MPSolveInfo getSolveInfo() {
      if (solveInfoBuilder_ == null) {
        return solveInfo_ == null ? com.google.ortools.linearsolver.MPSolveInfo.getDefaultInstance() : solveInfo_;
      } else {
        return solveInfoBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public Builder setSolveInfo(com.google.ortools.linearsolver.MPSolveInfo value) {
      if (solveInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        solveInfo_ = value;
      } else {
        solveInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public Builder setSolveInfo(
        com.google.ortools.linearsolver.MPSolveInfo.Builder builderForValue) {
      if (solveInfoBuilder_ == null) {
        solveInfo_ = builderForValue.build();
      } else {
        solveInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public Builder mergeSolveInfo(com.google.ortools.linearsolver.MPSolveInfo value) {
      if (solveInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0) &&
          solveInfo_ != null &&
          solveInfo_ != com.google.ortools.linearsolver.MPSolveInfo.getDefaultInstance()) {
          getSolveInfoBuilder().mergeFrom(value);
        } else {
          solveInfo_ = value;
        }
      } else {
        solveInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public Builder clearSolveInfo() {
      bitField0_ = (bitField0_ & ~0x00000020);
      solveInfo_ = null;
      if (solveInfoBuilder_ != null) {
        solveInfoBuilder_.dispose();
        solveInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public com.google.ortools.linearsolver.MPSolveInfo.Builder getSolveInfoBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSolveInfoFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    public com.google.ortools.linearsolver.MPSolveInfoOrBuilder getSolveInfoOrBuilder() {
      if (solveInfoBuilder_ != null) {
        return solveInfoBuilder_.getMessageOrBuilder();
      } else {
        return solveInfo_ == null ?
            com.google.ortools.linearsolver.MPSolveInfo.getDefaultInstance() : solveInfo_;
      }
    }
    /**
     * <pre>
     * Contains extra information about the solve, populated if the underlying
     * solver (and its interface) supports it. As of 2021/07/19 this is supported
     * by SCIP and Gurobi proto solves.
     * </pre>
     *
     * <code>optional .operations_research.MPSolveInfo solve_info = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.linearsolver.MPSolveInfo, com.google.ortools.linearsolver.MPSolveInfo.Builder, com.google.ortools.linearsolver.MPSolveInfoOrBuilder> 
        getSolveInfoFieldBuilder() {
      if (solveInfoBuilder_ == null) {
        solveInfoBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ortools.linearsolver.MPSolveInfo, com.google.ortools.linearsolver.MPSolveInfo.Builder, com.google.ortools.linearsolver.MPSolveInfoOrBuilder>(
                getSolveInfo(),
                getParentForChildren(),
                isClean());
        solveInfo_ = null;
      }
      return solveInfoBuilder_;
    }

    private com.google.protobuf.ByteString solverSpecificInfo_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * Opaque solver-specific information.
     * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
     * </pre>
     *
     * <code>optional bytes solver_specific_info = 11;</code>
     * @return Whether the solverSpecificInfo field is set.
     */
    @java.lang.Override
    public boolean hasSolverSpecificInfo() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Opaque solver-specific information.
     * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
     * </pre>
     *
     * <code>optional bytes solver_specific_info = 11;</code>
     * @return The solverSpecificInfo.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSolverSpecificInfo() {
      return solverSpecificInfo_;
    }
    /**
     * <pre>
     * Opaque solver-specific information.
     * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
     * </pre>
     *
     * <code>optional bytes solver_specific_info = 11;</code>
     * @param value The solverSpecificInfo to set.
     * @return This builder for chaining.
     */
    public Builder setSolverSpecificInfo(com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      solverSpecificInfo_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Opaque solver-specific information.
     * For the PDLP solver, this is a serialized pdlp::SolveLog proto.
     * </pre>
     *
     * <code>optional bytes solver_specific_info = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearSolverSpecificInfo() {
      bitField0_ = (bitField0_ & ~0x00000040);
      solverSpecificInfo_ = getDefaultInstance().getSolverSpecificInfo();
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList dualValue_ = emptyDoubleList();
    private void ensureDualValueIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        dualValue_ = mutableCopy(dualValue_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @return A list containing the dualValue.
     */
    public java.util.List<java.lang.Double>
        getDualValueList() {
      return ((bitField0_ & 0x00000080) != 0) ?
               java.util.Collections.unmodifiableList(dualValue_) : dualValue_;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @return The count of dualValue.
     */
    public int getDualValueCount() {
      return dualValue_.size();
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The dualValue at the given index.
     */
    public double getDualValue(int index) {
      return dualValue_.getDouble(index);
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The dualValue to set.
     * @return This builder for chaining.
     */
    public Builder setDualValue(
        int index, double value) {

      ensureDualValueIsMutable();
      dualValue_.setDouble(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @param value The dualValue to add.
     * @return This builder for chaining.
     */
    public Builder addDualValue(double value) {

      ensureDualValueIsMutable();
      dualValue_.addDouble(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @param values The dualValue to add.
     * @return This builder for chaining.
     */
    public Builder addAllDualValue(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureDualValueIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, dualValue_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the dual variables values in the same order as the
     * MPModelProto::constraint field. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if
     * it is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double dual_value = 4 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearDualValue() {
      dualValue_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList reducedCost_ = emptyDoubleList();
    private void ensureReducedCostIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        reducedCost_ = mutableCopy(reducedCost_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @return A list containing the reducedCost.
     */
    public java.util.List<java.lang.Double>
        getReducedCostList() {
      return ((bitField0_ & 0x00000100) != 0) ?
               java.util.Collections.unmodifiableList(reducedCost_) : reducedCost_;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @return The count of reducedCost.
     */
    public int getReducedCostCount() {
      return reducedCost_.size();
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @param index The index of the element to return.
     * @return The reducedCost at the given index.
     */
    public double getReducedCost(int index) {
      return reducedCost_.getDouble(index);
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @param index The index to set the value at.
     * @param value The reducedCost to set.
     * @return This builder for chaining.
     */
    public Builder setReducedCost(
        int index, double value) {

      ensureReducedCostIsMutable();
      reducedCost_.setDouble(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @param value The reducedCost to add.
     * @return This builder for chaining.
     */
    public Builder addReducedCost(double value) {

      ensureReducedCostIsMutable();
      reducedCost_.addDouble(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @param values The reducedCost to add.
     * @return This builder for chaining.
     */
    public Builder addAllReducedCost(
        java.lang.Iterable<? extends java.lang.Double> values) {
      ensureReducedCostIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, reducedCost_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * Values of the reduced cost of the variables in the same order as the
     * MPModelProto::variable. This is a dense representation.
     * These are not set if the problem was solved with a MIP solver (even if it
     * is actually a linear program).
     * These are set iff 'status' is OPTIMAL or FEASIBLE.
     * </pre>
     *
     * <code>repeated double reduced_cost = 6 [packed = true];</code>
     * @return This builder for chaining.
     */
    public Builder clearReducedCost() {
      reducedCost_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    private java.util.List<com.google.ortools.linearsolver.MPSolution> additionalSolutions_ =
      java.util.Collections.emptyList();
    private void ensureAdditionalSolutionsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        additionalSolutions_ = new java.util.ArrayList<com.google.ortools.linearsolver.MPSolution>(additionalSolutions_);
        bitField0_ |= 0x00000200;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.linearsolver.MPSolution, com.google.ortools.linearsolver.MPSolution.Builder, com.google.ortools.linearsolver.MPSolutionOrBuilder> additionalSolutionsBuilder_;

    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public java.util.List<com.google.ortools.linearsolver.MPSolution> getAdditionalSolutionsList() {
      if (additionalSolutionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(additionalSolutions_);
      } else {
        return additionalSolutionsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public int getAdditionalSolutionsCount() {
      if (additionalSolutionsBuilder_ == null) {
        return additionalSolutions_.size();
      } else {
        return additionalSolutionsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public com.google.ortools.linearsolver.MPSolution getAdditionalSolutions(int index) {
      if (additionalSolutionsBuilder_ == null) {
        return additionalSolutions_.get(index);
      } else {
        return additionalSolutionsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder setAdditionalSolutions(
        int index, com.google.ortools.linearsolver.MPSolution value) {
      if (additionalSolutionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.set(index, value);
        onChanged();
      } else {
        additionalSolutionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder setAdditionalSolutions(
        int index, com.google.ortools.linearsolver.MPSolution.Builder builderForValue) {
      if (additionalSolutionsBuilder_ == null) {
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.set(index, builderForValue.build());
        onChanged();
      } else {
        additionalSolutionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder addAdditionalSolutions(com.google.ortools.linearsolver.MPSolution value) {
      if (additionalSolutionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.add(value);
        onChanged();
      } else {
        additionalSolutionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder addAdditionalSolutions(
        int index, com.google.ortools.linearsolver.MPSolution value) {
      if (additionalSolutionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.add(index, value);
        onChanged();
      } else {
        additionalSolutionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder addAdditionalSolutions(
        com.google.ortools.linearsolver.MPSolution.Builder builderForValue) {
      if (additionalSolutionsBuilder_ == null) {
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.add(builderForValue.build());
        onChanged();
      } else {
        additionalSolutionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder addAdditionalSolutions(
        int index, com.google.ortools.linearsolver.MPSolution.Builder builderForValue) {
      if (additionalSolutionsBuilder_ == null) {
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.add(index, builderForValue.build());
        onChanged();
      } else {
        additionalSolutionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder addAllAdditionalSolutions(
        java.lang.Iterable<? extends com.google.ortools.linearsolver.MPSolution> values) {
      if (additionalSolutionsBuilder_ == null) {
        ensureAdditionalSolutionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, additionalSolutions_);
        onChanged();
      } else {
        additionalSolutionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder clearAdditionalSolutions() {
      if (additionalSolutionsBuilder_ == null) {
        additionalSolutions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        additionalSolutionsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public Builder removeAdditionalSolutions(int index) {
      if (additionalSolutionsBuilder_ == null) {
        ensureAdditionalSolutionsIsMutable();
        additionalSolutions_.remove(index);
        onChanged();
      } else {
        additionalSolutionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public com.google.ortools.linearsolver.MPSolution.Builder getAdditionalSolutionsBuilder(
        int index) {
      return getAdditionalSolutionsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public com.google.ortools.linearsolver.MPSolutionOrBuilder getAdditionalSolutionsOrBuilder(
        int index) {
      if (additionalSolutionsBuilder_ == null) {
        return additionalSolutions_.get(index);  } else {
        return additionalSolutionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public java.util.List<? extends com.google.ortools.linearsolver.MPSolutionOrBuilder> 
         getAdditionalSolutionsOrBuilderList() {
      if (additionalSolutionsBuilder_ != null) {
        return additionalSolutionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(additionalSolutions_);
      }
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public com.google.ortools.linearsolver.MPSolution.Builder addAdditionalSolutionsBuilder() {
      return getAdditionalSolutionsFieldBuilder().addBuilder(
          com.google.ortools.linearsolver.MPSolution.getDefaultInstance());
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public com.google.ortools.linearsolver.MPSolution.Builder addAdditionalSolutionsBuilder(
        int index) {
      return getAdditionalSolutionsFieldBuilder().addBuilder(
          index, com.google.ortools.linearsolver.MPSolution.getDefaultInstance());
    }
    /**
     * <pre>
     * [Advanced usage.]
     * If `MPModelRequest.populate_additional_solutions_up_to` &gt; 0, up to that
     * number of additional solutions may be populated here, if available. These
     * additional solutions are different than the main solution described by the
     * above fields `objective_value` and `variable_value`.
     * </pre>
     *
     * <code>repeated .operations_research.MPSolution additional_solutions = 8;</code>
     */
    public java.util.List<com.google.ortools.linearsolver.MPSolution.Builder> 
         getAdditionalSolutionsBuilderList() {
      return getAdditionalSolutionsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.linearsolver.MPSolution, com.google.ortools.linearsolver.MPSolution.Builder, com.google.ortools.linearsolver.MPSolutionOrBuilder> 
        getAdditionalSolutionsFieldBuilder() {
      if (additionalSolutionsBuilder_ == null) {
        additionalSolutionsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ortools.linearsolver.MPSolution, com.google.ortools.linearsolver.MPSolution.Builder, com.google.ortools.linearsolver.MPSolutionOrBuilder>(
                additionalSolutions_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        additionalSolutions_ = null;
      }
      return additionalSolutionsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.MPSolutionResponse)
  }

  // @@protoc_insertion_point(class_scope:operations_research.MPSolutionResponse)
  private static final com.google.ortools.linearsolver.MPSolutionResponse DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.linearsolver.MPSolutionResponse();
  }

  public static com.google.ortools.linearsolver.MPSolutionResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<MPSolutionResponse>
      PARSER = new com.google.protobuf.AbstractParser<MPSolutionResponse>() {
    @java.lang.Override
    public MPSolutionResponse parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MPSolutionResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MPSolutionResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.linearsolver.MPSolutionResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

