// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/cp_model.proto

package com.google.ortools.sat;

/**
 * <pre>
 * Define the strategy to follow when the solver needs to take a new decision.
 * Note that this strategy is only defined on a subset of variables.
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.DecisionStrategyProto}
 */
public final class DecisionStrategyProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.DecisionStrategyProto)
    DecisionStrategyProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use DecisionStrategyProto.newBuilder() to construct.
  private DecisionStrategyProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private DecisionStrategyProto() {
    variables_ = emptyIntList();
    variableSelectionStrategy_ = 0;
    domainReductionStrategy_ = 0;
    transformations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new DecisionStrategyProto();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.DecisionStrategyProto.class, com.google.ortools.sat.DecisionStrategyProto.Builder.class);
  }

  /**
   * <pre>
   * The order in which the variables above should be considered. Note that only
   * variables that are not already fixed are considered.
   *
   * TODO(user): extend as needed.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy}
   */
  public enum VariableSelectionStrategy
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>CHOOSE_FIRST = 0;</code>
     */
    CHOOSE_FIRST(0),
    /**
     * <code>CHOOSE_LOWEST_MIN = 1;</code>
     */
    CHOOSE_LOWEST_MIN(1),
    /**
     * <code>CHOOSE_HIGHEST_MAX = 2;</code>
     */
    CHOOSE_HIGHEST_MAX(2),
    /**
     * <code>CHOOSE_MIN_DOMAIN_SIZE = 3;</code>
     */
    CHOOSE_MIN_DOMAIN_SIZE(3),
    /**
     * <code>CHOOSE_MAX_DOMAIN_SIZE = 4;</code>
     */
    CHOOSE_MAX_DOMAIN_SIZE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>CHOOSE_FIRST = 0;</code>
     */
    public static final int CHOOSE_FIRST_VALUE = 0;
    /**
     * <code>CHOOSE_LOWEST_MIN = 1;</code>
     */
    public static final int CHOOSE_LOWEST_MIN_VALUE = 1;
    /**
     * <code>CHOOSE_HIGHEST_MAX = 2;</code>
     */
    public static final int CHOOSE_HIGHEST_MAX_VALUE = 2;
    /**
     * <code>CHOOSE_MIN_DOMAIN_SIZE = 3;</code>
     */
    public static final int CHOOSE_MIN_DOMAIN_SIZE_VALUE = 3;
    /**
     * <code>CHOOSE_MAX_DOMAIN_SIZE = 4;</code>
     */
    public static final int CHOOSE_MAX_DOMAIN_SIZE_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VariableSelectionStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VariableSelectionStrategy forNumber(int value) {
      switch (value) {
        case 0: return CHOOSE_FIRST;
        case 1: return CHOOSE_LOWEST_MIN;
        case 2: return CHOOSE_HIGHEST_MAX;
        case 3: return CHOOSE_MIN_DOMAIN_SIZE;
        case 4: return CHOOSE_MAX_DOMAIN_SIZE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VariableSelectionStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        VariableSelectionStrategy> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<VariableSelectionStrategy>() {
            public VariableSelectionStrategy findValueByNumber(int number) {
              return VariableSelectionStrategy.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.DecisionStrategyProto.getDescriptor().getEnumTypes().get(0);
    }

    private static final VariableSelectionStrategy[] VALUES = values();

    public static VariableSelectionStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VariableSelectionStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy)
  }

  /**
   * <pre>
   * Once a variable has been chosen, this enum describe what decision is taken
   * on its domain.
   *
   * TODO(user): extend as needed.
   * </pre>
   *
   * Protobuf enum {@code operations_research.sat.DecisionStrategyProto.DomainReductionStrategy}
   */
  public enum DomainReductionStrategy
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SELECT_MIN_VALUE = 0;</code>
     */
    SELECT_MIN_VALUE(0),
    /**
     * <code>SELECT_MAX_VALUE = 1;</code>
     */
    SELECT_MAX_VALUE(1),
    /**
     * <code>SELECT_LOWER_HALF = 2;</code>
     */
    SELECT_LOWER_HALF(2),
    /**
     * <code>SELECT_UPPER_HALF = 3;</code>
     */
    SELECT_UPPER_HALF(3),
    /**
     * <code>SELECT_MEDIAN_VALUE = 4;</code>
     */
    SELECT_MEDIAN_VALUE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>SELECT_MIN_VALUE = 0;</code>
     */
    public static final int SELECT_MIN_VALUE_VALUE = 0;
    /**
     * <code>SELECT_MAX_VALUE = 1;</code>
     */
    public static final int SELECT_MAX_VALUE_VALUE = 1;
    /**
     * <code>SELECT_LOWER_HALF = 2;</code>
     */
    public static final int SELECT_LOWER_HALF_VALUE = 2;
    /**
     * <code>SELECT_UPPER_HALF = 3;</code>
     */
    public static final int SELECT_UPPER_HALF_VALUE = 3;
    /**
     * <code>SELECT_MEDIAN_VALUE = 4;</code>
     */
    public static final int SELECT_MEDIAN_VALUE_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DomainReductionStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DomainReductionStrategy forNumber(int value) {
      switch (value) {
        case 0: return SELECT_MIN_VALUE;
        case 1: return SELECT_MAX_VALUE;
        case 2: return SELECT_LOWER_HALF;
        case 3: return SELECT_UPPER_HALF;
        case 4: return SELECT_MEDIAN_VALUE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DomainReductionStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DomainReductionStrategy> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DomainReductionStrategy>() {
            public DomainReductionStrategy findValueByNumber(int number) {
              return DomainReductionStrategy.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.ortools.sat.DecisionStrategyProto.getDescriptor().getEnumTypes().get(1);
    }

    private static final DomainReductionStrategy[] VALUES = values();

    public static DomainReductionStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DomainReductionStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:operations_research.sat.DecisionStrategyProto.DomainReductionStrategy)
  }

  public interface AffineTransformationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:operations_research.sat.DecisionStrategyProto.AffineTransformation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>int32 index = 1;</code>
     * @return The index.
     */
    int getIndex();

    /**
     * <code>int64 offset = 2;</code>
     * @return The offset.
     */
    long getOffset();

    /**
     * <code>int64 positive_coeff = 3;</code>
     * @return The positiveCoeff.
     */
    long getPositiveCoeff();
  }
  /**
   * <pre>
   * Advanced usage. Some of the variable listed above may have been transformed
   * by the presolve so this is needed to properly follow the given selection
   * strategy. Instead of using a value X for variables[index], we will use
   * positive_coeff * X + offset instead.
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.DecisionStrategyProto.AffineTransformation}
   */
  public static final class AffineTransformation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:operations_research.sat.DecisionStrategyProto.AffineTransformation)
      AffineTransformationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AffineTransformation.newBuilder() to construct.
    private AffineTransformation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AffineTransformation() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AffineTransformation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_AffineTransformation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_AffineTransformation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.class, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder.class);
    }

    public static final int INDEX_FIELD_NUMBER = 1;
    private int index_ = 0;
    /**
     * <code>int32 index = 1;</code>
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }

    public static final int OFFSET_FIELD_NUMBER = 2;
    private long offset_ = 0L;
    /**
     * <code>int64 offset = 2;</code>
     * @return The offset.
     */
    @java.lang.Override
    public long getOffset() {
      return offset_;
    }

    public static final int POSITIVE_COEFF_FIELD_NUMBER = 3;
    private long positiveCoeff_ = 0L;
    /**
     * <code>int64 positive_coeff = 3;</code>
     * @return The positiveCoeff.
     */
    @java.lang.Override
    public long getPositiveCoeff() {
      return positiveCoeff_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (index_ != 0) {
        output.writeInt32(1, index_);
      }
      if (offset_ != 0L) {
        output.writeInt64(2, offset_);
      }
      if (positiveCoeff_ != 0L) {
        output.writeInt64(3, positiveCoeff_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (index_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(1, index_);
      }
      if (offset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(2, offset_);
      }
      if (positiveCoeff_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(3, positiveCoeff_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.ortools.sat.DecisionStrategyProto.AffineTransformation)) {
        return super.equals(obj);
      }
      com.google.ortools.sat.DecisionStrategyProto.AffineTransformation other = (com.google.ortools.sat.DecisionStrategyProto.AffineTransformation) obj;

      if (getIndex()
          != other.getIndex()) return false;
      if (getOffset()
          != other.getOffset()) return false;
      if (getPositiveCoeff()
          != other.getPositiveCoeff()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex();
      hash = (37 * hash) + OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getOffset());
      hash = (37 * hash) + POSITIVE_COEFF_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getPositiveCoeff());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.ortools.sat.DecisionStrategyProto.AffineTransformation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Advanced usage. Some of the variable listed above may have been transformed
     * by the presolve so this is needed to properly follow the given selection
     * strategy. Instead of using a value X for variables[index], we will use
     * positive_coeff * X + offset instead.
     * </pre>
     *
     * Protobuf type {@code operations_research.sat.DecisionStrategyProto.AffineTransformation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:operations_research.sat.DecisionStrategyProto.AffineTransformation)
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_AffineTransformation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_AffineTransformation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.class, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder.class);
      }

      // Construct using com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        index_ = 0;
        offset_ = 0L;
        positiveCoeff_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_AffineTransformation_descriptor;
      }

      @java.lang.Override
      public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation getDefaultInstanceForType() {
        return com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation build() {
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation buildPartial() {
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformation result = new com.google.ortools.sat.DecisionStrategyProto.AffineTransformation(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.ortools.sat.DecisionStrategyProto.AffineTransformation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.index_ = index_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.offset_ = offset_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.positiveCoeff_ = positiveCoeff_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.ortools.sat.DecisionStrategyProto.AffineTransformation) {
          return mergeFrom((com.google.ortools.sat.DecisionStrategyProto.AffineTransformation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.ortools.sat.DecisionStrategyProto.AffineTransformation other) {
        if (other == com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.getDefaultInstance()) return this;
        if (other.getIndex() != 0) {
          setIndex(other.getIndex());
        }
        if (other.getOffset() != 0L) {
          setOffset(other.getOffset());
        }
        if (other.getPositiveCoeff() != 0L) {
          setPositiveCoeff(other.getPositiveCoeff());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                index_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 16: {
                offset_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                positiveCoeff_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int index_ ;
      /**
       * <code>int32 index = 1;</code>
       * @return The index.
       */
      @java.lang.Override
      public int getIndex() {
        return index_;
      }
      /**
       * <code>int32 index = 1;</code>
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(int value) {

        index_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>int32 index = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        index_ = 0;
        onChanged();
        return this;
      }

      private long offset_ ;
      /**
       * <code>int64 offset = 2;</code>
       * @return The offset.
       */
      @java.lang.Override
      public long getOffset() {
        return offset_;
      }
      /**
       * <code>int64 offset = 2;</code>
       * @param value The offset to set.
       * @return This builder for chaining.
       */
      public Builder setOffset(long value) {

        offset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>int64 offset = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearOffset() {
        bitField0_ = (bitField0_ & ~0x00000002);
        offset_ = 0L;
        onChanged();
        return this;
      }

      private long positiveCoeff_ ;
      /**
       * <code>int64 positive_coeff = 3;</code>
       * @return The positiveCoeff.
       */
      @java.lang.Override
      public long getPositiveCoeff() {
        return positiveCoeff_;
      }
      /**
       * <code>int64 positive_coeff = 3;</code>
       * @param value The positiveCoeff to set.
       * @return This builder for chaining.
       */
      public Builder setPositiveCoeff(long value) {

        positiveCoeff_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>int64 positive_coeff = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPositiveCoeff() {
        bitField0_ = (bitField0_ & ~0x00000004);
        positiveCoeff_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:operations_research.sat.DecisionStrategyProto.AffineTransformation)
    }

    // @@protoc_insertion_point(class_scope:operations_research.sat.DecisionStrategyProto.AffineTransformation)
    private static final com.google.ortools.sat.DecisionStrategyProto.AffineTransformation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.ortools.sat.DecisionStrategyProto.AffineTransformation();
    }

    public static com.google.ortools.sat.DecisionStrategyProto.AffineTransformation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AffineTransformation>
        PARSER = new com.google.protobuf.AbstractParser<AffineTransformation>() {
      @java.lang.Override
      public AffineTransformation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AffineTransformation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AffineTransformation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int VARIABLES_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList variables_;
  /**
   * <pre>
   * The variables to be considered for the next decision. The order matter and
   * is always used as a tie-breaker after the variable selection strategy
   * criteria defined below.
   * </pre>
   *
   * <code>repeated int32 variables = 1;</code>
   * @return A list containing the variables.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getVariablesList() {
    return variables_;
  }
  /**
   * <pre>
   * The variables to be considered for the next decision. The order matter and
   * is always used as a tie-breaker after the variable selection strategy
   * criteria defined below.
   * </pre>
   *
   * <code>repeated int32 variables = 1;</code>
   * @return The count of variables.
   */
  public int getVariablesCount() {
    return variables_.size();
  }
  /**
   * <pre>
   * The variables to be considered for the next decision. The order matter and
   * is always used as a tie-breaker after the variable selection strategy
   * criteria defined below.
   * </pre>
   *
   * <code>repeated int32 variables = 1;</code>
   * @param index The index of the element to return.
   * @return The variables at the given index.
   */
  public int getVariables(int index) {
    return variables_.getInt(index);
  }
  private int variablesMemoizedSerializedSize = -1;

  public static final int VARIABLE_SELECTION_STRATEGY_FIELD_NUMBER = 2;
  private int variableSelectionStrategy_ = 0;
  /**
   * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
   * @return The enum numeric value on the wire for variableSelectionStrategy.
   */
  @java.lang.Override public int getVariableSelectionStrategyValue() {
    return variableSelectionStrategy_;
  }
  /**
   * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
   * @return The variableSelectionStrategy.
   */
  @java.lang.Override public com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy getVariableSelectionStrategy() {
    com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy result = com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.forNumber(variableSelectionStrategy_);
    return result == null ? com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.UNRECOGNIZED : result;
  }

  public static final int DOMAIN_REDUCTION_STRATEGY_FIELD_NUMBER = 3;
  private int domainReductionStrategy_ = 0;
  /**
   * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
   * @return The enum numeric value on the wire for domainReductionStrategy.
   */
  @java.lang.Override public int getDomainReductionStrategyValue() {
    return domainReductionStrategy_;
  }
  /**
   * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
   * @return The domainReductionStrategy.
   */
  @java.lang.Override public com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy getDomainReductionStrategy() {
    com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy result = com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.forNumber(domainReductionStrategy_);
    return result == null ? com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.UNRECOGNIZED : result;
  }

  public static final int TRANSFORMATIONS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation> transformations_;
  /**
   * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation> getTransformationsList() {
    return transformations_;
  }
  /**
   * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder> 
      getTransformationsOrBuilderList() {
    return transformations_;
  }
  /**
   * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
   */
  @java.lang.Override
  public int getTransformationsCount() {
    return transformations_.size();
  }
  /**
   * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation getTransformations(int index) {
    return transformations_.get(index);
  }
  /**
   * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder getTransformationsOrBuilder(
      int index) {
    return transformations_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (getVariablesList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(variablesMemoizedSerializedSize);
    }
    for (int i = 0; i < variables_.size(); i++) {
      output.writeInt32NoTag(variables_.getInt(i));
    }
    if (variableSelectionStrategy_ != com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.CHOOSE_FIRST.getNumber()) {
      output.writeEnum(2, variableSelectionStrategy_);
    }
    if (domainReductionStrategy_ != com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.SELECT_MIN_VALUE.getNumber()) {
      output.writeEnum(3, domainReductionStrategy_);
    }
    for (int i = 0; i < transformations_.size(); i++) {
      output.writeMessage(4, transformations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < variables_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(variables_.getInt(i));
      }
      size += dataSize;
      if (!getVariablesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      variablesMemoizedSerializedSize = dataSize;
    }
    if (variableSelectionStrategy_ != com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.CHOOSE_FIRST.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, variableSelectionStrategy_);
    }
    if (domainReductionStrategy_ != com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.SELECT_MIN_VALUE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, domainReductionStrategy_);
    }
    for (int i = 0; i < transformations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, transformations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.DecisionStrategyProto)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.DecisionStrategyProto other = (com.google.ortools.sat.DecisionStrategyProto) obj;

    if (!getVariablesList()
        .equals(other.getVariablesList())) return false;
    if (variableSelectionStrategy_ != other.variableSelectionStrategy_) return false;
    if (domainReductionStrategy_ != other.domainReductionStrategy_) return false;
    if (!getTransformationsList()
        .equals(other.getTransformationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getVariablesCount() > 0) {
      hash = (37 * hash) + VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getVariablesList().hashCode();
    }
    hash = (37 * hash) + VARIABLE_SELECTION_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + variableSelectionStrategy_;
    hash = (37 * hash) + DOMAIN_REDUCTION_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + domainReductionStrategy_;
    if (getTransformationsCount() > 0) {
      hash = (37 * hash) + TRANSFORMATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.sat.DecisionStrategyProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.sat.DecisionStrategyProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.DecisionStrategyProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.DecisionStrategyProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Define the strategy to follow when the solver needs to take a new decision.
   * Note that this strategy is only defined on a subset of variables.
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.DecisionStrategyProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.DecisionStrategyProto)
      com.google.ortools.sat.DecisionStrategyProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.DecisionStrategyProto.class, com.google.ortools.sat.DecisionStrategyProto.Builder.class);
    }

    // Construct using com.google.ortools.sat.DecisionStrategyProto.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      variables_ = emptyIntList();
      variableSelectionStrategy_ = 0;
      domainReductionStrategy_ = 0;
      if (transformationsBuilder_ == null) {
        transformations_ = java.util.Collections.emptyList();
      } else {
        transformations_ = null;
        transformationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_DecisionStrategyProto_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto getDefaultInstanceForType() {
      return com.google.ortools.sat.DecisionStrategyProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto build() {
      com.google.ortools.sat.DecisionStrategyProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto buildPartial() {
      com.google.ortools.sat.DecisionStrategyProto result = new com.google.ortools.sat.DecisionStrategyProto(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.sat.DecisionStrategyProto result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        variables_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.variables_ = variables_;
      if (transformationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          transformations_ = java.util.Collections.unmodifiableList(transformations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.transformations_ = transformations_;
      } else {
        result.transformations_ = transformationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ortools.sat.DecisionStrategyProto result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.variableSelectionStrategy_ = variableSelectionStrategy_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.domainReductionStrategy_ = domainReductionStrategy_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.DecisionStrategyProto) {
        return mergeFrom((com.google.ortools.sat.DecisionStrategyProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.DecisionStrategyProto other) {
      if (other == com.google.ortools.sat.DecisionStrategyProto.getDefaultInstance()) return this;
      if (!other.variables_.isEmpty()) {
        if (variables_.isEmpty()) {
          variables_ = other.variables_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureVariablesIsMutable();
          variables_.addAll(other.variables_);
        }
        onChanged();
      }
      if (other.variableSelectionStrategy_ != 0) {
        setVariableSelectionStrategyValue(other.getVariableSelectionStrategyValue());
      }
      if (other.domainReductionStrategy_ != 0) {
        setDomainReductionStrategyValue(other.getDomainReductionStrategyValue());
      }
      if (transformationsBuilder_ == null) {
        if (!other.transformations_.isEmpty()) {
          if (transformations_.isEmpty()) {
            transformations_ = other.transformations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTransformationsIsMutable();
            transformations_.addAll(other.transformations_);
          }
          onChanged();
        }
      } else {
        if (!other.transformations_.isEmpty()) {
          if (transformationsBuilder_.isEmpty()) {
            transformationsBuilder_.dispose();
            transformationsBuilder_ = null;
            transformations_ = other.transformations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            transformationsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTransformationsFieldBuilder() : null;
          } else {
            transformationsBuilder_.addAllMessages(other.transformations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int v = input.readInt32();
              ensureVariablesIsMutable();
              variables_.addInt(v);
              break;
            } // case 8
            case 10: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureVariablesIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                variables_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 10
            case 16: {
              variableSelectionStrategy_ = input.readEnum();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              domainReductionStrategy_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 34: {
              com.google.ortools.sat.DecisionStrategyProto.AffineTransformation m =
                  input.readMessage(
                      com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.parser(),
                      extensionRegistry);
              if (transformationsBuilder_ == null) {
                ensureTransformationsIsMutable();
                transformations_.add(m);
              } else {
                transformationsBuilder_.addMessage(m);
              }
              break;
            } // case 34
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.Internal.IntList variables_ = emptyIntList();
    private void ensureVariablesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        variables_ = mutableCopy(variables_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @return A list containing the variables.
     */
    public java.util.List<java.lang.Integer>
        getVariablesList() {
      return ((bitField0_ & 0x00000001) != 0) ?
               java.util.Collections.unmodifiableList(variables_) : variables_;
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @return The count of variables.
     */
    public int getVariablesCount() {
      return variables_.size();
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @param index The index of the element to return.
     * @return The variables at the given index.
     */
    public int getVariables(int index) {
      return variables_.getInt(index);
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @param index The index to set the value at.
     * @param value The variables to set.
     * @return This builder for chaining.
     */
    public Builder setVariables(
        int index, int value) {

      ensureVariablesIsMutable();
      variables_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @param value The variables to add.
     * @return This builder for chaining.
     */
    public Builder addVariables(int value) {

      ensureVariablesIsMutable();
      variables_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @param values The variables to add.
     * @return This builder for chaining.
     */
    public Builder addAllVariables(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureVariablesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, variables_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variables to be considered for the next decision. The order matter and
     * is always used as a tie-breaker after the variable selection strategy
     * criteria defined below.
     * </pre>
     *
     * <code>repeated int32 variables = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearVariables() {
      variables_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private int variableSelectionStrategy_ = 0;
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
     * @return The enum numeric value on the wire for variableSelectionStrategy.
     */
    @java.lang.Override public int getVariableSelectionStrategyValue() {
      return variableSelectionStrategy_;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
     * @param value The enum numeric value on the wire for variableSelectionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setVariableSelectionStrategyValue(int value) {
      variableSelectionStrategy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
     * @return The variableSelectionStrategy.
     */
    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy getVariableSelectionStrategy() {
      com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy result = com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.forNumber(variableSelectionStrategy_);
      return result == null ? com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy.UNRECOGNIZED : result;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
     * @param value The variableSelectionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setVariableSelectionStrategy(com.google.ortools.sat.DecisionStrategyProto.VariableSelectionStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      variableSelectionStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.VariableSelectionStrategy variable_selection_strategy = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearVariableSelectionStrategy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      variableSelectionStrategy_ = 0;
      onChanged();
      return this;
    }

    private int domainReductionStrategy_ = 0;
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
     * @return The enum numeric value on the wire for domainReductionStrategy.
     */
    @java.lang.Override public int getDomainReductionStrategyValue() {
      return domainReductionStrategy_;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
     * @param value The enum numeric value on the wire for domainReductionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setDomainReductionStrategyValue(int value) {
      domainReductionStrategy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
     * @return The domainReductionStrategy.
     */
    @java.lang.Override
    public com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy getDomainReductionStrategy() {
      com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy result = com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.forNumber(domainReductionStrategy_);
      return result == null ? com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy.UNRECOGNIZED : result;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
     * @param value The domainReductionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setDomainReductionStrategy(com.google.ortools.sat.DecisionStrategyProto.DomainReductionStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      domainReductionStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.operations_research.sat.DecisionStrategyProto.DomainReductionStrategy domain_reduction_strategy = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearDomainReductionStrategy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      domainReductionStrategy_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation> transformations_ =
      java.util.Collections.emptyList();
    private void ensureTransformationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        transformations_ = new java.util.ArrayList<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation>(transformations_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformation, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder, com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder> transformationsBuilder_;

    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public java.util.List<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation> getTransformationsList() {
      if (transformationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transformations_);
      } else {
        return transformationsBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public int getTransformationsCount() {
      if (transformationsBuilder_ == null) {
        return transformations_.size();
      } else {
        return transformationsBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation getTransformations(int index) {
      if (transformationsBuilder_ == null) {
        return transformations_.get(index);
      } else {
        return transformationsBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder setTransformations(
        int index, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.set(index, value);
        onChanged();
      } else {
        transformationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder setTransformations(
        int index, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.set(index, builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder addTransformations(com.google.ortools.sat.DecisionStrategyProto.AffineTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.add(value);
        onChanged();
      } else {
        transformationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder addTransformations(
        int index, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation value) {
      if (transformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationsIsMutable();
        transformations_.add(index, value);
        onChanged();
      } else {
        transformationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder addTransformations(
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.add(builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder addTransformations(
        int index, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder builderForValue) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.add(index, builderForValue.build());
        onChanged();
      } else {
        transformationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder addAllTransformations(
        java.lang.Iterable<? extends com.google.ortools.sat.DecisionStrategyProto.AffineTransformation> values) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, transformations_);
        onChanged();
      } else {
        transformationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder clearTransformations() {
      if (transformationsBuilder_ == null) {
        transformations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        transformationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public Builder removeTransformations(int index) {
      if (transformationsBuilder_ == null) {
        ensureTransformationsIsMutable();
        transformations_.remove(index);
        onChanged();
      } else {
        transformationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder getTransformationsBuilder(
        int index) {
      return getTransformationsFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder getTransformationsOrBuilder(
        int index) {
      if (transformationsBuilder_ == null) {
        return transformations_.get(index);  } else {
        return transformationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public java.util.List<? extends com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder> 
         getTransformationsOrBuilderList() {
      if (transformationsBuilder_ != null) {
        return transformationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transformations_);
      }
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder addTransformationsBuilder() {
      return getTransformationsFieldBuilder().addBuilder(
          com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.getDefaultInstance());
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder addTransformationsBuilder(
        int index) {
      return getTransformationsFieldBuilder().addBuilder(
          index, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.getDefaultInstance());
    }
    /**
     * <code>repeated .operations_research.sat.DecisionStrategyProto.AffineTransformation transformations = 4;</code>
     */
    public java.util.List<com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder> 
         getTransformationsBuilderList() {
      return getTransformationsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.sat.DecisionStrategyProto.AffineTransformation, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder, com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder> 
        getTransformationsFieldBuilder() {
      if (transformationsBuilder_ == null) {
        transformationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ortools.sat.DecisionStrategyProto.AffineTransformation, com.google.ortools.sat.DecisionStrategyProto.AffineTransformation.Builder, com.google.ortools.sat.DecisionStrategyProto.AffineTransformationOrBuilder>(
                transformations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        transformations_ = null;
      }
      return transformationsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.DecisionStrategyProto)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.DecisionStrategyProto)
  private static final com.google.ortools.sat.DecisionStrategyProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.DecisionStrategyProto();
  }

  public static com.google.ortools.sat.DecisionStrategyProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DecisionStrategyProto>
      PARSER = new com.google.protobuf.AbstractParser<DecisionStrategyProto>() {
    @java.lang.Override
    public DecisionStrategyProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<DecisionStrategyProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DecisionStrategyProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.DecisionStrategyProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

