// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/cp_model.proto

package com.google.ortools.sat;

/**
 * <pre>
 * An integer variable.
 *
 * It will be referred to by an int32 corresponding to its index in a
 * CpModelProto variables field.
 *
 * Depending on the context, a reference to a variable whose domain is in [0, 1]
 * can also be seen as a Boolean that will be true if the variable value is 1
 * and false if it is 0. When used in this context, the field name will always
 * contain the word "literal".
 *
 * Negative reference (advanced usage): to simplify the creation of a model and
 * for efficiency reasons, all the "literal" or "variable" fields can also
 * contain a negative index. A negative index i will refer to the negation of
 * the integer variable at index -i -1 or to NOT the literal at the same index.
 *
 * Ex: A variable index 4 will refer to the integer variable model.variables(4)
 * and an index of -5 will refer to the negation of the same variable. A literal
 * index 4 will refer to the logical fact that model.variable(4) == 1 and a
 * literal index of -5 will refer to the logical fact model.variable(4) == 0.
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.IntegerVariableProto}
 */
public final class IntegerVariableProto extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.IntegerVariableProto)
    IntegerVariableProtoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use IntegerVariableProto.newBuilder() to construct.
  private IntegerVariableProto(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private IntegerVariableProto() {
    name_ = "";
    domain_ = emptyLongList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new IntegerVariableProto();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_IntegerVariableProto_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_IntegerVariableProto_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.IntegerVariableProto.class, com.google.ortools.sat.IntegerVariableProto.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * For debug/logging only. Can be empty.
   * </pre>
   *
   * <code>string name = 1;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * For debug/logging only. Can be empty.
   * </pre>
   *
   * <code>string name = 1;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList domain_;
  /**
   * <pre>
   * The variable domain given as a sorted list of n disjoint intervals
   * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
   *
   * The most common example being just [min, max].
   * If min == max, then this is a constant variable.
   *
   * We have:
   *  - domain_size() is always even.
   *  - min == domain.front();
   *  - max == domain.back();
   *  - for all i &lt; n   :      min_i &lt;= max_i
   *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
   *
   * Note that we check at validation that a variable domain is small enough so
   * that we don't run into integer overflow in our algorithms. Because of that,
   * you cannot just have "unbounded" variable like [0, kint64max] and should
   * try to specify tighter domains.
   * </pre>
   *
   * <code>repeated int64 domain = 2;</code>
   * @return A list containing the domain.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long>
      getDomainList() {
    return domain_;
  }
  /**
   * <pre>
   * The variable domain given as a sorted list of n disjoint intervals
   * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
   *
   * The most common example being just [min, max].
   * If min == max, then this is a constant variable.
   *
   * We have:
   *  - domain_size() is always even.
   *  - min == domain.front();
   *  - max == domain.back();
   *  - for all i &lt; n   :      min_i &lt;= max_i
   *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
   *
   * Note that we check at validation that a variable domain is small enough so
   * that we don't run into integer overflow in our algorithms. Because of that,
   * you cannot just have "unbounded" variable like [0, kint64max] and should
   * try to specify tighter domains.
   * </pre>
   *
   * <code>repeated int64 domain = 2;</code>
   * @return The count of domain.
   */
  public int getDomainCount() {
    return domain_.size();
  }
  /**
   * <pre>
   * The variable domain given as a sorted list of n disjoint intervals
   * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
   *
   * The most common example being just [min, max].
   * If min == max, then this is a constant variable.
   *
   * We have:
   *  - domain_size() is always even.
   *  - min == domain.front();
   *  - max == domain.back();
   *  - for all i &lt; n   :      min_i &lt;= max_i
   *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
   *
   * Note that we check at validation that a variable domain is small enough so
   * that we don't run into integer overflow in our algorithms. Because of that,
   * you cannot just have "unbounded" variable like [0, kint64max] and should
   * try to specify tighter domains.
   * </pre>
   *
   * <code>repeated int64 domain = 2;</code>
   * @param index The index of the element to return.
   * @return The domain at the given index.
   */
  public long getDomain(int index) {
    return domain_.getLong(index);
  }
  private int domainMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (getDomainList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(domainMemoizedSerializedSize);
    }
    for (int i = 0; i < domain_.size(); i++) {
      output.writeInt64NoTag(domain_.getLong(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domain_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt64SizeNoTag(domain_.getLong(i));
      }
      size += dataSize;
      if (!getDomainList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      domainMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.IntegerVariableProto)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.IntegerVariableProto other = (com.google.ortools.sat.IntegerVariableProto) obj;

    if (!getName()
        .equals(other.getName())) return false;
    if (!getDomainList()
        .equals(other.getDomainList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getDomainCount() > 0) {
      hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getDomainList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.sat.IntegerVariableProto parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.sat.IntegerVariableProto parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.IntegerVariableProto parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.IntegerVariableProto prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An integer variable.
   *
   * It will be referred to by an int32 corresponding to its index in a
   * CpModelProto variables field.
   *
   * Depending on the context, a reference to a variable whose domain is in [0, 1]
   * can also be seen as a Boolean that will be true if the variable value is 1
   * and false if it is 0. When used in this context, the field name will always
   * contain the word "literal".
   *
   * Negative reference (advanced usage): to simplify the creation of a model and
   * for efficiency reasons, all the "literal" or "variable" fields can also
   * contain a negative index. A negative index i will refer to the negation of
   * the integer variable at index -i -1 or to NOT the literal at the same index.
   *
   * Ex: A variable index 4 will refer to the integer variable model.variables(4)
   * and an index of -5 will refer to the negation of the same variable. A literal
   * index 4 will refer to the logical fact that model.variable(4) == 1 and a
   * literal index of -5 will refer to the logical fact model.variable(4) == 0.
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.IntegerVariableProto}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.IntegerVariableProto)
      com.google.ortools.sat.IntegerVariableProtoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_IntegerVariableProto_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_IntegerVariableProto_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.IntegerVariableProto.class, com.google.ortools.sat.IntegerVariableProto.Builder.class);
    }

    // Construct using com.google.ortools.sat.IntegerVariableProto.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      domain_ = emptyLongList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.CpModelProtobuf.internal_static_operations_research_sat_IntegerVariableProto_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.IntegerVariableProto getDefaultInstanceForType() {
      return com.google.ortools.sat.IntegerVariableProto.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.IntegerVariableProto build() {
      com.google.ortools.sat.IntegerVariableProto result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.IntegerVariableProto buildPartial() {
      com.google.ortools.sat.IntegerVariableProto result = new com.google.ortools.sat.IntegerVariableProto(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.sat.IntegerVariableProto result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        domain_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.domain_ = domain_;
    }

    private void buildPartial0(com.google.ortools.sat.IntegerVariableProto result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.IntegerVariableProto) {
        return mergeFrom((com.google.ortools.sat.IntegerVariableProto)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.IntegerVariableProto other) {
      if (other == com.google.ortools.sat.IntegerVariableProto.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.domain_.isEmpty()) {
        if (domain_.isEmpty()) {
          domain_ = other.domain_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureDomainIsMutable();
          domain_.addAll(other.domain_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              long v = input.readInt64();
              ensureDomainIsMutable();
              domain_.addLong(v);
              break;
            } // case 16
            case 18: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureDomainIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                domain_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            } // case 18
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * For debug/logging only. Can be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * For debug/logging only. Can be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * For debug/logging only. Can be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For debug/logging only. Can be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * For debug/logging only. Can be empty.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList domain_ = emptyLongList();
    private void ensureDomainIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        domain_ = mutableCopy(domain_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @return A list containing the domain.
     */
    public java.util.List<java.lang.Long>
        getDomainList() {
      return ((bitField0_ & 0x00000002) != 0) ?
               java.util.Collections.unmodifiableList(domain_) : domain_;
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @return The count of domain.
     */
    public int getDomainCount() {
      return domain_.size();
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @param index The index of the element to return.
     * @return The domain at the given index.
     */
    public long getDomain(int index) {
      return domain_.getLong(index);
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @param index The index to set the value at.
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(
        int index, long value) {

      ensureDomainIsMutable();
      domain_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @param value The domain to add.
     * @return This builder for chaining.
     */
    public Builder addDomain(long value) {

      ensureDomainIsMutable();
      domain_.addLong(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @param values The domain to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomain(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureDomainIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, domain_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The variable domain given as a sorted list of n disjoint intervals
     * [min, max] and encoded as [min_0, max_0,  ..., min_{n-1}, max_{n-1}].
     *
     * The most common example being just [min, max].
     * If min == max, then this is a constant variable.
     *
     * We have:
     *  - domain_size() is always even.
     *  - min == domain.front();
     *  - max == domain.back();
     *  - for all i &lt; n   :      min_i &lt;= max_i
     *  - for all i &lt; n-1 :  max_i + 1 &lt; min_{i+1}.
     *
     * Note that we check at validation that a variable domain is small enough so
     * that we don't run into integer overflow in our algorithms. Because of that,
     * you cannot just have "unbounded" variable like [0, kint64max] and should
     * try to specify tighter domains.
     * </pre>
     *
     * <code>repeated int64 domain = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      domain_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.IntegerVariableProto)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.IntegerVariableProto)
  private static final com.google.ortools.sat.IntegerVariableProto DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.IntegerVariableProto();
  }

  public static com.google.ortools.sat.IntegerVariableProto getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IntegerVariableProto>
      PARSER = new com.google.protobuf.AbstractParser<IntegerVariableProto>() {
    @java.lang.Override
    public IntegerVariableProto parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<IntegerVariableProto> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IntegerVariableProto> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.IntegerVariableProto getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

