// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/boolean_problem.proto

package com.google.ortools.sat;

/**
 * <pre>
 * A linear Boolean constraint which is a bounded sum of linear terms. Each term
 * beeing a literal times an integer coefficient. If we assume that a literal
 * takes the value 1 if it is true and 0 otherwise, the constraint is:
 *   lower_bound &lt;= ... + coefficients[i] * literals[i] + ... &lt;= upper_bound
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.LinearBooleanConstraint}
 */
public final class LinearBooleanConstraint extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.LinearBooleanConstraint)
    LinearBooleanConstraintOrBuilder {
private static final long serialVersionUID = 0L;
  // Use LinearBooleanConstraint.newBuilder() to construct.
  private LinearBooleanConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private LinearBooleanConstraint() {
    literals_ = emptyIntList();
    coefficients_ = emptyLongList();
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new LinearBooleanConstraint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanConstraint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanConstraint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.LinearBooleanConstraint.class, com.google.ortools.sat.LinearBooleanConstraint.Builder.class);
  }

  private int bitField0_;
  public static final int LITERALS_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList literals_;
  /**
   * <pre>
   * Linear terms involved in this constraint.
   *
   * literals[i] is the signed representation of the i-th literal of the
   * constraint and coefficients[i] its coefficients. The signed representation
   * is as follow: for a 0-based variable index x, (x + 1) represents the
   * variable x and -(x + 1) represents its negation.
   *
   * Note that the same variable shouldn't appear twice and that zero
   * coefficients are not allowed.
   * </pre>
   *
   * <code>repeated int32 literals = 1;</code>
   * @return A list containing the literals.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getLiteralsList() {
    return literals_;
  }
  /**
   * <pre>
   * Linear terms involved in this constraint.
   *
   * literals[i] is the signed representation of the i-th literal of the
   * constraint and coefficients[i] its coefficients. The signed representation
   * is as follow: for a 0-based variable index x, (x + 1) represents the
   * variable x and -(x + 1) represents its negation.
   *
   * Note that the same variable shouldn't appear twice and that zero
   * coefficients are not allowed.
   * </pre>
   *
   * <code>repeated int32 literals = 1;</code>
   * @return The count of literals.
   */
  public int getLiteralsCount() {
    return literals_.size();
  }
  /**
   * <pre>
   * Linear terms involved in this constraint.
   *
   * literals[i] is the signed representation of the i-th literal of the
   * constraint and coefficients[i] its coefficients. The signed representation
   * is as follow: for a 0-based variable index x, (x + 1) represents the
   * variable x and -(x + 1) represents its negation.
   *
   * Note that the same variable shouldn't appear twice and that zero
   * coefficients are not allowed.
   * </pre>
   *
   * <code>repeated int32 literals = 1;</code>
   * @param index The index of the element to return.
   * @return The literals at the given index.
   */
  public int getLiterals(int index) {
    return literals_.getInt(index);
  }

  public static final int COEFFICIENTS_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList coefficients_;
  /**
   * <code>repeated int64 coefficients = 2;</code>
   * @return A list containing the coefficients.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long>
      getCoefficientsList() {
    return coefficients_;
  }
  /**
   * <code>repeated int64 coefficients = 2;</code>
   * @return The count of coefficients.
   */
  public int getCoefficientsCount() {
    return coefficients_.size();
  }
  /**
   * <code>repeated int64 coefficients = 2;</code>
   * @param index The index of the element to return.
   * @return The coefficients at the given index.
   */
  public long getCoefficients(int index) {
    return coefficients_.getLong(index);
  }

  public static final int LOWER_BOUND_FIELD_NUMBER = 3;
  private long lowerBound_ = 0L;
  /**
   * <pre>
   * Optional lower (resp. upper) bound of the constraint. If not present, it
   * means that the constraint is not bounded in this direction. The bounds
   * are INCLUSIVE.
   * </pre>
   *
   * <code>optional int64 lower_bound = 3;</code>
   * @return Whether the lowerBound field is set.
   */
  @java.lang.Override
  public boolean hasLowerBound() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Optional lower (resp. upper) bound of the constraint. If not present, it
   * means that the constraint is not bounded in this direction. The bounds
   * are INCLUSIVE.
   * </pre>
   *
   * <code>optional int64 lower_bound = 3;</code>
   * @return The lowerBound.
   */
  @java.lang.Override
  public long getLowerBound() {
    return lowerBound_;
  }

  public static final int UPPER_BOUND_FIELD_NUMBER = 4;
  private long upperBound_ = 0L;
  /**
   * <code>optional int64 upper_bound = 4;</code>
   * @return Whether the upperBound field is set.
   */
  @java.lang.Override
  public boolean hasUpperBound() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <code>optional int64 upper_bound = 4;</code>
   * @return The upperBound.
   */
  @java.lang.Override
  public long getUpperBound() {
    return upperBound_;
  }

  public static final int NAME_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * The name of this constraint.
   * </pre>
   *
   * <code>optional string name = 5 [default = ""];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The name of this constraint.
   * </pre>
   *
   * <code>optional string name = 5 [default = ""];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        name_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * The name of this constraint.
   * </pre>
   *
   * <code>optional string name = 5 [default = ""];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < literals_.size(); i++) {
      output.writeInt32(1, literals_.getInt(i));
    }
    for (int i = 0; i < coefficients_.size(); i++) {
      output.writeInt64(2, coefficients_.getLong(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(3, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(4, upperBound_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < literals_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt32SizeNoTag(literals_.getInt(i));
      }
      size += dataSize;
      size += 1 * getLiteralsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < coefficients_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt64SizeNoTag(coefficients_.getLong(i));
      }
      size += dataSize;
      size += 1 * getCoefficientsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, lowerBound_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(4, upperBound_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.LinearBooleanConstraint)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.LinearBooleanConstraint other = (com.google.ortools.sat.LinearBooleanConstraint) obj;

    if (!getLiteralsList()
        .equals(other.getLiteralsList())) return false;
    if (!getCoefficientsList()
        .equals(other.getCoefficientsList())) return false;
    if (hasLowerBound() != other.hasLowerBound()) return false;
    if (hasLowerBound()) {
      if (getLowerBound()
          != other.getLowerBound()) return false;
    }
    if (hasUpperBound() != other.hasUpperBound()) return false;
    if (hasUpperBound()) {
      if (getUpperBound()
          != other.getUpperBound()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLiteralsCount() > 0) {
      hash = (37 * hash) + LITERALS_FIELD_NUMBER;
      hash = (53 * hash) + getLiteralsList().hashCode();
    }
    if (getCoefficientsCount() > 0) {
      hash = (37 * hash) + COEFFICIENTS_FIELD_NUMBER;
      hash = (53 * hash) + getCoefficientsList().hashCode();
    }
    if (hasLowerBound()) {
      hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getLowerBound());
    }
    if (hasUpperBound()) {
      hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getUpperBound());
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.sat.LinearBooleanConstraint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.sat.LinearBooleanConstraint parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.LinearBooleanConstraint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.LinearBooleanConstraint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A linear Boolean constraint which is a bounded sum of linear terms. Each term
   * beeing a literal times an integer coefficient. If we assume that a literal
   * takes the value 1 if it is true and 0 otherwise, the constraint is:
   *   lower_bound &lt;= ... + coefficients[i] * literals[i] + ... &lt;= upper_bound
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.LinearBooleanConstraint}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.LinearBooleanConstraint)
      com.google.ortools.sat.LinearBooleanConstraintOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanConstraint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanConstraint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.LinearBooleanConstraint.class, com.google.ortools.sat.LinearBooleanConstraint.Builder.class);
    }

    // Construct using com.google.ortools.sat.LinearBooleanConstraint.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      literals_ = emptyIntList();
      coefficients_ = emptyLongList();
      lowerBound_ = 0L;
      upperBound_ = 0L;
      name_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanConstraint_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanConstraint getDefaultInstanceForType() {
      return com.google.ortools.sat.LinearBooleanConstraint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanConstraint build() {
      com.google.ortools.sat.LinearBooleanConstraint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanConstraint buildPartial() {
      com.google.ortools.sat.LinearBooleanConstraint result = new com.google.ortools.sat.LinearBooleanConstraint(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.sat.LinearBooleanConstraint result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        literals_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.literals_ = literals_;
      if (((bitField0_ & 0x00000002) != 0)) {
        coefficients_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.coefficients_ = coefficients_;
    }

    private void buildPartial0(com.google.ortools.sat.LinearBooleanConstraint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.lowerBound_ = lowerBound_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.upperBound_ = upperBound_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.LinearBooleanConstraint) {
        return mergeFrom((com.google.ortools.sat.LinearBooleanConstraint)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.LinearBooleanConstraint other) {
      if (other == com.google.ortools.sat.LinearBooleanConstraint.getDefaultInstance()) return this;
      if (!other.literals_.isEmpty()) {
        if (literals_.isEmpty()) {
          literals_ = other.literals_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureLiteralsIsMutable();
          literals_.addAll(other.literals_);
        }
        onChanged();
      }
      if (!other.coefficients_.isEmpty()) {
        if (coefficients_.isEmpty()) {
          coefficients_ = other.coefficients_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureCoefficientsIsMutable();
          coefficients_.addAll(other.coefficients_);
        }
        onChanged();
      }
      if (other.hasLowerBound()) {
        setLowerBound(other.getLowerBound());
      }
      if (other.hasUpperBound()) {
        setUpperBound(other.getUpperBound());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              int v = input.readInt32();
              ensureLiteralsIsMutable();
              literals_.addInt(v);
              break;
            } // case 8
            case 10: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureLiteralsIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                literals_.addInt(input.readInt32());
              }
              input.popLimit(limit);
              break;
            } // case 10
            case 16: {
              long v = input.readInt64();
              ensureCoefficientsIsMutable();
              coefficients_.addLong(v);
              break;
            } // case 16
            case 18: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureCoefficientsIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                coefficients_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            } // case 18
            case 24: {
              lowerBound_ = input.readInt64();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              upperBound_ = input.readInt64();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              name_ = input.readBytes();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.Internal.IntList literals_ = emptyIntList();
    private void ensureLiteralsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        literals_ = mutableCopy(literals_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @return A list containing the literals.
     */
    public java.util.List<java.lang.Integer>
        getLiteralsList() {
      return ((bitField0_ & 0x00000001) != 0) ?
               java.util.Collections.unmodifiableList(literals_) : literals_;
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @return The count of literals.
     */
    public int getLiteralsCount() {
      return literals_.size();
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @param index The index of the element to return.
     * @return The literals at the given index.
     */
    public int getLiterals(int index) {
      return literals_.getInt(index);
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @param index The index to set the value at.
     * @param value The literals to set.
     * @return This builder for chaining.
     */
    public Builder setLiterals(
        int index, int value) {

      ensureLiteralsIsMutable();
      literals_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @param value The literals to add.
     * @return This builder for chaining.
     */
    public Builder addLiterals(int value) {

      ensureLiteralsIsMutable();
      literals_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @param values The literals to add.
     * @return This builder for chaining.
     */
    public Builder addAllLiterals(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureLiteralsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, literals_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Linear terms involved in this constraint.
     *
     * literals[i] is the signed representation of the i-th literal of the
     * constraint and coefficients[i] its coefficients. The signed representation
     * is as follow: for a 0-based variable index x, (x + 1) represents the
     * variable x and -(x + 1) represents its negation.
     *
     * Note that the same variable shouldn't appear twice and that zero
     * coefficients are not allowed.
     * </pre>
     *
     * <code>repeated int32 literals = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearLiterals() {
      literals_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList coefficients_ = emptyLongList();
    private void ensureCoefficientsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        coefficients_ = mutableCopy(coefficients_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @return A list containing the coefficients.
     */
    public java.util.List<java.lang.Long>
        getCoefficientsList() {
      return ((bitField0_ & 0x00000002) != 0) ?
               java.util.Collections.unmodifiableList(coefficients_) : coefficients_;
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @return The count of coefficients.
     */
    public int getCoefficientsCount() {
      return coefficients_.size();
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @param index The index of the element to return.
     * @return The coefficients at the given index.
     */
    public long getCoefficients(int index) {
      return coefficients_.getLong(index);
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @param index The index to set the value at.
     * @param value The coefficients to set.
     * @return This builder for chaining.
     */
    public Builder setCoefficients(
        int index, long value) {

      ensureCoefficientsIsMutable();
      coefficients_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @param value The coefficients to add.
     * @return This builder for chaining.
     */
    public Builder addCoefficients(long value) {

      ensureCoefficientsIsMutable();
      coefficients_.addLong(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @param values The coefficients to add.
     * @return This builder for chaining.
     */
    public Builder addAllCoefficients(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureCoefficientsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, coefficients_);
      onChanged();
      return this;
    }
    /**
     * <code>repeated int64 coefficients = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearCoefficients() {
      coefficients_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private long lowerBound_ ;
    /**
     * <pre>
     * Optional lower (resp. upper) bound of the constraint. If not present, it
     * means that the constraint is not bounded in this direction. The bounds
     * are INCLUSIVE.
     * </pre>
     *
     * <code>optional int64 lower_bound = 3;</code>
     * @return Whether the lowerBound field is set.
     */
    @java.lang.Override
    public boolean hasLowerBound() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Optional lower (resp. upper) bound of the constraint. If not present, it
     * means that the constraint is not bounded in this direction. The bounds
     * are INCLUSIVE.
     * </pre>
     *
     * <code>optional int64 lower_bound = 3;</code>
     * @return The lowerBound.
     */
    @java.lang.Override
    public long getLowerBound() {
      return lowerBound_;
    }
    /**
     * <pre>
     * Optional lower (resp. upper) bound of the constraint. If not present, it
     * means that the constraint is not bounded in this direction. The bounds
     * are INCLUSIVE.
     * </pre>
     *
     * <code>optional int64 lower_bound = 3;</code>
     * @param value The lowerBound to set.
     * @return This builder for chaining.
     */
    public Builder setLowerBound(long value) {

      lowerBound_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional lower (resp. upper) bound of the constraint. If not present, it
     * means that the constraint is not bounded in this direction. The bounds
     * are INCLUSIVE.
     * </pre>
     *
     * <code>optional int64 lower_bound = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearLowerBound() {
      bitField0_ = (bitField0_ & ~0x00000004);
      lowerBound_ = 0L;
      onChanged();
      return this;
    }

    private long upperBound_ ;
    /**
     * <code>optional int64 upper_bound = 4;</code>
     * @return Whether the upperBound field is set.
     */
    @java.lang.Override
    public boolean hasUpperBound() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional int64 upper_bound = 4;</code>
     * @return The upperBound.
     */
    @java.lang.Override
    public long getUpperBound() {
      return upperBound_;
    }
    /**
     * <code>optional int64 upper_bound = 4;</code>
     * @param value The upperBound to set.
     * @return This builder for chaining.
     */
    public Builder setUpperBound(long value) {

      upperBound_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <code>optional int64 upper_bound = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearUpperBound() {
      bitField0_ = (bitField0_ & ~0x00000008);
      upperBound_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of this constraint.
     * </pre>
     *
     * <code>optional string name = 5 [default = ""];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.LinearBooleanConstraint)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.LinearBooleanConstraint)
  private static final com.google.ortools.sat.LinearBooleanConstraint DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.LinearBooleanConstraint();
  }

  public static com.google.ortools.sat.LinearBooleanConstraint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<LinearBooleanConstraint>
      PARSER = new com.google.protobuf.AbstractParser<LinearBooleanConstraint>() {
    @java.lang.Override
    public LinearBooleanConstraint parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<LinearBooleanConstraint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LinearBooleanConstraint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.LinearBooleanConstraint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

