// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ortools/sat/boolean_problem.proto

package com.google.ortools.sat;

/**
 * <pre>
 * A linear Boolean problem.
 * </pre>
 *
 * Protobuf type {@code operations_research.sat.LinearBooleanProblem}
 */
public final class LinearBooleanProblem extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:operations_research.sat.LinearBooleanProblem)
    LinearBooleanProblemOrBuilder {
private static final long serialVersionUID = 0L;
  // Use LinearBooleanProblem.newBuilder() to construct.
  private LinearBooleanProblem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private LinearBooleanProblem() {
    name_ = "";
    constraints_ = java.util.Collections.emptyList();
    varNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new LinearBooleanProblem();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanProblem_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanProblem_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ortools.sat.LinearBooleanProblem.class, com.google.ortools.sat.LinearBooleanProblem.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * The name of the problem.
   * </pre>
   *
   * <code>optional string name = 1 [default = ""];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * The name of the problem.
   * </pre>
   *
   * <code>optional string name = 1 [default = ""];</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (bs.isValidUtf8()) {
        name_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * The name of the problem.
   * </pre>
   *
   * <code>optional string name = 1 [default = ""];</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUM_VARIABLES_FIELD_NUMBER = 3;
  private int numVariables_ = 0;
  /**
   * <pre>
   * The number of variables in the problem.
   * All the signed representation of the problem literals must be in
   * [-num_variables, num_variables], excluding 0.
   * </pre>
   *
   * <code>optional int32 num_variables = 3;</code>
   * @return Whether the numVariables field is set.
   */
  @java.lang.Override
  public boolean hasNumVariables() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * The number of variables in the problem.
   * All the signed representation of the problem literals must be in
   * [-num_variables, num_variables], excluding 0.
   * </pre>
   *
   * <code>optional int32 num_variables = 3;</code>
   * @return The numVariables.
   */
  @java.lang.Override
  public int getNumVariables() {
    return numVariables_;
  }

  public static final int CONSTRAINTS_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ortools.sat.LinearBooleanConstraint> constraints_;
  /**
   * <pre>
   * The constraints of the problem.
   * </pre>
   *
   * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ortools.sat.LinearBooleanConstraint> getConstraintsList() {
    return constraints_;
  }
  /**
   * <pre>
   * The constraints of the problem.
   * </pre>
   *
   * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ortools.sat.LinearBooleanConstraintOrBuilder> 
      getConstraintsOrBuilderList() {
    return constraints_;
  }
  /**
   * <pre>
   * The constraints of the problem.
   * </pre>
   *
   * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public int getConstraintsCount() {
    return constraints_.size();
  }
  /**
   * <pre>
   * The constraints of the problem.
   * </pre>
   *
   * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.LinearBooleanConstraint getConstraints(int index) {
    return constraints_.get(index);
  }
  /**
   * <pre>
   * The constraints of the problem.
   * </pre>
   *
   * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.LinearBooleanConstraintOrBuilder getConstraintsOrBuilder(
      int index) {
    return constraints_.get(index);
  }

  public static final int OBJECTIVE_FIELD_NUMBER = 5;
  private com.google.ortools.sat.LinearObjective objective_;
  /**
   * <pre>
   * The objective of the problem.
   * If left empty, we just have a satisfiability problem.
   * </pre>
   *
   * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
   * @return Whether the objective field is set.
   */
  @java.lang.Override
  public boolean hasObjective() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * The objective of the problem.
   * If left empty, we just have a satisfiability problem.
   * </pre>
   *
   * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
   * @return The objective.
   */
  @java.lang.Override
  public com.google.ortools.sat.LinearObjective getObjective() {
    return objective_ == null ? com.google.ortools.sat.LinearObjective.getDefaultInstance() : objective_;
  }
  /**
   * <pre>
   * The objective of the problem.
   * If left empty, we just have a satisfiability problem.
   * </pre>
   *
   * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.LinearObjectiveOrBuilder getObjectiveOrBuilder() {
    return objective_ == null ? com.google.ortools.sat.LinearObjective.getDefaultInstance() : objective_;
  }

  public static final int VAR_NAMES_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList varNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * The names of the problem variables. The variables index are 0-based and
   * var_names[i] will be the name of the i-th variable which correspond to
   * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
   * </pre>
   *
   * <code>repeated string var_names = 6;</code>
   * @return A list containing the varNames.
   */
  public com.google.protobuf.ProtocolStringList
      getVarNamesList() {
    return varNames_;
  }
  /**
   * <pre>
   * The names of the problem variables. The variables index are 0-based and
   * var_names[i] will be the name of the i-th variable which correspond to
   * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
   * </pre>
   *
   * <code>repeated string var_names = 6;</code>
   * @return The count of varNames.
   */
  public int getVarNamesCount() {
    return varNames_.size();
  }
  /**
   * <pre>
   * The names of the problem variables. The variables index are 0-based and
   * var_names[i] will be the name of the i-th variable which correspond to
   * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
   * </pre>
   *
   * <code>repeated string var_names = 6;</code>
   * @param index The index of the element to return.
   * @return The varNames at the given index.
   */
  public java.lang.String getVarNames(int index) {
    return varNames_.get(index);
  }
  /**
   * <pre>
   * The names of the problem variables. The variables index are 0-based and
   * var_names[i] will be the name of the i-th variable which correspond to
   * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
   * </pre>
   *
   * <code>repeated string var_names = 6;</code>
   * @param index The index of the value to return.
   * @return The bytes of the varNames at the given index.
   */
  public com.google.protobuf.ByteString
      getVarNamesBytes(int index) {
    return varNames_.getByteString(index);
  }

  public static final int ASSIGNMENT_FIELD_NUMBER = 7;
  private com.google.ortools.sat.BooleanAssignment assignment_;
  /**
   * <pre>
   * Stores an assignment of the problem variables. That may be an initial
   * feasible solution, just a partial assignment or the optimal solution.
   * </pre>
   *
   * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
   * @return Whether the assignment field is set.
   */
  @java.lang.Override
  public boolean hasAssignment() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Stores an assignment of the problem variables. That may be an initial
   * feasible solution, just a partial assignment or the optimal solution.
   * </pre>
   *
   * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
   * @return The assignment.
   */
  @java.lang.Override
  public com.google.ortools.sat.BooleanAssignment getAssignment() {
    return assignment_ == null ? com.google.ortools.sat.BooleanAssignment.getDefaultInstance() : assignment_;
  }
  /**
   * <pre>
   * Stores an assignment of the problem variables. That may be an initial
   * feasible solution, just a partial assignment or the optimal solution.
   * </pre>
   *
   * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
   */
  @java.lang.Override
  public com.google.ortools.sat.BooleanAssignmentOrBuilder getAssignmentOrBuilder() {
    return assignment_ == null ? com.google.ortools.sat.BooleanAssignment.getDefaultInstance() : assignment_;
  }

  public static final int ORIGINAL_NUM_VARIABLES_FIELD_NUMBER = 8;
  private int originalNumVariables_ = 0;
  /**
   * <pre>
   * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
   * variables need to be created. This stores the number of variables in the
   * original problem (which are in one to one correspondence with the first
   * variables of this problem).
   * </pre>
   *
   * <code>optional int32 original_num_variables = 8;</code>
   * @return Whether the originalNumVariables field is set.
   */
  @java.lang.Override
  public boolean hasOriginalNumVariables() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
   * variables need to be created. This stores the number of variables in the
   * original problem (which are in one to one correspondence with the first
   * variables of this problem).
   * </pre>
   *
   * <code>optional int32 original_num_variables = 8;</code>
   * @return The originalNumVariables.
   */
  @java.lang.Override
  public int getOriginalNumVariables() {
    return originalNumVariables_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(3, numVariables_);
    }
    for (int i = 0; i < constraints_.size(); i++) {
      output.writeMessage(4, constraints_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getObjective());
    }
    for (int i = 0; i < varNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, varNames_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getAssignment());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(8, originalNumVariables_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(3, numVariables_);
    }
    for (int i = 0; i < constraints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, constraints_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getObjective());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < varNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(varNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getVarNamesList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getAssignment());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(8, originalNumVariables_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ortools.sat.LinearBooleanProblem)) {
      return super.equals(obj);
    }
    com.google.ortools.sat.LinearBooleanProblem other = (com.google.ortools.sat.LinearBooleanProblem) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (hasNumVariables() != other.hasNumVariables()) return false;
    if (hasNumVariables()) {
      if (getNumVariables()
          != other.getNumVariables()) return false;
    }
    if (!getConstraintsList()
        .equals(other.getConstraintsList())) return false;
    if (hasObjective() != other.hasObjective()) return false;
    if (hasObjective()) {
      if (!getObjective()
          .equals(other.getObjective())) return false;
    }
    if (!getVarNamesList()
        .equals(other.getVarNamesList())) return false;
    if (hasAssignment() != other.hasAssignment()) return false;
    if (hasAssignment()) {
      if (!getAssignment()
          .equals(other.getAssignment())) return false;
    }
    if (hasOriginalNumVariables() != other.hasOriginalNumVariables()) return false;
    if (hasOriginalNumVariables()) {
      if (getOriginalNumVariables()
          != other.getOriginalNumVariables()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNumVariables()) {
      hash = (37 * hash) + NUM_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getNumVariables();
    }
    if (getConstraintsCount() > 0) {
      hash = (37 * hash) + CONSTRAINTS_FIELD_NUMBER;
      hash = (53 * hash) + getConstraintsList().hashCode();
    }
    if (hasObjective()) {
      hash = (37 * hash) + OBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getObjective().hashCode();
    }
    if (getVarNamesCount() > 0) {
      hash = (37 * hash) + VAR_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getVarNamesList().hashCode();
    }
    if (hasAssignment()) {
      hash = (37 * hash) + ASSIGNMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAssignment().hashCode();
    }
    if (hasOriginalNumVariables()) {
      hash = (37 * hash) + ORIGINAL_NUM_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalNumVariables();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ortools.sat.LinearBooleanProblem parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ortools.sat.LinearBooleanProblem parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ortools.sat.LinearBooleanProblem parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ortools.sat.LinearBooleanProblem prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A linear Boolean problem.
   * </pre>
   *
   * Protobuf type {@code operations_research.sat.LinearBooleanProblem}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:operations_research.sat.LinearBooleanProblem)
      com.google.ortools.sat.LinearBooleanProblemOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanProblem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanProblem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ortools.sat.LinearBooleanProblem.class, com.google.ortools.sat.LinearBooleanProblem.Builder.class);
    }

    // Construct using com.google.ortools.sat.LinearBooleanProblem.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getConstraintsFieldBuilder();
        getObjectiveFieldBuilder();
        getAssignmentFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      numVariables_ = 0;
      if (constraintsBuilder_ == null) {
        constraints_ = java.util.Collections.emptyList();
      } else {
        constraints_ = null;
        constraintsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      objective_ = null;
      if (objectiveBuilder_ != null) {
        objectiveBuilder_.dispose();
        objectiveBuilder_ = null;
      }
      varNames_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      assignment_ = null;
      if (assignmentBuilder_ != null) {
        assignmentBuilder_.dispose();
        assignmentBuilder_ = null;
      }
      originalNumVariables_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ortools.sat.BooleanProblem.internal_static_operations_research_sat_LinearBooleanProblem_descriptor;
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanProblem getDefaultInstanceForType() {
      return com.google.ortools.sat.LinearBooleanProblem.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanProblem build() {
      com.google.ortools.sat.LinearBooleanProblem result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ortools.sat.LinearBooleanProblem buildPartial() {
      com.google.ortools.sat.LinearBooleanProblem result = new com.google.ortools.sat.LinearBooleanProblem(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ortools.sat.LinearBooleanProblem result) {
      if (constraintsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          constraints_ = java.util.Collections.unmodifiableList(constraints_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.constraints_ = constraints_;
      } else {
        result.constraints_ = constraintsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ortools.sat.LinearBooleanProblem result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.numVariables_ = numVariables_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.objective_ = objectiveBuilder_ == null
            ? objective_
            : objectiveBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        varNames_.makeImmutable();
        result.varNames_ = varNames_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.assignment_ = assignmentBuilder_ == null
            ? assignment_
            : assignmentBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.originalNumVariables_ = originalNumVariables_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ortools.sat.LinearBooleanProblem) {
        return mergeFrom((com.google.ortools.sat.LinearBooleanProblem)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ortools.sat.LinearBooleanProblem other) {
      if (other == com.google.ortools.sat.LinearBooleanProblem.getDefaultInstance()) return this;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasNumVariables()) {
        setNumVariables(other.getNumVariables());
      }
      if (constraintsBuilder_ == null) {
        if (!other.constraints_.isEmpty()) {
          if (constraints_.isEmpty()) {
            constraints_ = other.constraints_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConstraintsIsMutable();
            constraints_.addAll(other.constraints_);
          }
          onChanged();
        }
      } else {
        if (!other.constraints_.isEmpty()) {
          if (constraintsBuilder_.isEmpty()) {
            constraintsBuilder_.dispose();
            constraintsBuilder_ = null;
            constraints_ = other.constraints_;
            bitField0_ = (bitField0_ & ~0x00000004);
            constraintsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getConstraintsFieldBuilder() : null;
          } else {
            constraintsBuilder_.addAllMessages(other.constraints_);
          }
        }
      }
      if (other.hasObjective()) {
        mergeObjective(other.getObjective());
      }
      if (!other.varNames_.isEmpty()) {
        if (varNames_.isEmpty()) {
          varNames_ = other.varNames_;
          bitField0_ |= 0x00000010;
        } else {
          ensureVarNamesIsMutable();
          varNames_.addAll(other.varNames_);
        }
        onChanged();
      }
      if (other.hasAssignment()) {
        mergeAssignment(other.getAssignment());
      }
      if (other.hasOriginalNumVariables()) {
        setOriginalNumVariables(other.getOriginalNumVariables());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              name_ = input.readBytes();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 24: {
              numVariables_ = input.readInt32();
              bitField0_ |= 0x00000002;
              break;
            } // case 24
            case 34: {
              com.google.ortools.sat.LinearBooleanConstraint m =
                  input.readMessage(
                      com.google.ortools.sat.LinearBooleanConstraint.PARSER,
                      extensionRegistry);
              if (constraintsBuilder_ == null) {
                ensureConstraintsIsMutable();
                constraints_.add(m);
              } else {
                constraintsBuilder_.addMessage(m);
              }
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getObjectiveFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000008;
              break;
            } // case 42
            case 50: {
              com.google.protobuf.ByteString bs = input.readBytes();
              ensureVarNamesIsMutable();
              varNames_.add(bs);
              break;
            } // case 50
            case 58: {
              input.readMessage(
                  getAssignmentFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000020;
              break;
            } // case 58
            case 64: {
              originalNumVariables_ = input.readInt32();
              bitField0_ |= 0x00000040;
              break;
            } // case 64
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The name of the problem.
     * </pre>
     *
     * <code>optional string name = 1 [default = ""];</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int numVariables_ ;
    /**
     * <pre>
     * The number of variables in the problem.
     * All the signed representation of the problem literals must be in
     * [-num_variables, num_variables], excluding 0.
     * </pre>
     *
     * <code>optional int32 num_variables = 3;</code>
     * @return Whether the numVariables field is set.
     */
    @java.lang.Override
    public boolean hasNumVariables() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The number of variables in the problem.
     * All the signed representation of the problem literals must be in
     * [-num_variables, num_variables], excluding 0.
     * </pre>
     *
     * <code>optional int32 num_variables = 3;</code>
     * @return The numVariables.
     */
    @java.lang.Override
    public int getNumVariables() {
      return numVariables_;
    }
    /**
     * <pre>
     * The number of variables in the problem.
     * All the signed representation of the problem literals must be in
     * [-num_variables, num_variables], excluding 0.
     * </pre>
     *
     * <code>optional int32 num_variables = 3;</code>
     * @param value The numVariables to set.
     * @return This builder for chaining.
     */
    public Builder setNumVariables(int value) {

      numVariables_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of variables in the problem.
     * All the signed representation of the problem literals must be in
     * [-num_variables, num_variables], excluding 0.
     * </pre>
     *
     * <code>optional int32 num_variables = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearNumVariables() {
      bitField0_ = (bitField0_ & ~0x00000002);
      numVariables_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ortools.sat.LinearBooleanConstraint> constraints_ =
      java.util.Collections.emptyList();
    private void ensureConstraintsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        constraints_ = new java.util.ArrayList<com.google.ortools.sat.LinearBooleanConstraint>(constraints_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.sat.LinearBooleanConstraint, com.google.ortools.sat.LinearBooleanConstraint.Builder, com.google.ortools.sat.LinearBooleanConstraintOrBuilder> constraintsBuilder_;

    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public java.util.List<com.google.ortools.sat.LinearBooleanConstraint> getConstraintsList() {
      if (constraintsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(constraints_);
      } else {
        return constraintsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public int getConstraintsCount() {
      if (constraintsBuilder_ == null) {
        return constraints_.size();
      } else {
        return constraintsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public com.google.ortools.sat.LinearBooleanConstraint getConstraints(int index) {
      if (constraintsBuilder_ == null) {
        return constraints_.get(index);
      } else {
        return constraintsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder setConstraints(
        int index, com.google.ortools.sat.LinearBooleanConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.set(index, value);
        onChanged();
      } else {
        constraintsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder setConstraints(
        int index, com.google.ortools.sat.LinearBooleanConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.set(index, builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder addConstraints(com.google.ortools.sat.LinearBooleanConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.add(value);
        onChanged();
      } else {
        constraintsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        int index, com.google.ortools.sat.LinearBooleanConstraint value) {
      if (constraintsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConstraintsIsMutable();
        constraints_.add(index, value);
        onChanged();
      } else {
        constraintsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        com.google.ortools.sat.LinearBooleanConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.add(builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder addConstraints(
        int index, com.google.ortools.sat.LinearBooleanConstraint.Builder builderForValue) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.add(index, builderForValue.build());
        onChanged();
      } else {
        constraintsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder addAllConstraints(
        java.lang.Iterable<? extends com.google.ortools.sat.LinearBooleanConstraint> values) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, constraints_);
        onChanged();
      } else {
        constraintsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder clearConstraints() {
      if (constraintsBuilder_ == null) {
        constraints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        constraintsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public Builder removeConstraints(int index) {
      if (constraintsBuilder_ == null) {
        ensureConstraintsIsMutable();
        constraints_.remove(index);
        onChanged();
      } else {
        constraintsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public com.google.ortools.sat.LinearBooleanConstraint.Builder getConstraintsBuilder(
        int index) {
      return getConstraintsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public com.google.ortools.sat.LinearBooleanConstraintOrBuilder getConstraintsOrBuilder(
        int index) {
      if (constraintsBuilder_ == null) {
        return constraints_.get(index);  } else {
        return constraintsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public java.util.List<? extends com.google.ortools.sat.LinearBooleanConstraintOrBuilder> 
         getConstraintsOrBuilderList() {
      if (constraintsBuilder_ != null) {
        return constraintsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(constraints_);
      }
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public com.google.ortools.sat.LinearBooleanConstraint.Builder addConstraintsBuilder() {
      return getConstraintsFieldBuilder().addBuilder(
          com.google.ortools.sat.LinearBooleanConstraint.getDefaultInstance());
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public com.google.ortools.sat.LinearBooleanConstraint.Builder addConstraintsBuilder(
        int index) {
      return getConstraintsFieldBuilder().addBuilder(
          index, com.google.ortools.sat.LinearBooleanConstraint.getDefaultInstance());
    }
    /**
     * <pre>
     * The constraints of the problem.
     * </pre>
     *
     * <code>repeated .operations_research.sat.LinearBooleanConstraint constraints = 4;</code>
     */
    public java.util.List<com.google.ortools.sat.LinearBooleanConstraint.Builder> 
         getConstraintsBuilderList() {
      return getConstraintsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ortools.sat.LinearBooleanConstraint, com.google.ortools.sat.LinearBooleanConstraint.Builder, com.google.ortools.sat.LinearBooleanConstraintOrBuilder> 
        getConstraintsFieldBuilder() {
      if (constraintsBuilder_ == null) {
        constraintsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ortools.sat.LinearBooleanConstraint, com.google.ortools.sat.LinearBooleanConstraint.Builder, com.google.ortools.sat.LinearBooleanConstraintOrBuilder>(
                constraints_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        constraints_ = null;
      }
      return constraintsBuilder_;
    }

    private com.google.ortools.sat.LinearObjective objective_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.sat.LinearObjective, com.google.ortools.sat.LinearObjective.Builder, com.google.ortools.sat.LinearObjectiveOrBuilder> objectiveBuilder_;
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     * @return Whether the objective field is set.
     */
    public boolean hasObjective() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     * @return The objective.
     */
    public com.google.ortools.sat.LinearObjective getObjective() {
      if (objectiveBuilder_ == null) {
        return objective_ == null ? com.google.ortools.sat.LinearObjective.getDefaultInstance() : objective_;
      } else {
        return objectiveBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public Builder setObjective(com.google.ortools.sat.LinearObjective value) {
      if (objectiveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objective_ = value;
      } else {
        objectiveBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public Builder setObjective(
        com.google.ortools.sat.LinearObjective.Builder builderForValue) {
      if (objectiveBuilder_ == null) {
        objective_ = builderForValue.build();
      } else {
        objectiveBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public Builder mergeObjective(com.google.ortools.sat.LinearObjective value) {
      if (objectiveBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
          objective_ != null &&
          objective_ != com.google.ortools.sat.LinearObjective.getDefaultInstance()) {
          getObjectiveBuilder().mergeFrom(value);
        } else {
          objective_ = value;
        }
      } else {
        objectiveBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public Builder clearObjective() {
      bitField0_ = (bitField0_ & ~0x00000008);
      objective_ = null;
      if (objectiveBuilder_ != null) {
        objectiveBuilder_.dispose();
        objectiveBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public com.google.ortools.sat.LinearObjective.Builder getObjectiveBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getObjectiveFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    public com.google.ortools.sat.LinearObjectiveOrBuilder getObjectiveOrBuilder() {
      if (objectiveBuilder_ != null) {
        return objectiveBuilder_.getMessageOrBuilder();
      } else {
        return objective_ == null ?
            com.google.ortools.sat.LinearObjective.getDefaultInstance() : objective_;
      }
    }
    /**
     * <pre>
     * The objective of the problem.
     * If left empty, we just have a satisfiability problem.
     * </pre>
     *
     * <code>optional .operations_research.sat.LinearObjective objective = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.sat.LinearObjective, com.google.ortools.sat.LinearObjective.Builder, com.google.ortools.sat.LinearObjectiveOrBuilder> 
        getObjectiveFieldBuilder() {
      if (objectiveBuilder_ == null) {
        objectiveBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ortools.sat.LinearObjective, com.google.ortools.sat.LinearObjective.Builder, com.google.ortools.sat.LinearObjectiveOrBuilder>(
                getObjective(),
                getParentForChildren(),
                isClean());
        objective_ = null;
      }
      return objectiveBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList varNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureVarNamesIsMutable() {
      if (!varNames_.isModifiable()) {
        varNames_ = new com.google.protobuf.LazyStringArrayList(varNames_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @return A list containing the varNames.
     */
    public com.google.protobuf.ProtocolStringList
        getVarNamesList() {
      varNames_.makeImmutable();
      return varNames_;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @return The count of varNames.
     */
    public int getVarNamesCount() {
      return varNames_.size();
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param index The index of the element to return.
     * @return The varNames at the given index.
     */
    public java.lang.String getVarNames(int index) {
      return varNames_.get(index);
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param index The index of the value to return.
     * @return The bytes of the varNames at the given index.
     */
    public com.google.protobuf.ByteString
        getVarNamesBytes(int index) {
      return varNames_.getByteString(index);
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param index The index to set the value at.
     * @param value The varNames to set.
     * @return This builder for chaining.
     */
    public Builder setVarNames(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureVarNamesIsMutable();
      varNames_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param value The varNames to add.
     * @return This builder for chaining.
     */
    public Builder addVarNames(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureVarNamesIsMutable();
      varNames_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param values The varNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllVarNames(
        java.lang.Iterable<java.lang.String> values) {
      ensureVarNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, varNames_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearVarNames() {
      varNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The names of the problem variables. The variables index are 0-based and
     * var_names[i] will be the name of the i-th variable which correspond to
     * literals +(i + 1) or -(i + 1). This is optional and can be left empty.
     * </pre>
     *
     * <code>repeated string var_names = 6;</code>
     * @param value The bytes of the varNames to add.
     * @return This builder for chaining.
     */
    public Builder addVarNamesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      ensureVarNamesIsMutable();
      varNames_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.ortools.sat.BooleanAssignment assignment_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.sat.BooleanAssignment, com.google.ortools.sat.BooleanAssignment.Builder, com.google.ortools.sat.BooleanAssignmentOrBuilder> assignmentBuilder_;
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     * @return Whether the assignment field is set.
     */
    public boolean hasAssignment() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     * @return The assignment.
     */
    public com.google.ortools.sat.BooleanAssignment getAssignment() {
      if (assignmentBuilder_ == null) {
        return assignment_ == null ? com.google.ortools.sat.BooleanAssignment.getDefaultInstance() : assignment_;
      } else {
        return assignmentBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public Builder setAssignment(com.google.ortools.sat.BooleanAssignment value) {
      if (assignmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assignment_ = value;
      } else {
        assignmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public Builder setAssignment(
        com.google.ortools.sat.BooleanAssignment.Builder builderForValue) {
      if (assignmentBuilder_ == null) {
        assignment_ = builderForValue.build();
      } else {
        assignmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public Builder mergeAssignment(com.google.ortools.sat.BooleanAssignment value) {
      if (assignmentBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0) &&
          assignment_ != null &&
          assignment_ != com.google.ortools.sat.BooleanAssignment.getDefaultInstance()) {
          getAssignmentBuilder().mergeFrom(value);
        } else {
          assignment_ = value;
        }
      } else {
        assignmentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public Builder clearAssignment() {
      bitField0_ = (bitField0_ & ~0x00000020);
      assignment_ = null;
      if (assignmentBuilder_ != null) {
        assignmentBuilder_.dispose();
        assignmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public com.google.ortools.sat.BooleanAssignment.Builder getAssignmentBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAssignmentFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    public com.google.ortools.sat.BooleanAssignmentOrBuilder getAssignmentOrBuilder() {
      if (assignmentBuilder_ != null) {
        return assignmentBuilder_.getMessageOrBuilder();
      } else {
        return assignment_ == null ?
            com.google.ortools.sat.BooleanAssignment.getDefaultInstance() : assignment_;
      }
    }
    /**
     * <pre>
     * Stores an assignment of the problem variables. That may be an initial
     * feasible solution, just a partial assignment or the optimal solution.
     * </pre>
     *
     * <code>optional .operations_research.sat.BooleanAssignment assignment = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ortools.sat.BooleanAssignment, com.google.ortools.sat.BooleanAssignment.Builder, com.google.ortools.sat.BooleanAssignmentOrBuilder> 
        getAssignmentFieldBuilder() {
      if (assignmentBuilder_ == null) {
        assignmentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ortools.sat.BooleanAssignment, com.google.ortools.sat.BooleanAssignment.Builder, com.google.ortools.sat.BooleanAssignmentOrBuilder>(
                getAssignment(),
                getParentForChildren(),
                isClean());
        assignment_ = null;
      }
      return assignmentBuilder_;
    }

    private int originalNumVariables_ ;
    /**
     * <pre>
     * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
     * variables need to be created. This stores the number of variables in the
     * original problem (which are in one to one correspondence with the first
     * variables of this problem).
     * </pre>
     *
     * <code>optional int32 original_num_variables = 8;</code>
     * @return Whether the originalNumVariables field is set.
     */
    @java.lang.Override
    public boolean hasOriginalNumVariables() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
     * variables need to be created. This stores the number of variables in the
     * original problem (which are in one to one correspondence with the first
     * variables of this problem).
     * </pre>
     *
     * <code>optional int32 original_num_variables = 8;</code>
     * @return The originalNumVariables.
     */
    @java.lang.Override
    public int getOriginalNumVariables() {
      return originalNumVariables_;
    }
    /**
     * <pre>
     * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
     * variables need to be created. This stores the number of variables in the
     * original problem (which are in one to one correspondence with the first
     * variables of this problem).
     * </pre>
     *
     * <code>optional int32 original_num_variables = 8;</code>
     * @param value The originalNumVariables to set.
     * @return This builder for chaining.
     */
    public Builder setOriginalNumVariables(int value) {

      originalNumVariables_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hack: When converting a wcnf formulat to a LinearBooleanProblem, extra
     * variables need to be created. This stores the number of variables in the
     * original problem (which are in one to one correspondence with the first
     * variables of this problem).
     * </pre>
     *
     * <code>optional int32 original_num_variables = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearOriginalNumVariables() {
      bitField0_ = (bitField0_ & ~0x00000040);
      originalNumVariables_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:operations_research.sat.LinearBooleanProblem)
  }

  // @@protoc_insertion_point(class_scope:operations_research.sat.LinearBooleanProblem)
  private static final com.google.ortools.sat.LinearBooleanProblem DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ortools.sat.LinearBooleanProblem();
  }

  public static com.google.ortools.sat.LinearBooleanProblem getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  @java.lang.Deprecated public static final com.google.protobuf.Parser<LinearBooleanProblem>
      PARSER = new com.google.protobuf.AbstractParser<LinearBooleanProblem>() {
    @java.lang.Override
    public LinearBooleanProblem parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<LinearBooleanProblem> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LinearBooleanProblem> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ortools.sat.LinearBooleanProblem getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

