package com.google.privacy.differentialprivacy;

import javax.annotation.Nullable;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_BoundedQuantiles_Params extends BoundedQuantiles.Params {

  private final Noise noise;

  private final double epsilon;

  private final Double delta;

  private final int maxPartitionsContributed;

  private final int maxContributionsPerPartition;

  private final double lower;

  private final double upper;

  private final int treeHeight;

  private final int branchingFactor;

  private AutoValue_BoundedQuantiles_Params(
      Noise noise,
      double epsilon,
      @Nullable Double delta,
      int maxPartitionsContributed,
      int maxContributionsPerPartition,
      double lower,
      double upper,
      int treeHeight,
      int branchingFactor) {
    this.noise = noise;
    this.epsilon = epsilon;
    this.delta = delta;
    this.maxPartitionsContributed = maxPartitionsContributed;
    this.maxContributionsPerPartition = maxContributionsPerPartition;
    this.lower = lower;
    this.upper = upper;
    this.treeHeight = treeHeight;
    this.branchingFactor = branchingFactor;
  }

  @Override
  Noise noise() {
    return noise;
  }

  @Override
  double epsilon() {
    return epsilon;
  }

  @Nullable
  @Override
  Double delta() {
    return delta;
  }

  @Override
  int maxPartitionsContributed() {
    return maxPartitionsContributed;
  }

  @Override
  int maxContributionsPerPartition() {
    return maxContributionsPerPartition;
  }

  @Override
  double lower() {
    return lower;
  }

  @Override
  double upper() {
    return upper;
  }

  @Override
  int treeHeight() {
    return treeHeight;
  }

  @Override
  int branchingFactor() {
    return branchingFactor;
  }

  @Override
  public String toString() {
    return "Params{"
        + "noise=" + noise + ", "
        + "epsilon=" + epsilon + ", "
        + "delta=" + delta + ", "
        + "maxPartitionsContributed=" + maxPartitionsContributed + ", "
        + "maxContributionsPerPartition=" + maxContributionsPerPartition + ", "
        + "lower=" + lower + ", "
        + "upper=" + upper + ", "
        + "treeHeight=" + treeHeight + ", "
        + "branchingFactor=" + branchingFactor
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BoundedQuantiles.Params) {
      BoundedQuantiles.Params that = (BoundedQuantiles.Params) o;
      return this.noise.equals(that.noise())
          && Double.doubleToLongBits(this.epsilon) == Double.doubleToLongBits(that.epsilon())
          && (this.delta == null ? that.delta() == null : this.delta.equals(that.delta()))
          && this.maxPartitionsContributed == that.maxPartitionsContributed()
          && this.maxContributionsPerPartition == that.maxContributionsPerPartition()
          && Double.doubleToLongBits(this.lower) == Double.doubleToLongBits(that.lower())
          && Double.doubleToLongBits(this.upper) == Double.doubleToLongBits(that.upper())
          && this.treeHeight == that.treeHeight()
          && this.branchingFactor == that.branchingFactor();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= noise.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(epsilon) >>> 32) ^ Double.doubleToLongBits(epsilon));
    h$ *= 1000003;
    h$ ^= (delta == null) ? 0 : delta.hashCode();
    h$ *= 1000003;
    h$ ^= maxPartitionsContributed;
    h$ *= 1000003;
    h$ ^= maxContributionsPerPartition;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(lower) >>> 32) ^ Double.doubleToLongBits(lower));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(upper) >>> 32) ^ Double.doubleToLongBits(upper));
    h$ *= 1000003;
    h$ ^= treeHeight;
    h$ *= 1000003;
    h$ ^= branchingFactor;
    return h$;
  }

  static final class Builder extends BoundedQuantiles.Params.Builder {
    private Noise noise;
    private Double epsilon;
    private Double delta;
    private Integer maxPartitionsContributed;
    private Integer maxContributionsPerPartition;
    private Double lower;
    private Double upper;
    private Integer treeHeight;
    private Integer branchingFactor;
    Builder() {
    }
    @Override
    public BoundedQuantiles.Params.Builder noise(Noise noise) {
      if (noise == null) {
        throw new NullPointerException("Null noise");
      }
      this.noise = noise;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder epsilon(double epsilon) {
      this.epsilon = epsilon;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder delta(@Nullable Double delta) {
      this.delta = delta;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder maxPartitionsContributed(int maxPartitionsContributed) {
      this.maxPartitionsContributed = maxPartitionsContributed;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder maxContributionsPerPartition(int maxContributionsPerPartition) {
      this.maxContributionsPerPartition = maxContributionsPerPartition;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder lower(double lower) {
      this.lower = lower;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder upper(double upper) {
      this.upper = upper;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder treeHeight(int treeHeight) {
      this.treeHeight = treeHeight;
      return this;
    }
    @Override
    public BoundedQuantiles.Params.Builder branchingFactor(int branchingFactor) {
      this.branchingFactor = branchingFactor;
      return this;
    }
    @Override
    BoundedQuantiles.Params autoBuild() {
      String missing = "";
      if (this.noise == null) {
        missing += " noise";
      }
      if (this.epsilon == null) {
        missing += " epsilon";
      }
      if (this.maxPartitionsContributed == null) {
        missing += " maxPartitionsContributed";
      }
      if (this.maxContributionsPerPartition == null) {
        missing += " maxContributionsPerPartition";
      }
      if (this.lower == null) {
        missing += " lower";
      }
      if (this.upper == null) {
        missing += " upper";
      }
      if (this.treeHeight == null) {
        missing += " treeHeight";
      }
      if (this.branchingFactor == null) {
        missing += " branchingFactor";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BoundedQuantiles_Params(
          this.noise,
          this.epsilon,
          this.delta,
          this.maxPartitionsContributed,
          this.maxContributionsPerPartition,
          this.lower,
          this.upper,
          this.treeHeight,
          this.branchingFactor);
    }
  }

}
