package com.google.privacy.differentialprivacy;

import javax.annotation.Nullable;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_BoundedSum_Params extends BoundedSum.Params {

  private final Noise noise;

  private final double epsilon;

  private final Double delta;

  private final int maxPartitionsContributed;

  private final int maxContributionsPerPartition;

  private final double lower;

  private final double upper;

  private AutoValue_BoundedSum_Params(
      Noise noise,
      double epsilon,
      @Nullable Double delta,
      int maxPartitionsContributed,
      int maxContributionsPerPartition,
      double lower,
      double upper) {
    this.noise = noise;
    this.epsilon = epsilon;
    this.delta = delta;
    this.maxPartitionsContributed = maxPartitionsContributed;
    this.maxContributionsPerPartition = maxContributionsPerPartition;
    this.lower = lower;
    this.upper = upper;
  }

  @Override
  Noise noise() {
    return noise;
  }

  @Override
  double epsilon() {
    return epsilon;
  }

  @Nullable
  @Override
  Double delta() {
    return delta;
  }

  @Override
  int maxPartitionsContributed() {
    return maxPartitionsContributed;
  }

  @Override
  int maxContributionsPerPartition() {
    return maxContributionsPerPartition;
  }

  @Override
  double lower() {
    return lower;
  }

  @Override
  double upper() {
    return upper;
  }

  @Override
  public String toString() {
    return "Params{"
        + "noise=" + noise + ", "
        + "epsilon=" + epsilon + ", "
        + "delta=" + delta + ", "
        + "maxPartitionsContributed=" + maxPartitionsContributed + ", "
        + "maxContributionsPerPartition=" + maxContributionsPerPartition + ", "
        + "lower=" + lower + ", "
        + "upper=" + upper
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BoundedSum.Params) {
      BoundedSum.Params that = (BoundedSum.Params) o;
      return this.noise.equals(that.noise())
          && Double.doubleToLongBits(this.epsilon) == Double.doubleToLongBits(that.epsilon())
          && (this.delta == null ? that.delta() == null : this.delta.equals(that.delta()))
          && this.maxPartitionsContributed == that.maxPartitionsContributed()
          && this.maxContributionsPerPartition == that.maxContributionsPerPartition()
          && Double.doubleToLongBits(this.lower) == Double.doubleToLongBits(that.lower())
          && Double.doubleToLongBits(this.upper) == Double.doubleToLongBits(that.upper());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= noise.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(epsilon) >>> 32) ^ Double.doubleToLongBits(epsilon));
    h$ *= 1000003;
    h$ ^= (delta == null) ? 0 : delta.hashCode();
    h$ *= 1000003;
    h$ ^= maxPartitionsContributed;
    h$ *= 1000003;
    h$ ^= maxContributionsPerPartition;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(lower) >>> 32) ^ Double.doubleToLongBits(lower));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(upper) >>> 32) ^ Double.doubleToLongBits(upper));
    return h$;
  }

  static final class Builder extends BoundedSum.Params.Builder {
    private Noise noise;
    private Double epsilon;
    private Double delta;
    private Integer maxPartitionsContributed;
    private Integer maxContributionsPerPartition;
    private Double lower;
    private Double upper;
    Builder() {
    }
    @Override
    public BoundedSum.Params.Builder noise(Noise noise) {
      if (noise == null) {
        throw new NullPointerException("Null noise");
      }
      this.noise = noise;
      return this;
    }
    @Override
    public BoundedSum.Params.Builder epsilon(double epsilon) {
      this.epsilon = epsilon;
      return this;
    }
    @Override
    public BoundedSum.Params.Builder delta(@Nullable Double delta) {
      this.delta = delta;
      return this;
    }
    @Override
    public BoundedSum.Params.Builder maxPartitionsContributed(int maxPartitionsContributed) {
      this.maxPartitionsContributed = maxPartitionsContributed;
      return this;
    }
    @Override
    BoundedSum.Params.Builder maxContributionsPerPartition(int maxContributionsPerPartition) {
      this.maxContributionsPerPartition = maxContributionsPerPartition;
      return this;
    }
    @Override
    public BoundedSum.Params.Builder lower(double lower) {
      this.lower = lower;
      return this;
    }
    @Override
    public BoundedSum.Params.Builder upper(double upper) {
      this.upper = upper;
      return this;
    }
    @Override
    BoundedSum.Params autoBuild() {
      String missing = "";
      if (this.noise == null) {
        missing += " noise";
      }
      if (this.epsilon == null) {
        missing += " epsilon";
      }
      if (this.maxPartitionsContributed == null) {
        missing += " maxPartitionsContributed";
      }
      if (this.maxContributionsPerPartition == null) {
        missing += " maxContributionsPerPartition";
      }
      if (this.lower == null) {
        missing += " lower";
      }
      if (this.upper == null) {
        missing += " upper";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BoundedSum_Params(
          this.noise,
          this.epsilon,
          this.delta,
          this.maxPartitionsContributed,
          this.maxContributionsPerPartition,
          this.lower,
          this.upper);
    }
  }

}
