/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.privacy.differentialprivacy.BoundedQuantiles;
import com.google.privacy.differentialprivacy.Noise;
import javax.annotation.Nullable;

final class AutoValue_BoundedQuantiles_Params
extends BoundedQuantiles.Params {
    private final Noise noise;
    private final double epsilon;
    private final Double delta;
    private final int maxPartitionsContributed;
    private final int maxContributionsPerPartition;
    private final double lower;
    private final double upper;
    private final int treeHeight;
    private final int branchingFactor;

    private AutoValue_BoundedQuantiles_Params(Noise noise, double epsilon, @Nullable Double delta, int maxPartitionsContributed, int maxContributionsPerPartition, double lower, double upper, int treeHeight, int branchingFactor) {
        this.noise = noise;
        this.epsilon = epsilon;
        this.delta = delta;
        this.maxPartitionsContributed = maxPartitionsContributed;
        this.maxContributionsPerPartition = maxContributionsPerPartition;
        this.lower = lower;
        this.upper = upper;
        this.treeHeight = treeHeight;
        this.branchingFactor = branchingFactor;
    }

    @Override
    Noise noise() {
        return this.noise;
    }

    @Override
    double epsilon() {
        return this.epsilon;
    }

    @Override
    @Nullable
    Double delta() {
        return this.delta;
    }

    @Override
    int maxPartitionsContributed() {
        return this.maxPartitionsContributed;
    }

    @Override
    int maxContributionsPerPartition() {
        return this.maxContributionsPerPartition;
    }

    @Override
    double lower() {
        return this.lower;
    }

    @Override
    double upper() {
        return this.upper;
    }

    @Override
    int treeHeight() {
        return this.treeHeight;
    }

    @Override
    int branchingFactor() {
        return this.branchingFactor;
    }

    public String toString() {
        return "Params{noise=" + this.noise + ", epsilon=" + this.epsilon + ", delta=" + this.delta + ", maxPartitionsContributed=" + this.maxPartitionsContributed + ", maxContributionsPerPartition=" + this.maxContributionsPerPartition + ", lower=" + this.lower + ", upper=" + this.upper + ", treeHeight=" + this.treeHeight + ", branchingFactor=" + this.branchingFactor + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BoundedQuantiles.Params) {
            BoundedQuantiles.Params that = (BoundedQuantiles.Params)o;
            return this.noise.equals(that.noise()) && Double.doubleToLongBits(this.epsilon) == Double.doubleToLongBits(that.epsilon()) && (this.delta == null ? that.delta() == null : this.delta.equals(that.delta())) && this.maxPartitionsContributed == that.maxPartitionsContributed() && this.maxContributionsPerPartition == that.maxContributionsPerPartition() && Double.doubleToLongBits(this.lower) == Double.doubleToLongBits(that.lower()) && Double.doubleToLongBits(this.upper) == Double.doubleToLongBits(that.upper()) && this.treeHeight == that.treeHeight() && this.branchingFactor == that.branchingFactor();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.noise.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.epsilon) >>> 32 ^ Double.doubleToLongBits(this.epsilon));
        h$ *= 1000003;
        h$ ^= this.delta == null ? 0 : this.delta.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxPartitionsContributed;
        h$ *= 1000003;
        h$ ^= this.maxContributionsPerPartition;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.lower) >>> 32 ^ Double.doubleToLongBits(this.lower));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.upper) >>> 32 ^ Double.doubleToLongBits(this.upper));
        h$ *= 1000003;
        h$ ^= this.treeHeight;
        h$ *= 1000003;
        return h$ ^= this.branchingFactor;
    }

    static final class Builder
    extends BoundedQuantiles.Params.Builder {
        private Noise noise;
        private Double epsilon;
        private Double delta;
        private Integer maxPartitionsContributed;
        private Integer maxContributionsPerPartition;
        private Double lower;
        private Double upper;
        private Integer treeHeight;
        private Integer branchingFactor;

        Builder() {
        }

        @Override
        public BoundedQuantiles.Params.Builder noise(Noise noise) {
            if (noise == null) {
                throw new NullPointerException("Null noise");
            }
            this.noise = noise;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder delta(@Nullable Double delta) {
            this.delta = delta;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder maxPartitionsContributed(int maxPartitionsContributed) {
            this.maxPartitionsContributed = maxPartitionsContributed;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder maxContributionsPerPartition(int maxContributionsPerPartition) {
            this.maxContributionsPerPartition = maxContributionsPerPartition;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder lower(double lower) {
            this.lower = lower;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder upper(double upper) {
            this.upper = upper;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder treeHeight(int treeHeight) {
            this.treeHeight = treeHeight;
            return this;
        }

        @Override
        public BoundedQuantiles.Params.Builder branchingFactor(int branchingFactor) {
            this.branchingFactor = branchingFactor;
            return this;
        }

        @Override
        BoundedQuantiles.Params autoBuild() {
            String missing = "";
            if (this.noise == null) {
                missing = missing + " noise";
            }
            if (this.epsilon == null) {
                missing = missing + " epsilon";
            }
            if (this.maxPartitionsContributed == null) {
                missing = missing + " maxPartitionsContributed";
            }
            if (this.maxContributionsPerPartition == null) {
                missing = missing + " maxContributionsPerPartition";
            }
            if (this.lower == null) {
                missing = missing + " lower";
            }
            if (this.upper == null) {
                missing = missing + " upper";
            }
            if (this.treeHeight == null) {
                missing = missing + " treeHeight";
            }
            if (this.branchingFactor == null) {
                missing = missing + " branchingFactor";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BoundedQuantiles_Params(this.noise, this.epsilon, this.delta, this.maxPartitionsContributed, this.maxContributionsPerPartition, this.lower, this.upper, this.treeHeight, this.branchingFactor);
        }
    }
}

