/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.privacy.differentialprivacy.Count;
import com.google.privacy.differentialprivacy.Noise;
import javax.annotation.Nullable;

final class AutoValue_Count_Params
extends Count.Params {
    private final Noise noise;
    private final double epsilon;
    private final Double delta;
    private final int maxPartitionsContributed;
    private final int maxContributionsPerPartition;

    private AutoValue_Count_Params(Noise noise, double epsilon, @Nullable Double delta, int maxPartitionsContributed, int maxContributionsPerPartition) {
        this.noise = noise;
        this.epsilon = epsilon;
        this.delta = delta;
        this.maxPartitionsContributed = maxPartitionsContributed;
        this.maxContributionsPerPartition = maxContributionsPerPartition;
    }

    @Override
    Noise noise() {
        return this.noise;
    }

    @Override
    double epsilon() {
        return this.epsilon;
    }

    @Override
    @Nullable
    Double delta() {
        return this.delta;
    }

    @Override
    int maxPartitionsContributed() {
        return this.maxPartitionsContributed;
    }

    @Override
    int maxContributionsPerPartition() {
        return this.maxContributionsPerPartition;
    }

    public String toString() {
        return "Params{noise=" + this.noise + ", epsilon=" + this.epsilon + ", delta=" + this.delta + ", maxPartitionsContributed=" + this.maxPartitionsContributed + ", maxContributionsPerPartition=" + this.maxContributionsPerPartition + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Count.Params) {
            Count.Params that = (Count.Params)o;
            return this.noise.equals(that.noise()) && Double.doubleToLongBits(this.epsilon) == Double.doubleToLongBits(that.epsilon()) && (this.delta == null ? that.delta() == null : this.delta.equals(that.delta())) && this.maxPartitionsContributed == that.maxPartitionsContributed() && this.maxContributionsPerPartition == that.maxContributionsPerPartition();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.noise.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.epsilon) >>> 32 ^ Double.doubleToLongBits(this.epsilon));
        h$ *= 1000003;
        h$ ^= this.delta == null ? 0 : this.delta.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxPartitionsContributed;
        h$ *= 1000003;
        return h$ ^= this.maxContributionsPerPartition;
    }

    static final class Builder
    extends Count.Params.Builder {
        private Noise noise;
        private Double epsilon;
        private Double delta;
        private Integer maxPartitionsContributed;
        private Integer maxContributionsPerPartition;

        Builder() {
        }

        @Override
        public Count.Params.Builder noise(Noise noise) {
            if (noise == null) {
                throw new NullPointerException("Null noise");
            }
            this.noise = noise;
            return this;
        }

        @Override
        public Count.Params.Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        @Override
        public Count.Params.Builder delta(@Nullable Double delta) {
            this.delta = delta;
            return this;
        }

        @Override
        public Count.Params.Builder maxPartitionsContributed(int maxPartitionsContributed) {
            this.maxPartitionsContributed = maxPartitionsContributed;
            return this;
        }

        @Override
        Count.Params.Builder maxContributionsPerPartition(int maxContributionsPerPartition) {
            this.maxContributionsPerPartition = maxContributionsPerPartition;
            return this;
        }

        @Override
        Count.Params autoBuild() {
            String missing = "";
            if (this.noise == null) {
                missing = missing + " noise";
            }
            if (this.epsilon == null) {
                missing = missing + " epsilon";
            }
            if (this.maxPartitionsContributed == null) {
                missing = missing + " maxPartitionsContributed";
            }
            if (this.maxContributionsPerPartition == null) {
                missing = missing + " maxContributionsPerPartition";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Count_Params(this.noise, this.epsilon, this.delta, this.maxPartitionsContributed, this.maxContributionsPerPartition);
        }
    }
}

