/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.AggregationState;
import com.google.privacy.differentialprivacy.AutoValue_BoundedMean_Params;
import com.google.privacy.differentialprivacy.BoundedSum;
import com.google.privacy.differentialprivacy.ConfidenceInterval;
import com.google.privacy.differentialprivacy.Count;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.LaplaceNoise;
import com.google.privacy.differentialprivacy.Noise;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import javax.annotation.Nullable;

public class BoundedMean {
    private final Params params;
    private final BoundedSum normalizedSum;
    private final Count count;
    private final double midpoint;
    private AggregationState state = AggregationState.DEFAULT;

    private BoundedMean(Params params) {
        this.params = params;
        this.midpoint = params.lower() * 0.5 + params.upper() * 0.5;
        double maxDistFromMidpoint = Math.abs(params.upper() - this.midpoint);
        double halfEpsilon = params.epsilon() * 0.5;
        Double halfDelta = params.delta() == null ? null : Double.valueOf(params.delta() * 0.5);
        this.normalizedSum = BoundedSum.builder().noise(params.noise()).epsilon(halfEpsilon).delta(halfDelta).maxPartitionsContributed(params.maxPartitionsContributed()).maxContributionsPerPartition(params.maxContributionsPerPartition()).lower(-maxDistFromMidpoint).upper(maxDistFromMidpoint).build();
        this.count = Count.builder().noise(params.noise()).epsilon(halfEpsilon).delta(halfDelta).maxPartitionsContributed(params.maxPartitionsContributed()).maxContributionsPerPartition(params.maxContributionsPerPartition()).build();
    }

    public static Params.Builder builder() {
        return Params.Builder.newBuilder();
    }

    public void addEntry(double e) {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Entry cannot be added.");
        if (Double.isNaN(e)) {
            return;
        }
        this.normalizedSum.addEntry(this.clamp(e) - this.midpoint);
        this.count.increment();
    }

    public void addEntries(Collection<Double> e) {
        e.forEach(this::addEntry);
    }

    private double clamp(double value) {
        return Math.max(Math.min(value, this.params.upper()), this.params.lower());
    }

    public double computeResult() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"DP mean cannot be computed.");
        this.state = AggregationState.RESULT_RETURNED;
        long noisedCount = Math.max(1L, this.count.computeResult());
        double normalizedNoisedSum = this.normalizedSum.computeResult();
        return this.clamp(normalizedNoisedSum / (double)noisedCount + this.midpoint);
    }

    public ConfidenceInterval computeConfidenceInterval(double alpha) {
        Preconditions.checkState((this.state == AggregationState.RESULT_RETURNED ? 1 : 0) != 0, (Object)"Confidence interval cannot be computed.");
        double minSize = Double.POSITIVE_INFINITY;
        ConfidenceInterval tightestConfInt = null;
        for (int i = 1; i < 1000; ++i) {
            double alphaNum = (double)i / 1000.0 * alpha;
            ConfidenceInterval confInt = this.computeConfidenceInterval(alpha, alphaNum);
            double size = confInt.upperBound() - confInt.lowerBound();
            if (!(size < minSize)) continue;
            minSize = size;
            tightestConfInt = confInt;
        }
        return tightestConfInt;
    }

    @VisibleForTesting
    ConfidenceInterval computeConfidenceInterval(double alpha, double alphaNum) {
        double alphaDen = (alpha - alphaNum) / (1.0 - alphaNum);
        ConfidenceInterval confIntNum = this.normalizedSum.computeConfidenceInterval(alphaNum);
        ConfidenceInterval confIntDen = this.count.computeConfidenceInterval(alphaDen);
        confIntDen = ConfidenceInterval.create(Math.max(1.0, confIntDen.lowerBound()), Math.max(1.0, confIntDen.upperBound()));
        double meanLowerBound = confIntNum.lowerBound() >= 0.0 ? confIntNum.lowerBound() / confIntDen.upperBound() : confIntNum.lowerBound() / confIntDen.lowerBound();
        double meanUpperBound = confIntNum.upperBound() >= 0.0 ? confIntNum.upperBound() / confIntDen.lowerBound() : confIntNum.upperBound() / confIntDen.upperBound();
        meanLowerBound = this.clamp(meanLowerBound + this.midpoint);
        meanUpperBound = this.clamp(meanUpperBound + this.midpoint);
        return ConfidenceInterval.create(meanLowerBound, meanUpperBound);
    }

    public byte[] getSerializableSummary() {
        SummaryOuterClass.BoundedSumSummary deserializedNormalizedSum;
        SummaryOuterClass.CountSummary deserializedCount;
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Mean cannot be serialized.");
        this.state = AggregationState.SERIALIZED;
        try {
            deserializedCount = SummaryOuterClass.CountSummary.parseFrom(this.count.getSerializableSummary());
            deserializedNormalizedSum = SummaryOuterClass.BoundedSumSummary.parseFrom(this.normalizedSum.getSerializableSummary());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Mean object cannot be serialized. Reason: " + (Object)((Object)e));
        }
        SummaryOuterClass.BoundedMeanSummary serializedMean = SummaryOuterClass.BoundedMeanSummary.newBuilder().setCountSummary(deserializedCount).setSumSummary(deserializedNormalizedSum).build();
        return serializedMean.toByteArray();
    }

    public void mergeWith(byte[] otherBoundedMeanSummary) {
        SummaryOuterClass.BoundedMeanSummary otherSummaryParsed;
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Means cannot be merged.");
        try {
            otherSummaryParsed = SummaryOuterClass.BoundedMeanSummary.parseFrom(otherBoundedMeanSummary);
        }
        catch (InvalidProtocolBufferException pbe) {
            throw new IllegalArgumentException(pbe);
        }
        this.normalizedSum.mergeWith(otherSummaryParsed.getSumSummary().toByteArray());
        this.count.mergeWith(otherSummaryParsed.getCountSummary().toByteArray());
    }

    @AutoValue
    public static abstract class Params {
        abstract Noise noise();

        abstract double epsilon();

        @Nullable
        abstract Double delta();

        abstract int maxPartitionsContributed();

        abstract int maxContributionsPerPartition();

        abstract double lower();

        abstract double upper();

        @AutoValue.Builder
        public static abstract class Builder {
            private static Builder newBuilder() {
                AutoValue_BoundedMean_Params.Builder builder = new AutoValue_BoundedMean_Params.Builder();
                ((Builder)builder).noise(new LaplaceNoise());
                return builder;
            }

            public abstract Builder epsilon(double var1);

            public abstract Builder delta(@Nullable Double var1);

            public abstract Builder maxPartitionsContributed(int var1);

            public abstract Builder maxContributionsPerPartition(int var1);

            public abstract Builder noise(Noise var1);

            public abstract Builder lower(double var1);

            public abstract Builder upper(double var1);

            abstract Params autoBuild();

            public BoundedMean build() {
                Params params = this.autoBuild();
                DpPreconditions.checkEpsilon(params.epsilon());
                DpPreconditions.checkNoiseDelta(params.delta(), params.noise());
                DpPreconditions.checkMaxPartitionsContributed(params.maxPartitionsContributed());
                DpPreconditions.checkMaxContributionsPerPartition(params.maxContributionsPerPartition());
                DpPreconditions.checkBounds(params.lower(), params.upper());
                return new BoundedMean(params);
            }
        }
    }
}

