/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.AggregationState;
import com.google.privacy.differentialprivacy.AutoValue_BoundedQuantiles_Params;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.LaplaceNoise;
import com.google.privacy.differentialprivacy.Noise;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class BoundedQuantiles {
    public static final double NUMERICAL_TOLERANCE = 1.0E-6;
    public static final int DEFAULT_TREE_HEIGHT = 4;
    public static final int DEFAULT_BRANCHING_FACTOR = 16;
    private static final int ROOT_INDEX = 0;
    private static final double ALPHA = 0.0075;
    private final Params params;
    private final Map<Integer, Long> tree;
    private final Map<Integer, Double> noisedTree;
    private final int numberOfLeaves;
    private final int leftmostLeafIndex;
    private AggregationState state = AggregationState.DEFAULT;

    private BoundedQuantiles(Params params) {
        this.params = params;
        this.tree = new HashMap<Integer, Long>();
        this.noisedTree = new HashMap<Integer, Double>();
        int numberOfNodes = (int)((Math.pow(params.branchingFactor(), params.treeHeight() + 1) - 1.0) / (double)(params.branchingFactor() - 1));
        this.numberOfLeaves = (int)Math.pow(params.branchingFactor(), params.treeHeight());
        this.leftmostLeafIndex = numberOfNodes - this.numberOfLeaves;
    }

    public static Params.Builder builder() {
        return Params.Builder.newBuilder();
    }

    public void addEntry(double e) {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Entry cannot be added.");
        if (Double.isNaN(e)) {
            return;
        }
        int index = this.getIndex(this.clamp(e));
        while (index != 0) {
            long count = this.tree.containsKey(index) ? this.tree.get(index) : 0L;
            this.tree.put(index, count + 1L);
            index = this.getParent(index);
        }
    }

    public void addEntries(Collection<Double> e) {
        e.forEach(this::addEntry);
    }

    private double clamp(double value) {
        return Math.max(Math.min(value, this.params.upper()), this.params.lower());
    }

    private int getIndex(double value) {
        return this.leftmostLeafIndex + (value == this.params.upper() ? this.numberOfLeaves - 1 : (int)Math.floor((value - this.params.lower()) / (this.params.upper() - this.params.lower()) * (double)this.numberOfLeaves));
    }

    private double getLeftValue(int index) {
        while (index < this.leftmostLeafIndex) {
            index = this.getLeftmostChild(index);
        }
        return (this.params.upper() - this.params.lower()) * ((double)(index - this.leftmostLeafIndex) / (double)this.numberOfLeaves) + this.params.lower();
    }

    private double getRightValue(int index) {
        while (index < this.leftmostLeafIndex) {
            index = this.getRightmostChild(index);
        }
        return (this.params.upper() - this.params.lower()) * ((double)(index - this.leftmostLeafIndex + 1) / (double)this.numberOfLeaves) + this.params.lower();
    }

    public double computeResult(double rank) {
        Preconditions.checkState((this.state == AggregationState.DEFAULT || this.state == AggregationState.RESULT_RETURNED ? 1 : 0) != 0, (Object)"DP quantile cannot be computed.");
        this.state = AggregationState.RESULT_RETURNED;
        Preconditions.checkArgument((rank >= 0.0 && rank <= 1.0 ? 1 : 0) != 0, (String)"rank must be >= 0 and <= 1. Provided value: %s", (Object)rank);
        rank = BoundedQuantiles.adjustRank(rank);
        int index = 0;
        block0: while (index < this.leftmostLeafIndex) {
            int leftmostChildIndex = this.getLeftmostChild(index);
            int rightmostChildIndex = this.getRightmostChild(index);
            double totalCount = 0.0;
            for (int i = leftmostChildIndex; i <= rightmostChildIndex; ++i) {
                totalCount += Math.max(0.0, this.getNoisedCount(i));
            }
            double correctedTotalCount = 0.0;
            for (int i = leftmostChildIndex; i <= rightmostChildIndex; ++i) {
                correctedTotalCount += this.getNoisedCount(i) >= totalCount * 0.0075 ? this.getNoisedCount(i) : 0.0;
            }
            if (correctedTotalCount == 0.0) break;
            double partialCount = 0.0;
            int i = leftmostChildIndex;
            while (true) {
                double count;
                if ((count = this.getNoisedCount(i)) >= totalCount * 0.0075 && (partialCount += count) / correctedTotalCount >= rank - 1.0E-6) {
                    rank = (rank - (partialCount - count) / correctedTotalCount) / (count / correctedTotalCount);
                    rank = Math.min(Math.max(0.0, rank), 1.0);
                    index = i;
                    continue block0;
                }
                ++i;
            }
        }
        return (1.0 - rank) * this.getLeftValue(index) + rank * this.getRightValue(index);
    }

    private int getLeftmostChild(int index) {
        return index * this.params.branchingFactor() + 1;
    }

    private int getRightmostChild(int index) {
        return (index + 1) * this.params.branchingFactor();
    }

    private int getParent(int index) {
        return (index - 1) / this.params.branchingFactor();
    }

    @VisibleForTesting
    static double adjustRank(double rank) {
        return Math.max(Math.min(rank, 0.995), 0.005);
    }

    private double getNoisedCount(int index) {
        if (this.noisedTree.containsKey(index)) {
            return this.noisedTree.get(index);
        }
        double rawCount = this.tree.containsKey(index) ? (double)this.tree.get(index).longValue() : 0.0;
        double noisedCount = this.params.noise().addNoise(rawCount, this.params.treeHeight() * this.params.maxPartitionsContributed(), (double)this.params.maxContributionsPerPartition(), this.params.epsilon(), this.params.delta());
        this.noisedTree.put(index, noisedCount);
        return noisedCount;
    }

    public byte[] getSerializableSummary() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Distribution cannot be serialized.");
        this.state = AggregationState.SERIALIZED;
        SummaryOuterClass.BoundedQuantilesSummary.Builder builder = SummaryOuterClass.BoundedQuantilesSummary.newBuilder().putAllQuantileTree(this.tree).setEpsilon(this.params.epsilon()).setLower(this.params.lower()).setUpper(this.params.upper()).setMaxPartitionsContributed(this.params.maxPartitionsContributed()).setMaxContributionsPerPartition(this.params.maxContributionsPerPartition()).setMechanismType(this.params.noise().getMechanismType()).setTreeHeight(this.params.treeHeight()).setBranchingFactor(this.params.branchingFactor());
        if (this.params.delta() != null) {
            builder.setDelta(this.params.delta());
        }
        return builder.build().toByteArray();
    }

    public void mergeWith(byte[] otherBoundedQuantilesSummary) {
        SummaryOuterClass.BoundedQuantilesSummary otherSummaryParsed;
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Distributions cannot be merged.");
        try {
            otherSummaryParsed = SummaryOuterClass.BoundedQuantilesSummary.parseFrom(otherBoundedQuantilesSummary);
        }
        catch (InvalidProtocolBufferException pbe) {
            throw new IllegalArgumentException(pbe);
        }
        this.checkMergeParametersAreEqual(otherSummaryParsed);
        for (int index : otherSummaryParsed.getQuantileTreeMap().keySet()) {
            long oldCount = this.tree.containsKey(index) ? this.tree.get(index) : 0L;
            this.tree.put(index, oldCount + otherSummaryParsed.getQuantileTreeOrDefault(index, 0L));
        }
    }

    private void checkMergeParametersAreEqual(SummaryOuterClass.BoundedQuantilesSummary summary) {
        DpPreconditions.checkMergeMechanismTypesAreEqual(this.params.noise().getMechanismType(), summary.getMechanismType());
        DpPreconditions.checkMergeEpsilonAreEqual(this.params.epsilon(), summary.getEpsilon());
        DpPreconditions.checkMergeDeltaAreEqual(this.params.delta(), summary.getDelta());
        DpPreconditions.checkMergeMaxPartitionsContributedAreEqual(this.params.maxPartitionsContributed(), summary.getMaxPartitionsContributed());
        DpPreconditions.checkMergeMaxContributionsPerPartitionAreEqual(this.params.maxContributionsPerPartition(), summary.getMaxContributionsPerPartition());
        DpPreconditions.checkMergeBoundsAreEqual(this.params.lower(), summary.getLower(), this.params.upper(), summary.getUpper());
        Preconditions.checkArgument((this.params.treeHeight() == summary.getTreeHeight() ? 1 : 0) != 0, (String)"Failed to merge: unequal values of treeheight. treeHeight1 = %s, treeHeight2 = %s", (int)this.params.treeHeight(), (int)summary.getTreeHeight());
        Preconditions.checkArgument((this.params.branchingFactor() == summary.getBranchingFactor() ? 1 : 0) != 0, (String)"Failed to merge: unequal values of branchingFactor. branchingFactor1 = %s, branchingFactor2 = %s", (int)this.params.branchingFactor(), (int)summary.getBranchingFactor());
    }

    @AutoValue
    public static abstract class Params {
        abstract Noise noise();

        abstract double epsilon();

        @Nullable
        abstract Double delta();

        abstract int maxPartitionsContributed();

        abstract int maxContributionsPerPartition();

        abstract double lower();

        abstract double upper();

        abstract int treeHeight();

        abstract int branchingFactor();

        @AutoValue.Builder
        public static abstract class Builder {
            private static Builder newBuilder() {
                AutoValue_BoundedQuantiles_Params.Builder builder = new AutoValue_BoundedQuantiles_Params.Builder();
                ((Builder)builder).noise(new LaplaceNoise());
                ((Builder)builder).treeHeight(4);
                ((Builder)builder).branchingFactor(16);
                return builder;
            }

            public abstract Builder epsilon(double var1);

            public abstract Builder delta(@Nullable Double var1);

            public abstract Builder maxPartitionsContributed(int var1);

            public abstract Builder maxContributionsPerPartition(int var1);

            public abstract Builder noise(Noise var1);

            public abstract Builder lower(double var1);

            public abstract Builder upper(double var1);

            @VisibleForTesting
            public abstract Builder treeHeight(int var1);

            @VisibleForTesting
            public abstract Builder branchingFactor(int var1);

            private static void checkTreeHeight(int treeHeight) {
                Preconditions.checkArgument((treeHeight >= 1 ? 1 : 0) != 0, (String)"Tree height must be at least 1. Provided value: %s", (int)treeHeight);
            }

            private static void checkBranchingFactor(int branchingFactor) {
                Preconditions.checkArgument((branchingFactor >= 2 ? 1 : 0) != 0, (String)"Branching factor must be at least 2. Provided value: %s", (int)branchingFactor);
            }

            private static void checkBoundsNotEqual(double lower, double upper) {
                Preconditions.checkArgument((lower != upper ? 1 : 0) != 0, (Object)"Lower and upper bounds must not be equal");
            }

            abstract Params autoBuild();

            public BoundedQuantiles build() {
                Params params = this.autoBuild();
                DpPreconditions.checkEpsilon(params.epsilon());
                DpPreconditions.checkNoiseDelta(params.delta(), params.noise());
                DpPreconditions.checkMaxPartitionsContributed(params.maxPartitionsContributed());
                DpPreconditions.checkMaxContributionsPerPartition(params.maxContributionsPerPartition());
                DpPreconditions.checkBounds(params.lower(), params.upper());
                Builder.checkBoundsNotEqual(params.lower(), params.upper());
                Builder.checkTreeHeight(params.treeHeight());
                Builder.checkBranchingFactor(params.branchingFactor());
                return new BoundedQuantiles(params);
            }
        }
    }
}

