/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.Data;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.AggregationState;
import com.google.privacy.differentialprivacy.AutoValue_BoundedSum_Params;
import com.google.privacy.differentialprivacy.ConfidenceInterval;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.LaplaceNoise;
import com.google.privacy.differentialprivacy.Noise;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import javax.annotation.Nullable;

public class BoundedSum {
    private final Params params;
    private double sum = 0.0;
    private double noisedSum;
    private AggregationState state = AggregationState.DEFAULT;

    private BoundedSum(Params params) {
        this.params = params;
    }

    public static Params.Builder builder() {
        return Params.Builder.newBuilder();
    }

    public void addEntry(double e) {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Entry cannot be added.");
        if (Double.isNaN(e)) {
            return;
        }
        this.sum += this.clamp(e);
    }

    public void addEntries(Collection<Double> e) {
        e.forEach(this::addEntry);
    }

    private double clamp(double value) {
        return Math.max(Math.min(value, this.params.upper()), this.params.lower());
    }

    public double computeResult() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"DP sum cannot be computed.");
        this.state = AggregationState.RESULT_RETURNED;
        this.noisedSum = this.params.noise().addNoise(this.sum, this.getL0Sensitivity(), this.getLInfSensitivity(), this.params.epsilon(), this.params.delta());
        return this.noisedSum;
    }

    public ConfidenceInterval computeConfidenceInterval(double alpha) {
        Preconditions.checkState((this.state == AggregationState.RESULT_RETURNED ? 1 : 0) != 0, (Object)"Confidence interval cannot be computed.");
        ConfidenceInterval confInt = this.params.noise().computeConfidenceInterval(this.noisedSum, this.getL0Sensitivity(), this.getLInfSensitivity(), this.params.epsilon(), this.params.delta(), alpha);
        if (this.params.lower() >= 0.0) {
            confInt = ConfidenceInterval.create(Math.max(0.0, confInt.lowerBound()), Math.max(0.0, confInt.upperBound()));
        } else if (this.params.upper() <= 0.0) {
            confInt = ConfidenceInterval.create(Math.min(0.0, confInt.lowerBound()), Math.min(0.0, confInt.upperBound()));
        }
        return confInt;
    }

    public byte[] getSerializableSummary() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Sum cannot be serialized.");
        this.state = AggregationState.SERIALIZED;
        Data.ValueType sumValue = Data.ValueType.newBuilder().setFloatValue(this.sum).build();
        SummaryOuterClass.BoundedSumSummary.Builder builder = SummaryOuterClass.BoundedSumSummary.newBuilder().setPartialSum(sumValue).setEpsilon(this.params.epsilon()).setLower(this.params.lower()).setUpper(this.params.upper()).setMaxPartitionsContributed(this.params.maxPartitionsContributed()).setMaxContributionsPerPartition(this.params.maxContributionsPerPartition()).setMechanismType(this.params.noise().getMechanismType());
        if (this.params.delta() != null) {
            builder.setDelta(this.params.delta());
        }
        return builder.build().toByteArray();
    }

    public void mergeWith(byte[] otherBoundedSumSummary) {
        SummaryOuterClass.BoundedSumSummary otherSummaryParsed;
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Sums cannot be merged.");
        try {
            otherSummaryParsed = SummaryOuterClass.BoundedSumSummary.parseFrom(otherBoundedSumSummary);
        }
        catch (InvalidProtocolBufferException pbe) {
            throw new IllegalArgumentException(pbe);
        }
        this.checkMergeParametersAreEqual(otherSummaryParsed);
        this.sum += otherSummaryParsed.getPartialSum().getFloatValue();
    }

    private void checkMergeParametersAreEqual(SummaryOuterClass.BoundedSumSummary summary) {
        DpPreconditions.checkMergeMechanismTypesAreEqual(this.params.noise().getMechanismType(), summary.getMechanismType());
        DpPreconditions.checkMergeEpsilonAreEqual(this.params.epsilon(), summary.getEpsilon());
        DpPreconditions.checkMergeDeltaAreEqual(this.params.delta(), summary.getDelta());
        DpPreconditions.checkMergeMaxPartitionsContributedAreEqual(this.params.maxPartitionsContributed(), summary.getMaxPartitionsContributed());
        DpPreconditions.checkMergeMaxContributionsPerPartitionAreEqual(this.params.maxContributionsPerPartition(), summary.getMaxContributionsPerPartition());
        DpPreconditions.checkMergeBoundsAreEqual(this.params.lower(), summary.getLower(), this.params.upper(), summary.getUpper());
    }

    private int getL0Sensitivity() {
        return this.params.maxPartitionsContributed();
    }

    private double getLInfSensitivity() {
        return BoundedSum.getLInfSensitivity(this.params.lower(), this.params.upper(), this.params.maxContributionsPerPartition());
    }

    private static double getLInfSensitivity(double lower, double upper, int maxContributionsPerPartition) {
        return Math.max(Math.abs(lower), Math.abs(upper)) * (double)maxContributionsPerPartition;
    }

    @AutoValue
    public static abstract class Params {
        abstract Noise noise();

        abstract double epsilon();

        @Nullable
        abstract Double delta();

        abstract int maxPartitionsContributed();

        abstract int maxContributionsPerPartition();

        abstract double lower();

        abstract double upper();

        @AutoValue.Builder
        public static abstract class Builder {
            private static void checkLInfSensitivityOverflow(double lower, double upper, int maxContributionsPerPartition) {
                double lInfSensitivity = BoundedSum.getLInfSensitivity(lower, upper, maxContributionsPerPartition);
                Preconditions.checkArgument((Double.compare(lInfSensitivity, Double.MAX_VALUE) <= 0 ? 1 : 0) != 0, (String)"bounds and maxContributionsPerPartition are too high - the LInfSensitivity  overflows. Provided values: lower bound = %s, upper bound = %s, maxContributionsPerPartition = %s", (Object)lower, (Object)upper, (Object)maxContributionsPerPartition);
            }

            private static void checkL1SensitivityOverflow(double lower, double upper, int maxContributionsPerPartition, int maxPartitionsContributed) {
                double lInfSensitivity = BoundedSum.getLInfSensitivity(lower, upper, maxContributionsPerPartition);
                double l1Sensitivity = Noise.getL1Sensitivity(maxPartitionsContributed, lInfSensitivity);
                Preconditions.checkArgument((Double.compare(l1Sensitivity, Double.MAX_VALUE) <= 0 ? 1 : 0) != 0, (String)"bounds and maxContributionsPerPartition are too high - the L1Sensitivity  overflows. Provided values: lower bound = %s, upper bound = %s, maxContributionsPerPartition = %s", (Object)lower, (Object)upper, (Object)maxContributionsPerPartition);
            }

            private static void checkL2SensitivityOverflow(double lower, double upper, int maxContributionsPerPartition, int maxPartitionsContributed) {
                double lInfSensitivity = BoundedSum.getLInfSensitivity(lower, upper, maxContributionsPerPartition);
                double l2Sensitivity = Noise.getL2Sensitivity(maxPartitionsContributed, lInfSensitivity);
                Preconditions.checkArgument((Double.compare(l2Sensitivity, Double.MAX_VALUE) <= 0 ? 1 : 0) != 0, (String)"bounds and maxContributionsPerPartition are too high - the L2Sensitivity  overflows. Provided values: lower bound = %s, upper bound = %s, maxContributionsPerPartition = %s", (Object)lower, (Object)upper, (Object)maxContributionsPerPartition);
            }

            private static Builder newBuilder() {
                AutoValue_BoundedSum_Params.Builder builder = new AutoValue_BoundedSum_Params.Builder();
                ((Builder)builder).noise(new LaplaceNoise());
                ((Builder)builder).maxContributionsPerPartition(1);
                return builder;
            }

            public abstract Builder epsilon(double var1);

            public abstract Builder delta(@Nullable Double var1);

            public abstract Builder maxPartitionsContributed(int var1);

            public abstract Builder noise(Noise var1);

            public abstract Builder lower(double var1);

            public abstract Builder upper(double var1);

            abstract Builder maxContributionsPerPartition(int var1);

            abstract Params autoBuild();

            public BoundedSum build() {
                Params params = this.autoBuild();
                DpPreconditions.checkEpsilon(params.epsilon());
                DpPreconditions.checkNoiseDelta(params.delta(), params.noise());
                DpPreconditions.checkMaxPartitionsContributed(params.maxPartitionsContributed());
                DpPreconditions.checkMaxContributionsPerPartition(params.maxContributionsPerPartition());
                DpPreconditions.checkBounds(params.lower(), params.upper());
                switch (params.noise().getMechanismType()) {
                    case LAPLACE: {
                        Builder.checkL1SensitivityOverflow(params.lower(), params.upper(), params.maxContributionsPerPartition(), params.maxPartitionsContributed());
                        break;
                    }
                    case GAUSSIAN: {
                        Builder.checkL2SensitivityOverflow(params.lower(), params.upper(), params.maxContributionsPerPartition(), params.maxPartitionsContributed());
                        break;
                    }
                }
                Builder.checkLInfSensitivityOverflow(params.lower(), params.upper(), params.maxContributionsPerPartition());
                return new BoundedSum(params);
            }
        }
    }
}

