/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.AggregationState;
import com.google.privacy.differentialprivacy.AutoValue_Count_Params;
import com.google.privacy.differentialprivacy.ConfidenceInterval;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.LaplaceNoise;
import com.google.privacy.differentialprivacy.Noise;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Optional;
import javax.annotation.Nullable;

public class Count {
    private final Params params;
    private long rawCount;
    private long noisedCount;
    private AggregationState state = AggregationState.DEFAULT;

    private Count(Params params) {
        this.params = params;
    }

    public static Params.Builder builder() {
        return Params.Builder.newBuilder();
    }

    public void increment() {
        this.incrementBy(1L);
    }

    public void incrementBy(long count) {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Count cannot be incremented.");
        if (count > 0L) {
            this.rawCount += count;
        }
    }

    public long computeResult() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"DP count cannot be computed.");
        this.state = AggregationState.RESULT_RETURNED;
        this.noisedCount = this.params.noise().addNoise(this.rawCount, this.params.maxPartitionsContributed(), this.params.maxContributionsPerPartition(), this.params.epsilon(), this.params.delta());
        return this.noisedCount;
    }

    public ConfidenceInterval computeConfidenceInterval(double alpha) {
        Preconditions.checkState((this.state == AggregationState.RESULT_RETURNED ? 1 : 0) != 0, (Object)"Confidence interval cannot be computed.");
        ConfidenceInterval confInt = this.params.noise().computeConfidenceInterval(this.noisedCount, this.params.maxPartitionsContributed(), this.params.maxContributionsPerPartition(), this.params.epsilon(), this.params.delta(), alpha);
        return ConfidenceInterval.create(Math.max(0.0, confInt.lowerBound()), Math.max(0.0, confInt.upperBound()));
    }

    public Optional<Long> computeThresholdedResult(double thresholdDelta) {
        DpPreconditions.checkDelta(thresholdDelta);
        long noisyCount = this.computeResult();
        Preconditions.checkState((this.params.noise().getMechanismType() == SummaryOuterClass.MechanismType.LAPLACE || this.params.noise().getMechanismType() == SummaryOuterClass.MechanismType.GAUSSIAN ? 1 : 0) != 0, (String)"Unable to calculate the threshold for an unknown mechanism type %s", (Object)((Object)this.params.noise().getMechanismType()));
        double thresholdDeltaPerPartition = thresholdDelta / (double)this.params.maxContributionsPerPartition();
        double threshold = -1.0 * this.params.noise().computeQuantile(thresholdDeltaPerPartition, 0.0, this.params.maxPartitionsContributed(), this.params.maxContributionsPerPartition(), this.params.epsilon(), this.params.delta()) + (double)this.params.maxContributionsPerPartition();
        if (Double.compare(noisyCount, threshold) >= 0) {
            return Optional.of(noisyCount);
        }
        return Optional.empty();
    }

    public byte[] getSerializableSummary() {
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Count cannot be serialized.");
        this.state = AggregationState.SERIALIZED;
        SummaryOuterClass.CountSummary.Builder builder = SummaryOuterClass.CountSummary.newBuilder().setCount(this.rawCount).setEpsilon(this.params.epsilon()).setMaxPartitionsContributed(this.params.maxPartitionsContributed()).setMaxContributionsPerPartition(this.params.maxContributionsPerPartition()).setMechanismType(this.params.noise().getMechanismType());
        if (this.params.delta() != null) {
            builder.setDelta(this.params.delta());
        }
        return builder.build().toByteArray();
    }

    public void mergeWith(byte[] otherCountSummary) {
        SummaryOuterClass.CountSummary otherSummaryParsed;
        Preconditions.checkState((this.state == AggregationState.DEFAULT ? 1 : 0) != 0, (Object)"Counts cannot be merged.");
        try {
            otherSummaryParsed = SummaryOuterClass.CountSummary.parseFrom(otherCountSummary);
        }
        catch (InvalidProtocolBufferException pbe) {
            throw new IllegalArgumentException(pbe);
        }
        this.checkMergeParametersAreEqual(otherSummaryParsed);
        this.rawCount += otherSummaryParsed.getCount();
    }

    private void checkMergeParametersAreEqual(SummaryOuterClass.CountSummary summary) {
        DpPreconditions.checkMergeMechanismTypesAreEqual(this.params.noise().getMechanismType(), summary.getMechanismType());
        DpPreconditions.checkMergeEpsilonAreEqual(this.params.epsilon(), summary.getEpsilon());
        DpPreconditions.checkMergeDeltaAreEqual(this.params.delta(), summary.getDelta());
        DpPreconditions.checkMergeMaxPartitionsContributedAreEqual(this.params.maxPartitionsContributed(), summary.getMaxPartitionsContributed());
        DpPreconditions.checkMergeMaxContributionsPerPartitionAreEqual(this.params.maxContributionsPerPartition(), summary.getMaxContributionsPerPartition());
    }

    @AutoValue
    public static abstract class Params {
        abstract Noise noise();

        abstract double epsilon();

        @Nullable
        abstract Double delta();

        abstract int maxPartitionsContributed();

        abstract int maxContributionsPerPartition();

        @AutoValue.Builder
        public static abstract class Builder {
            private static Builder newBuilder() {
                AutoValue_Count_Params.Builder builder = new AutoValue_Count_Params.Builder();
                ((Builder)builder).noise(new LaplaceNoise());
                ((Builder)builder).maxContributionsPerPartition(1);
                return builder;
            }

            public abstract Builder epsilon(double var1);

            public abstract Builder delta(@Nullable Double var1);

            public abstract Builder maxPartitionsContributed(int var1);

            public abstract Builder noise(Noise var1);

            abstract Builder maxContributionsPerPartition(int var1);

            abstract Params autoBuild();

            public Count build() {
                Params params = this.autoBuild();
                DpPreconditions.checkEpsilon(params.epsilon());
                DpPreconditions.checkNoiseDelta(params.delta(), params.noise());
                DpPreconditions.checkMaxPartitionsContributed(params.maxPartitionsContributed());
                DpPreconditions.checkMaxContributionsPerPartition(params.maxContributionsPerPartition());
                return new Count(params);
            }
        }
    }
}

