/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.Noise;
import java.util.Objects;
import javax.annotation.Nullable;

public class DpPreconditions {
    private DpPreconditions() {
    }

    static void checkEpsilon(double epsilon) {
        double epsilonLowerBound = 8.881784197001252E-16;
        Preconditions.checkArgument((Double.isFinite(epsilon) && epsilon >= epsilonLowerBound ? 1 : 0) != 0, (String)"epsilon must be >= %s and < infinity. Provided value: %s", (Object)epsilonLowerBound, (Object)epsilon);
    }

    static void checkNoiseDelta(Double delta, Noise noise) {
        if (noise.getMechanismType() == SummaryOuterClass.MechanismType.LAPLACE) {
            Preconditions.checkArgument((delta == null ? 1 : 0) != 0, (String)"delta should not be set when Laplace noise is used. Provided value: %s", (Object)delta);
        } else if (noise.getMechanismType() == SummaryOuterClass.MechanismType.GAUSSIAN) {
            Preconditions.checkNotNull((Object)delta);
            DpPreconditions.checkDelta(delta);
        } else if (delta != null) {
            Preconditions.checkArgument((delta >= 0.0 && delta < 1.0 ? 1 : 0) != 0, (String)"delta must be >= 0 and < 1. Provided value: %s", (Object)delta);
        }
    }

    static void checkDelta(double delta) {
        Preconditions.checkArgument((delta > 0.0 && delta < 1.0 ? 1 : 0) != 0, (String)"delta must be > 0 and < 1. Provided value: %s", (Object)delta);
    }

    static void checkSensitivities(int l0Sensitivity, double lInfSensitivity) {
        DpPreconditions.checkL0Sensitivity(l0Sensitivity);
        Preconditions.checkArgument((Double.isFinite(lInfSensitivity) && lInfSensitivity > 0.0 ? 1 : 0) != 0, (String)"lInfSensitivity must be > 0 and finite. Provided value: %s", (Object)lInfSensitivity);
    }

    static void checkL0Sensitivity(int l0Sensitivity) {
        Preconditions.checkArgument((l0Sensitivity > 0 ? 1 : 0) != 0, (String)"l0Sensitivity must be > 0. Provided value: %s", (int)l0Sensitivity);
    }

    static void checkL1Sensitivity(double l1Sensitivity) {
        Preconditions.checkArgument((Double.isFinite(l1Sensitivity) && l1Sensitivity > 0.0 ? 1 : 0) != 0, (String)"l1Sensitivity must be > 0 and finite. Provided value: %s", (Object)l1Sensitivity);
    }

    static void checkMaxPartitionsContributed(int maxPartitionsContributed) {
        DpPreconditions.checkL0Sensitivity(maxPartitionsContributed);
    }

    static void checkMaxContributionsPerPartition(int maxContributionsPerPartition) {
        Preconditions.checkArgument((maxContributionsPerPartition > 0 ? 1 : 0) != 0, (String)"maxContributionsPerPartitions must be > 0. Provided value: %s", (int)maxContributionsPerPartition);
    }

    static void checkBounds(double lower, double upper) {
        Preconditions.checkArgument((upper >= lower ? 1 : 0) != 0, (String)"The upper bound should be greater than the lower bound. Provided values: lower = %s upper = %s", (Object)lower, (Object)upper);
        Preconditions.checkArgument((Double.isFinite(lower) && Double.isFinite(upper) ? 1 : 0) != 0, (String)"Lower and upper bounds should be finite. Provided values: lower = %s upper = %s", (Object)lower, (Object)upper);
    }

    static void checkMergeDeltaAreEqual(@Nullable Double delta1, double delta2) {
        if (delta1 != null) {
            Preconditions.checkArgument((Double.compare(delta1, delta2) == 0 ? 1 : 0) != 0, (String)"Failed to merge: unequal values of delta. delta1 = %s, delta2 = %s", (Object)delta1, (Object)delta2);
        } else {
            Preconditions.checkArgument((Double.compare(delta2, 0.0) == 0 ? 1 : 0) != 0, (String)"Failed to merge: unequal values of delta. delta1 = %s, delta2 = %s", (Object)delta1, (Object)delta2);
        }
    }

    static void checkMergeEpsilonAreEqual(double epsilon1, double epsilon2) {
        Preconditions.checkArgument((Double.compare(epsilon1, epsilon2) == 0 ? 1 : 0) != 0, (String)"Failed to merge: unequal values of epsilon. epsilon1 = %s, epsilon2 = %s", (Object)epsilon1, (Object)epsilon2);
    }

    static void checkMergeBoundsAreEqual(double lower1, double lower2, double upper1, double upper2) {
        Preconditions.checkArgument((Double.compare(lower1, lower2) == 0 ? 1 : 0) != 0, (String)"Failed to merge: unequal lower bounds. lower1 = %s, lower2 = %s", (Object)lower1, (Object)lower2);
        Preconditions.checkArgument((Double.compare(upper1, upper2) == 0 ? 1 : 0) != 0, (String)"Failed to merge: unequal upper bounds. upper1 = %s, upper2 = %s", (Object)upper1, (Object)upper2);
    }

    static void checkMergeMaxContributionsPerPartitionAreEqual(int maxContributionsPerPartition1, int maxContributionsPerPartition2) {
        Preconditions.checkArgument((maxContributionsPerPartition1 == maxContributionsPerPartition2 ? 1 : 0) != 0, (String)"Failed to merge: unequal values of maxContributionsPerPartition. maxContributionsPerPartition1 = %s, maxContributionsPerPartition2 = %s", (int)maxContributionsPerPartition1, (int)maxContributionsPerPartition2);
    }

    static void checkMergeMaxPartitionsContributedAreEqual(int maxPartitionsContributed1, int maxPartitionsContributed2) {
        Preconditions.checkArgument((maxPartitionsContributed1 == maxPartitionsContributed2 ? 1 : 0) != 0, (String)"Failed to merge: unequal values of maxPartitionsContributed. maxPartitionsContributed1 = %s, maxPartitionsContributed2 = %s", (int)maxPartitionsContributed1, (int)maxPartitionsContributed2);
    }

    static void checkMergeMechanismTypesAreEqual(SummaryOuterClass.MechanismType type1, SummaryOuterClass.MechanismType type2) {
        Preconditions.checkArgument((boolean)Objects.equals((Object)type1, (Object)type2), (String)"Failed to merge: unequal mechanism types. type1 = %s, type2 = %s", (Object)((Object)type1), (Object)((Object)type2));
    }

    static void checkAlpha(double alpha) {
        Preconditions.checkArgument((0.0 < alpha && alpha < 1.0 ? 1 : 0) != 0, (String)"alpha should be strictly between 0 and 1. Provided value: %s", (Object)alpha);
    }

    static void checkNoiseComputeQuantileArguments(Noise noise, double rank, int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkSensitivities(l0Sensitivity, lInfSensitivity);
        DpPreconditions.checkEpsilon(epsilon);
        DpPreconditions.checkNoiseDelta(delta, noise);
        Preconditions.checkArgument((rank > 0.0 && rank < 1.0 ? 1 : 0) != 0, (String)"rank must be > 0 and < 1. Provided value: %s", (Object)rank);
    }
}

