/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.ConfidenceInterval;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.Noise;
import com.google.privacy.differentialprivacy.SecureNoiseMath;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Erf;

public class GaussianNoise
implements Noise {
    private static final double BINOMIAL_BOUND = 1.4411518807585587E17;
    private static final long GEOMETRIC_BOUND = Long.MAX_VALUE / Math.round(Math.sqrt(2.0) * 1.4411518807585587E17 + 1.0) - 1L;
    private static final NormalDistribution NORMAL_DISTRIBUTION = new NormalDistribution(null, 0.0, 1.0);
    private static final double GAUSSIAN_SIGMA_ACCURACY = 0.001;
    private final SecureRandom random = new SecureRandom();

    @Override
    public double addNoise(double x, int l0Sensitivity, double lInfSensitivity, double epsilon, Double delta) {
        this.checkParameters(l0Sensitivity, lInfSensitivity, epsilon, delta);
        double l2Sensitivity = Noise.getL2Sensitivity(l0Sensitivity, lInfSensitivity);
        double sigma = GaussianNoise.getSigma(l2Sensitivity, epsilon, delta);
        double granularity = GaussianNoise.getGranularity(sigma);
        double sqrtN = 2.0 * sigma / granularity;
        long binomialSample = this.sampleSymmetricBinomial(sqrtN);
        return SecureNoiseMath.roundToMultipleOfPowerOfTwo(x, granularity) + (double)binomialSample * granularity;
    }

    @Override
    public long addNoise(long x, int l0Sensitivity, long lInfSensitivity, double epsilon, @Nullable Double delta) {
        this.checkParameters(l0Sensitivity, lInfSensitivity, epsilon, delta);
        double l2Sensitivity = Noise.getL2Sensitivity(l0Sensitivity, lInfSensitivity);
        double sigma = GaussianNoise.getSigma(l2Sensitivity, epsilon, delta);
        double granularity = GaussianNoise.getGranularity(sigma);
        double sqrtN = 2.0 * sigma / granularity;
        long binomialSample = this.sampleSymmetricBinomial(sqrtN);
        if (granularity <= 1.0) {
            return x + Math.round((double)binomialSample * granularity);
        }
        return SecureNoiseMath.roundToMultiple(x, (long)granularity) + binomialSample * (long)granularity;
    }

    @Override
    public SummaryOuterClass.MechanismType getMechanismType() {
        return SummaryOuterClass.MechanismType.GAUSSIAN;
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double noisedX, int l0Sensitivity, double lInfSensitivity, double epsilon, Double delta, double alpha) {
        this.checkConfidenceIntervalParameters(l0Sensitivity, lInfSensitivity, epsilon, delta, alpha);
        double z = this.computeQuantile(alpha / 2.0, noisedX, l0Sensitivity, lInfSensitivity, epsilon, delta);
        return ConfidenceInterval.create(z, 2.0 * noisedX - z);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(long noisedX, int l0Sensitivity, long lInfSensitivity, double epsilon, Double delta, double alpha) {
        ConfidenceInterval confIntAroundZero = this.computeConfidenceInterval(0.0, l0Sensitivity, (double)lInfSensitivity, epsilon, delta, alpha);
        return ConfidenceInterval.create(SecureNoiseMath.nextSmallerDouble(Math.round(confIntAroundZero.lowerBound()) + noisedX), SecureNoiseMath.nextLargerDouble(Math.round(confIntAroundZero.upperBound()) + noisedX));
    }

    @Override
    public double computeQuantile(double rank, double x, int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkNoiseComputeQuantileArguments(this, rank, l0Sensitivity, lInfSensitivity, epsilon, delta);
        double l2Sensitivity = Noise.getL2Sensitivity(l0Sensitivity, lInfSensitivity);
        double sigma = GaussianNoise.getSigma(l2Sensitivity, epsilon, delta);
        return x - sigma * Math.sqrt(2.0) * Erf.erfcInv((double)(2.0 * rank));
    }

    private void checkParameters(int l0Sensitivity, double lInfSensitivity, double epsilon, Double delta) {
        DpPreconditions.checkSensitivities(l0Sensitivity, lInfSensitivity);
        DpPreconditions.checkEpsilon(epsilon);
        DpPreconditions.checkNoiseDelta(delta, this);
        double twoLInf = 2.0 * lInfSensitivity;
        Preconditions.checkArgument((boolean)Double.isFinite(twoLInf), (String)"2 * lInfSensitivity must be finite but is %s", (Object)twoLInf);
    }

    private void checkConfidenceIntervalParameters(int l0Sensitivity, double lInfSensitivity, double epsilon, Double delta, double alpha) {
        DpPreconditions.checkAlpha(alpha);
        this.checkParameters(l0Sensitivity, lInfSensitivity, epsilon, delta);
    }

    private static double getSigma(double l2Sensitivity, double epsilon, double delta) {
        double upperBound = l2Sensitivity;
        double lowerBound = 0.0;
        while (GaussianNoise.getDelta(upperBound, l2Sensitivity, epsilon) > delta) {
            lowerBound = upperBound;
            upperBound *= 2.0;
        }
        while (upperBound - lowerBound > 0.001 * lowerBound) {
            double middle = lowerBound * 0.5 + upperBound * 0.5;
            if (GaussianNoise.getDelta(middle, l2Sensitivity, epsilon) > delta) {
                lowerBound = middle;
                continue;
            }
            upperBound = middle;
        }
        return upperBound;
    }

    private static double getDelta(double sigma, double l2Sensitivity, double epsilon) {
        double a = l2Sensitivity / (2.0 * sigma);
        double b = epsilon * sigma / l2Sensitivity;
        double c = Math.exp(epsilon);
        if (b == Double.POSITIVE_INFINITY || c == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return NORMAL_DISTRIBUTION.cumulativeProbability(a - b) - c * NORMAL_DISTRIBUTION.cumulativeProbability(-a - b);
    }

    private static double getGranularity(double sigma) {
        return SecureNoiseMath.ceilPowerOfTwo(2.0 * sigma / 1.4411518807585587E17);
    }

    @VisibleForTesting
    long sampleSymmetricBinomial(double sqrtN) {
        long result;
        long geometricSample;
        double rejectProbability;
        double resultProbability;
        Preconditions.checkArgument((sqrtN >= 1000000.0 ? 1 : 0) != 0, (String)"Input must be at least 10^6. Provided value: %s", (Object)sqrtN);
        Preconditions.checkArgument((boolean)Double.isFinite(sqrtN), (String)"Input must be finite. Provided value: %s", (Object)sqrtN);
        long stepSize = Math.round(Math.sqrt(2.0) * sqrtN + 1.0);
        do {
            geometricSample = this.sampleBoundedGeometric();
            long twoSidedGeometricSample = this.random.nextBoolean() ? geometricSample : -geometricSample - 1L;
            result = stepSize * twoSidedGeometricSample + this.sampleUniform(stepSize);
            resultProbability = GaussianNoise.approximateBinomialProbability(sqrtN, result);
            rejectProbability = this.random.nextDouble();
        } while (!(resultProbability > 0.0) || !(rejectProbability > 0.0) || !(rejectProbability < resultProbability * (double)stepSize * Math.pow(2.0, geometricSample) / 4.0));
        return result;
    }

    private long sampleBoundedGeometric() {
        long result;
        for (result = 0L; this.random.nextBoolean() && result < GEOMETRIC_BOUND; ++result) {
        }
        return result;
    }

    private long sampleUniform(long n) {
        long signMask;
        long uniformNonNegativeLong;
        long largestMultipleOfN = Long.MAX_VALUE / n * n;
        while ((uniformNonNegativeLong = (signMask = Long.MAX_VALUE) & this.random.nextLong()) >= largestMultipleOfN) {
        }
        return uniformNonNegativeLong % n;
    }

    private static double approximateBinomialProbability(double sqrtN, long m) {
        if ((double)Math.abs(m) > sqrtN * Math.sqrt(Math.log(sqrtN) / 2.0)) {
            return 0.0;
        }
        return Math.sqrt(0.6366197723675814) / sqrtN * Math.exp(-2.0 * (double)m * (double)m / (sqrtN * sqrtN)) * (1.0 - 0.4 * Math.pow(2.0, 1.5) * Math.pow(Math.log(sqrtN), 1.5) / sqrtN);
    }
}

