/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.differentialprivacy.SummaryOuterClass;
import com.google.privacy.differentialprivacy.ConfidenceInterval;
import com.google.privacy.differentialprivacy.DpPreconditions;
import com.google.privacy.differentialprivacy.Noise;
import com.google.privacy.differentialprivacy.SecureNoiseMath;
import java.security.SecureRandom;
import javax.annotation.Nullable;

public class LaplaceNoise
implements Noise {
    private static final double GRANULARITY_PARAM = 1.099511627776E12;
    private final SecureRandom random = new SecureRandom();

    @Override
    public double addNoise(double x, int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkSensitivities(l0Sensitivity, lInfSensitivity);
        return this.addNoise(x, Noise.getL1Sensitivity(l0Sensitivity, lInfSensitivity), epsilon, delta);
    }

    public double addNoise(double x, double l1Sensitivity, double epsilon, @Nullable Double delta) {
        this.checkParameters(l1Sensitivity, epsilon, delta);
        double granularity = LaplaceNoise.getGranularity(l1Sensitivity, epsilon);
        long twoSidedGeomericSample = this.sampleTwoSidedGeometric(granularity * epsilon / (l1Sensitivity + granularity));
        return SecureNoiseMath.roundToMultipleOfPowerOfTwo(x, granularity) + (double)twoSidedGeomericSample * granularity;
    }

    @Override
    public long addNoise(long x, int l0Sensitivity, long lInfSensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkSensitivities(l0Sensitivity, lInfSensitivity);
        return this.addNoise(x, (long)Noise.getL1Sensitivity(l0Sensitivity, lInfSensitivity), epsilon, delta);
    }

    public long addNoise(long x, long l1Sensitivity, double epsilon, @Nullable Double delta) {
        this.checkParameters(l1Sensitivity, epsilon, delta);
        double granularity = LaplaceNoise.getGranularity(l1Sensitivity, epsilon);
        long twoSidedGeomericSample = this.sampleTwoSidedGeometric(granularity * epsilon / ((double)l1Sensitivity + granularity));
        if (granularity <= 1.0) {
            return x + Math.round((double)twoSidedGeomericSample * granularity);
        }
        return SecureNoiseMath.roundToMultiple(x, (long)granularity) + twoSidedGeomericSample * (long)granularity;
    }

    @Override
    public SummaryOuterClass.MechanismType getMechanismType() {
        return SummaryOuterClass.MechanismType.LAPLACE;
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(double noisedX, int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta, double alpha) {
        this.checkConfidenceIntervalParameters(l0Sensitivity, lInfSensitivity, epsilon, delta, alpha);
        double z = this.computeQuantile(alpha / 2.0, noisedX, l0Sensitivity, lInfSensitivity, epsilon, delta);
        return ConfidenceInterval.create(z, 2.0 * noisedX - z);
    }

    @Override
    public ConfidenceInterval computeConfidenceInterval(long noisedX, int l0Sensitivity, long lInfSensitivity, double epsilon, @Nullable Double delta, double alpha) {
        ConfidenceInterval confIntAroundZero = this.computeConfidenceInterval(0.0, l0Sensitivity, (double)lInfSensitivity, epsilon, delta, alpha);
        return ConfidenceInterval.create(SecureNoiseMath.nextSmallerDouble(Math.round(confIntAroundZero.lowerBound()) + noisedX), SecureNoiseMath.nextLargerDouble(Math.round(confIntAroundZero.upperBound()) + noisedX));
    }

    @Override
    public double computeQuantile(double rank, double x, int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkNoiseComputeQuantileArguments(this, rank, l0Sensitivity, lInfSensitivity, epsilon, delta);
        double lambda = Noise.getL1Sensitivity(l0Sensitivity, lInfSensitivity) / epsilon;
        if (rank < 0.5) {
            return x + lambda * Math.log(2.0 * rank);
        }
        return x - lambda * Math.log(2.0 * (1.0 - rank));
    }

    private void checkParameters(double l1Sensitivity, double epsilon, @Nullable Double delta) {
        DpPreconditions.checkEpsilon(epsilon);
        DpPreconditions.checkNoiseDelta(delta, this);
        DpPreconditions.checkL1Sensitivity(l1Sensitivity);
    }

    private void checkConfidenceIntervalParameters(int l0Sensitivity, double lInfSensitivity, double epsilon, @Nullable Double delta, double alpha) {
        DpPreconditions.checkAlpha(alpha);
        DpPreconditions.checkSensitivities(l0Sensitivity, lInfSensitivity);
        this.checkParameters(Noise.getL1Sensitivity(l0Sensitivity, lInfSensitivity), epsilon, delta);
    }

    private static double getGranularity(double l1Sensitivity, double epsilon) {
        return SecureNoiseMath.ceilPowerOfTwo(l1Sensitivity / epsilon / 1.099511627776E12);
    }

    @VisibleForTesting
    long sampleGeometric(double lambda) {
        Preconditions.checkArgument((lambda > 1.734723475976807E-18 ? 1 : 0) != 0, (String)"The parameter lambda must be at least 2^-59. Provided value: %s", (Object)lambda);
        if (this.random.nextDouble() > -1.0 * Math.expm1(-1.0 * lambda * 9.223372036854776E18)) {
            return Long.MAX_VALUE;
        }
        long left = 0L;
        long right = Long.MAX_VALUE;
        while (left + 1L < right) {
            long mid = (long)Math.ceil((double)left - (Math.log(0.5) + Math.log1p(Math.exp(lambda * (double)(left - right)))) / lambda);
            mid = Math.min(Math.max(mid, left + 1L), right - 1L);
            double q = Math.expm1(lambda * (double)(left - mid)) / Math.expm1(lambda * (double)(left - right));
            if (this.random.nextDouble() <= q) {
                right = mid;
                continue;
            }
            left = mid;
        }
        return right;
    }

    private long sampleTwoSidedGeometric(double lambda) {
        long geometricSample = 0L;
        boolean sign = false;
        while (geometricSample == 0L && !sign) {
            geometricSample = this.sampleGeometric(lambda) - 1L;
            sign = this.random.nextBoolean();
        }
        return sign ? geometricSample : -geometricSample;
    }
}

