/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.differentialprivacy;

import com.google.common.base.Preconditions;

final class SecureNoiseMath {
    private SecureNoiseMath() {
    }

    public static double ceilPowerOfTwo(double x) {
        Preconditions.checkArgument((x > 0.0 ? 1 : 0) != 0, (String)"Input must be positive. Provided value: %s", (Object)x);
        Preconditions.checkArgument((boolean)Double.isFinite(x), (String)"Input must be finite. Provided value: %s", (Object)x);
        Preconditions.checkArgument((!Double.isNaN(x) ? 1 : 0) != 0, (Object)"Input must be a number. Provided value: NaN");
        long exponentMask = 0x7FF0000000000000L;
        long mantissaMask = 0xFFFFFFFFFFFFFL;
        long bits = Double.doubleToLongBits(x);
        long mantissaBits = bits & 0xFFFFFFFFFFFFFL;
        if (mantissaBits == 0L) {
            return x;
        }
        long exponentBits = bits & 0x7FF0000000000000L;
        long maxExponentBits = Double.doubleToLongBits(Double.MAX_VALUE) & 0x7FF0000000000000L;
        Preconditions.checkArgument((exponentBits < maxExponentBits ? 1 : 0) != 0, (String)"Input must not be greater than 2^1023. Provided value: %s", (Object)x);
        return Double.longBitsToDouble(exponentBits + 0x10000000000000L);
    }

    public static double roundToMultipleOfPowerOfTwo(double x, double granularity) {
        Preconditions.checkArgument((granularity > 0.0 && Double.isFinite(granularity) && (Double.doubleToLongBits(granularity) & 0xFFFFFFFFFFFFFL) == 0L ? 1 : 0) != 0, (String)"Granularity must be a power of 2. Provided value: %s", (Object)granularity);
        if (Math.abs(x / granularity) < 1.8014398509481984E16) {
            return (double)Math.round(x / granularity) * granularity;
        }
        return x;
    }

    public static long roundToMultiple(long x, long granularity) {
        Preconditions.checkArgument((granularity > 0L ? 1 : 0) != 0, (String)"Granularity must be positive. Provided value: %s", (long)granularity);
        return (x / granularity + Math.round((double)(x % granularity) / (double)granularity)) * granularity;
    }

    public static double nextLargerDouble(long n) {
        double result = n;
        long dif = (long)result - n;
        return dif >= 0L ? result : Math.nextUp(result);
    }

    public static double nextSmallerDouble(long n) {
        double result = n;
        long dif = (long)result - n;
        return dif <= 0L ? result : Math.nextDown(result);
    }
}

