/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.gradle.ExecutableLocator;
import com.google.protobuf.gradle.ToolsLocator;
import com.google.protobuf.gradle.Utils;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;

public class GenerateProtoTask
extends DefaultTask
implements GroovyObject {
    private static final int WINDOWS_CMD_LENGTH_LIMIT = 32760;
    private static final int CMD_ARGUMENT_EXTRA_LENGTH = 3;
    private final ConfigurableFileCollection includeDirs;
    private final ConfigurableFileCollection sourceFiles;
    private final NamedDomainObjectContainer<PluginOptions> builtins;
    private final NamedDomainObjectContainer<PluginOptions> plugins;
    private String outputBaseDir;
    private SourceSet sourceSet;
    private Object variant;
    private ImmutableList<String> flavors;
    private String buildType;
    private boolean isTestVariant;
    private FileResolver fileResolver;
    private boolean generateDescriptorSet;
    private final DescriptorSetOptions descriptorSetOptions;
    private State state;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GenerateProtoTask() {
        MetaClass metaClass;
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.includeDirs = (ConfigurableFileCollection)ScriptBytecodeAdapter.castToType((Object)object, ConfigurableFileCollection.class);
        Object object2 = callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this));
        this.sourceFiles = (ConfigurableFileCollection)ScriptBytecodeAdapter.castToType((Object)object2, ConfigurableFileCollection.class);
        Object object3 = callSiteArray[4].callConstructor(DescriptorSetOptions.class, (Object)this);
        this.descriptorSetOptions = (DescriptorSetOptions)ScriptBytecodeAdapter.castToType((Object)object3, DescriptorSetOptions.class);
        Object object4 = callSiteArray[5].callGetProperty(State.class);
        this.state = (State)ShortTypeHandling.castToEnum((Object)object4, State.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object5 = callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), PluginOptions.class);
        this.builtins = (NamedDomainObjectContainer)ScriptBytecodeAdapter.castToType((Object)object5, NamedDomainObjectContainer.class);
        Object object6 = callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), PluginOptions.class);
        this.plugins = (NamedDomainObjectContainer)ScriptBytecodeAdapter.castToType((Object)object6, NamedDomainObjectContainer.class);
    }

    public static String makeOptionsPrefix(List<String> options) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        Reference prefix = new Reference((Object)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callConstructor(StringBuilder.class), StringBuilder.class)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(options))) {
            public final class _makeOptionsPrefix_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference prefix;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _makeOptionsPrefix_closure1(Object _outerInstance, Object _thisObject, Reference prefix) {
                    Reference reference;
                    CallSite[] callSiteArray = _makeOptionsPrefix_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.prefix = reference = prefix;
                }

                public Object doCall(Object option) {
                    CallSite[] callSiteArray = _makeOptionsPrefix_closure1.$getCallSiteArray();
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].call(this.prefix.get()), (Object)0)) {
                        callSiteArray[1].call(this.prefix.get(), (Object)",");
                    }
                    return callSiteArray[2].call(this.prefix.get(), option);
                }

                public StringBuilder getPrefix() {
                    CallSite[] callSiteArray = _makeOptionsPrefix_closure1.$getCallSiteArray();
                    return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.prefix.get(), StringBuilder.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _makeOptionsPrefix_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "length";
                    stringArray[1] = "append";
                    stringArray[2] = "append";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _makeOptionsPrefix_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_makeOptionsPrefix_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _makeOptionsPrefix_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[12].call(options, (Object)new _makeOptionsPrefix_closure1(GenerateProtoTask.class, GenerateProtoTask.class, prefix));
            callSiteArray[13].call((Object)((StringBuilder)prefix.get()), (Object)":");
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[14].call((Object)((StringBuilder)prefix.get())));
    }

    public static List<List<String>> generateCmds(List<String> baseCmd, List<File> protoFiles, int cmdLengthLimit) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        List cmds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(protoFiles))) {
            public final class _generateCmds_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _generateCmds_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _generateCmds_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _generateCmds_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].call(it), callSiteArray[2].callGetProperty(GenerateProtoTask.class));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _generateCmds_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _generateCmds_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "length";
                    stringArray[2] = "CMD_ARGUMENT_EXTRA_LENGTH";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _generateCmds_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_generateCmds_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _generateCmds_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            int baseCmdLength = DefaultTypeTransformation.intUnbox((Object)callSiteArray[16].call(baseCmd, (Object)new _generateCmds_closure2(GenerateProtoTask.class, GenerateProtoTask.class)));
            List currentArgs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            int currentArgsLength = 0;
            File proto = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call(protoFiles), Iterator.class);
            while (iterator.hasNext()) {
                proto = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
                String protoFileName = ShortTypeHandling.castToString((Object)proto);
                int currentFileLength = DefaultTypeTransformation.intUnbox((Object)callSiteArray[18].call(callSiteArray[19].call((Object)protoFileName), (Object)CMD_ARGUMENT_EXTRA_LENGTH));
                if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[20].call(callSiteArray[21].call((Object)baseCmdLength, (Object)currentArgsLength), (Object)currentFileLength)) > cmdLengthLimit) {
                    int n;
                    callSiteArray[22].call((Object)cmds, callSiteArray[23].call(baseCmd, (Object)currentArgs));
                    callSiteArray[24].call((Object)currentArgs);
                    currentArgsLength = n = 0;
                }
                callSiteArray[25].call((Object)currentArgs, (Object)protoFileName);
                currentArgsLength = DefaultTypeTransformation.intUnbox((Object)callSiteArray[26].call((Object)currentArgsLength, (Object)currentFileLength));
            }
            callSiteArray[27].call((Object)cmds, callSiteArray[28].call(baseCmd, (Object)currentArgs));
        }
        return cmds;
    }

    public static int getCmdLengthLimit() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[29].callStatic(GenerateProtoTask.class, callSiteArray[30].call(System.class, (Object)"os.name")));
    }

    public static int getCmdLengthLimit(String os) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareNotEqual((Object)os, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[31].call(callSiteArray[32].call((Object)os, callSiteArray[33].callGetProperty(Locale.class)), (Object)"win"), (Object)-1) : ScriptBytecodeAdapter.compareNotEqual((Object)os, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[34].call(callSiteArray[35].call((Object)os, callSiteArray[36].callGetProperty(Locale.class)), (Object)"win"), (Object)-1)) {
            return WINDOWS_CMD_LENGTH_LIMIT;
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[37].callGetProperty(Integer.class));
    }

    public void setOutputBaseDir(String outputBaseDir) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[38].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        callSiteArray[39].call(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)this.outputBaseDir, null), (Object)"outputBaseDir is already set");
        String string = outputBaseDir;
        this.outputBaseDir = ShortTypeHandling.castToString((Object)string);
        callSiteArray[40].call(callSiteArray[41].callGroovyObjectGetProperty((Object)this), (Object)outputBaseDir);
    }

    public void setSourceSet(SourceSet sourceSet) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[42].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        callSiteArray[43].call(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call(Utils.class, callSiteArray[45].callGroovyObjectGetProperty((Object)this))) ? 1 : 0), (Object)"sourceSet should not be set in an Android project");
        SourceSet sourceSet2 = sourceSet;
        this.sourceSet = (SourceSet)ScriptBytecodeAdapter.castToType((Object)sourceSet2, SourceSet.class);
    }

    public void setVariant(Object variant, boolean isTestVariant) {
        Object object;
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[46].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        callSiteArray[47].call(Preconditions.class, callSiteArray[48].call(Utils.class, callSiteArray[49].callGroovyObjectGetProperty((Object)this)), (Object)"variant should not be set in a Java project");
        this.variant = object = variant;
        boolean bl = isTestVariant;
        this.isTestVariant = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public void setFlavors(ImmutableList<String> flavors) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[50].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        callSiteArray[51].call(Preconditions.class, callSiteArray[52].call(Utils.class, callSiteArray[53].callGroovyObjectGetProperty((Object)this)), (Object)"flavors should not be set in a Java project");
        ImmutableList<String> immutableList = flavors;
        this.flavors = (ImmutableList)ScriptBytecodeAdapter.castToType(immutableList, ImmutableList.class);
    }

    public void setBuildType(String buildType) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[54].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        callSiteArray[55].call(Preconditions.class, callSiteArray[56].call(Utils.class, callSiteArray[57].callGroovyObjectGetProperty((Object)this)), (Object)"buildType should not be set in a Java project");
        String string = buildType;
        this.buildType = ShortTypeHandling.castToString((Object)string);
    }

    public void setFileResolver(FileResolver fileResolver) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[58].callCurrent((GroovyObject)this);
        } else {
            this.checkInitializing();
        }
        FileResolver fileResolver2 = fileResolver;
        this.fileResolver = (FileResolver)ScriptBytecodeAdapter.castToType((Object)fileResolver2, FileResolver.class);
    }

    public SourceSet getSourceSet() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[59].call(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call(Utils.class, callSiteArray[61].callGroovyObjectGetProperty((Object)this))) ? 1 : 0), (Object)"sourceSet should not be used in an Android project");
        callSiteArray[62].call(Preconditions.class, (Object)this.sourceSet, (Object)"sourceSet is not set");
        return this.sourceSet;
    }

    public FileCollection getSourceFiles() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return this.sourceFiles;
    }

    public Object getVariant() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[63].call(Preconditions.class, callSiteArray[64].call(Utils.class, callSiteArray[65].callGroovyObjectGetProperty((Object)this)), (Object)"variant should not be used in a Java project");
        callSiteArray[66].call(Preconditions.class, this.variant, (Object)"variant is not set");
        return this.variant;
    }

    public boolean getIsTestVariant() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[67].call(Preconditions.class, callSiteArray[68].call(Utils.class, callSiteArray[69].callGroovyObjectGetProperty((Object)this)), (Object)"isTestVariant should not be used in a Java project");
        callSiteArray[70].call(Preconditions.class, this.variant, (Object)"variant is not set");
        return this.isTestVariant;
    }

    public ImmutableList<String> getFlavors() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[71].call(Preconditions.class, callSiteArray[72].call(Utils.class, callSiteArray[73].callGroovyObjectGetProperty((Object)this)), (Object)"flavors should not be used in a Java project");
        callSiteArray[74].call(Preconditions.class, this.flavors, (Object)"flavors is not set");
        return this.flavors;
    }

    public String getBuildType() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[75].call(Preconditions.class, callSiteArray[76].call(Utils.class, callSiteArray[77].callGroovyObjectGetProperty((Object)this)), (Object)"buildType should not be used in a Java project");
        callSiteArray[78].call(Preconditions.class, (Object)(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[79].callGetProperty(this.variant), (Object)"test") || DefaultTypeTransformation.booleanUnbox((Object)this.buildType) ? 1 : 0), (Object)"buildType is not set and task is not for local unit test variant");
        return this.buildType;
    }

    public FileResolver getFileResolver() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[80].call(Preconditions.class, (Object)this.fileResolver);
        return this.fileResolver;
    }

    public void doneInitializing() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[81].call(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[82].callGetProperty(State.class)), (Object)new GStringImpl(new Object[]{this.state}, new String[]{"Invalid state: ", ""}));
        Object object = callSiteArray[83].callGetProperty(State.class);
        this.state = (State)ShortTypeHandling.castToEnum((Object)object, State.class);
    }

    public void doneConfig() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[84].call(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[85].callGetProperty(State.class)), (Object)new GStringImpl(new Object[]{this.state}, new String[]{"Invalid state: ", ""}));
        Object object = callSiteArray[86].callGetProperty(State.class);
        this.state = (State)ShortTypeHandling.castToEnum((Object)object, State.class);
    }

    public String getDescriptorPath() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (!this.generateDescriptorSet) {
            throw (Throwable)callSiteArray[87].callConstructor(IllegalStateException.class, (Object)"requested descriptor path but descriptor generation is off");
        }
        return ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[88].callGroovyObjectGetProperty((Object)this.descriptorSetOptions), null) ? callSiteArray[89].callGroovyObjectGetProperty((Object)this.descriptorSetOptions) : new GStringImpl(new Object[]{this.outputBaseDir}, new String[]{"", "/descriptor_set.desc"})));
    }

    public void builtins(Closure configureClosure) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[90].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        callSiteArray[91].call(ConfigureUtil.class, (Object)configureClosure, this.builtins);
    }

    public NamedDomainObjectContainer<PluginOptions> getBuiltins() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[92].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        return this.builtins;
    }

    public void plugins(Closure configureClosure) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[93].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        callSiteArray[94].call(ConfigureUtil.class, (Object)configureClosure, this.plugins);
    }

    public NamedDomainObjectContainer<PluginOptions> getPlugins() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[95].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        return this.plugins;
    }

    public boolean hasPlugin(String name) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[96].call(this.plugins, (Object)name), null);
    }

    public void addIncludeDir(FileCollection dir) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[97].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        callSiteArray[98].call((Object)this.includeDirs, (Object)dir);
        callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].callGroovyObjectGetProperty((Object)this), (Object)dir), callSiteArray[102].callGetProperty(PathSensitivity.class));
    }

    public void addSourceFiles(FileCollection files) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[103].callCurrent((GroovyObject)this);
        } else {
            this.checkCanConfig();
        }
        callSiteArray[104].call((Object)this.sourceFiles, (Object)files);
        callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].callGroovyObjectGetProperty((Object)this), (Object)files), callSiteArray[108].callGetProperty(PathSensitivity.class));
    }

    public boolean getIsTest() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].call(Utils.class, callSiteArray[110].callGroovyObjectGetProperty((Object)this)))) {
            return this.isTestVariant;
        }
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[111].call(Utils.class, callSiteArray[112].callGetProperty((Object)this.sourceSet)));
    }

    public String getOutputDir(PluginOptions plugin) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.outputBaseDir, callSiteArray[113].callGroovyObjectGetProperty((Object)plugin)}, new String[]{"", "/", ""}));
    }

    public SourceDirectorySet getOutputSourceDirectorySet() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        String srcSetName = ShortTypeHandling.castToString((Object)callSiteArray[114].call((Object)"generate-proto-", callSiteArray[115].callGroovyObjectGetProperty((Object)this)));
        Reference srcSet = new Reference(null);
        SourceDirectorySet cfr_ignored_0 = (SourceDirectorySet)srcSet.get();
        if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[116].call(Utils.class, callSiteArray[117].callGroovyObjectGetProperty((Object)this), (Object)"5.0"), (Object)0)) {
            callSiteArray[118].call(Preconditions.class, (Object)this.fileResolver);
            Object object = callSiteArray[119].callConstructor(DefaultSourceDirectorySet.class, (Object)srcSetName, (Object)this.fileResolver, callSiteArray[120].callConstructor(DefaultDirectoryFileTreeFactory.class));
            srcSet.set((Object)((SourceDirectorySet)ScriptBytecodeAdapter.castToType((Object)object, SourceDirectorySet.class)));
        } else {
            Object object = callSiteArray[121].call(callSiteArray[122].callGetProperty(callSiteArray[123].callGroovyObjectGetProperty((Object)this)), (Object)srcSetName, (Object)srcSetName);
            srcSet.set((Object)((SourceDirectorySet)ScriptBytecodeAdapter.castToType((Object)object, SourceDirectorySet.class)));
        }
        public final class _getOutputSourceDirectorySet_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getOutputSourceDirectorySet_closure3(Object _outerInstance, Object _thisObject, Reference srcSet) {
                Reference reference;
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcSet = reference = srcSet;
            }

            public Object doCall(Object builtin) {
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure3.$getCallSiteArray();
                return callSiteArray[0].call(this.srcSet.get(), callSiteArray[1].callConstructor(File.class, callSiteArray[2].callCurrent((GroovyObject)this, builtin)));
            }

            public SourceDirectorySet getSrcSet() {
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure3.$getCallSiteArray();
                return (SourceDirectorySet)ScriptBytecodeAdapter.castToType((Object)this.srcSet.get(), SourceDirectorySet.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOutputSourceDirectorySet_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "srcDir";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "getOutputDir";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getOutputSourceDirectorySet_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getOutputSourceDirectorySet_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getOutputSourceDirectorySet_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[124].call(this.builtins, (Object)new _getOutputSourceDirectorySet_closure3((Object)this, (Object)this, srcSet));
        public final class _getOutputSourceDirectorySet_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getOutputSourceDirectorySet_closure4(Object _outerInstance, Object _thisObject, Reference srcSet) {
                Reference reference;
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcSet = reference = srcSet;
            }

            public Object doCall(Object plugin) {
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure4.$getCallSiteArray();
                return callSiteArray[0].call(this.srcSet.get(), callSiteArray[1].callConstructor(File.class, callSiteArray[2].callCurrent((GroovyObject)this, plugin)));
            }

            public SourceDirectorySet getSrcSet() {
                CallSite[] callSiteArray = _getOutputSourceDirectorySet_closure4.$getCallSiteArray();
                return (SourceDirectorySet)ScriptBytecodeAdapter.castToType((Object)this.srcSet.get(), SourceDirectorySet.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOutputSourceDirectorySet_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "srcDir";
                stringArray[1] = "<$constructor$>";
                stringArray[2] = "getOutputDir";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getOutputSourceDirectorySet_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getOutputSourceDirectorySet_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getOutputSourceDirectorySet_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[125].call(this.plugins, (Object)new _getOutputSourceDirectorySet_closure4((Object)this, (Object)this, srcSet));
        return (SourceDirectorySet)srcSet.get();
    }

    @TaskAction
    public void compile() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[126].call(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[127].callGetProperty(State.class)), (Object)"doneConfig() has not been called");
        Reference tools = new Reference((Object)((ToolsLocator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callGetProperty(callSiteArray[129].callGetProperty(callSiteArray[130].callGroovyObjectGetProperty((Object)this))), ToolsLocator.class)));
        List protoFiles = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].call(callSiteArray[132].callGetProperty((Object)this.sourceFiles)), List.class);
        public final class _compile_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _compile_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object plugin) {
                CallSite[] callSiteArray = _compile_closure5.$getCallSiteArray();
                File outputDir = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(File.class, callSiteArray[1].callCurrent((GroovyObject)this, plugin)), File.class);
                return callSiteArray[2].call((Object)outputDir);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "getOutputDir";
                stringArray[2] = "mkdirs";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _compile_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_compile_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ScriptBytecodeAdapter.invokeMethodNSpreadSafe(GenerateProtoTask.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.builtins, this.plugins}), (String)"each", (Object[])new Object[]{new _compile_closure5((Object)this, (Object)this)});
        public final class _compile_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _compile_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _compile_closure6.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _compile_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "exists";
                return new CallSiteArray(_compile_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _compile_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _compile_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _compile_closure7.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"-I", ""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _compile_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_compile_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List dirs = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call(ScriptBytecodeAdapter.getPropertySpreadSafe(GenerateProtoTask.class, (Object)callSiteArray[134].call((Object)this.includeDirs, (Object)new _compile_closure6((Object)this, (Object)this)), (String)"path"), (Object)new _compile_closure7((Object)this, (Object)this)), List.class);
        callSiteArray[135].call(callSiteArray[136].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{dirs}, new String[]{"ProtobufCompile using directories ", ""}));
        callSiteArray[137].call(callSiteArray[138].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{protoFiles}, new String[]{"ProtobufCompile using files ", ""}));
        Reference baseCmd = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[139].callGetProperty(callSiteArray[140].callGroovyObjectGetProperty((Object)((ToolsLocator)tools.get())))}));
        callSiteArray[141].call((Object)((List)baseCmd.get()), (Object)dirs);
        public final class _compile_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference baseCmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure8(Object _outerInstance, Object _thisObject, Reference baseCmd) {
                Reference reference;
                CallSite[] callSiteArray = _compile_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.baseCmd = reference = baseCmd;
            }

            public Object doCall(Object builtin) {
                CallSite[] callSiteArray = _compile_closure8.$getCallSiteArray();
                String outPrefix = ShortTypeHandling.castToString((Object)callSiteArray[0].callStatic(GenerateProtoTask.class, callSiteArray[1].callGetProperty(builtin)));
                Object object = callSiteArray[2].call(this.baseCmd.get(), (Object)new GStringImpl(new Object[]{callSiteArray[3].callGetProperty(builtin), outPrefix, callSiteArray[4].callCurrent((GroovyObject)this, builtin)}, new String[]{"--", "_out=", "", ""}));
                this.baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class)));
                return object;
            }

            public List getBaseCmd() {
                CallSite[] callSiteArray = _compile_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "makeOptionsPrefix";
                stringArray[1] = "options";
                stringArray[2] = "plus";
                stringArray[3] = "name";
                stringArray[4] = "getOutputDir";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _compile_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_compile_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[142].call(this.builtins, (Object)new _compile_closure8((Object)this, (Object)this, baseCmd));
        public final class _compile_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tools;
            private /* synthetic */ Reference baseCmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _compile_closure9(Object _outerInstance, Object _thisObject, Reference tools, Reference baseCmd) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _compile_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.tools = reference2 = tools;
                this.baseCmd = reference = baseCmd;
            }

            public Object doCall(Object plugin) {
                CallSite[] callSiteArray = _compile_closure9.$getCallSiteArray();
                String name = ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(plugin));
                ExecutableLocator locator = (ExecutableLocator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty(this.tools.get()), (Object)name), ExecutableLocator.class);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)locator, null)) {
                    this.baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(this.baseCmd.get(), (Object)new GStringImpl(new Object[]{name, callSiteArray[4].callGroovyObjectGetProperty((Object)locator)}, new String[]{"--plugin=protoc-gen-", "=", ""})), List.class)));
                } else {
                    callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{name, name}, new String[]{"protoc plugin '", "' not defined. Trying to use 'protoc-gen-", "' from system path"}));
                }
                String pluginOutPrefix = ShortTypeHandling.castToString((Object)callSiteArray[7].callStatic(GenerateProtoTask.class, callSiteArray[8].callGetProperty(plugin)));
                Object object = callSiteArray[9].call(this.baseCmd.get(), (Object)new GStringImpl(new Object[]{name, pluginOutPrefix, callSiteArray[10].callCurrent((GroovyObject)this, plugin)}, new String[]{"--", "_out=", "", ""}));
                this.baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object, List.class)));
                return object;
            }

            public ToolsLocator getTools() {
                CallSite[] callSiteArray = _compile_closure9.$getCallSiteArray();
                return (ToolsLocator)ScriptBytecodeAdapter.castToType((Object)this.tools.get(), ToolsLocator.class);
            }

            public List getBaseCmd() {
                CallSite[] callSiteArray = _compile_closure9.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "findByName";
                stringArray[2] = "plugins";
                stringArray[3] = "plus";
                stringArray[4] = "path";
                stringArray[5] = "warn";
                stringArray[6] = "logger";
                stringArray[7] = "makeOptionsPrefix";
                stringArray[8] = "options";
                stringArray[9] = "plus";
                stringArray[10] = "getOutputDir";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _compile_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_compile_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _compile_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[143].call(this.plugins, (Object)new _compile_closure9((Object)this, (Object)this, tools, baseCmd));
        if (this.generateDescriptorSet) {
            String path = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[144].callCurrent((GroovyObject)this);
                path = ShortTypeHandling.castToString((Object)object);
            } else {
                String string;
                path = string = this.getDescriptorPath();
            }
            File folder = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callGetProperty(callSiteArray[146].callConstructor(File.class, (Object)path)), File.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[147].call((Object)folder))) {
                callSiteArray[148].call((Object)folder);
            }
            baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].call((Object)((List)baseCmd.get()), (Object)new GStringImpl(new Object[]{path}, new String[]{"--descriptor_set_out=", ""})), List.class)));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callGroovyObjectGetProperty((Object)this.descriptorSetOptions))) {
                baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call((Object)((List)baseCmd.get()), (Object)"--include_imports"), List.class)));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[152].callGroovyObjectGetProperty((Object)this.descriptorSetOptions))) {
                baseCmd.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].call((Object)((List)baseCmd.get()), (Object)"--include_source_info"), List.class)));
            }
        }
        List cmds = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[154].callStatic(GenerateProtoTask.class, (Object)((List)baseCmd.get()), (Object)protoFiles, callSiteArray[155].callStatic(GenerateProtoTask.class));
            cmds = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            Object object = callSiteArray[156].callStatic(GenerateProtoTask.class, (Object)((List)baseCmd.get()), (Object)protoFiles, (Object)GenerateProtoTask.getCmdLengthLimit());
            cmds = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        List cmd = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].call((Object)cmds), Iterator.class);
        while (iterator.hasNext()) {
            cmd = (List)ScriptBytecodeAdapter.castToType(iterator.next(), List.class);
            callSiteArray[158].callCurrent((GroovyObject)this, (Object)cmd);
        }
    }

    private void checkInitializing() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[159].call(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[160].callGetProperty(State.class)), (Object)"Should not be called after initilization has finished");
    }

    private void checkCanConfig() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[161].call(Preconditions.class, (Object)(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[162].callGetProperty(State.class)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[163].callGetProperty(State.class)) ? 1 : 0), (Object)"Should not be called after configuration has finished");
        } else {
            callSiteArray[164].call(Preconditions.class, (Object)(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[165].callGetProperty(State.class)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)callSiteArray[166].callGetProperty(State.class)) ? 1 : 0), (Object)"Should not be called after configuration has finished");
        }
    }

    private void compileFiles(List<String> cmd) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[167].call(callSiteArray[168].callGroovyObjectGetProperty((Object)this), callSiteArray[169].callGetProperty(LogLevel.class), callSiteArray[170].call(cmd));
        StringBuffer stdout = (StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callConstructor(StringBuffer.class), StringBuffer.class);
        StringBuffer stderr = (StringBuffer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(StringBuffer.class), StringBuffer.class);
        Process result = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[173].call(cmd), Process.class);
        callSiteArray[174].call((Object)result, (Object)stdout, (Object)stderr);
        String output = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stdout, stderr}, new String[]{"protoc: stdout: ", ". stderr: ", ""}));
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[175].call((Object)result), (Object)0)) {
            throw (Throwable)callSiteArray[179].callConstructor(GradleException.class, (Object)output);
        }
        callSiteArray[176].call(callSiteArray[177].callGroovyObjectGetProperty((Object)this), callSiteArray[178].callGetProperty(LogLevel.class), (Object)output);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateProtoTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static int getWINDOWS_CMD_LENGTH_LIMIT() {
        return WINDOWS_CMD_LENGTH_LIMIT;
    }

    @Generated
    public static int getCMD_ARGUMENT_EXTRA_LENGTH() {
        return CMD_ARGUMENT_EXTRA_LENGTH;
    }

    @Generated
    public boolean getGenerateDescriptorSet() {
        return this.generateDescriptorSet;
    }

    @Generated
    public boolean isGenerateDescriptorSet() {
        return this.generateDescriptorSet;
    }

    @Generated
    public void setGenerateDescriptorSet(boolean bl) {
        this.generateDescriptorSet = bl;
    }

    @Generated
    public final DescriptorSetOptions getDescriptorSetOptions() {
        return this.descriptorSetOptions;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "files";
        stringArray[1] = "project";
        stringArray[2] = "files";
        stringArray[3] = "project";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "INIT";
        stringArray[6] = "container";
        stringArray[7] = "project";
        stringArray[8] = "container";
        stringArray[9] = "project";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "isEmpty";
        stringArray[12] = "each";
        stringArray[13] = "append";
        stringArray[14] = "toString";
        stringArray[15] = "isEmpty";
        stringArray[16] = "sum";
        stringArray[17] = "iterator";
        stringArray[18] = "plus";
        stringArray[19] = "length";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "add";
        stringArray[23] = "plus";
        stringArray[24] = "clear";
        stringArray[25] = "add";
        stringArray[26] = "plus";
        stringArray[27] = "add";
        stringArray[28] = "plus";
        stringArray[29] = "getCmdLengthLimit";
        stringArray[30] = "getProperty";
        stringArray[31] = "indexOf";
        stringArray[32] = "toLowerCase";
        stringArray[33] = "ROOT";
        stringArray[34] = "indexOf";
        stringArray[35] = "toLowerCase";
        stringArray[36] = "ROOT";
        stringArray[37] = "MAX_VALUE";
        stringArray[38] = "checkInitializing";
        stringArray[39] = "checkState";
        stringArray[40] = "dir";
        stringArray[41] = "outputs";
        stringArray[42] = "checkInitializing";
        stringArray[43] = "checkState";
        stringArray[44] = "isAndroidProject";
        stringArray[45] = "project";
        stringArray[46] = "checkInitializing";
        stringArray[47] = "checkState";
        stringArray[48] = "isAndroidProject";
        stringArray[49] = "project";
        stringArray[50] = "checkInitializing";
        stringArray[51] = "checkState";
        stringArray[52] = "isAndroidProject";
        stringArray[53] = "project";
        stringArray[54] = "checkInitializing";
        stringArray[55] = "checkState";
        stringArray[56] = "isAndroidProject";
        stringArray[57] = "project";
        stringArray[58] = "checkInitializing";
        stringArray[59] = "checkState";
        stringArray[60] = "isAndroidProject";
        stringArray[61] = "project";
        stringArray[62] = "checkNotNull";
        stringArray[63] = "checkState";
        stringArray[64] = "isAndroidProject";
        stringArray[65] = "project";
        stringArray[66] = "checkNotNull";
        stringArray[67] = "checkState";
        stringArray[68] = "isAndroidProject";
        stringArray[69] = "project";
        stringArray[70] = "checkNotNull";
        stringArray[71] = "checkState";
        stringArray[72] = "isAndroidProject";
        stringArray[73] = "project";
        stringArray[74] = "checkNotNull";
        stringArray[75] = "checkState";
        stringArray[76] = "isAndroidProject";
        stringArray[77] = "project";
        stringArray[78] = "checkState";
        stringArray[79] = "name";
        stringArray[80] = "checkNotNull";
        stringArray[81] = "checkState";
        stringArray[82] = "INIT";
        stringArray[83] = "CONFIG";
        stringArray[84] = "checkState";
        stringArray[85] = "CONFIG";
        stringArray[86] = "FINALIZED";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "path";
        stringArray[89] = "path";
        stringArray[90] = "checkCanConfig";
        stringArray[91] = "configure";
        stringArray[92] = "checkCanConfig";
        stringArray[93] = "checkCanConfig";
        stringArray[94] = "configure";
        stringArray[95] = "checkCanConfig";
        stringArray[96] = "findByName";
        stringArray[97] = "checkCanConfig";
        stringArray[98] = "from";
        stringArray[99] = "withPathSensitivity";
        stringArray[100] = "files";
        stringArray[101] = "inputs";
        stringArray[102] = "RELATIVE";
        stringArray[103] = "checkCanConfig";
        stringArray[104] = "from";
        stringArray[105] = "withPathSensitivity";
        stringArray[106] = "files";
        stringArray[107] = "inputs";
        stringArray[108] = "RELATIVE";
        stringArray[109] = "isAndroidProject";
        stringArray[110] = "project";
        stringArray[111] = "isTest";
        stringArray[112] = "name";
        stringArray[113] = "outputSubDir";
        stringArray[114] = "plus";
        stringArray[115] = "name";
        stringArray[116] = "compareGradleVersion";
        stringArray[117] = "project";
        stringArray[118] = "checkNotNull";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "<$constructor$>";
        stringArray[121] = "sourceDirectorySet";
        stringArray[122] = "objects";
        stringArray[123] = "project";
        stringArray[124] = "each";
        stringArray[125] = "each";
        stringArray[126] = "checkState";
        stringArray[127] = "FINALIZED";
        stringArray[128] = "tools";
        stringArray[129] = "protobuf";
        stringArray[130] = "project";
        stringArray[131] = "sort";
        stringArray[132] = "files";
        stringArray[133] = "collect";
        stringArray[134] = "filter";
        stringArray[135] = "debug";
        stringArray[136] = "logger";
        stringArray[137] = "debug";
        stringArray[138] = "logger";
        stringArray[139] = "path";
        stringArray[140] = "protoc";
        stringArray[141] = "addAll";
        stringArray[142] = "each";
        stringArray[143] = "each";
        stringArray[144] = "getDescriptorPath";
        stringArray[145] = "parentFile";
        stringArray[146] = "<$constructor$>";
        stringArray[147] = "exists";
        stringArray[148] = "mkdirs";
        stringArray[149] = "plus";
        stringArray[150] = "includeImports";
        stringArray[151] = "plus";
        stringArray[152] = "includeSourceInfo";
        stringArray[153] = "plus";
        stringArray[154] = "generateCmds";
        stringArray[155] = "getCmdLengthLimit";
        stringArray[156] = "generateCmds";
        stringArray[157] = "iterator";
        stringArray[158] = "compileFiles";
        stringArray[159] = "checkState";
        stringArray[160] = "INIT";
        stringArray[161] = "checkState";
        stringArray[162] = "CONFIG";
        stringArray[163] = "INIT";
        stringArray[164] = "checkState";
        stringArray[165] = "CONFIG";
        stringArray[166] = "INIT";
        stringArray[167] = "log";
        stringArray[168] = "logger";
        stringArray[169] = "INFO";
        stringArray[170] = "toString";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "execute";
        stringArray[174] = "waitForProcessOutput";
        stringArray[175] = "exitValue";
        stringArray[176] = "log";
        stringArray[177] = "logger";
        stringArray[178] = "INFO";
        stringArray[179] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[180];
        GenerateProtoTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GenerateProtoTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GenerateProtoTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public class DescriptorSetOptions
    implements GroovyObject {
        private GString path;
        private boolean includeSourceInfo;
        private boolean includeImports;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ GenerateProtoTask this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public DescriptorSetOptions(GenerateProtoTask $p$) {
            MetaClass metaClass;
            GenerateProtoTask generateProtoTask;
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            this.this$0 = generateProtoTask = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DescriptorSetOptions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            return this.this$0.this$dist$invoke$3(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorSetOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            this.this$0.this$dist$set$3(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            return this.this$0.this$dist$get$3(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = DescriptorSetOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(DescriptorSetOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public GString getPath() {
            return this.path;
        }

        @Generated
        public void setPath(GString gString) {
            this.path = gString;
        }

        @Generated
        public boolean getIncludeSourceInfo() {
            return this.includeSourceInfo;
        }

        @Generated
        public boolean isIncludeSourceInfo() {
            return this.includeSourceInfo;
        }

        @Generated
        public void setIncludeSourceInfo(boolean bl) {
            this.includeSourceInfo = bl;
        }

        @Generated
        public boolean getIncludeImports() {
            return this.includeImports;
        }

        @Generated
        public boolean isIncludeImports() {
            return this.includeImports;
        }

        @Generated
        public void setIncludeImports(boolean bl) {
            this.includeImports = bl;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(DescriptorSetOptions.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = DescriptorSetOptions.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class PluginOptions
    implements Named,
    GroovyObject {
        private final List<String> options;
        private final String name;
        private String outputSubDir;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public PluginOptions(String name) {
            MetaClass metaClass;
            List list;
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            this.options = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = name;
            this.name = ShortTypeHandling.castToString((Object)string);
        }

        public PluginOptions option(String option) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            callSiteArray[0].call(this.options, (Object)option);
            return this;
        }

        public List<String> getOptions() {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return this.options;
        }

        public String getName() {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return this.name;
        }

        public void setOutputSubDir(String outputSubDir) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            String string = outputSubDir;
            this.outputSubDir = ShortTypeHandling.castToString((Object)string);
        }

        public String getOutputSubDir() {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.outputSubDir, null)) {
                return this.outputSubDir;
            }
            return this.name;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != PluginOptions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = PluginOptions.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "add";
            return new CallSiteArray(PluginOptions.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = PluginOptions.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    static final class State
    extends Enum<State>
    implements GroovyObject {
        public static final /* enum */ State INIT;
        public static final /* enum */ State CONFIG;
        public static final /* enum */ State FINALIZED;
        public static final State MIN_VALUE;
        public static final State MAX_VALUE;
        private static final /* synthetic */ State[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public State(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            CallSite[] callSiteArray = State.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)__namedArgs, null)) {
                throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"One of the enum constants for enum com.google.protobuf.gradle.GenerateProtoTask$State was initialized with null. Please use a non-null value or define your own constructor.");
            }
            callSiteArray[1].callStatic(ImmutableASTTransformation.class, (Object)this, (Object)__namedArgs);
        }

        @Generated
        public State() {
            CallSite[] callSiteArray = State.$getCallSiteArray();
            this((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LinkedHashMap.class), LinkedHashMap.class));
        }

        public static final State[] values() {
            CallSite[] callSiteArray = State.$getCallSiteArray();
            return (State[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), State[].class);
        }

        public /* synthetic */ State next() {
            CallSite[] callSiteArray = State.$getCallSiteArray();
            Object ordinal = callSiteArray[3].call(callSiteArray[4].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[5].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (State)ShortTypeHandling.castToEnum((Object)callSiteArray[6].call((Object)$VALUES, ordinal), State.class);
        }

        public /* synthetic */ State previous() {
            CallSite[] callSiteArray = State.$getCallSiteArray();
            Object ordinal = callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[9].call(callSiteArray[10].call((Object)$VALUES), (Object)1);
            }
            return (State)ShortTypeHandling.castToEnum((Object)callSiteArray[11].call((Object)$VALUES, ordinal), State.class);
        }

        public static State valueOf(String name) {
            CallSite[] callSiteArray = State.$getCallSiteArray();
            return (State)ShortTypeHandling.castToEnum((Object)callSiteArray[12].callStatic(State.class, State.class, (Object)name), State.class);
        }

        public static final /* synthetic */ State $INIT(Object ... para) {
            State state;
            CallSite[] callSiteArray = State.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, State.class)) {
                case -1348271900: {
                    State state2;
                    state = state2;
                    Object[] objectArray2 = objectArray;
                    state2 = new State();
                    break;
                }
                case -242181752: {
                    State state2;
                    state = state2;
                    Object[] objectArray2 = objectArray;
                    state2 = new State((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return state;
        }

        static {
            State state;
            State state2;
            Object object = State.$getCallSiteArray()[13].callStatic(State.class, (Object)"INIT", (Object)0);
            INIT = (State)ShortTypeHandling.castToEnum((Object)object, State.class);
            Object object2 = State.$getCallSiteArray()[14].callStatic(State.class, (Object)"CONFIG", (Object)1);
            CONFIG = (State)ShortTypeHandling.castToEnum((Object)object2, State.class);
            Object object3 = State.$getCallSiteArray()[15].callStatic(State.class, (Object)"FINALIZED", (Object)2);
            FINALIZED = (State)ShortTypeHandling.castToEnum((Object)object3, State.class);
            MIN_VALUE = state2 = INIT;
            MAX_VALUE = state = FINALIZED;
            State[] stateArray = new State[]{INIT, CONFIG, FINALIZED};
            $VALUES = stateArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != State.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "checkPropNames";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "next";
            stringArray[4] = "ordinal";
            stringArray[5] = "size";
            stringArray[6] = "getAt";
            stringArray[7] = "previous";
            stringArray[8] = "ordinal";
            stringArray[9] = "minus";
            stringArray[10] = "size";
            stringArray[11] = "getAt";
            stringArray[12] = "valueOf";
            stringArray[13] = "$INIT";
            stringArray[14] = "$INIT";
            stringArray[15] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[16];
            State.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(State.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = State.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

