/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import com.google.protobuf.gradle.CopyActionFacade;
import com.google.protobuf.gradle.ExecutableLocator;
import com.google.protobuf.gradle.Preconditions;
import com.google.protobuf.gradle.ProtobufExtension;
import com.google.protobuf.gradle.ToolsLocator;
import com.google.protobuf.gradle.Utils;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class GenerateProtoTask
extends DefaultTask
implements GroovyObject {
    private static final int WINDOWS_CMD_LENGTH_LIMIT = 32760;
    private static final int DEFAULT_CMD_LENGTH_LIMIT = 65536;
    private static final int CMD_ARGUMENT_EXTRA_LENGTH = 3;
    private static final String JAR_SUFFIX = ".jar";
    private final CopyActionFacade copyActionFacade;
    private final ConfigurableFileCollection includeDirs;
    private final ConfigurableFileCollection sourceDirs;
    private final NamedDomainObjectContainer<PluginOptions> builtins;
    private final NamedDomainObjectContainer<PluginOptions> plugins;
    private final ProjectLayout projectLayout;
    private final ToolsLocator toolsLocator;
    private Provider<String> outputBaseDir;
    private transient SourceSet sourceSet;
    private transient Object variant;
    private List<String> flavors;
    private String buildType;
    private boolean isTestVariant;
    private final Provider<Boolean> isAndroidProject;
    private final Provider<Boolean> isTestProvider;
    @Internal(value="Handled as input via getDescriptorSetOptionsForCaching()")
    private boolean generateDescriptorSet;
    @Internal(value="Handled as input via getDescriptorSetOptionsForCaching()")
    private final DescriptorSetOptions descriptorSetOptions;
    private State state;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$com$google$protobuf$gradle$Preconditions;

    @Generated
    public GenerateProtoTask() {
        MetaClass metaClass;
        State state;
        DescriptorSetOptions descriptorSetOptions;
        Provider provider;
        Provider provider2;
        ToolsLocator toolsLocator;
        ProjectLayout projectLayout;
        NamedDomainObjectContainer namedDomainObjectContainer;
        NamedDomainObjectContainer namedDomainObjectContainer2;
        ConfigurableFileCollection configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2;
        CopyActionFacade copyActionFacade;
        this.copyActionFacade = copyActionFacade = CopyActionFacade.Loader.create(this.getProject(), this.getObjectFactory());
        this.includeDirs = configurableFileCollection2 = this.getObjectFactory().fileCollection();
        this.sourceDirs = configurableFileCollection = this.getObjectFactory().fileCollection();
        this.builtins = namedDomainObjectContainer2 = this.getObjectFactory().domainObjectContainer(PluginOptions.class);
        this.plugins = namedDomainObjectContainer = this.getObjectFactory().domainObjectContainer(PluginOptions.class);
        this.projectLayout = projectLayout = this.getProject().getLayout();
        this.toolsLocator = toolsLocator = ((ProtobufExtension)this.getProject().getExtensions().findByType(ProtobufExtension.class)).getTools();
        this.isAndroidProject = provider2 = this.getProviderFactory().provider((Callable)((Object)new _closure1((Object)this, (Object)this)));
        this.isTestProvider = provider = this.getProviderFactory().provider((Callable)((Object)new _closure2((Object)this, (Object)this)));
        this.descriptorSetOptions = descriptorSetOptions = new DescriptorSetOptions(this);
        this.state = state = State.INIT;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String makeOptionsPrefix(List<String> options) {
        Reference prefix = new Reference((Object)new StringBuilder());
        if (!options.isEmpty()) {
            public final class _makeOptionsPrefix_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference prefix;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _makeOptionsPrefix_closure3(Object _outerInstance, Object _thisObject, Reference prefix) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.prefix = reference = prefix;
                }

                public Object doCall(Object option) {
                    if (((StringBuilder)this.prefix.get()).length() > 0) {
                        ((StringBuilder)this.prefix.get()).append(",");
                    }
                    return ((StringBuilder)this.prefix.get()).append(ShortTypeHandling.castToString((Object)option));
                }

                @Generated
                public StringBuilder getPrefix() {
                    return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.prefix.get(), StringBuilder.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _makeOptionsPrefix_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(options, (Closure)new _makeOptionsPrefix_closure3(GenerateProtoTask.class, GenerateProtoTask.class, prefix));
            ((StringBuilder)prefix.get()).append(":");
        }
        return ((StringBuilder)prefix.get()).toString();
    }

    public static List<List<String>> generateCmds(List<String> baseCmd, List<File> protoFiles, int cmdLengthLimit) {
        List cmds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (!protoFiles.isEmpty()) {
            public final class _generateCmds_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _generateCmds_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((String)it).length() + GenerateProtoTask.getCMD_ARGUMENT_EXTRA_LENGTH();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _generateCmds_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            int baseCmdLength = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.sum(baseCmd, (Closure)new _generateCmds_closure4(GenerateProtoTask.class, GenerateProtoTask.class)), Integer.TYPE));
            List currentArgs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            int currentArgsLength = 0;
            File proto = null;
            Iterator<File> iterator = protoFiles.iterator();
            while (iterator.hasNext()) {
                proto = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
                String protoFileName = ShortTypeHandling.castToString((Object)proto);
                int currentFileLength = protoFileName.length() + CMD_ARGUMENT_EXTRA_LENGTH;
                if (baseCmdLength + currentArgsLength + currentFileLength > cmdLengthLimit) {
                    int n;
                    cmds.add(DefaultGroovyMethods.plus(baseCmd, (Collection)currentArgs));
                    currentArgs.clear();
                    currentArgsLength = n = 0;
                }
                currentArgs.add(protoFileName);
                int cfr_ignored_0 = currentArgsLength + currentFileLength;
            }
            cmds.add(DefaultGroovyMethods.plus(baseCmd, (Collection)currentArgs));
        }
        return cmds;
    }

    public static int getCmdLengthLimit() {
        return GenerateProtoTask.getCmdLengthLimit(System.getProperty("os.name"));
    }

    public static int getCmdLengthLimit(String os) {
        return GenerateProtoTask.isWindows(os) ? WINDOWS_CMD_LENGTH_LIMIT : DEFAULT_CMD_LENGTH_LIMIT;
    }

    public static boolean isWindows(String os) {
        return os != null && ScriptBytecodeAdapter.compareGreaterThan((Object)os.toLowerCase(Locale.ROOT).indexOf("win"), (Object)-1);
    }

    public static boolean isWindows() {
        return GenerateProtoTask.isWindows(System.getProperty("os.name"));
    }

    public static String escapePathUnix(String path) {
        return path.replace("'", "'\\''");
    }

    public static String escapePathWindows(String path) {
        String escapedPath = path.replace("%", "%%");
        return escapedPath.endsWith("\\") ? StringGroovyMethods.plus((String)escapedPath, (CharSequence)"\\") : escapedPath;
    }

    public static void mkdirsForFile(File outputFile) throws IOException {
        if (!outputFile.getParentFile().isDirectory() && !outputFile.getParentFile().mkdirs()) {
            throw (Throwable)new IOException(StringGroovyMethods.plus((String)"unable to make directories for file: ", (CharSequence)outputFile.getCanonicalPath()));
        }
    }

    public static void setExecutableOrFail(File outputFile) throws IOException {
        if (!outputFile.setExecutable(true)) {
            outputFile.delete();
            throw (Throwable)new IOException(StringGroovyMethods.plus((String)"unable to set file as executable: ", (CharSequence)outputFile.getCanonicalPath()));
        }
    }

    public static String computeJavaExePath(boolean isWindows) throws IOException {
        File java = new File(System.getProperty("java.home"), isWindows ? "bin/java.exe" : "bin/java");
        if (!java.exists()) {
            throw (Throwable)new IOException(StringGroovyMethods.plus((String)"Could not find java executable at ", (CharSequence)java.getPath()));
        }
        return java.getPath();
    }

    public void setOutputBaseDir(Provider<String> outputBaseDir) {
        this.checkInitializing();
        Preconditions.checkState(this.outputBaseDir == null, "outputBaseDir is already set");
        Provider<String> provider = outputBaseDir;
        this.outputBaseDir = provider;
    }

    @OutputDirectory
    public String getOutputBaseDir() {
        return ShortTypeHandling.castToString((Object)this.outputBaseDir.get());
    }

    public void setSourceSet(SourceSet sourceSet) {
        SourceSet sourceSet2;
        this.checkInitializing();
        Preconditions.checkState(!DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "sourceSet should not be set in an Android project");
        this.sourceSet = sourceSet2 = sourceSet;
    }

    public void setVariant(Object variant, boolean isTestVariant) {
        boolean bl;
        Object object;
        this.checkInitializing();
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "variant should not be set in a Java project");
        this.variant = object = variant;
        this.isTestVariant = bl = isTestVariant;
    }

    public void setFlavors(List<String> flavors) {
        this.checkInitializing();
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "flavors should not be set in a Java project");
        List<String> list = Collections.unmodifiableList(new ArrayList<String>(flavors));
        this.flavors = list;
    }

    public void setBuildType(String buildType) {
        String string;
        this.checkInitializing();
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "buildType should not be set in a Java project");
        this.buildType = string = buildType;
    }

    @Internal(value="Inputs tracked in getSourceDirs()")
    public SourceSet getSourceSet() {
        Preconditions.checkState(!DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "sourceSet should not be used in an Android project");
        Preconditions.checkNotNull(this.sourceSet, "sourceSet is not set");
        return this.sourceSet;
    }

    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @IgnoreEmptyDirectories
    @InputFiles
    public FileCollection getSourceDirs() {
        return this.sourceDirs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getIncludeDirs() {
        return this.includeDirs;
    }

    @Internal(value="Not an actual input to the task, only used to find tasks belonging to a variant")
    public Object getVariant() {
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "variant should not be used in a Java project");
        Preconditions.checkNotNull(this.variant, "variant is not set");
        return this.variant;
    }

    @Input
    public Provider<List<String>> getReleaseArtifacts() {
        public final class _getReleaseArtifacts_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getReleaseArtifacts_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                public final class _closure18
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure18(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return InvokerHelper.invokeMethodSafe((Object)it, (String)"getSimplifiedArtifactName", (Object)new Object[0]);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.collect(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getReleaseExecutableLocators(), (Closure)new _closure18((Object)this, this.getThisObject()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReleaseArtifacts_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.getProviderFactory().provider((Callable)((Object)new _getReleaseArtifacts_closure5((Object)this, (Object)this)));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getExecutables() {
        public final class _getExecutables_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getExecutables_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Reference release = new Reference(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getReleaseExecutableLocators());
                public final class _closure19
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference release;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure19(Object _outerInstance, Object _thisObject, Reference release) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.release = reference = release;
                    }

                    public Object doCall(Object it) {
                        return !((List)this.release.get()).contains(it);
                    }

                    @Generated
                    public List getRelease() {
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.release.get(), List.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure19.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure20(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((ExecutableLocator)it).getPath() != null ? ((ExecutableLocator)it).getPath() : InvokerHelper.invokeMethodSafe((Object)it, (String)"getArtifactFiles", (Object)new Object[0]);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.collect((Iterable)DefaultGroovyMethods.findAll(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getAllExecutableLocators(), (Closure)new _closure19((Object)this, this.getThisObject(), release)), (Closure)new _closure20((Object)this, this.getThisObject()));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getExecutables_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider executables = this.getProviderFactory().provider((Callable)((Object)new _getExecutables_closure6((Object)this, (Object)this)));
        return this.getObjectFactory().fileCollection().from(new Object[]{executables});
    }

    private List<ExecutableLocator> getReleaseExecutableLocators() {
        public final class _getReleaseExecutableLocators_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getReleaseExecutableLocators_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ExecutableLocator)it).getPath() == null && !((String)InvokerHelper.invokeMethodSafe((Object)it, (String)"getSimplifiedArtifactName", (Object)new Object[0])).endsWith("-SNAPSHOT");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getReleaseExecutableLocators_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(this.getAllExecutableLocators(), (Closure)new _getReleaseExecutableLocators_closure7((Object)this, (Object)this));
    }

    private List<ExecutableLocator> getAllExecutableLocators() {
        public final class _getAllExecutableLocators_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllExecutableLocators_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(PluginOptions it) {
                return ((GenerateProtoTask)((Object)this.getThisObject())).toolsLocator.getPlugins().getByName(it.getName());
            }

            public Object call(PluginOptions it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllExecutableLocators_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.plus((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.toolsLocator.getProtoc()}), (Collection)DefaultGroovyMethods.collect(this.plugins, (Closure)new _getAllExecutableLocators_closure8((Object)this, (Object)this)));
    }

    @Internal(value="Not an actual input to the task, only used to find tasks belonging to a variant")
    public Provider<Boolean> getIsAndroidProject() {
        return this.isAndroidProject;
    }

    @Internal(value="Not an actual input to the task, only used to find tasks belonging to a variant")
    public boolean getIsTestVariant() {
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "isTestVariant should not be used in a Java project");
        Preconditions.checkNotNull(this.variant, "variant is not set");
        return this.isTestVariant;
    }

    @Internal(value="Not an actual input to the task, only used to find tasks belonging to a variant")
    public List<String> getFlavors() {
        Preconditions.checkState(DefaultTypeTransformation.booleanUnbox((Object)this.isAndroidProject.get()), "flavors should not be used in a Java project");
        Preconditions.checkNotNull(this.flavors, "flavors is not set");
        return this.flavors;
    }

    @Internal(value="Not an actual input to the task, only used to find tasks belonging to a variant")
    public String getBuildType() {
        CallSite[] callSiteArray = GenerateProtoTask.$getCallSiteArray();
        callSiteArray[0].call((Object)GenerateProtoTask.$get$$class$com$google$protobuf$gradle$Preconditions(), callSiteArray[1].call(this.isAndroidProject), (Object)"buildType should not be used in a Java project");
        callSiteArray[2].call((Object)GenerateProtoTask.$get$$class$com$google$protobuf$gradle$Preconditions(), (Object)(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(this.variant), (Object)"test") || DefaultTypeTransformation.booleanUnbox((Object)this.buildType) ? 1 : 0), (Object)"buildType is not set and task is not for local unit test variant");
        return this.buildType;
    }

    public void doneInitializing() {
        State state;
        Preconditions.checkState(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.INIT)), new GStringImpl(new Object[]{this.state}, new String[]{"Invalid state: ", ""}));
        this.state = state = State.CONFIG;
    }

    public void doneConfig() {
        State state;
        Preconditions.checkState(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.CONFIG)), new GStringImpl(new Object[]{this.state}, new String[]{"Invalid state: ", ""}));
        this.state = state = State.FINALIZED;
    }

    @Internal(value="Tracked as an input via getDescriptorSetOptionsForCaching()")
    public String getDescriptorPath() {
        if (!this.generateDescriptorSet) {
            throw (Throwable)new IllegalStateException("requested descriptor path but descriptor generation is off");
        }
        return ShortTypeHandling.castToString((Object)(this.descriptorSetOptions.getPath() != null ? this.descriptorSetOptions.getPath() : new GStringImpl(new Object[]{this.outputBaseDir.get()}, new String[]{"", "/descriptor_set.desc"})));
    }

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Inject
    public abstract ObjectFactory getObjectFactory();

    public void builtins(Action<NamedDomainObjectContainer<PluginOptions>> configureAction) {
        this.checkCanConfig();
        configureAction.execute(this.builtins);
    }

    @Internal(value="Tracked as an input via getBuiltinsForCaching()")
    public NamedDomainObjectContainer<PluginOptions> getBuiltins() {
        this.checkCanConfig();
        return this.builtins;
    }

    public void plugins(Action<NamedDomainObjectContainer<PluginOptions>> configureAction) {
        this.checkCanConfig();
        configureAction.execute(this.plugins);
    }

    @Internal(value="Tracked as an input via getPluginsForCaching()")
    public NamedDomainObjectContainer<PluginOptions> getPlugins() {
        this.checkCanConfig();
        return this.plugins;
    }

    public boolean hasPlugin(String name) {
        return this.plugins.findByName(name) != null;
    }

    public void addIncludeDir(FileCollection dir) {
        this.checkCanConfig();
        this.includeDirs.from(new Object[]{dir});
    }

    public void addSourceDirs(FileCollection dirs) {
        this.checkCanConfig();
        this.sourceDirs.from(new Object[]{dirs});
    }

    @Input
    public boolean getIsTest() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.isTestProvider.get());
    }

    @Internal(value="Already captured with getIsTest()")
    public Provider<Boolean> getIsTestProvider() {
        return this.isTestProvider;
    }

    public String getOutputDir(PluginOptions plugin) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.outputBaseDir.get(), plugin.getOutputSubDir()}, new String[]{"", "/", ""}));
    }

    @Internal
    @Deprecated
    public SourceDirectorySet getOutputSourceDirectorySet() {
        SourceDirectorySet sourceDirectorySet;
        String srcSetName = StringGroovyMethods.plus((String)"generate-proto-", (CharSequence)this.getName());
        SourceDirectorySet srcSet = null;
        srcSet = sourceDirectorySet = this.getObjectFactory().sourceDirectorySet(srcSetName, srcSetName);
        public final class _getOutputSourceDirectorySet_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getOutputSourceDirectorySet_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((Object)((GenerateProtoTask)((Object)this.getThisObject()))), (String)"getOutputSourceDirectories", (Object)new Object[0]);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOutputSourceDirectorySet_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        srcSet.srcDirs(new Object[]{this.getObjectFactory().fileCollection().builtBy(new Object[]{this}).from(new Object[]{this.getProviderFactory().provider((Callable)((Object)new _getOutputSourceDirectorySet_closure9((Object)this, (Object)this)))})});
        return srcSet;
    }

    @Internal
    Collection<File> getOutputSourceDirectories() {
        Reference srcDirs = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getOutputSourceDirectories_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDirs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getOutputSourceDirectories_closure10(Object _outerInstance, Object _thisObject, Reference srcDirs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.srcDirs = reference = srcDirs;
            }

            public Object doCall(Object builtin) {
                File dir = new File(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputDir((PluginOptions)ScriptBytecodeAdapter.castToType((Object)builtin, PluginOptions.class)));
                if (!dir.getName().endsWith(".zip") && !dir.getName().endsWith(GenerateProtoTask.JAR_SUFFIX)) {
                    return ((List)this.srcDirs.get()).add(dir);
                }
                return null;
            }

            @Generated
            public Collection getSrcDirs() {
                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.srcDirs.get(), Collection.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOutputSourceDirectories_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.builtins, (Closure)new _getOutputSourceDirectories_closure10((Object)this, (Object)this, srcDirs));
        public final class _getOutputSourceDirectories_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDirs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getOutputSourceDirectories_closure11(Object _outerInstance, Object _thisObject, Reference srcDirs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.srcDirs = reference = srcDirs;
            }

            public Object doCall(Object plugin) {
                File dir = new File(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputDir((PluginOptions)ScriptBytecodeAdapter.castToType((Object)plugin, PluginOptions.class)));
                if (!dir.getName().endsWith(".zip") && !dir.getName().endsWith(GenerateProtoTask.JAR_SUFFIX)) {
                    return ((List)this.srcDirs.get()).add(dir);
                }
                return null;
            }

            @Generated
            public Collection getSrcDirs() {
                return (Collection)ScriptBytecodeAdapter.castToType((Object)this.srcDirs.get(), Collection.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOutputSourceDirectories_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.plugins, (Closure)new _getOutputSourceDirectories_closure11((Object)this, (Object)this, srcDirs));
        return (List)srcDirs.get();
    }

    @TaskAction
    public void compile() {
        Preconditions.checkState(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.FINALIZED)), "doneConfig() has not been called");
        public final class _compile_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _compile_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object spec) {
                return ((DeleteSpec)spec).delete(new Object[]{((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputBaseDir()});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.copyActionFacade.delete((Action<? super DeleteSpec>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _compile_closure12((Object)this, (Object)this)), Action.class)));
        List protoFiles = DefaultGroovyMethods.sort((Iterable)this.sourceDirs.getAsFileTree().getFiles());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.builtins, this.plugins});
        if (list != null) {
            Object for$it$12 = null;
            for (Object for$it$12 : list) {
                Object v0;
                Object var6_6 = for$it$12;
                if (var6_6 != null) {
                    public final class _compile_closure13
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _compile_closure13(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(PluginOptions plugin) {
                            String outputPath = ((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputDir(plugin);
                            File outputDir = new File(outputPath);
                            if (outputPath.endsWith(GenerateProtoTask.JAR_SUFFIX) || outputPath.endsWith(".zip")) {
                                File file;
                                outputDir = file = outputDir.getParentFile();
                            }
                            return outputDir.mkdirs();
                        }

                        public Object call(PluginOptions plugin) {
                            return this.doCall(plugin);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _compile_closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    ((Iterable)var6_6).forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _compile_closure13((Object)this, (Object)this)), Consumer.class));
                    v0 = null;
                } else {
                    v0 = null;
                }
                arrayList.add(v0);
            }
        }
        public final class _compile_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _compile_closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File it) {
                return it.exists();
            }

            public Object call(File it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _compile_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _compile_closure15(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return new GStringImpl(new Object[]{it}, new String[]{"-I", ""}).toString();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List dirs = DefaultGroovyMethods.collect((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(GenerateProtoTask.class, (Object)this.includeDirs.filter((Closure)new _compile_closure14((Object)this, (Object)this)), (String)"path"), Iterable.class)), (Closure)new _compile_closure15((Object)this, (Object)this));
        this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dirs}, new String[]{"ProtobufCompile using directories ", ""})));
        this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{protoFiles}, new String[]{"ProtobufCompile using files ", ""})));
        String protocPath = this.computeExecutablePath(this.toolsLocator.getProtoc());
        Reference baseCmd = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{protocPath}));
        ((List)baseCmd.get()).addAll(dirs);
        public final class _compile_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference baseCmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _compile_closure16(Object _outerInstance, Object _thisObject, Reference baseCmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.baseCmd = reference = baseCmd;
            }

            public Object doCall(Object builtin) {
                String outPrefix = GenerateProtoTask.makeOptionsPrefix(((PluginOptions)builtin).getOptions());
                List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class)), (Object)new GStringImpl(new Object[]{((PluginOptions)builtin).getName(), outPrefix, ((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputDir((PluginOptions)ScriptBytecodeAdapter.castToType((Object)builtin, PluginOptions.class))}, new String[]{"--", "_out=", "", ""}).toString());
                this.baseCmd.set((Object)list);
                return list;
            }

            @Generated
            public List getBaseCmd() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.builtins, (Closure)new _compile_closure16((Object)this, (Object)this, baseCmd));
        Reference executableLocations = new Reference((Object)this.toolsLocator.getPlugins().getAsMap());
        public final class _compile_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference executableLocations;
            private /* synthetic */ Reference baseCmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _compile_closure17(Object _outerInstance, Object _thisObject, Reference executableLocations, Reference baseCmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.executableLocations = reference2 = executableLocations;
                this.baseCmd = reference = baseCmd;
            }

            public Object doCall(Object plugin) {
                String name = ((PluginOptions)plugin).getName();
                ExecutableLocator locator = (ExecutableLocator)ScriptBytecodeAdapter.castToType(((SortedMap)this.executableLocations.get()).get(name), ExecutableLocator.class);
                if (locator != null) {
                    List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class)), (Object)new GStringImpl(new Object[]{name, InvokerHelper.invokeMethodSafe((Object)((Object)((GenerateProtoTask)((Object)this.getThisObject()))), (String)"computeExecutablePath", (Object)new Object[]{locator})}, new String[]{"--plugin=protoc-gen-", "=", ""}).toString());
                    this.baseCmd.set((Object)list);
                } else {
                    ((GenerateProtoTask)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, name}, new String[]{"protoc plugin '", "' not defined. Trying to use 'protoc-gen-", "' from system path"})));
                }
                String pluginOutPrefix = GenerateProtoTask.makeOptionsPrefix(((PluginOptions)plugin).getOptions());
                List list = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class)), (Object)new GStringImpl(new Object[]{name, pluginOutPrefix, ((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getOutputDir((PluginOptions)ScriptBytecodeAdapter.castToType((Object)plugin, PluginOptions.class))}, new String[]{"--", "_out=", "", ""}).toString());
                this.baseCmd.set((Object)list);
                return list;
            }

            @Generated
            public Map getExecutableLocations() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.executableLocations.get(), Map.class);
            }

            @Generated
            public List getBaseCmd() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.baseCmd.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _compile_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.plugins, (Closure)new _compile_closure17((Object)this, (Object)this, executableLocations, baseCmd));
        if (this.generateDescriptorSet) {
            String path = this.getDescriptorPath();
            File folder = new File(path).getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            List list2 = DefaultGroovyMethods.plus((List)((List)baseCmd.get()), (Object)new GStringImpl(new Object[]{path}, new String[]{"--descriptor_set_out=", ""}).toString());
            baseCmd.set((Object)list2);
            if (this.descriptorSetOptions.getIncludeImports()) {
                List list3 = DefaultGroovyMethods.plus((List)((List)baseCmd.get()), (Object)"--include_imports");
                baseCmd.set((Object)list3);
            }
            if (this.descriptorSetOptions.getIncludeSourceInfo()) {
                List list4 = DefaultGroovyMethods.plus((List)((List)baseCmd.get()), (Object)"--include_source_info");
                baseCmd.set((Object)list4);
            }
        }
        List<List<String>> cmds = GenerateProtoTask.generateCmds((List)baseCmd.get(), protoFiles, GenerateProtoTask.getCmdLengthLimit());
        List cmd = null;
        Iterator<List<String>> iterator = cmds.iterator();
        while (iterator.hasNext()) {
            cmd = (List)ScriptBytecodeAdapter.castToType(iterator.next(), List.class);
            this.compileFiles(cmd);
        }
    }

    @Optional
    @Nested
    protected DescriptorSetOptions getDescriptorSetOptionsForCaching() {
        return (DescriptorSetOptions)ScriptBytecodeAdapter.castToType((Object)(this.generateDescriptorSet ? this.descriptorSetOptions : null), DescriptorSetOptions.class);
    }

    @Nested
    protected Collection<PluginOptions> getBuiltinsForCaching() {
        return this.builtins;
    }

    @Nested
    protected Collection<PluginOptions> getPluginsForCaching() {
        return this.plugins;
    }

    private void checkInitializing() {
        Preconditions.checkState(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.INIT)), "Should not be called after initilization has finished");
    }

    private void checkCanConfig() {
        Preconditions.checkState(ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.CONFIG)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.state), (Object)((Object)State.INIT)), "Should not be called after configuration has finished");
    }

    private void compileFiles(List<String> cmd) {
        this.getLogger().log(LogLevel.INFO, cmd.toString());
        StringBuffer stdout = new StringBuffer();
        StringBuffer stderr = new StringBuffer();
        Process result = ProcessGroovyMethods.execute(cmd);
        ProcessGroovyMethods.waitForProcessOutput((Process)result, (Appendable)stdout, (Appendable)stderr);
        String output = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stdout, stderr}, new String[]{"protoc: stdout: ", ". stderr: ", ""}));
        if (!(result.exitValue() == 0)) {
            throw (Throwable)new GradleException(output);
        }
        this.getLogger().log(LogLevel.INFO, output);
    }

    protected String computeExecutablePath(ExecutableLocator locator) {
        if (locator.getPath() != null) {
            return locator.getPath().endsWith(JAR_SUFFIX) ? this.createJarTrampolineScript(locator.getPath()) : locator.getPath();
        }
        File file = locator.getArtifactFiles().getSingleFile();
        if (file.getName().endsWith(JAR_SUFFIX)) {
            return this.createJarTrampolineScript(file.getAbsolutePath());
        }
        if (!file.canExecute() && !file.setExecutable(true)) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"Cannot set ", " as executable"})));
        }
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"Resolved artifact: ", ""})));
        return file.getPath();
    }

    private String createJarTrampolineScript(String jarAbsolutePath) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = jarAbsolutePath;
            valueRecorder.record((Object)string, 8);
            String string2 = JAR_SUFFIX;
            valueRecorder.record((Object)string2, 33);
            valueRecorder.record((Object)string2, 33);
            boolean bl = string.endsWith(string2);
            valueRecorder.record((Object)bl, 24);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert jarAbsolutePath.endsWith(JAR_SUFFIX)", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean isWindows = GenerateProtoTask.isWindows();
        String jarFileName = new File(jarAbsolutePath).getName();
        if (jarFileName.length() <= JAR_SUFFIX.length()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{jarAbsolutePath}, new String[]{".jar protoc plugin path '", "' has no file name"})));
        }
        File scriptExecutableFile = new File(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.projectLayout.getBuildDirectory().get()}, new String[]{"", "/scripts/"}).plus(StringGroovyMethods.getAt((String)jarFileName, (IntRange)new IntRange(true, 0, jarFileName.length() - JAR_SUFFIX.length() - 1))).plus((GString)new GStringImpl(new Object[]{this.getName()}, new String[]{"-", "-trampoline."})).plus(isWindows ? "bat" : "sh")));
        GenerateProtoTask.mkdirsForFile(scriptExecutableFile);
        String javaExe = GenerateProtoTask.computeJavaExePath(isWindows);
        String trampoline = ShortTypeHandling.castToString((Object)(isWindows ? new GStringImpl(new Object[]{GenerateProtoTask.escapePathWindows(javaExe), GenerateProtoTask.escapePathWindows(jarAbsolutePath)}, new String[]{"@ECHO OFF\r\n\"", "\" -jar \"", "\" %*\r\n"}) : new GStringImpl(new Object[]{GenerateProtoTask.escapePathUnix(javaExe), GenerateProtoTask.escapePathUnix(jarAbsolutePath)}, new String[]{"#!/bin/sh\nexec '", "' -jar '", "' \"$@\"\n"})));
        ResourceGroovyMethods.write((File)scriptExecutableFile, (String)trampoline, (String)StandardCharsets.US_ASCII.name());
        GenerateProtoTask.setExecutableOrFail(scriptExecutableFile);
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{jarAbsolutePath, scriptExecutableFile}, new String[]{"Resolved artifact jar: ", ". Created trampoline file: ", ""})));
        String string = scriptExecutableFile.getPath();
        try {
            return string;
        }
        catch (IOException e) {
            throw (Throwable)new GradleException("Unable to generate trampoline for .jar protoc plugin", (Throwable)e);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateProtoTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GenerateProtoTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ int pfaccess$0(GenerateProtoTask $that) {
        return CMD_ARGUMENT_EXTRA_LENGTH;
    }

    @Generated
    @groovy.transform.Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @groovy.transform.Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @groovy.transform.Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static int getWINDOWS_CMD_LENGTH_LIMIT() {
        return WINDOWS_CMD_LENGTH_LIMIT;
    }

    @Generated
    public static int getDEFAULT_CMD_LENGTH_LIMIT() {
        return DEFAULT_CMD_LENGTH_LIMIT;
    }

    @Generated
    public static int getCMD_ARGUMENT_EXTRA_LENGTH() {
        return CMD_ARGUMENT_EXTRA_LENGTH;
    }

    @Generated
    public boolean getGenerateDescriptorSet() {
        return this.generateDescriptorSet;
    }

    @Generated
    public boolean isGenerateDescriptorSet() {
        return this.generateDescriptorSet;
    }

    @Generated
    public void setGenerateDescriptorSet(boolean bl) {
        this.generateDescriptorSet = bl;
    }

    @Generated
    public final DescriptorSetOptions getDescriptorSetOptions() {
        return this.descriptorSetOptions;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkState";
        stringArray[1] = "get";
        stringArray[2] = "checkState";
        stringArray[3] = "name";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        GenerateProtoTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GenerateProtoTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GenerateProtoTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$com$google$protobuf$gradle$Preconditions() {
        Class clazz = $class$com$google$protobuf$gradle$Preconditions;
        if (clazz == null) {
            clazz = $class$com$google$protobuf$gradle$Preconditions = GenerateProtoTask.class$("com.google.protobuf.gradle.Preconditions");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DescriptorSetOptions
    implements GroovyObject {
        @Nullable
        @Optional
        @OutputFile
        private String path;
        @Input
        private boolean includeSourceInfo;
        @Input
        private boolean includeImports;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        public /* synthetic */ GenerateProtoTask this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public DescriptorSetOptions(GenerateProtoTask $p$) {
            MetaClass metaClass;
            GenerateProtoTask generateProtoTask;
            this.this$0 = generateProtoTask = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DescriptorSetOptions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$3(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorSetOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$3(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$3(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescriptorSetOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public boolean getIncludeSourceInfo() {
            return this.includeSourceInfo;
        }

        @Generated
        public boolean isIncludeSourceInfo() {
            return this.includeSourceInfo;
        }

        @Generated
        public void setIncludeSourceInfo(boolean bl) {
            this.includeSourceInfo = bl;
        }

        @Generated
        public boolean getIncludeImports() {
            return this.includeImports;
        }

        @Generated
        public boolean isIncludeImports() {
            return this.includeImports;
        }

        @Generated
        public void setIncludeImports(boolean bl) {
            this.includeImports = bl;
        }
    }

    public static class PluginOptions
    implements Named,
    GroovyObject {
        private final List<String> options;
        private final String name;
        private String outputSubDir;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public PluginOptions(String name) {
            String string;
            MetaClass metaClass;
            List list;
            this.options = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string = name;
        }

        public PluginOptions option(String option) {
            this.options.add(option);
            return this;
        }

        @Input
        public List<String> getOptions() {
            return this.options;
        }

        @Input
        public String getName() {
            return this.name;
        }

        public void setOutputSubDir(String outputSubDir) {
            String string;
            this.outputSubDir = string = outputSubDir;
        }

        @Input
        public String getOutputSubDir() {
            if (this.outputSubDir != null) {
                return this.outputSubDir;
            }
            return this.name;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != PluginOptions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(PluginOptions.class, GenerateProtoTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    static final class State
    extends Enum<State>
    implements GroovyObject {
        public static final /* enum */ State INIT;
        public static final /* enum */ State CONFIG;
        public static final /* enum */ State FINALIZED;
        public static final State MIN_VALUE;
        public static final State MAX_VALUE;
        private static final /* synthetic */ State[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public State(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.google.protobuf.gradle.GenerateProtoTask$State was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public State() {
            this(new LinkedHashMap());
        }

        public static final State[] values() {
            return (State[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), State[].class);
        }

        public /* synthetic */ State next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (State)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), State.class);
        }

        public /* synthetic */ State previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (State)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), State.class);
        }

        public static State valueOf(String name) {
            return (State)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(State.class, name)), State.class);
        }

        public static final /* synthetic */ State $INIT(Object ... para) {
            State state;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, State.class)) {
                case -1348271900: {
                    State state2;
                    state = state2;
                    Object[] objectArray2 = objectArray;
                    state2 = new State();
                    break;
                }
                case -242181752: {
                    State state2;
                    state = state2;
                    Object[] objectArray2 = objectArray;
                    state2 = new State((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return state;
        }

        static {
            State state;
            State state2;
            State state3;
            State state4;
            State state5;
            INIT = state5 = State.$INIT("INIT", 0);
            CONFIG = state4 = State.$INIT("CONFIG", 1);
            FINALIZED = state3 = State.$INIT("FINALIZED", 2);
            MIN_VALUE = state2 = INIT;
            MAX_VALUE = state = FINALIZED;
            State[] stateArray = new State[]{INIT, CONFIG, FINALIZED};
            $VALUES = stateArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != State.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @groovy.transform.Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return Utils.isAndroidProject(((GenerateProtoTask)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject());
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            if (Utils.isAndroidProject(((GenerateProtoTask)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject())) {
                return ((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getIsTestVariant();
            }
            return Utils.isTest(((GenerateProtoTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GenerateProtoTask.class))).getSourceSet().getName());
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

