/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.GradleVersion;

interface CopyActionFacade {
    public WorkResult copy(Action<? super CopySpec> var1);

    public WorkResult delete(Action<? super DeleteSpec> var1);

    public WorkResult sync(Action<? super CopySpec> var1);

    public static abstract class FileSystemOperationsBased
    implements CopyActionFacade {
        @Inject
        public abstract FileSystemOperations getFileSystemOperations();

        @Override
        public WorkResult copy(Action<? super CopySpec> action) {
            return this.getFileSystemOperations().copy(action);
        }

        @Override
        public WorkResult delete(Action<? super DeleteSpec> action) {
            return this.getFileSystemOperations().delete(action);
        }

        @Override
        public WorkResult sync(Action<? super CopySpec> action) {
            return this.getFileSystemOperations().sync(action);
        }
    }

    public static class ProjectBased
    implements CopyActionFacade {
        private final Project project;

        public ProjectBased(Project project) {
            this.project = project;
        }

        @Override
        public WorkResult copy(Action<? super CopySpec> action) {
            return this.project.copy(action);
        }

        @Override
        public WorkResult delete(Action<? super DeleteSpec> action) {
            return this.project.delete(action);
        }

        @Override
        public WorkResult sync(Action<? super CopySpec> action) {
            return this.project.sync(action);
        }
    }

    public static final class Loader {
        public static CopyActionFacade create(Project project, ObjectFactory objectFactory) {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.0")) >= 0) {
                return (CopyActionFacade)objectFactory.newInstance(FileSystemOperationsBased.class, new Object[0]);
            }
            return new ProjectBased(project);
        }
    }
}

