// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/protobuf/field_mask.proto

package com.google.protobuf;

/**
 * <pre>
 * `FieldMask` represents a set of symbolic field paths, for example:
 *     paths: "f.a"
 *     paths: "f.b.d"
 * Here `f` represents a field in some root message, `a` and `b`
 * fields in the message found in `f`, and `d` a field found in the
 * message in `f.b`.
 * Field masks are used to specify a subset of fields that should be
 * returned by a get operation or modified by an update operation.
 * Field masks also have a custom JSON encoding (see below).
 * # Field Masks in Projections
 * When used in the context of a projection, a response message or
 * sub-message is filtered by the API to only contain those fields as
 * specified in the mask. For example, if the mask in the previous
 * example is applied to a response message as follows:
 *     f {
 *       a : 22
 *       b {
 *         d : 1
 *         x : 2
 *       }
 *       y : 13
 *     }
 *     z: 8
 * The result will not contain specific values for fields x,y and z
 * (their value will be set to the default, and omitted in proto text
 * output):
 *     f {
 *       a : 22
 *       b {
 *         d : 1
 *       }
 *     }
 * A repeated field is not allowed except at the last position of a
 * paths string.
 * If a FieldMask object is not present in a get operation, the
 * operation applies to all fields (as if a FieldMask of all fields
 * had been specified).
 * Note that a field mask does not necessarily apply to the
 * top-level response message. In case of a REST get operation, the
 * field mask applies directly to the response, but in case of a REST
 * list operation, the mask instead applies to each individual message
 * in the returned resource list. In case of a REST custom method,
 * other definitions may be used. Where the mask applies will be
 * clearly documented together with its declaration in the API.  In
 * any case, the effect on the returned resource/resources is required
 * behavior for APIs.
 * # Field Masks in Update Operations
 * A field mask in update operations specifies which fields of the
 * targeted resource are going to be updated. The API is required
 * to only change the values of the fields as specified in the mask
 * and leave the others untouched. If a resource is passed in to
 * describe the updated values, the API ignores the values of all
 * fields not covered by the mask.
 * If a repeated field is specified for an update operation, new values will
 * be appended to the existing repeated field in the target resource. Note that
 * a repeated field is only allowed in the last position of a `paths` string.
 * If a sub-message is specified in the last position of the field mask for an
 * update operation, then new value will be merged into the existing sub-message
 * in the target resource.
 * For example, given the target message:
 *     f {
 *       b {
 *         d: 1
 *         x: 2
 *       }
 *       c: [1]
 *     }
 * And an update message:
 *     f {
 *       b {
 *         d: 10
 *       }
 *       c: [2]
 *     }
 * then if the field mask is:
 *  paths: ["f.b", "f.c"]
 * then the result will be:
 *     f {
 *       b {
 *         d: 10
 *         x: 2
 *       }
 *       c: [1, 2]
 *     }
 * An implementation may provide options to override this default behavior for
 * repeated and message fields.
 * In order to reset a field's value to the default, the field must
 * be in the mask and set to the default value in the provided resource.
 * Hence, in order to reset all fields of a resource, provide a default
 * instance of the resource and set all fields in the mask, or do
 * not provide a mask as described below.
 * If a field mask is not present on update, the operation applies to
 * all fields (as if a field mask of all fields has been specified).
 * Note that in the presence of schema evolution, this may mean that
 * fields the client does not know and has therefore not filled into
 * the request will be reset to their default. If this is unwanted
 * behavior, a specific service may require a client to always specify
 * a field mask, producing an error if not.
 * As with get operations, the location of the resource which
 * describes the updated values in the request message depends on the
 * operation kind. In any case, the effect of the field mask is
 * required to be honored by the API.
 * ## Considerations for HTTP REST
 * The HTTP kind of an update operation which uses a field mask must
 * be set to PATCH instead of PUT in order to satisfy HTTP semantics
 * (PUT must only be used for full updates).
 * # JSON Encoding of Field Masks
 * In JSON, a field mask is encoded as a single string where paths are
 * separated by a comma. Fields name in each path are converted
 * to/from lower-camel naming conventions.
 * As an example, consider the following message declarations:
 *     message Profile {
 *       User user = 1;
 *       Photo photo = 2;
 *     }
 *     message User {
 *       string display_name = 1;
 *       string address = 2;
 *     }
 * In proto a field mask for `Profile` may look as such:
 *     mask {
 *       paths: "user.display_name"
 *       paths: "photo"
 *     }
 * In JSON, the same mask is represented as below:
 *     {
 *       mask: "user.displayName,photo"
 *     }
 * # Field Masks and Oneof Fields
 * Field masks treat fields in oneofs just as regular fields. Consider the
 * following message:
 *     message SampleMessage {
 *       oneof test_oneof {
 *         string name = 4;
 *         SubMessage sub_message = 9;
 *       }
 *     }
 * The field mask can be:
 *     mask {
 *       paths: "name"
 *     }
 * Or:
 *     mask {
 *       paths: "sub_message"
 *     }
 * Note that oneof type names ("test_oneof" in this case) cannot be used in
 * paths.
 * ## Field Mask Verification
 * The implementation of any API method which has a FieldMask type field in the
 * request should verify the included field paths, and return an
 * `INVALID_ARGUMENT` error if any path is duplicated or unmappable.
 * </pre>
 *
 * Protobuf type {@code google.protobuf.FieldMask}
 */
public  final class FieldMask extends
    com.google.protobuf.GeneratedMessageLite<
        FieldMask, FieldMask.Builder> implements
    // @@protoc_insertion_point(message_implements:google.protobuf.FieldMask)
    FieldMaskOrBuilder {
  private FieldMask() {
    paths_ = com.google.protobuf.GeneratedMessageLite.emptyProtobufList();
  }
  public static final int PATHS_FIELD_NUMBER = 1;
  private com.google.protobuf.Internal.ProtobufList<java.lang.String> paths_;
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @return A list containing the paths.
   */
  @java.lang.Override
  public java.util.List<java.lang.String> getPathsList() {
    return paths_;
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @return The count of paths.
   */
  @java.lang.Override
  public int getPathsCount() {
    return paths_.size();
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param index The index of the element to return.
   * @return The paths at the given index.
   */
  @java.lang.Override
  public java.lang.String getPaths(int index) {
    return paths_.get(index);
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param index The index of the value to return.
   * @return The bytes of the paths at the given index.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPathsBytes(int index) {
    return com.google.protobuf.ByteString.copyFromUtf8(
        paths_.get(index));
  }
  private void ensurePathsIsMutable() {
    if (!paths_.isModifiable()) {
      paths_ =
          com.google.protobuf.GeneratedMessageLite.mutableCopy(paths_);
     }
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param index The index to set the value at.
   * @param value The paths to set.
   */
  private void setPaths(
      int index, java.lang.String value) {
    if (value == null) {
    throw new NullPointerException();
  }
  ensurePathsIsMutable();
    paths_.set(index, value);
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param value The paths to add.
   */
  private void addPaths(
      java.lang.String value) {
    if (value == null) {
    throw new NullPointerException();
  }
  ensurePathsIsMutable();
    paths_.add(value);
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param values The paths to add.
   */
  private void addAllPaths(
      java.lang.Iterable<java.lang.String> values) {
    ensurePathsIsMutable();
    com.google.protobuf.AbstractMessageLite.addAll(
        values, paths_);
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   */
  private void clearPaths() {
    paths_ = com.google.protobuf.GeneratedMessageLite.emptyProtobufList();
  }
  /**
   * <pre>
   * The set of field mask paths.
   * </pre>
   *
   * <code>repeated string paths = 1;</code>
   * @param value The bytes of the paths to add.
   */
  private void addPathsBytes(
      com.google.protobuf.ByteString value) {
    if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
    ensurePathsIsMutable();
    paths_.add(value.toStringUtf8());
  }

  public static com.google.protobuf.FieldMask parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.protobuf.FieldMask parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, data, extensionRegistry);
  }
  public static com.google.protobuf.FieldMask parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input, extensionRegistry);
  }
  public static com.google.protobuf.FieldMask parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return parseDelimitedFrom(DEFAULT_INSTANCE, input);
  }
  public static com.google.protobuf.FieldMask parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input);
  }
  public static com.google.protobuf.FieldMask parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageLite.parseFrom(
        DEFAULT_INSTANCE, input, extensionRegistry);
  }

  public static Builder newBuilder() {
    return (Builder) DEFAULT_INSTANCE.createBuilder();
  }
  public static Builder newBuilder(com.google.protobuf.FieldMask prototype) {
    return (Builder) DEFAULT_INSTANCE.createBuilder(prototype);
  }

  /**
   * <pre>
   * `FieldMask` represents a set of symbolic field paths, for example:
   *     paths: "f.a"
   *     paths: "f.b.d"
   * Here `f` represents a field in some root message, `a` and `b`
   * fields in the message found in `f`, and `d` a field found in the
   * message in `f.b`.
   * Field masks are used to specify a subset of fields that should be
   * returned by a get operation or modified by an update operation.
   * Field masks also have a custom JSON encoding (see below).
   * # Field Masks in Projections
   * When used in the context of a projection, a response message or
   * sub-message is filtered by the API to only contain those fields as
   * specified in the mask. For example, if the mask in the previous
   * example is applied to a response message as follows:
   *     f {
   *       a : 22
   *       b {
   *         d : 1
   *         x : 2
   *       }
   *       y : 13
   *     }
   *     z: 8
   * The result will not contain specific values for fields x,y and z
   * (their value will be set to the default, and omitted in proto text
   * output):
   *     f {
   *       a : 22
   *       b {
   *         d : 1
   *       }
   *     }
   * A repeated field is not allowed except at the last position of a
   * paths string.
   * If a FieldMask object is not present in a get operation, the
   * operation applies to all fields (as if a FieldMask of all fields
   * had been specified).
   * Note that a field mask does not necessarily apply to the
   * top-level response message. In case of a REST get operation, the
   * field mask applies directly to the response, but in case of a REST
   * list operation, the mask instead applies to each individual message
   * in the returned resource list. In case of a REST custom method,
   * other definitions may be used. Where the mask applies will be
   * clearly documented together with its declaration in the API.  In
   * any case, the effect on the returned resource/resources is required
   * behavior for APIs.
   * # Field Masks in Update Operations
   * A field mask in update operations specifies which fields of the
   * targeted resource are going to be updated. The API is required
   * to only change the values of the fields as specified in the mask
   * and leave the others untouched. If a resource is passed in to
   * describe the updated values, the API ignores the values of all
   * fields not covered by the mask.
   * If a repeated field is specified for an update operation, new values will
   * be appended to the existing repeated field in the target resource. Note that
   * a repeated field is only allowed in the last position of a `paths` string.
   * If a sub-message is specified in the last position of the field mask for an
   * update operation, then new value will be merged into the existing sub-message
   * in the target resource.
   * For example, given the target message:
   *     f {
   *       b {
   *         d: 1
   *         x: 2
   *       }
   *       c: [1]
   *     }
   * And an update message:
   *     f {
   *       b {
   *         d: 10
   *       }
   *       c: [2]
   *     }
   * then if the field mask is:
   *  paths: ["f.b", "f.c"]
   * then the result will be:
   *     f {
   *       b {
   *         d: 10
   *         x: 2
   *       }
   *       c: [1, 2]
   *     }
   * An implementation may provide options to override this default behavior for
   * repeated and message fields.
   * In order to reset a field's value to the default, the field must
   * be in the mask and set to the default value in the provided resource.
   * Hence, in order to reset all fields of a resource, provide a default
   * instance of the resource and set all fields in the mask, or do
   * not provide a mask as described below.
   * If a field mask is not present on update, the operation applies to
   * all fields (as if a field mask of all fields has been specified).
   * Note that in the presence of schema evolution, this may mean that
   * fields the client does not know and has therefore not filled into
   * the request will be reset to their default. If this is unwanted
   * behavior, a specific service may require a client to always specify
   * a field mask, producing an error if not.
   * As with get operations, the location of the resource which
   * describes the updated values in the request message depends on the
   * operation kind. In any case, the effect of the field mask is
   * required to be honored by the API.
   * ## Considerations for HTTP REST
   * The HTTP kind of an update operation which uses a field mask must
   * be set to PATCH instead of PUT in order to satisfy HTTP semantics
   * (PUT must only be used for full updates).
   * # JSON Encoding of Field Masks
   * In JSON, a field mask is encoded as a single string where paths are
   * separated by a comma. Fields name in each path are converted
   * to/from lower-camel naming conventions.
   * As an example, consider the following message declarations:
   *     message Profile {
   *       User user = 1;
   *       Photo photo = 2;
   *     }
   *     message User {
   *       string display_name = 1;
   *       string address = 2;
   *     }
   * In proto a field mask for `Profile` may look as such:
   *     mask {
   *       paths: "user.display_name"
   *       paths: "photo"
   *     }
   * In JSON, the same mask is represented as below:
   *     {
   *       mask: "user.displayName,photo"
   *     }
   * # Field Masks and Oneof Fields
   * Field masks treat fields in oneofs just as regular fields. Consider the
   * following message:
   *     message SampleMessage {
   *       oneof test_oneof {
   *         string name = 4;
   *         SubMessage sub_message = 9;
   *       }
   *     }
   * The field mask can be:
   *     mask {
   *       paths: "name"
   *     }
   * Or:
   *     mask {
   *       paths: "sub_message"
   *     }
   * Note that oneof type names ("test_oneof" in this case) cannot be used in
   * paths.
   * ## Field Mask Verification
   * The implementation of any API method which has a FieldMask type field in the
   * request should verify the included field paths, and return an
   * `INVALID_ARGUMENT` error if any path is duplicated or unmappable.
   * </pre>
   *
   * Protobuf type {@code google.protobuf.FieldMask}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageLite.Builder<
        com.google.protobuf.FieldMask, Builder> implements
      // @@protoc_insertion_point(builder_implements:google.protobuf.FieldMask)
      com.google.protobuf.FieldMaskOrBuilder {
    // Construct using com.google.protobuf.FieldMask.newBuilder()
    private Builder() {
      super(DEFAULT_INSTANCE);
    }


    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @return A list containing the paths.
     */
    @java.lang.Override
    public java.util.List<java.lang.String>
        getPathsList() {
      return java.util.Collections.unmodifiableList(
          instance.getPathsList());
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @return The count of paths.
     */
    @java.lang.Override
    public int getPathsCount() {
      return instance.getPathsCount();
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    @java.lang.Override
    public java.lang.String getPaths(int index) {
      return instance.getPaths(index);
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPathsBytes(int index) {
      return instance.getPathsBytes(index);
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param index The index to set the value at.
     * @param value The paths to set.
     * @return This builder for chaining.
     */
    public Builder setPaths(
        int index, java.lang.String value) {
      copyOnWrite();
      instance.setPaths(index, value);
      return this;
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param value The paths to add.
     * @return This builder for chaining.
     */
    public Builder addPaths(
        java.lang.String value) {
      copyOnWrite();
      instance.addPaths(value);
      return this;
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param values The paths to add.
     * @return This builder for chaining.
     */
    public Builder addAllPaths(
        java.lang.Iterable<java.lang.String> values) {
      copyOnWrite();
      instance.addAllPaths(values);
      return this;
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearPaths() {
      copyOnWrite();
      instance.clearPaths();
      return this;
    }
    /**
     * <pre>
     * The set of field mask paths.
     * </pre>
     *
     * <code>repeated string paths = 1;</code>
     * @param value The bytes of the paths to add.
     * @return This builder for chaining.
     */
    public Builder addPathsBytes(
        com.google.protobuf.ByteString value) {
      copyOnWrite();
      instance.addPathsBytes(value);
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.protobuf.FieldMask)
  }
  @java.lang.Override
  @java.lang.SuppressWarnings({"unchecked", "fallthrough"})
  protected final java.lang.Object dynamicMethod(
      com.google.protobuf.GeneratedMessageLite.MethodToInvoke method,
      java.lang.Object arg0, java.lang.Object arg1) {
    switch (method) {
      case NEW_MUTABLE_INSTANCE: {
        return new com.google.protobuf.FieldMask();
      }
      case NEW_BUILDER: {
        return new Builder();
      }
      case BUILD_MESSAGE_INFO: {
          java.lang.Object[] objects = new java.lang.Object[] {
            "paths_",
          };
          java.lang.String info =
              "\u0000\u0001\u0000\u0000\u0001\u0001\u0001\u0000\u0001\u0000\u0001\u021a";
          return newMessageInfo(DEFAULT_INSTANCE, info, objects);
      }
      // fall through
      case GET_DEFAULT_INSTANCE: {
        return DEFAULT_INSTANCE;
      }
      case GET_PARSER: {
        com.google.protobuf.Parser<com.google.protobuf.FieldMask> parser = PARSER;
        if (parser == null) {
          synchronized (com.google.protobuf.FieldMask.class) {
            parser = PARSER;
            if (parser == null) {
              parser =
                  new DefaultInstanceBasedParser<com.google.protobuf.FieldMask>(
                      DEFAULT_INSTANCE);
              PARSER = parser;
            }
          }
        }
        return parser;
    }
    case GET_MEMOIZED_IS_INITIALIZED: {
      return (byte) 1;
    }
    case SET_MEMOIZED_IS_INITIALIZED: {
      return null;
    }
    }
    throw new UnsupportedOperationException();
  }


  // @@protoc_insertion_point(class_scope:google.protobuf.FieldMask)
  private static final com.google.protobuf.FieldMask DEFAULT_INSTANCE;
  static {
    FieldMask defaultInstance = new FieldMask();
    // New instances are implicitly immutable so no need to make
    // immutable.
    DEFAULT_INSTANCE = defaultInstance;
    com.google.protobuf.GeneratedMessageLite.registerDefaultInstance(
      FieldMask.class, defaultInstance);
  }

  public static com.google.protobuf.FieldMask getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static volatile com.google.protobuf.Parser<FieldMask> PARSER;

  public static com.google.protobuf.Parser<FieldMask> parser() {
    return DEFAULT_INSTANCE.getParserForType();
  }
}

