/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Predicate;
import com.google.security.fences.ClassRoot;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

abstract class AbstractClassesVisitor {
    AbstractClassesVisitor() {
    }

    protected abstract ClassVisitor makeVisitorForClass(ClassRoot var1, String var2, ClassReader var3) throws IOException;

    protected void startClassRoot(ClassRoot cr) throws IOException {
    }

    protected void finishClassRoot(ClassRoot cr) throws IOException {
    }

    final void visitAll(Iterable<? extends ClassRoot> roots) throws IOException {
        for (ClassRoot classRoot : roots) {
            this.startClassRoot(classRoot);
            classRoot.readEachPathMatching(new Predicate<String>(){

                public boolean apply(String relativePath) {
                    return relativePath.endsWith(".class");
                }
            }, new ClassRoot.IOConsumer<InputStream, Boolean>(){

                @Override
                public Boolean consume(ClassRoot cr, String relPath, InputStream is) throws IOException {
                    ClassReader reader = new ClassReader(is);
                    ClassVisitor classChecker = AbstractClassesVisitor.this.makeVisitorForClass(cr, relPath, reader);
                    reader.accept(classChecker, 0);
                    return true;
                }
            });
            this.finishClassRoot(classRoot);
        }
    }
}

