/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.security.fences.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;

final class ClassRoot {
    final Artifact art;
    final File classRoot;
    final ClassRootKind kind;

    ClassRoot(Artifact art, File classRoot, ClassRootKind kind) {
        this.art = art;
        this.classRoot = classRoot;
        this.kind = kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T readRelativePath(String path, IOConsumer<? super InputStream, ? extends T> c) throws IOException {
        switch (this.kind) {
            case ZIPFILE: {
                ZipFile zf = new ZipFile(this.classRoot);
                try {
                    T t;
                    ZipEntry e = zf.getEntry(path);
                    if (e == null) {
                        throw new FileNotFoundException("Could not find " + path + " in " + Utils.artToString(this.art));
                    }
                    InputStream is = zf.getInputStream(e);
                    try {
                        t = c.consume(this, path, is);
                    }
                    catch (Throwable throwable) {
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    return t;
                }
                finally {
                    zf.close();
                }
            }
            case BUILD_OUTPUT_DIRECTORY: {
                String[] pathElements;
                File f = this.classRoot;
                for (String pathElement : pathElements = path.split("/")) {
                    if ("".equals(pathElement)) continue;
                    f = new File(f, pathElement);
                }
                FileInputStream is = new FileInputStream(f);
                try {
                    T t = c.consume(this, path, is);
                    return t;
                }
                finally {
                    is.close();
                }
            }
        }
        throw new AssertionError((Object)this.kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Map<String, T> readEachPathMatching(Predicate<String> relativePathFilter, IOConsumer<? super InputStream, ? extends T> c) throws IOException {
        ImmutableMap.Builder b = ImmutableMap.builder();
        switch (this.kind) {
            case ZIPFILE: {
                FileInputStream in = new FileInputStream(this.classRoot);
                try {
                    ZipInputStream zipIn = new ZipInputStream(in);
                    try {
                        ZipEntry zipEntry;
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            String entryName;
                            if (!zipEntry.isDirectory() && relativePathFilter.apply((Object)(entryName = zipEntry.getName()))) {
                                b.put((Object)entryName, c.consume(this, entryName, zipIn));
                            }
                            zipIn.closeEntry();
                        }
                    }
                    finally {
                        zipIn.close();
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
                return b.build();
            }
            case BUILD_OUTPUT_DIRECTORY: {
                this.find("", this.classRoot, relativePathFilter, c, b);
                return b.build();
            }
        }
        throw new AssertionError((Object)this.kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void find(String relativePath, File directory, Predicate<String> relativePathFilter, IOConsumer<? super InputStream, ? extends T> c, ImmutableMap.Builder<String, T> b) throws IOException {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)directory.getPath());
        File[] contents = directory.listFiles();
        if (contents == null) {
            throw new IOException("Cannot list contents of " + directory);
        }
        StringBuilder childRelPathBuilder = new StringBuilder();
        childRelPathBuilder.append(relativePath);
        if (childRelPathBuilder.length() != 0) {
            childRelPathBuilder.append('/');
        }
        int childRelPathPrefixLength = childRelPathBuilder.length();
        for (File child : contents) {
            childRelPathBuilder.setLength(childRelPathPrefixLength);
            String childRelPath = childRelPathBuilder.append(child.getName()).toString();
            if (child.isDirectory()) {
                this.find(childRelPath, child, relativePathFilter, c, b);
                continue;
            }
            if (!relativePathFilter.apply((Object)childRelPath)) continue;
            FileInputStream in = new FileInputStream(child);
            try {
                T result = c.consume(this, childRelPath, in);
                b.put((Object)childRelPath, result);
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    public String toString() {
        switch (this.kind) {
            case ZIPFILE: {
                return "zip " + this.classRoot + " from " + this.art.getId();
            }
            case BUILD_OUTPUT_DIRECTORY: {
                return "dir " + this.classRoot + " from " + this.art.getId();
            }
        }
        throw new AssertionError((Object)this.kind);
    }

    static interface IOConsumer<I, O> {
        public O consume(ClassRoot var1, String var2, I var3) throws IOException;
    }

    static enum ClassRootKind {
        ZIPFILE,
        BUILD_OUTPUT_DIRECTORY;

    }
}

