/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.security.fences.RelevantSystemProperties;
import com.google.security.fences.Violation;
import com.google.security.fences.config.HumanReadableText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

final class PolicyViolationReporter {
    final Log log;
    final Interpolator interpolator;

    PolicyViolationReporter(Log log) {
        this.log = log;
        this.interpolator = new RegexBasedInterpolator();
    }

    int report(ImmutableList<Violation> violations) {
        int errorCount = violations.size();
        if (!(!violations.isEmpty() ? errorCount > 0 : errorCount == 0)) {
            errorCount = Integer.MAX_VALUE;
        }
        if (errorCount == 0) {
            this.log.info((CharSequence)"No access policy violations");
            return 0;
        }
        ArrayList<Violation> violationsInOrder = new ArrayList<Violation>((Collection<Violation>)violations);
        Collections.sort(violationsInOrder);
        ImmutableList violationList = ImmutableList.copyOf(violationsInOrder);
        ReportTree t = this.groupByArtifactAndReport((ImmutableList<Violation>)violationList);
        String logMessage = t.toLogMessage();
        if (RelevantSystemProperties.inExperimentalMode()) {
            this.log.warn((CharSequence)logMessage);
        } else {
            this.log.error((CharSequence)logMessage);
        }
        Preconditions.checkState((errorCount > 0 ? 1 : 0) != 0);
        return errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> formatRationale(Violation v) {
        HumanReadableText wholeRationale = v.rationale.getWholeText();
        if (wholeRationale.isEmpty()) {
            return Optional.absent();
        }
        ObjectBasedValueSource artifactValueSource = new ObjectBasedValueSource((Object)v.artifact);
        MapBasedValueSource failedAccessValueSource = new MapBasedValueSource((Map)ImmutableMap.of((Object)"fences.api", (Object)v.useSiteApiElement.toDottedName(), (Object)"fences.distrusted", (Object)v.useSiteContainer));
        this.interpolator.addValueSource((ValueSource)artifactValueSource);
        this.interpolator.addValueSource((ValueSource)failedAccessValueSource);
        String rationaleText = wholeRationale.text;
        try {
            rationaleText = this.interpolator.interpolate(rationaleText);
        }
        catch (InterpolationException ex) {
            this.log.warn((Throwable)ex);
        }
        finally {
            this.interpolator.removeValuesSource((ValueSource)failedAccessValueSource);
            this.interpolator.removeValuesSource((ValueSource)artifactValueSource);
        }
        return Optional.of((Object)rationaleText);
    }

    private static ImmutableList<ReportTree> group(Function<Violation, String> getGroup, Function<ImmutableList<Violation>, ImmutableList<ReportTree>> descend, ImmutableList<Violation> violations) {
        int n = violations.size();
        if (n == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder groups = ImmutableList.builder();
        int i = 0;
        while (i < n) {
            String g;
            int groupEnd;
            String group = (String)getGroup.apply(violations.get(i));
            for (groupEnd = i + 1; groupEnd < n && group.equals(g = (String)getGroup.apply(violations.get(groupEnd))); ++groupEnd) {
            }
            ReportTree t = new ReportTree(group);
            t.children.addAll((Collection)descend.apply((Object)violations.subList(i, groupEnd)));
            groups.add((Object)t);
            i = groupEnd;
        }
        return groups.build();
    }

    private ReportTree groupByArtifactAndReport(ImmutableList<Violation> violations) {
        ReportTree root = new ReportTree("");
        root.children.addAll((Collection<ReportTree>)PolicyViolationReporter.group(new Function<Violation, String>(){

            public String apply(Violation v) {
                return v.artifact.getId();
            }
        }, new Function<ImmutableList<Violation>, ImmutableList<ReportTree>>(){

            public ImmutableList<ReportTree> apply(ImmutableList<Violation> vs) {
                return PolicyViolationReporter.this.groupByUseSiteSource((ImmutableList<Violation>)vs);
            }
        }, violations));
        return root;
    }

    private ImmutableList<ReportTree> groupByUseSiteSource(ImmutableList<Violation> violations) {
        return PolicyViolationReporter.group(new Function<Violation, String>(){

            public String apply(Violation v) {
                return v.useSiteSource;
            }
        }, new Function<ImmutableList<Violation>, ImmutableList<ReportTree>>(){

            public ImmutableList<ReportTree> apply(ImmutableList<Violation> vs) {
                return PolicyViolationReporter.this.groupByUseSiteLine((ImmutableList<Violation>)vs);
            }
        }, violations);
    }

    private ImmutableList<ReportTree> groupByUseSiteLine(ImmutableList<Violation> violations) {
        return PolicyViolationReporter.group(new Function<Violation, String>(){

            public String apply(Violation v) {
                return v.useSiteLineNumber < 0 ? "" : "L" + v.useSiteLineNumber;
            }
        }, new Function<ImmutableList<Violation>, ImmutableList<ReportTree>>(){

            public ImmutableList<ReportTree> apply(ImmutableList<Violation> vs) {
                return PolicyViolationReporter.this.formatViolations((ImmutableList<Violation>)vs);
            }
        }, violations);
    }

    private ImmutableList<ReportTree> formatViolations(ImmutableList<Violation> violations) {
        LinkedHashMap errorMessages = Maps.newLinkedHashMap();
        LinkedHashSet rationales = Sets.newLinkedHashSet();
        for (Violation v : violations) {
            String message = v.useSiteApiElement.toDottedName() + " cannot be accessed from " + v.useSiteContainer;
            if (!v.sensitiveApiElement.equals(v.useSiteApiElement)) {
                message = message + " because " + v.sensitiveApiElement.toDottedName() + " is restricted";
            }
            Optional<String> rationale = this.formatRationale(v);
            Integer priorCount = (Integer)errorMessages.get(message);
            errorMessages.put(message, 1 + (priorCount != null ? priorCount : 0));
            if (!rationale.isPresent()) continue;
            rationales.add(rationale.get());
        }
        ImmutableList.Builder leaves = ImmutableList.builder();
        for (Map.Entry e : errorMessages.entrySet()) {
            String message = (String)e.getKey();
            int count = (Integer)e.getValue();
            if (count != 1) {
                message = message + " (" + count + " times)";
            }
            leaves.add((Object)new ReportTree(message));
        }
        for (String rationale : rationales) {
            leaves.add((Object)new ReportTree(rationale));
        }
        return leaves.build();
    }

    static final class ReportTree {
        final List<ReportTree> children;
        final String text;

        ReportTree(String text) {
            this(text, Lists.newArrayList());
        }

        ReportTree(String text, List<ReportTree> children) {
            this.text = text;
            this.children = children;
        }

        String toLogMessage() {
            StringBuilder sb = new StringBuilder();
            this.appendLogMessage(0, sb);
            return sb.toString();
        }

        private void appendLogMessage(int depth, StringBuilder sb) {
            if (this.children.size() == 1) {
                ReportTree soleChild = this.children.get(0);
                if (!"".equals(this.text)) {
                    String combinedText = this.text;
                    if (!"".equals(soleChild.text)) {
                        combinedText = combinedText + " : " + soleChild.text;
                        soleChild = new ReportTree(combinedText, soleChild.children);
                    }
                }
                soleChild.appendLogMessage(depth, sb);
                return;
            }
            int childDepth = depth;
            boolean newLineBeforeChild = false;
            if (!"".equals(this.text)) {
                newLineBeforeChild = true;
                ++childDepth;
                int prefixStart = sb.length();
                for (int i = 0; i < depth; ++i) {
                    sb.append(". ");
                }
                String indentedText = this.text;
                Object[] lines = this.text.split("\r\n?|\n");
                if (lines.length != 1) {
                    String prefix = sb.substring(prefixStart);
                    indentedText = Joiner.on((String)("\n" + prefix)).join(lines);
                }
                sb.append(indentedText);
            }
            for (ReportTree child : this.children) {
                if (newLineBeforeChild) {
                    sb.append('\n');
                } else {
                    newLineBeforeChild = true;
                }
                child.appendLogMessage(childDepth, sb);
            }
        }
    }
}

