/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences;

import com.google.common.base.Objects;
import com.google.security.fences.config.Rationale;
import com.google.security.fences.namespace.Namespace;
import com.google.security.fences.policy.ApiElement;
import org.apache.maven.artifact.Artifact;

final class Violation
implements Comparable<Violation> {
    final Artifact artifact;
    final Namespace useSiteContainer;
    final String useSiteSource;
    final int useSiteLineNumber;
    final ApiElement useSiteApiElement;
    final ApiElement sensitiveApiElement;
    final Rationale rationale;

    Violation(Artifact artifact, Namespace useSiteContainer, String useSiteSource, int useSiteLineNumber, ApiElement useSiteApiElement, ApiElement sensitiveApiElement, Rationale rationale) {
        this.artifact = artifact;
        this.useSiteContainer = useSiteContainer;
        this.useSiteSource = useSiteSource;
        this.useSiteLineNumber = useSiteLineNumber;
        this.useSiteApiElement = useSiteApiElement;
        this.sensitiveApiElement = sensitiveApiElement;
        this.rationale = rationale;
    }

    @Override
    public int compareTo(Violation that) {
        int delta = this.artifact.compareTo((Object)that.artifact);
        if (delta == 0 && (delta = this.useSiteSource.compareTo(that.useSiteSource)) == 0 && (delta = Integer.compare(this.useSiteLineNumber, that.useSiteLineNumber)) == 0 && (delta = this.useSiteApiElement.compareTo(that.useSiteApiElement)) == 0) {
            delta = this.sensitiveApiElement.compareTo(that.sensitiveApiElement);
        }
        return delta;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation that = (Violation)o;
        return 0 == this.compareTo(that);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.artifact, this.useSiteSource, this.useSiteLineNumber, this.useSiteApiElement, this.sensitiveApiElement});
    }
}

