/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.security.fences.config.ClassFence;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.FenceVisitor;
import com.google.security.fences.config.PackageFence;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ApiFence
extends Fence {
    private final List<PackageFence> packages = Lists.newArrayList();
    private final List<ClassFence> classes = Lists.newArrayList();

    public void setPackage(PackageFence x) {
        this.packages.add((PackageFence)Preconditions.checkNotNull((Object)x));
    }

    public void setClass(ClassFence x) {
        this.classes.add((ClassFence)Preconditions.checkNotNull((Object)x));
    }

    ImmutableList<PackageFence> getPackages() {
        return ImmutableList.copyOf(this.packages);
    }

    ImmutableList<ClassFence> getClasses() {
        return ImmutableList.copyOf(this.classes);
    }

    @Override
    public Iterable<Fence> getChildFences() {
        return ImmutableList.builder().addAll(this.packages).addAll(this.classes).build();
    }

    @Override
    void visit(FenceVisitor v, ApiElement el) {
        Preconditions.checkArgument((boolean)el.equals(ApiElement.DEFAULT_PACKAGE));
        v.visit(this, ApiElement.DEFAULT_PACKAGE);
        for (Fence child : this.getChildFences()) {
            child.visit(v, ApiElement.DEFAULT_PACKAGE);
        }
    }

    @Override
    public ApiFence splitDottedNames(ApiElement parentEl, InheritanceGraph g) throws EnforcerRuleException {
        Preconditions.checkArgument((boolean)parentEl.equals(ApiElement.DEFAULT_PACKAGE));
        ImmutableList.Builder splitChildren = ImmutableList.builder();
        for (Fence unsplitChild : this.getChildFences()) {
            splitChildren.add((Object)unsplitChild.splitDottedNames(parentEl, g));
        }
        this.replaceChildFences((Iterable<? extends Fence>)splitChildren.build());
        return this;
    }

    @Override
    void replaceChildFences(Iterable<? extends Fence> newChildren) {
        this.packages.clear();
        this.classes.clear();
        for (Fence fence : newChildren) {
            if (fence instanceof PackageFence) {
                this.packages.add((PackageFence)fence);
                continue;
            }
            if (fence instanceof ClassFence) {
                this.classes.add((ClassFence)fence);
                continue;
            }
            if (fence instanceof ApiFence) {
                ApiFence apiChild = (ApiFence)fence;
                this.mergeFrom(apiChild);
                this.packages.addAll(apiChild.packages);
                this.classes.addAll(apiChild.classes);
                continue;
            }
            throw new IllegalArgumentException(fence.getClass().getName());
        }
    }

    @Override
    String getKey() {
        return "";
    }

    public Element buildEffectiveConfiguration() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element el = doc.createElement(this.getConfigurationElementName());
        this.fleshOutEffectiveConfiguration(el);
        return el;
    }

    @Override
    String getConfigurationElementName() {
        return "api";
    }

    @Override
    public ApiFence promoteToApi() {
        return this;
    }
}

