/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.fences.config.ApiFence;
import com.google.security.fences.config.FenceVisitor;
import com.google.security.fences.config.Frenemies;
import com.google.security.fences.config.HumanReadableText;
import com.google.security.fences.config.Rationale;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.namespace.Namespace;
import com.google.security.fences.policy.ApiElement;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Fence {
    private final List<Namespace> trusts = Lists.newArrayList();
    private final List<Namespace> distrusts = Lists.newArrayList();
    private final Rationale.Builder rationale = new Rationale.Builder();
    private int importOrder = -1;

    Fence() {
    }

    abstract String getKey();

    public void setTrusts(String s) throws EnforcerRuleException {
        this.trusts.add(Fence.parsePrinciple(s));
    }

    public void setDistrusts(String s) throws EnforcerRuleException {
        this.distrusts.add(Fence.parsePrinciple(s));
    }

    public void setRationale(@Nullable String s) throws EnforcerRuleException {
        if (s != null) {
            this.rationale.addBody(s);
        }
    }

    public void setAddendum(@Nullable String s) throws EnforcerRuleException {
        if (s != null) {
            this.rationale.addAddendum(s);
        }
    }

    public void check() throws EnforcerRuleException {
        for (Fence childFence : this.getChildFences()) {
            childFence.check();
        }
    }

    public abstract Iterable<Fence> getChildFences();

    abstract void replaceChildFences(Iterable<? extends Fence> var1);

    public final Frenemies getFrenemies() {
        Frenemies.Builder b = Frenemies.builder();
        for (Namespace ns : this.trusts) {
            b.addFriend(ns);
        }
        for (Namespace ns : this.distrusts) {
            b.addEnemy(ns);
        }
        b.setRationale(this.rationale.build());
        return b.build();
    }

    public final void assignImportOrder(int newImportOrder) {
        Preconditions.checkState((this.importOrder == -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((newImportOrder >= 0 ? 1 : 0) != 0);
        this.importOrder = newImportOrder;
        for (Fence child : this.getChildFences()) {
            child.assignImportOrder(newImportOrder);
        }
    }

    public abstract Fence splitDottedNames(ApiElement var1, InheritanceGraph var2) throws EnforcerRuleException;

    public ApiFence promoteToApi() {
        throw new IllegalStateException("Cannot promote " + this.getClass());
    }

    final void mergeFrom(Fence that) {
        this.trusts.addAll(that.trusts);
        this.distrusts.addAll(that.distrusts);
        if (this.importOrder > that.importOrder && !that.rationale.getBody().isEmpty()) {
            this.rationale.setBodyFrom(that.rationale.build());
        } else if (this.importOrder == that.importOrder) {
            this.rationale.addBodyFrom(that.rationale.build());
        }
        this.rationale.addAddendumFrom(that.rationale.build());
    }

    public final void mergeDeep(Fence f) {
        this.mergeFrom(f);
        LinkedHashMap childrenByKey = Maps.newLinkedHashMap();
        ImmutableList childrenToMerge = ImmutableList.builder().addAll(this.getChildFences()).addAll(f.getChildFences()).build();
        for (Fence childToMerge : childrenToMerge) {
            String fullKey = childToMerge.getClass().getName() + " : " + childToMerge.getKey();
            Fence previousChild = (Fence)childrenByKey.get(fullKey);
            if (previousChild != null) {
                previousChild.mergeDeep(childToMerge);
                continue;
            }
            childrenByKey.put(fullKey, childToMerge);
        }
        this.replaceChildFences(childrenByKey.values());
    }

    abstract void visit(FenceVisitor var1, ApiElement var2);

    public final void visit(FenceVisitor v) {
        this.visit(v, ApiElement.DEFAULT_PACKAGE);
    }

    abstract String getConfigurationElementName();

    void fleshOutEffectiveConfiguration(Element el) {
        HumanReadableText addendum;
        Element trustElement;
        Document doc = el.getOwnerDocument();
        for (Namespace ns : this.trusts) {
            trustElement = doc.createElement("trusts");
            trustElement.appendChild(doc.createTextNode(Fence.toTextNode(ns)));
            el.appendChild(trustElement);
        }
        for (Namespace ns : this.distrusts) {
            trustElement = doc.createElement("distrusts");
            trustElement.appendChild(doc.createTextNode(Fence.toTextNode(ns)));
            el.appendChild(trustElement);
        }
        HumanReadableText rbody = this.rationale.getBody();
        if (!rbody.isEmpty()) {
            Element rationaleElement = doc.createElement("rationale");
            rationaleElement.appendChild(doc.createTextNode(rbody.text));
            el.appendChild(rationaleElement);
        }
        if (!(addendum = this.rationale.getAddendum()).isEmpty()) {
            Element addendumElement = doc.createElement("addendum");
            addendumElement.appendChild(doc.createTextNode(addendum.text));
            el.appendChild(addendumElement);
        }
        for (Fence child : this.getChildFences()) {
            Element childEl = doc.createElement(child.getConfigurationElementName());
            el.appendChild(childEl);
            child.fleshOutEffectiveConfiguration(childEl);
        }
    }

    private static String toTextNode(Namespace ns) {
        if (Namespace.DEFAULT_PACKAGE.equals(ns)) {
            return "*";
        }
        return ns.toString();
    }

    private static Namespace parsePrinciple(String s) throws EnforcerRuleException {
        String trimmed = s.trim();
        if (!"*".equals(trimmed) && trimmed.contains("*")) {
            throw new EnforcerRuleException("Globs not allowed in namespace names: " + trimmed);
        }
        return Namespace.fromDottedString(trimmed);
    }
}

