/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.security.fences.config.ApiFence;
import com.google.security.fences.config.ClassFence;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.FenceVisitor;
import com.google.security.fences.config.NamedFence;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.policy.ApiElement;
import com.google.security.fences.policy.ApiElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;

public final class PackageFence
extends NamedFence {
    private final List<PackageFence> packages = Lists.newArrayList();
    private final List<ClassFence> classes = Lists.newArrayList();

    public void setPackage(PackageFence x) {
        this.packages.add((PackageFence)Preconditions.checkNotNull((Object)x));
    }

    public void setClass(ClassFence x) {
        this.classes.add((ClassFence)Preconditions.checkNotNull((Object)x));
    }

    @Override
    public Iterable<Fence> getChildFences() {
        return ImmutableList.builder().addAll(this.packages).addAll(this.classes).build();
    }

    @Override
    void visit(FenceVisitor v, ApiElement el) {
        String name = this.getName();
        ApiElement pkgEl = el.child(name, ApiElementType.PACKAGE);
        v.visit(this, pkgEl);
        for (Fence child : this.getChildFences()) {
            child.visit(v, pkgEl);
        }
    }

    @Override
    public Fence splitDottedNames(ApiElement parentEl, InheritanceGraph g) throws EnforcerRuleException {
        String name = this.getName();
        ImmutableList nameParts = name.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(Arrays.asList(name.split("[./]")));
        ImmutableList.Builder splitChildren = ImmutableList.builder();
        ApiElement el = parentEl;
        for (String namePart : nameParts) {
            el = el.child(namePart, ApiElementType.PACKAGE);
        }
        for (Fence unsplitChild : this.getChildFences()) {
            splitChildren.add((Object)unsplitChild.splitDottedNames(el, g));
        }
        this.replaceChildFences((Iterable<? extends Fence>)splitChildren.build());
        int nParts = nameParts.size();
        if (nParts == 0) {
            ApiFence apiFence = new ApiFence();
            apiFence.mergeFrom(this);
            for (PackageFence pkg : this.packages) {
                apiFence.setPackage(pkg);
            }
            for (ClassFence cls : this.classes) {
                apiFence.setClass(cls);
            }
            return apiFence;
        }
        PackageFence pkg = this;
        this.setName((String)nameParts.get(nParts - 1));
        int i = nParts - 1;
        while (--i >= 0) {
            String part = (String)nameParts.get(i);
            PackageFence parent = new PackageFence();
            parent.setName(part);
            parent.setPackage(pkg);
            pkg = parent;
        }
        return pkg;
    }

    @Override
    void replaceChildFences(Iterable<? extends Fence> newChildren) {
        this.packages.clear();
        this.classes.clear();
        for (Fence fence : newChildren) {
            if (fence instanceof PackageFence) {
                this.packages.add((PackageFence)fence);
                continue;
            }
            if (fence instanceof ClassFence) {
                this.classes.add((ClassFence)fence);
                continue;
            }
            if (fence instanceof ApiFence) {
                ApiFence apiChild = (ApiFence)fence;
                this.mergeFrom(apiChild);
                this.packages.addAll((Collection<PackageFence>)apiChild.getPackages());
                this.classes.addAll((Collection<ClassFence>)apiChild.getClasses());
                continue;
            }
            throw new IllegalArgumentException(fence.getClass().getName());
        }
    }

    @Override
    String getConfigurationElementName() {
        return "package";
    }

    @Override
    public ApiFence promoteToApi() {
        ApiFence api = new ApiFence();
        api.setPackage(this);
        return api;
    }
}

