/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.inheritance;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.security.fences.inheritance.FieldDetails;
import com.google.security.fences.inheritance.MethodDetails;

public final class ClassNode
implements Comparable<ClassNode> {
    public final String name;
    public final int access;
    public final Optional<String> superType;
    public final Optional<String> outerClass;
    public final ImmutableList<String> interfaces;
    public final ImmutableSet<MethodDetails> methods;
    public final ImmutableSet<FieldDetails> fields;

    ClassNode(String name, int access, Optional<String> superType, Optional<String> outerClass, Iterable<? extends String> interfaces, Iterable<? extends MethodDetails> methods, Iterable<? extends FieldDetails> fields) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (Object)name);
        this.name = name;
        this.access = access;
        this.superType = superType;
        this.outerClass = outerClass;
        this.interfaces = ImmutableList.copyOf(interfaces);
        this.methods = ImmutableSet.copyOf(methods);
        this.fields = ImmutableSet.copyOf(fields);
    }

    public Optional<MethodDetails> getMethod(String methodName, String descriptor) {
        for (MethodDetails m : this.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals(descriptor)) continue;
            return Optional.of((Object)m);
        }
        return Optional.absent();
    }

    public Optional<FieldDetails> getField(String fieldName) {
        for (FieldDetails f : this.fields) {
            if (!f.name.equals(fieldName)) continue;
            return Optional.of((Object)f);
        }
        return Optional.absent();
    }

    public boolean isMethodVisibleThrough(String methodName, String descriptor) {
        for (MethodDetails m : this.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals(descriptor) || (m.access & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isFieldVisibleThrough(String fieldName) {
        for (FieldDetails f : this.fields) {
            if (!f.name.equals(fieldName) || (f.access & 2) != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ClassNode x) {
        return this.name.compareTo(x.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassNode)) {
            return false;
        }
        ClassNode that = (ClassNode)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

