/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.inheritance;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.fences.inheritance.FieldDetails;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.inheritance.MethodDetails;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class ClassNodeFromClassFileVisitor
extends ClassVisitor {
    private final InheritanceGraph.Builder graphBuilder;
    private String name;
    private int access;
    private Optional<String> superName;
    private Iterable<String> interfaces;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private boolean includePrivates = true;

    public ClassNodeFromClassFileVisitor(InheritanceGraph.Builder graphBuilder) {
        super(327680);
        this.graphBuilder = graphBuilder;
    }

    void setIncludePrivates(boolean newIncludePrivates) {
        this.includePrivates = newIncludePrivates;
    }

    public void visit(int version, int accessFlags, String className, String signature, @Nullable String superClassName, String[] interfaceNames) {
        Preconditions.checkState((this.name == null ? 1 : 0) != 0);
        this.name = className;
        this.access = accessFlags;
        this.superName = Optional.fromNullable((Object)superClassName);
        this.interfaces = Arrays.asList(interfaceNames);
        this.fields = Lists.newArrayList();
        this.methods = Lists.newArrayList();
    }

    public void visitEnd() {
        this.graphBuilder.declare(this.name, this.access).superClassName(this.superName).interfaceNames(this.interfaces).methods(this.methods).fields(this.fields).commit();
        this.name = null;
    }

    public void visitInnerClass(String innerInternalName, String outerName, String innerName, int innerClassAccess) {
        if (outerName != null) {
            this.graphBuilder.classContains(outerName, innerInternalName);
        }
    }

    public FieldVisitor visitField(int fieldAccess, String fieldName, String desc, String signature, Object value) {
        if (this.includePrivates || (this.access & 2) == 0) {
            this.fields.add(new FieldDetails(fieldName, fieldAccess));
        }
        return null;
    }

    public MethodVisitor visitMethod(int methodAccess, String methodName, String desc, String signature, String[] exceptions) {
        if (this.includePrivates || (this.access & 2) == 0) {
            this.methods.add(new MethodDetails(methodName, desc, methodAccess));
        }
        return null;
    }
}

