/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.inheritance;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.security.fences.inheritance.ClassNode;
import com.google.security.fences.inheritance.FieldDetails;
import com.google.security.fences.inheritance.MethodDetails;
import com.google.security.fences.inheritance.SystemInheritanceGraph;
import java.util.Map;

public final class InheritanceGraph {
    private final Map<String, ClassNode> classNodes;
    private final Function<String, ClassNode> fallback;

    InheritanceGraph(Map<String, ClassNode> classNodes, Function<String, ClassNode> fallback) {
        this.classNodes = Maps.newLinkedHashMap(classNodes);
        this.fallback = fallback;
    }

    public Optional<ClassNode> named(String name) {
        ClassNode node = this.classNodes.get(name);
        if (node == null && !this.classNodes.containsKey(name)) {
            node = (ClassNode)this.fallback.apply((Object)name);
            this.classNodes.put(name, node);
        }
        return Optional.fromNullable((Object)node);
    }

    public static Builder builder() {
        return new Builder(SystemInheritanceGraph.LAZY_LOADER);
    }

    static Builder builder(Function<String, ClassNode> fallback) {
        return new Builder(fallback);
    }

    public Iterable<String> allDeclaredNames() {
        return ImmutableList.copyOf(this.classNodes.keySet());
    }

    public Iterable<ClassNode> allDeclaredNodes() {
        return ImmutableList.copyOf(this.classNodes.values());
    }

    public static final class Builder {
        private final Map<String, ClassNode> classNodes = Maps.newLinkedHashMap();
        private final Function<String, ClassNode> lazyLoadSystemClass;
        private final Map<String, String> outers = Maps.newLinkedHashMap();

        Builder(Function<String, ClassNode> lazyLoadSystemClass) {
            this.lazyLoadSystemClass = lazyLoadSystemClass;
        }

        public DeclarationBuilder declare(String name, int access) {
            return new DeclarationBuilder(name, access);
        }

        public InheritanceGraph build() {
            return new InheritanceGraph(this.classNodes, this.lazyLoadSystemClass);
        }

        void classContains(String outer, String inner) {
            ClassNode innerNode = this.classNodes.get(inner);
            if (innerNode != null) {
                innerNode = new ClassNode(innerNode.name, innerNode.access, innerNode.superType, (Optional<String>)Optional.of((Object)outer), (Iterable<? extends String>)innerNode.interfaces, (Iterable<? extends MethodDetails>)innerNode.methods, (Iterable<? extends FieldDetails>)innerNode.fields);
                this.classNodes.put(inner, innerNode);
            } else {
                this.outers.put(inner, outer);
            }
        }

        public final class DeclarationBuilder {
            private final String name;
            private final int access;
            private Optional<String> superClassName = Optional.of((Object)"java/lang/Object");
            private Optional<String> outerClassName = Optional.absent();
            private ImmutableList.Builder<String> interfaceNames = ImmutableList.builder();
            private ImmutableList.Builder<MethodDetails> methods = ImmutableList.builder();
            private ImmutableList.Builder<FieldDetails> fields = ImmutableList.builder();

            DeclarationBuilder(String name, int access) {
                this.name = name;
                this.access = access;
            }

            public DeclarationBuilder superClassName(Optional<String> newSuperClassName) {
                this.superClassName = newSuperClassName;
                return this;
            }

            public DeclarationBuilder outerClassName(Optional<String> newOuterClassName) {
                this.outerClassName = newOuterClassName;
                return this;
            }

            public DeclarationBuilder interfaceNames(Iterable<? extends String> newInterfaceNames) {
                this.interfaceNames.addAll(newInterfaceNames);
                return this;
            }

            public DeclarationBuilder methods(Iterable<? extends MethodDetails> newMethods) {
                this.methods.addAll(newMethods);
                return this;
            }

            public DeclarationBuilder fields(Iterable<? extends FieldDetails> newFields) {
                this.fields.addAll(newFields);
                return this;
            }

            public Builder commit() {
                Map classNodesMap = Builder.this.classNodes;
                Map outersMap = Builder.this.outers;
                ClassNode node = (ClassNode)classNodesMap.get(this.name);
                if (node == null) {
                    Optional outer = this.outerClassName;
                    if (!outer.isPresent()) {
                        outer = Optional.fromNullable(outersMap.remove(this.name));
                    }
                    node = new ClassNode(this.name, this.access, this.superClassName, (Optional<String>)outer, (Iterable<? extends String>)this.interfaceNames.build(), (Iterable<? extends MethodDetails>)this.methods.build(), (Iterable<? extends FieldDetails>)this.fields.build());
                    classNodesMap.put(this.name, node);
                }
                return Builder.this;
            }
        }
    }
}

