/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.inheritance;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.security.fences.inheritance.ClassNode;
import com.google.security.fences.inheritance.ClassNodeFromClassFileVisitor;
import com.google.security.fences.inheritance.FieldDetails;
import com.google.security.fences.inheritance.InheritanceGraph;
import com.google.security.fences.inheritance.MethodDetails;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class SystemInheritanceGraph {
    public static final Function<String, ClassNode> LAZY_LOADER = new Function<String, ClassNode>(){

        @Nonnull
        public ClassNode apply(@Nonnull String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            return LazyLoader.INSTANCE.get(name);
        }
    };
    private static final String ACCESS_DB_NAME = "access";
    private static final String SUPERTYPE_DB_NAME = "supertype";
    private static final String OUTER_CLASS_DB_NAME = "outerclasses";
    private static final String INTERFACE_DB_NAME = "interfaces";
    private static final String METHOD_DB_NAME = "methods";
    private static final String FIELD_DB_NAME = "fields";

    static String utf8(DatabaseEntry e) {
        if (e.getSize() == 0) {
            return "";
        }
        return Charsets.UTF_8.decode(ByteBuffer.wrap(e.getData())).toString();
    }

    static DatabaseEntry utf8(String s) {
        ByteBuffer bb = Charsets.UTF_8.encode(s);
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        return new DatabaseEntry(bytes);
    }

    static int int32(DatabaseEntry e) {
        int x = 0;
        byte[] data = e.getData();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            x = x << 8 | data[i] & 0xFF;
        }
        return x;
    }

    static DatabaseEntry int32(int n) {
        int nBytes = n < 65536 ? (n < 256 ? (n == 0 ? 0 : 1) : 2) : (n < 0x1000000 ? 3 : 4);
        byte[] bytes = new byte[nBytes];
        int x = n;
        int i = nBytes;
        while (--i >= 0) {
            bytes[i] = (byte)(x & 0xFF);
            x >>>= 8;
        }
        DatabaseEntry e = new DatabaseEntry(bytes);
        if (SystemInheritanceGraph.int32(e) != n) {
            throw new AssertionError((Object)("n=" + n + ", nBytes=" + nBytes + ", bytes=" + Arrays.toString(bytes)));
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... argv) throws IOException {
        boolean argsOk = argv.length > 1;
        File bdbHome = null;
        if (argsOk && !(bdbHome = new File(argv[0])).isDirectory()) {
            System.err.println("Expected directory for BDB files, not " + bdbHome);
            argsOk = false;
        }
        List<String> jars = null;
        if (argsOk) {
            jars = Arrays.asList(argv);
            if (!Iterables.all(jars = jars.subList(1, jars.size()), (Predicate)new Predicate<String>(){

                public boolean apply(@Nonnull String arg) {
                    if (arg == null) {
                        throw new NullPointerException();
                    }
                    return arg.endsWith(".jar") && new File(arg).isFile();
                }
            })) {
                System.err.println("Not all are jars : " + jars);
                argsOk = false;
            }
        }
        if (!argsOk) {
            System.err.println("Usage: " + SystemInheritanceGraph.class.getName() + " path/to/bdb-home" + " path/to/rt.jar path/to/other-system.jar ...");
            return;
        }
        InheritanceGraph.Builder graphBuilder = InheritanceGraph.builder(new Function<String, ClassNode>(){

            public ClassNode apply(String name) {
                return null;
            }
        });
        for (String arg : (List)Preconditions.checkNotNull(jars)) {
            File jarFile = new File(arg);
            if (!jarFile.isFile()) {
                System.err.println("Not a valid jar file : " + jarFile);
                return;
            }
            FileInputStream in = new FileInputStream(jarFile);
            try {
                ZipInputStream zipIn = new ZipInputStream(in);
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipIn.getNextEntry()) != null) {
                        String entryName;
                        if (!zipEntry.isDirectory() && (entryName = zipEntry.getName()).endsWith(".class")) {
                            ClassReader reader = new ClassReader((InputStream)zipIn);
                            ClassNodeFromClassFileVisitor visitor = new ClassNodeFromClassFileVisitor(graphBuilder);
                            visitor.setIncludePrivates(false);
                            reader.accept((ClassVisitor)visitor, 0);
                        }
                        zipIn.closeEntry();
                    }
                }
                finally {
                    zipIn.close();
                }
            }
            finally {
                ((InputStream)in).close();
            }
            InheritanceGraph graph = graphBuilder.build();
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            Environment env = new Environment(bdbHome, envConfig);
            Transaction txn = null;
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setAllowCreateVoid(true);
            dbConfig.setReadOnly(false);
            Database accessDb = env.openDatabase(txn, ACCESS_DB_NAME, dbConfig);
            Database supertypeDb = env.openDatabase(txn, SUPERTYPE_DB_NAME, dbConfig);
            Database outerClassDb = env.openDatabase(txn, OUTER_CLASS_DB_NAME, dbConfig);
            Database interfaceDb = env.openDatabase(txn, INTERFACE_DB_NAME, dbConfig);
            Database methodDb = env.openDatabase(txn, METHOD_DB_NAME, dbConfig);
            Database fieldDb = env.openDatabase(txn, FIELD_DB_NAME, dbConfig);
            for (ClassNode node : graph.allDeclaredNodes()) {
                StringBuilder sb;
                String name = node.name;
                int access = node.access;
                DatabaseEntry nameData = SystemInheritanceGraph.utf8(name);
                if (access != 0) {
                    accessDb.put(txn, nameData, SystemInheritanceGraph.int32(access));
                }
                if (node.superType.isPresent()) {
                    supertypeDb.put(txn, nameData, SystemInheritanceGraph.utf8((String)node.superType.get()));
                }
                interfaceDb.put(txn, nameData, SystemInheritanceGraph.utf8(Joiner.on((String)",").join(node.interfaces)));
                if (!node.fields.isEmpty()) {
                    sb = new StringBuilder();
                    for (FieldDetails f : node.fields) {
                        if (sb.length() != 0) {
                            sb.append(',');
                        }
                        sb.append(f.toCompactString());
                    }
                    fieldDb.put(txn, nameData, SystemInheritanceGraph.utf8(sb.toString()));
                }
                if (node.methods.isEmpty()) continue;
                sb = new StringBuilder();
                for (MethodDetails m : node.methods) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(m.toCompactString());
                }
                methodDb.put(txn, nameData, SystemInheritanceGraph.utf8(sb.toString()));
            }
            fieldDb.close();
            methodDb.close();
            interfaceDb.close();
            outerClassDb.close();
            supertypeDb.close();
            accessDb.close();
            env.close();
        }
    }

    private static final class LazyLoader {
        static final LazyLoader INSTANCE = new LazyLoader();
        private final ConcurrentHashMap<String, ClassNode> classNodes = new ConcurrentHashMap();
        private final Environment env;
        private final Database accessDb;
        private final Database supertypeDb;
        private final Database outerClassDb;
        private final Database interfaceDb;
        private final Database methodDb;
        private final Database fieldDb;

        private LazyLoader() {
            try {
                this.env = this.init();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                AssertionError err = new AssertionError((Object)"Cannot unpack system class inheritance graph to a temp file");
                ((Throwable)((Object)err)).initCause(ex);
                throw err;
            }
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setReadOnly(true);
            this.accessDb = this.env.openDatabase(null, SystemInheritanceGraph.ACCESS_DB_NAME, dbConfig);
            this.supertypeDb = this.env.openDatabase(null, SystemInheritanceGraph.SUPERTYPE_DB_NAME, dbConfig);
            this.outerClassDb = this.env.openDatabase(null, SystemInheritanceGraph.OUTER_CLASS_DB_NAME, dbConfig);
            this.interfaceDb = this.env.openDatabase(null, SystemInheritanceGraph.INTERFACE_DB_NAME, dbConfig);
            this.methodDb = this.env.openDatabase(null, SystemInheritanceGraph.METHOD_DB_NAME, dbConfig);
            this.fieldDb = this.env.openDatabase(null, SystemInheritanceGraph.FIELD_DB_NAME, dbConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Environment init() throws IOException {
            String[] dbBaseNames;
            File home = File.createTempFile("system-inheritance-graph-", "-home");
            if (home.exists() && !home.delete()) {
                throw new IOException("Could not delete temp file " + home);
            }
            if (!home.mkdirs()) {
                throw new IOException("Could not make temp dir " + home);
            }
            for (String dbBaseName : dbBaseNames = new String[]{"00000000.jdb", "00000001.jdb", "00000002.jdb"}) {
                InputStream in = this.getClass().getResourceAsStream("system-inheritance-graph/" + dbBaseName);
                try {
                    FileOutputStream out = new FileOutputStream(new File(home, dbBaseName));
                    try {
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
            EnvironmentConfig config = new EnvironmentConfig();
            config.setAllowCreate(false);
            config.setReadOnly(true);
            return new Environment(home, config);
        }

        ClassNode get(String name) {
            ClassNode node;
            String fieldCsv;
            String methodCsv;
            DatabaseEntry interfaces;
            ClassNode inMap = this.classNodes.get(name);
            if (inMap != null) {
                return inMap;
            }
            DatabaseEntry nameData = SystemInheritanceGraph.utf8(name);
            OperationStatus ifaceStatus = this.interfaceDb.get(null, nameData, interfaces = new DatabaseEntry(), LockMode.DEFAULT);
            if (!OperationStatus.SUCCESS.equals((Object)ifaceStatus)) {
                return null;
            }
            DatabaseEntry accessEntry = new DatabaseEntry();
            int access = 0;
            OperationStatus accessStates = this.accessDb.get(null, nameData, accessEntry, LockMode.DEFAULT);
            if (OperationStatus.SUCCESS.equals((Object)accessStates)) {
                access = SystemInheritanceGraph.int32(accessEntry);
            }
            DatabaseEntry supertype = new DatabaseEntry();
            OperationStatus stypeStatus = this.supertypeDb.get(null, nameData, supertype, LockMode.DEFAULT);
            Optional supertypeName = Optional.absent();
            if (OperationStatus.SUCCESS.equals((Object)stypeStatus)) {
                supertypeName = Optional.of((Object)SystemInheritanceGraph.utf8(supertype));
            }
            DatabaseEntry outerClass = new DatabaseEntry();
            OperationStatus oclassStatus = this.outerClassDb.get(null, nameData, outerClass, LockMode.DEFAULT);
            Optional outerClassName = Optional.absent();
            if (OperationStatus.SUCCESS.equals((Object)oclassStatus)) {
                outerClassName = Optional.of((Object)SystemInheritanceGraph.utf8(outerClass));
            }
            String interfaceNamesCsv = SystemInheritanceGraph.utf8(interfaces);
            Object interfaceNames = ImmutableList.of();
            if (!interfaceNamesCsv.isEmpty()) {
                interfaceNames = Arrays.asList(interfaceNamesCsv.split(","));
            }
            DatabaseEntry methodSigs = new DatabaseEntry();
            OperationStatus methodStatus = this.methodDb.get(null, nameData, methodSigs, LockMode.DEFAULT);
            Object methods = ImmutableList.of();
            if (OperationStatus.SUCCESS.equals((Object)methodStatus) && !(methodCsv = SystemInheritanceGraph.utf8(methodSigs)).isEmpty()) {
                methods = Lists.newArrayList();
                for (String compactString : methodCsv.split(",")) {
                    methods.add(MethodDetails.fromCompactString(compactString));
                }
            }
            DatabaseEntry fieldSigs = new DatabaseEntry();
            OperationStatus fieldStatus = this.fieldDb.get(null, nameData, fieldSigs, LockMode.DEFAULT);
            Object fields = ImmutableList.of();
            if (OperationStatus.SUCCESS.equals((Object)fieldStatus) && !(fieldCsv = SystemInheritanceGraph.utf8(fieldSigs)).isEmpty()) {
                fields = Lists.newArrayList();
                for (String compactString : fieldCsv.split(",")) {
                    fields.add(FieldDetails.fromCompactString(compactString));
                }
            }
            return (inMap = this.classNodes.putIfAbsent(name, node = new ClassNode(name, access, (Optional<String>)supertypeName, (Optional<String>)outerClassName, (Iterable<? extends String>)interfaceNames, (Iterable<? extends MethodDetails>)methods, (Iterable<? extends FieldDetails>)fields))) != null ? inMap : node;
        }
    }
}

