/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.namespace;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;

public final class Namespace {
    private final Namespace parent;
    private final String name;
    public static final Namespace DEFAULT_PACKAGE = new Namespace();

    private Namespace() {
        this.parent = null;
        this.name = null;
    }

    private Namespace(Namespace parent, String name) {
        Preconditions.checkArgument((name.length() != 0 && name.indexOf(46) < 0 ? 1 : 0) != 0);
        this.parent = (Namespace)Preconditions.checkNotNull((Object)parent);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public Optional<Namespace> getParent() {
        return Optional.fromNullable((Object)this.parent);
    }

    public Optional<String> getName() {
        return Optional.fromNullable((Object)this.name);
    }

    public Namespace child(String childName) {
        return new Namespace(this, childName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Namespace)) {
            return false;
        }
        Namespace that = (Namespace)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.parent, (Object)that.parent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.parent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (this.parent != null) {
            int n = sb.length();
            this.parent.toStringBuilder(sb);
            if (sb.length() != n) {
                sb.append('.');
            }
            sb.append(this.name);
        } else assert (this.name == null);
    }

    public static Namespace fromDottedString(String dottedString) throws EnforcerRuleException {
        if ("*".equals(dottedString)) {
            return DEFAULT_PACKAGE;
        }
        return Namespace.fromSeparatedString("dotted name", dottedString, "[.]");
    }

    public static Namespace fromInternalClassName(String icn) throws EnforcerRuleException {
        return Namespace.fromSeparatedString("internal class name", icn, "/");
    }

    static Namespace fromSeparatedString(String description, String string, String separatorPattern) throws EnforcerRuleException {
        Namespace ns = DEFAULT_PACKAGE;
        if (string.length() != 0) {
            for (String part : string.split(separatorPattern)) {
                if (part.length() == 0) {
                    throw new EnforcerRuleException("Invalid " + description + ": " + string);
                }
                ns = ns.child(part);
            }
        }
        return ns;
    }
}

