/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.namespace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.security.fences.namespace.Namespace;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class NamespaceTrie<SIMPLE_VALUE, COMPLEX_VALUE> {
    final Entry<COMPLEX_VALUE> root = new Entry(null);
    final Supplier<COMPLEX_VALUE> makeEmpty;
    final Function<COMPLEX_VALUE, Function<SIMPLE_VALUE, COMPLEX_VALUE>> folder;

    public NamespaceTrie(Supplier<COMPLEX_VALUE> makeEmpty, Function<COMPLEX_VALUE, Function<SIMPLE_VALUE, COMPLEX_VALUE>> folder) {
        this.makeEmpty = makeEmpty;
        this.folder = folder;
    }

    public Map<Namespace, COMPLEX_VALUE> overlapping(Namespace ns) {
        Entry<COMPLEX_VALUE> e = this.getEntry(ns, false, false);
        ImmutableMap.Builder b = ImmutableMap.builder();
        if (e != null) {
            e.addTransitively(ns, b);
        }
        return b.build();
    }

    public Entry<COMPLEX_VALUE> get(Namespace ns) {
        return this.getEntry(ns, false, false);
    }

    public Entry<COMPLEX_VALUE> put(Namespace ns, SIMPLE_VALUE simpleValue) {
        Entry e = (Entry)Preconditions.checkNotNull(this.getEntry(ns, true, false));
        e.putValue(this.makeEmpty, this.folder, simpleValue);
        return e;
    }

    public Entry<COMPLEX_VALUE> getDeepest(Namespace ns) {
        return this.getEntry(ns, false, true);
    }

    private Entry<COMPLEX_VALUE> getEntry(Namespace ns, boolean manufacture, boolean bestEffort) {
        Optional<String> nameOpt;
        Entry<COMPLEX_VALUE> parentEntry;
        Optional<Namespace> parent = ns.getParent();
        if (parent.isPresent()) {
            parentEntry = this.getEntry((Namespace)parent.get(), manufacture, bestEffort);
            if (parentEntry == null) {
                return null;
            }
        } else {
            parentEntry = this.root;
        }
        if ((nameOpt = ns.getName()).isPresent()) {
            String name = (String)nameOpt.get();
            SortedMap children = ((Entry)parentEntry).children;
            Entry<COMPLEX_VALUE> child = (Entry<COMPLEX_VALUE>)children.get(name);
            if (child == null) {
                if (manufacture) {
                    child = new Entry<COMPLEX_VALUE>(parentEntry);
                    children.put(name, child);
                } else if (bestEffort) {
                    return parentEntry;
                }
            }
            return child;
        }
        return parentEntry;
    }

    public String toTree() {
        return this.root.toTree();
    }

    public static final class Entry<T> {
        private Optional<T> value = Optional.absent();
        private final Entry<T> parent;
        private final SortedMap<String, Entry<T>> children = new TreeMap<String, Entry<T>>();

        Entry(Entry<T> parent) {
            this.parent = parent;
        }

        <X> void putValue(Supplier<T> emptyValue, Function<T, Function<X, T>> fold, X newValuePart) {
            Object newValue = ((Function)fold.apply(this.value.or(emptyValue))).apply(newValuePart);
            this.value = Optional.of((Object)newValue);
        }

        public Optional<T> getValue() {
            return this.value;
        }

        public Optional<Entry<T>> getParent() {
            return Optional.fromNullable(this.parent);
        }

        void addTransitively(Namespace ns, ImmutableMap.Builder<Namespace, T> out) {
            if (this.value.isPresent()) {
                out.put((Object)ns, this.value.get());
            }
            for (Map.Entry<String, Entry<T>> e : this.children.entrySet()) {
                e.getValue().addTransitively(ns.child(e.getKey()), out);
            }
        }

        public String toString() {
            return this.toShallowString();
        }

        String toShallowString() {
            return "Entry " + this.value;
        }

        public String toTree() {
            StringBuilder sb = new StringBuilder();
            this.toTree(sb, 0);
            return sb.toString();
        }

        public void toTree(StringBuilder sb, int n) {
            sb.append(this.toShallowString());
            int childDepth = n + 1;
            for (Map.Entry<String, Entry<T>> e : this.children.entrySet()) {
                sb.append('\n');
                int i = childDepth;
                while (--i >= 0) {
                    sb.append(". ");
                }
                sb.append(e.getKey()).append(" => ");
                e.getValue().toTree(sb, childDepth);
            }
        }
    }
}

