/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.fences.policy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.security.fences.config.Fence;
import com.google.security.fences.config.FenceVisitor;
import com.google.security.fences.config.Frenemies;
import com.google.security.fences.config.HumanReadableText;
import com.google.security.fences.namespace.Namespace;
import com.google.security.fences.namespace.NamespaceTrie;
import com.google.security.fences.policy.AccessLevel;
import com.google.security.fences.policy.ApiElement;
import java.util.Map;

public final class Policy {
    private final NamespaceTrie<AccessControlDecision, NamespacePolicy> trie = new NamespaceTrie<AccessControlDecision, NamespacePolicy>(NamespacePolicy.EMPTY_SUPPLIER, FOLD_POLICIES_TOGETHER);
    private final Map<ApiElement, HumanReadableText> addenda = Maps.newHashMap();
    private static final Function<NamespacePolicy, Function<AccessControlDecision, NamespacePolicy>> FOLD_POLICIES_TOGETHER = new Function<NamespacePolicy, Function<AccessControlDecision, NamespacePolicy>>(){

        public Function<AccessControlDecision, NamespacePolicy> apply(final NamespacePolicy policies) {
            return new Function<AccessControlDecision, NamespacePolicy>(){

                public NamespacePolicy apply(AccessControlDecision onePolicy) {
                    policies.restrictAccess(onePolicy);
                    return policies;
                }
            };
        }
    };

    public ImmutableList<NamespacePolicy> forNamespace(Namespace ns) {
        ImmutableList.Builder b = ImmutableList.builder();
        NamespaceTrie.Entry<NamespacePolicy> d = this.trie.getDeepest(ns);
        Optional e = Optional.of(d);
        while (e.isPresent()) {
            Optional accessLevels = ((NamespaceTrie.Entry)e.get()).getValue();
            if (accessLevels.isPresent()) {
                b.add(accessLevels.get());
            }
            e = ((NamespaceTrie.Entry)e.get()).getParent();
        }
        return b.build();
    }

    public HumanReadableText getAddenda(ApiElement el) {
        HumanReadableText allAddenda = HumanReadableText.EMPTY;
        Optional<ApiElement> ancestor = Optional.of((Object)el);
        while (ancestor.isPresent()) {
            HumanReadableText addendum = this.addenda.get(ancestor.get());
            if (addendum != null) {
                allAddenda = addendum.concat(allAddenda);
            }
            ancestor = ((ApiElement)ancestor.get()).parent;
        }
        return allAddenda;
    }

    public static Policy fromFence(Fence fence) {
        final Policy policy = new Policy();
        FenceVisitor buildFencesVisitor = new FenceVisitor(){

            @Override
            public void visit(Fence f, ApiElement apiElement) {
                Frenemies frenemies = f.getFrenemies();
                this.addToPolicy((Iterable<Namespace>)frenemies.friends, AccessLevel.ALLOWED, apiElement, HumanReadableText.EMPTY);
                this.addToPolicy((Iterable<Namespace>)frenemies.enemies, AccessLevel.DISALLOWED, apiElement, frenemies.rationale.body);
                if (!frenemies.rationale.addendum.isEmpty()) {
                    this.addAddenda(apiElement, frenemies.rationale.addendum);
                }
            }

            private void addToPolicy(Iterable<Namespace> nss, AccessLevel lvl, ApiElement el, HumanReadableText rationale) {
                AccessControlDecision d = new AccessControlDecision(el, lvl, rationale);
                for (Namespace ns : nss) {
                    policy.trie.put(ns, d);
                }
            }

            private void addAddenda(ApiElement el, HumanReadableText addendum) {
                HumanReadableText old = (HumanReadableText)policy.addenda.get(el);
                if (old == null) {
                    old = HumanReadableText.EMPTY;
                }
                policy.addenda.put(el, old.concat(addendum));
            }
        };
        fence.visit(buildFencesVisitor);
        return policy;
    }

    public String toString() {
        return this.trie.toTree();
    }

    public static final class NamespacePolicy {
        public static final Supplier<NamespacePolicy> EMPTY_SUPPLIER = new Supplier<NamespacePolicy>(){

            public NamespacePolicy get() {
                return new NamespacePolicy();
            }
        };
        private final Map<ApiElement, AccessControlDecision> apiElementToPolicy = Maps.newLinkedHashMap();

        public Optional<AccessControlDecision> accessPolicyForApiElement(ApiElement element) {
            Optional<ApiElement> e = Optional.of((Object)element);
            while (e.isPresent()) {
                ApiElement el = (ApiElement)e.get();
                AccessControlDecision p = this.apiElementToPolicy.get(el);
                if (p != null) {
                    return Optional.of((Object)p);
                }
                e = ((ApiElement)e.get()).parent;
            }
            return Optional.absent();
        }

        AccessControlDecision getAccessPolicy(ApiElement el) {
            return this.apiElementToPolicy.get(el);
        }

        void restrictAccess(AccessControlDecision p) {
            AccessControlDecision newPolicy = (AccessControlDecision)Preconditions.checkNotNull((Object)p);
            ApiElement el = newPolicy.apiElement;
            AccessControlDecision oldPolicy = this.apiElementToPolicy.get(el);
            if (oldPolicy != null) {
                newPolicy = AccessControlDecision.mostRestrictive(oldPolicy, newPolicy);
            }
            this.apiElementToPolicy.put(el, newPolicy);
        }

        @VisibleForTesting
        static NamespacePolicy fromMap(Map<ApiElement, AccessControlDecision> m) {
            NamespacePolicy al = new NamespacePolicy();
            al.apiElementToPolicy.putAll(m);
            return al;
        }

        @VisibleForTesting
        static NamespacePolicy fromAccessLevelMap(Map<ApiElement, AccessLevel> m) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            for (Map.Entry<ApiElement, AccessLevel> e : m.entrySet()) {
                ApiElement k = e.getKey();
                AccessLevel v = e.getValue();
                b.put((Object)k, (Object)new AccessControlDecision(k, v, HumanReadableText.EMPTY));
            }
            return NamespacePolicy.fromMap((Map<ApiElement, AccessControlDecision>)b.build());
        }

        public String toString() {
            return this.apiElementToPolicy.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof NamespacePolicy)) {
                return false;
            }
            NamespacePolicy that = (NamespacePolicy)o;
            return this.apiElementToPolicy.equals(that.apiElementToPolicy);
        }

        public int hashCode() {
            return this.apiElementToPolicy.hashCode();
        }
    }

    public static final class AccessControlDecision {
        public final ApiElement apiElement;
        public final AccessLevel accessLevel;
        public final HumanReadableText rationale;

        AccessControlDecision(ApiElement apiElement, AccessLevel accessLevel, HumanReadableText rationale) {
            this.apiElement = apiElement;
            this.accessLevel = accessLevel;
            this.rationale = rationale;
        }

        public String toString() {
            return "{" + this.apiElement + " " + (Object)((Object)this.accessLevel) + "}";
        }

        public boolean equals(Object o) {
            if (!(o instanceof AccessControlDecision)) {
                return false;
            }
            AccessControlDecision that = (AccessControlDecision)o;
            return this.accessLevel == that.accessLevel && this.apiElement.equals(that.apiElement) && this.rationale.equals(that.rationale);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.accessLevel, this.apiElement, this.rationale});
        }

        static AccessControlDecision mostRestrictive(AccessControlDecision a, AccessControlDecision b) {
            Preconditions.checkArgument((boolean)a.apiElement.equals(b.apiElement));
            AccessLevel mostRestrictiveLevel = AccessLevel.mostRestrictive(a.accessLevel, b.accessLevel);
            HumanReadableText mergedRationale = a.rationale.concatDedupe(b.rationale);
            return new AccessControlDecision(a.apiElement, mostRestrictiveLevel, mergedRationale);
        }
    }
}

