/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Injector;
import com.google.sitebricks.client.Transport;
import com.google.sitebricks.client.TransportException;
import com.google.sitebricks.client.Web;
import com.google.sitebricks.client.WebClient;
import com.google.sitebricks.client.WebResponse;
import com.google.sitebricks.client.WebResponseImpl;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class AHCWebClient<T>
implements WebClient<T> {
    private final String url;
    private final Map<String, String> headers;
    private final Class<T> classTypeToTransport;
    private final AsyncHttpClient httpClient;
    private final Transport transport;
    private final Injector injector;

    public AHCWebClient(Injector injector, Transport transport, Web.Auth authType, String username, String password, String url, Map<String, String> headers, Class<T> classTypeToTransport) {
        this.injector = injector;
        this.url = url;
        this.headers = null == headers ? null : ImmutableMap.copyOf(headers);
        this.classTypeToTransport = classTypeToTransport;
        this.transport = transport;
        AsyncHttpClientConfig.Builder c = new AsyncHttpClientConfig.Builder();
        if (null != authType) {
            Realm.RealmBuilder b = new Realm.RealmBuilder();
            Realm.AuthScheme scheme = authType.equals((Object)Web.Auth.BASIC) ? Realm.AuthScheme.BASIC : Realm.AuthScheme.DIGEST;
            b.setPrincipal(username).setPassword(password).setScheme(scheme);
            c.setRealm(b.build());
        }
        this.httpClient = new AsyncHttpClient(c.build());
    }

    private WebResponse simpleRequest(RequestBuilder requestBuilder) {
        requestBuilder = this.addHeadersToRequestBuilder(requestBuilder);
        try {
            Response r = (Response)this.httpClient.executeRequest(requestBuilder.build()).get();
            return new WebResponseImpl(this.injector, r);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        catch (InterruptedException e) {
            throw new TransportException(e);
        }
        catch (ExecutionException e) {
            throw new TransportException(e);
        }
    }

    private ListenableFuture<WebResponse> simpleAsyncRequest(RequestBuilder requestBuilder, Executor executor) {
        requestBuilder = this.addHeadersToRequestBuilder(requestBuilder);
        try {
            final SettableFuture future = SettableFuture.create();
            final com.ning.http.client.ListenableFuture responseFuture = this.httpClient.executeRequest(requestBuilder.build());
            responseFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        future.set((Object)new WebResponseImpl(AHCWebClient.this.injector, (Response)responseFuture.get()));
                    }
                    catch (InterruptedException e) {
                        throw new TransportException(e);
                    }
                    catch (ExecutionException e) {
                        throw new TransportException(e);
                    }
                }
            }, executor);
            return future;
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private WebResponse request(RequestBuilder requestBuilder, T t) {
        requestBuilder = this.addHeadersToRequestBuilder(requestBuilder);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.transport.out(stream, this.classTypeToTransport, t);
            byte[] outBuffer = stream.toByteArray();
            requestBuilder.setBody(outBuffer);
            Response r = (Response)this.httpClient.executeRequest(requestBuilder.build()).get();
            return new WebResponseImpl(this.injector, r);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        catch (InterruptedException e) {
            throw new TransportException(e);
        }
        catch (ExecutionException e) {
            throw new TransportException(e);
        }
    }

    private ListenableFuture<WebResponse> requestAsync(RequestBuilder requestBuilder, T t, Executor executor) {
        requestBuilder = this.addHeadersToRequestBuilder(requestBuilder);
        try {
            InputStream in;
            final SettableFuture future = SettableFuture.create();
            if (t instanceof InputStream) {
                in = (InputStream)t;
            } else {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.transport.out(stream, this.classTypeToTransport, t);
                in = new ByteArrayInputStream(stream.toByteArray());
            }
            requestBuilder.setBody(in);
            final com.ning.http.client.ListenableFuture responseFuture = this.httpClient.executeRequest(requestBuilder.build());
            responseFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        future.set((Object)new WebResponseImpl(AHCWebClient.this.injector, (Response)responseFuture.get()));
                    }
                    catch (InterruptedException e) {
                        throw new TransportException(e);
                    }
                    catch (ExecutionException e) {
                        throw new TransportException(e);
                    }
                }
            }, executor);
            return future;
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private RequestBuilder addHeadersToRequestBuilder(RequestBuilder requestBuilder) {
        boolean contentTypeOverriddenInHeaders = false;
        if (null != this.headers) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                if (header.getKey().toLowerCase().equals("content-type")) {
                    contentTypeOverriddenInHeaders = true;
                }
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        if (!contentTypeOverriddenInHeaders) {
            requestBuilder.addHeader("Content-Type", this.transport.contentType());
        }
        return requestBuilder;
    }

    @Override
    public WebResponse get() {
        return this.simpleRequest(new RequestBuilder("GET").setUrl(this.url));
    }

    @Override
    public WebResponse post(T t) {
        return this.request(new RequestBuilder("POST").setUrl(this.url), t);
    }

    @Override
    public WebResponse put(T t) {
        return this.request(new RequestBuilder("PUT").setUrl(this.url), t);
    }

    @Override
    public WebResponse patch(T t) {
        return this.request(new RequestBuilder("PATCH").setUrl(this.url), t);
    }

    @Override
    public WebResponse delete() {
        return this.simpleRequest(new RequestBuilder("DELETE").setUrl(this.url));
    }

    @Override
    public ListenableFuture<WebResponse> get(Executor executor) {
        return this.simpleAsyncRequest(new RequestBuilder("GET").setUrl(this.url), executor);
    }

    @Override
    public ListenableFuture<WebResponse> post(T t, Executor executor) {
        return this.requestAsync(new RequestBuilder("POST").setUrl(this.url), t, executor);
    }

    @Override
    public ListenableFuture<WebResponse> put(T t, Executor executor) {
        return this.requestAsync(new RequestBuilder("PUT").setUrl(this.url), t, executor);
    }

    @Override
    public ListenableFuture<WebResponse> patch(T t, Executor executor) {
        return this.requestAsync(new RequestBuilder("PATCH").setUrl(this.url), t, executor);
    }

    @Override
    public ListenableFuture<WebResponse> delete(Executor executor) {
        return this.simpleAsyncRequest(new RequestBuilder("DELETE").setUrl(this.url), executor);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }
}

