/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.client;

import com.google.inject.Injector;
import com.google.sitebricks.client.Transport;
import com.google.sitebricks.client.TransportException;
import com.google.sitebricks.client.WebResponse;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class WebResponseImpl
implements WebResponse {
    private final Injector injector;
    private final Response response;
    private Map<String, String> headers;

    public WebResponseImpl(Injector injector, Response response) {
        this.injector = injector;
        this.response = response;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (null != this.headers) {
            return this.headers;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry header : this.response.getHeaders().entrySet()) {
            for (String value : (List)header.getValue()) {
                headers.put((String)header.getKey(), value);
            }
        }
        this.headers = headers;
        return this.headers;
    }

    @Override
    public <T> WebResponse.ResponseTransportBuilder<T> to(final Class<T> data) {
        return new WebResponse.ResponseTransportBuilder<T>(){

            @Override
            public T using(Class<? extends Transport> transportKey) {
                InputStream in = null;
                try {
                    in = WebResponseImpl.this.response.getResponseBodyAsStream();
                    Object t = ((Transport)WebResponseImpl.this.injector.getInstance(transportKey)).in(in, data);
                    return t;
                }
                catch (IOException e) {
                    throw new TransportException(e);
                }
                finally {
                    try {
                        if (null != in) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(WebResponseImpl.class.getName()).severe("Could not close input stream to in-memory byte array: " + e);
                    }
                }
            }
        };
    }

    @Override
    public int status() {
        return this.response.getStatusCode();
    }

    @Override
    public String toString() {
        try {
            return this.response.getResponseBody();
        }
        catch (IOException e) {
            return "";
        }
    }
}

