/*
 * Decompiled with CFR 0.152.
 */
package com.google.sitebricks.client.transport;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.sitebricks.client.transport.Json;
import com.google.sitebricks.conversion.Converter;
import com.google.sitebricks.conversion.ConverterRegistry;
import com.google.sitebricks.conversion.StandardTypeConverter;
import com.google.sitebricks.conversion.generics.Generics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.CustomDeserializerFactory;
import org.codehaus.jackson.map.deser.StdDeserializerProvider;

@Singleton
public class JacksonJsonTransportWithConverters
extends Json {
    private final ObjectMapper objectMapper;
    private Collection<Class<?>> exceptions = Sets.newHashSet();

    @Inject
    public JacksonJsonTransportWithConverters(ConverterRegistry registry) {
        this.objectMapper = new ObjectMapper();
        CustomDeserializerFactory deserializerFactory = new CustomDeserializerFactory();
        this.exceptions.add(String.class);
        this.exceptions.add(Object.class);
        this.exceptions.addAll(Primitives.allWrapperTypes());
        ArrayListMultimap typeToConverterDirection = ArrayListMultimap.create();
        this.addConverterDirections(registry, true, (Multimap<Type, ConverterDirection>)typeToConverterDirection);
        this.addConverterDirections(registry, false, (Multimap<Type, ConverterDirection>)typeToConverterDirection);
        this.createJacksonDeserializers(deserializerFactory, (Multimap<Type, ConverterDirection>)typeToConverterDirection);
        this.objectMapper.setDeserializerProvider((DeserializerProvider)new StdDeserializerProvider((DeserializerFactory)deserializerFactory));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private void addConverterDirections(ConverterRegistry registry, boolean forward, Multimap<Type, ConverterDirection> typeToConverterDirections) {
        Multimap typeToConverters = forward ? registry.getConvertersByTarget() : registry.getConvertersBySource();
        Set types = typeToConverters.keySet();
        for (Type type : types) {
            if (this.exceptions.contains(type)) continue;
            Collection converters = typeToConverters.get((Object)type);
            for (Converter converter : converters) {
                ConverterDirection converterDirection = new ConverterDirection();
                converterDirection.converter = converter;
                converterDirection.forward = forward;
                typeToConverterDirections.put((Object)type, (Object)converterDirection);
            }
        }
    }

    private void createJacksonDeserializers(CustomDeserializerFactory deserializerFactory, Multimap<Type, ConverterDirection> typeToConverterDirections) {
        Set targetTypes = typeToConverterDirections.keySet();
        for (Type targetType : targetTypes) {
            Collection converterDirections = typeToConverterDirections.get((Object)targetType);
            Class targetClass = Generics.erase((Type)targetType);
            ConvertersDeserializer jds = new ConvertersDeserializer(converterDirections);
            this.typesafeAddMapping(targetClass, jds, deserializerFactory);
        }
    }

    private <T> void typesafeAddMapping(Class<?> type, JsonDeserializer<T> deserializer, CustomDeserializerFactory factory) {
        factory.addSpecificMapping(type, deserializer);
    }

    @Override
    public <T> T in(InputStream in, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(in, type);
    }

    @Override
    public <T> void out(OutputStream out, Class<T> type, T data) {
        try {
            this.objectMapper.writeValue(out, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class ConvertersDeserializer
    extends JsonDeserializer<Object> {
        private final Collection<ConverterDirection> converterDirections;

        public ConvertersDeserializer(Collection<ConverterDirection> converterDirections) {
            this.converterDirections = converterDirections;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object source = this.getSourceObject(jp, ctxt);
            for (ConverterDirection converterDirection : this.converterDirections) {
                Type sourceType = converterDirection.forward ? StandardTypeConverter.sourceType(converterDirection.converter) : StandardTypeConverter.targetType(converterDirection.converter);
                Class converterSourceClass = Generics.erase((Type)sourceType);
                if (!converterSourceClass.isAssignableFrom(source.getClass())) continue;
                return converterDirection.forward ? StandardTypeConverter.typeSafeTo(converterDirection.converter, (Object)source) : StandardTypeConverter.typeSafeFrom(converterDirection.converter, (Object)source);
            }
            throw new IllegalStateException("Cannot convert from " + source);
        }

        private Object getSourceObject(JsonParser jp, DeserializationContext ctxt) throws JsonParseException, IOException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return jp.getLongValue();
            }
            if (t == JsonToken.VALUE_NUMBER_FLOAT) {
                return jp.getDoubleValue();
            }
            if (t == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (t == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (t == JsonToken.VALUE_STRING) {
                return jp.getText();
            }
            throw new IllegalStateException();
        }
    }

    private static class ConverterDirection {
        Converter<?, ?> converter;
        boolean forward;

        private ConverterDirection() {
        }
    }
}

