/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast.expression;

import com.google.summit.ast.Node;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.expression.Expression;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/google/summit/ast/expression/BinaryExpression;", "Lcom/google/summit/ast/expression/Expression;", "left", "opString", "", "right", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Lcom/google/summit/ast/expression/Expression;Ljava/lang/String;Lcom/google/summit/ast/expression/Expression;Lcom/google/summit/ast/SourceLocation;)V", "op", "Lcom/google/summit/ast/expression/BinaryExpression$Operator;", "(Lcom/google/summit/ast/expression/Expression;Lcom/google/summit/ast/expression/BinaryExpression$Operator;Lcom/google/summit/ast/expression/Expression;Lcom/google/summit/ast/SourceLocation;)V", "getLeft", "()Lcom/google/summit/ast/expression/Expression;", "getOp", "()Lcom/google/summit/ast/expression/BinaryExpression$Operator;", "getRight", "getChildren", "", "Lcom/google/summit/ast/Node;", "BinaryExpression", "Operator", "-maven_lib"})
public final class BinaryExpression
extends Expression {
    @NotNull
    public static final BinaryExpression BinaryExpression = new BinaryExpression(null);
    @NotNull
    private final Expression left;
    @NotNull
    private final Operator op;
    @NotNull
    private final Expression right;

    public BinaryExpression(@NotNull Expression left, @NotNull Operator op, @NotNull Expression right, @NotNull SourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        super(loc, null);
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @NotNull
    public final Expression getLeft() {
        return this.left;
    }

    @NotNull
    public final Operator getOp() {
        return this.op;
    }

    @NotNull
    public final Expression getRight() {
        return this.right;
    }

    public BinaryExpression(@NotNull Expression left, @NotNull String opString, @NotNull Expression right, @NotNull SourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)opString, (String)"opString");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this(left, BinaryExpression.toOperator(opString), right, loc);
    }

    @Override
    @NotNull
    public List<Node> getChildren() {
        Object[] objectArray = new Expression[]{this.left, this.right};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/google/summit/ast/expression/BinaryExpression$BinaryExpression;", "", "()V", "toOperator", "Lcom/google/summit/ast/expression/BinaryExpression$Operator;", "str", "", "toString", "op", "-maven_lib"})
    public static final class BinaryExpression {
        private BinaryExpression() {
        }

        @NotNull
        public final Operator toOperator(@NotNull String str) {
            Operator operator;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String string = str.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            switch (string) {
                case "+": {
                    operator = Operator.ADDITION;
                    break;
                }
                case "-": {
                    operator = Operator.SUBTRACTION;
                    break;
                }
                case "*": {
                    operator = Operator.MULTIPLICATION;
                    break;
                }
                case "/": {
                    operator = Operator.DIVISION;
                    break;
                }
                case ">": {
                    operator = Operator.GREATER_THAN;
                    break;
                }
                case ">=": {
                    operator = Operator.GREATER_THAN_OR_EQUAL;
                    break;
                }
                case "<": {
                    operator = Operator.LESS_THAN;
                    break;
                }
                case "<=": {
                    operator = Operator.LESS_THAN_OR_EQUAL;
                    break;
                }
                case "==": {
                    operator = Operator.EQUAL;
                    break;
                }
                case "!=": {
                    operator = Operator.NOT_EQUAL;
                    break;
                }
                case "<>": {
                    operator = Operator.ALTERNATIVE_NOT_EQUAL;
                    break;
                }
                case "===": {
                    operator = Operator.EXACTLY_EQUAL;
                    break;
                }
                case "!==": {
                    operator = Operator.EXACTLY_NOT_EQUAL;
                    break;
                }
                case "instanceof": {
                    operator = Operator.INSTANCEOF;
                    break;
                }
                case "<<": {
                    operator = Operator.LEFT_SHIFT;
                    break;
                }
                case ">>": {
                    operator = Operator.RIGHT_SHIFT_SIGNED;
                    break;
                }
                case ">>>": {
                    operator = Operator.RIGHT_SHIFT_UNSIGNED;
                    break;
                }
                case "&": {
                    operator = Operator.BITWISE_AND;
                    break;
                }
                case "|": {
                    operator = Operator.BITWISE_OR;
                    break;
                }
                case "^": {
                    operator = Operator.BITWISE_XOR;
                    break;
                }
                case "&&": {
                    operator = Operator.LOGICAL_AND;
                    break;
                }
                case "||": {
                    operator = Operator.LOGICAL_OR;
                    break;
                }
                case "??": {
                    operator = Operator.NULL_COALESCING;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator '" + str + '\'');
                }
            }
            return operator;
        }

        @NotNull
        public final String toString(@NotNull Operator op) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
            switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
                case 1: {
                    string = "+";
                    break;
                }
                case 2: {
                    string = "-";
                    break;
                }
                case 3: {
                    string = "*";
                    break;
                }
                case 4: {
                    string = "/";
                    break;
                }
                case 5: {
                    string = ">";
                    break;
                }
                case 6: {
                    string = ">=";
                    break;
                }
                case 7: {
                    string = "<";
                    break;
                }
                case 8: {
                    string = "<=";
                    break;
                }
                case 9: {
                    string = "==";
                    break;
                }
                case 10: {
                    string = "!=";
                    break;
                }
                case 11: {
                    string = "<>";
                    break;
                }
                case 12: {
                    string = "===";
                    break;
                }
                case 13: {
                    string = "!==";
                    break;
                }
                case 14: {
                    string = "instanceof";
                    break;
                }
                case 15: {
                    string = "<<";
                    break;
                }
                case 16: {
                    string = ">>";
                    break;
                }
                case 17: {
                    string = ">>>";
                    break;
                }
                case 18: {
                    string = "&";
                    break;
                }
                case 19: {
                    string = "|";
                    break;
                }
                case 20: {
                    string = "^";
                    break;
                }
                case 21: {
                    string = "&&";
                    break;
                }
                case 22: {
                    string = "||";
                    break;
                }
                case 23: {
                    string = "??";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public /* synthetic */ BinaryExpression(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Operator.values().length];
                try {
                    nArray[Operator.ADDITION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.SUBTRACTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.MULTIPLICATION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.DIVISION.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.GREATER_THAN.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.GREATER_THAN_OR_EQUAL.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.LESS_THAN.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.LESS_THAN_OR_EQUAL.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.EQUAL.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.NOT_EQUAL.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.ALTERNATIVE_NOT_EQUAL.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.EXACTLY_EQUAL.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.EXACTLY_NOT_EQUAL.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.INSTANCEOF.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.LEFT_SHIFT.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.RIGHT_SHIFT_SIGNED.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.RIGHT_SHIFT_UNSIGNED.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.BITWISE_AND.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.BITWISE_OR.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.BITWISE_XOR.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.LOGICAL_AND.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.LOGICAL_OR.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Operator.NULL_COALESCING.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0019\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/google/summit/ast/expression/BinaryExpression$Operator;", "", "(Ljava/lang/String;I)V", "ADDITION", "SUBTRACTION", "MULTIPLICATION", "DIVISION", "GREATER_THAN_OR_EQUAL", "GREATER_THAN", "LESS_THAN", "LESS_THAN_OR_EQUAL", "EQUAL", "NOT_EQUAL", "ALTERNATIVE_NOT_EQUAL", "EXACTLY_EQUAL", "EXACTLY_NOT_EQUAL", "INSTANCEOF", "LEFT_SHIFT", "RIGHT_SHIFT_SIGNED", "RIGHT_SHIFT_UNSIGNED", "BITWISE_AND", "BITWISE_OR", "BITWISE_XOR", "LOGICAL_AND", "LOGICAL_OR", "NULL_COALESCING", "-maven_lib"})
    public static final class Operator
    extends Enum<Operator> {
        public static final /* enum */ Operator ADDITION = new Operator();
        public static final /* enum */ Operator SUBTRACTION = new Operator();
        public static final /* enum */ Operator MULTIPLICATION = new Operator();
        public static final /* enum */ Operator DIVISION = new Operator();
        public static final /* enum */ Operator GREATER_THAN_OR_EQUAL = new Operator();
        public static final /* enum */ Operator GREATER_THAN = new Operator();
        public static final /* enum */ Operator LESS_THAN = new Operator();
        public static final /* enum */ Operator LESS_THAN_OR_EQUAL = new Operator();
        public static final /* enum */ Operator EQUAL = new Operator();
        public static final /* enum */ Operator NOT_EQUAL = new Operator();
        public static final /* enum */ Operator ALTERNATIVE_NOT_EQUAL = new Operator();
        public static final /* enum */ Operator EXACTLY_EQUAL = new Operator();
        public static final /* enum */ Operator EXACTLY_NOT_EQUAL = new Operator();
        public static final /* enum */ Operator INSTANCEOF = new Operator();
        public static final /* enum */ Operator LEFT_SHIFT = new Operator();
        public static final /* enum */ Operator RIGHT_SHIFT_SIGNED = new Operator();
        public static final /* enum */ Operator RIGHT_SHIFT_UNSIGNED = new Operator();
        public static final /* enum */ Operator BITWISE_AND = new Operator();
        public static final /* enum */ Operator BITWISE_OR = new Operator();
        public static final /* enum */ Operator BITWISE_XOR = new Operator();
        public static final /* enum */ Operator LOGICAL_AND = new Operator();
        public static final /* enum */ Operator LOGICAL_OR = new Operator();
        public static final /* enum */ Operator NULL_COALESCING = new Operator();
        private static final /* synthetic */ Operator[] $VALUES;

        public static Operator[] values() {
            return (Operator[])$VALUES.clone();
        }

        public static Operator valueOf(String value) {
            return Enum.valueOf(Operator.class, value);
        }

        static {
            $VALUES = operatorArray = new Operator[]{Operator.ADDITION, Operator.SUBTRACTION, Operator.MULTIPLICATION, Operator.DIVISION, Operator.GREATER_THAN_OR_EQUAL, Operator.GREATER_THAN, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL, Operator.EQUAL, Operator.NOT_EQUAL, Operator.ALTERNATIVE_NOT_EQUAL, Operator.EXACTLY_EQUAL, Operator.EXACTLY_NOT_EQUAL, Operator.INSTANCEOF, Operator.LEFT_SHIFT, Operator.RIGHT_SHIFT_SIGNED, Operator.RIGHT_SHIFT_UNSIGNED, Operator.BITWISE_AND, Operator.BITWISE_OR, Operator.BITWISE_XOR, Operator.LOGICAL_AND, Operator.LOGICAL_OR, Operator.NULL_COALESCING};
        }
    }
}

