/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast.expression;

import com.google.summit.ast.Node;
import com.google.summit.ast.PrintableAsCodeString;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.expression.Expression;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0007\t\n\u000b\f\r\u000e\u000fB\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u0082\u0001\u0007\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression;", "Lcom/google/summit/ast/expression/Expression;", "Lcom/google/summit/ast/PrintableAsCodeString;", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Lcom/google/summit/ast/SourceLocation;)V", "getChildren", "", "Lcom/google/summit/ast/Node;", "BooleanVal", "DecimalVal", "DoubleVal", "IntegerVal", "LongVal", "NullVal", "StringVal", "Lcom/google/summit/ast/expression/LiteralExpression$BooleanVal;", "Lcom/google/summit/ast/expression/LiteralExpression$DecimalVal;", "Lcom/google/summit/ast/expression/LiteralExpression$DoubleVal;", "Lcom/google/summit/ast/expression/LiteralExpression$IntegerVal;", "Lcom/google/summit/ast/expression/LiteralExpression$LongVal;", "Lcom/google/summit/ast/expression/LiteralExpression$NullVal;", "Lcom/google/summit/ast/expression/LiteralExpression$StringVal;", "-maven_lib"})
public abstract class LiteralExpression
extends Expression
implements PrintableAsCodeString {
    private LiteralExpression(SourceLocation loc) {
        super(loc, null);
    }

    @Override
    @NotNull
    public List<Node> getChildren() {
        return CollectionsKt.emptyList();
    }

    public /* synthetic */ LiteralExpression(SourceLocation loc, DefaultConstructorMarker $constructor_marker) {
        this(loc);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$BooleanVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "", "loc", "Lcom/google/summit/ast/SourceLocation;", "(ZLcom/google/summit/ast/SourceLocation;)V", "getValue", "()Z", "asCodeString", "", "-maven_lib"})
    public static final class BooleanVal
    extends LiteralExpression {
        private final boolean value;

        public BooleanVal(boolean value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        public final boolean getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$DecimalVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "Ljava/math/BigDecimal;", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Ljava/math/BigDecimal;Lcom/google/summit/ast/SourceLocation;)V", "getValue", "()Ljava/math/BigDecimal;", "asCodeString", "", "-maven_lib"})
    public static final class DecimalVal
    extends LiteralExpression {
        @NotNull
        private final BigDecimal value;

        public DecimalVal(@NotNull BigDecimal value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        @NotNull
        public final BigDecimal getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            String string = this.value.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$DoubleVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "", "loc", "Lcom/google/summit/ast/SourceLocation;", "(DLcom/google/summit/ast/SourceLocation;)V", "getValue", "()D", "asCodeString", "", "-maven_lib"})
    public static final class DoubleVal
    extends LiteralExpression {
        private final double value;

        public DoubleVal(double value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        public final double getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$IntegerVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "", "loc", "Lcom/google/summit/ast/SourceLocation;", "(ILcom/google/summit/ast/SourceLocation;)V", "getValue", "()I", "asCodeString", "", "-maven_lib"})
    public static final class IntegerVal
    extends LiteralExpression {
        private final int value;

        public IntegerVal(int value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$LongVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "", "loc", "Lcom/google/summit/ast/SourceLocation;", "(JLcom/google/summit/ast/SourceLocation;)V", "getValue", "()J", "asCodeString", "", "-maven_lib"})
    public static final class LongVal
    extends LiteralExpression {
        private final long value;

        public LongVal(long value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        public final long getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$NullVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Lcom/google/summit/ast/SourceLocation;)V", "asCodeString", "", "-maven_lib"})
    public static final class NullVal
    extends LiteralExpression {
        public NullVal(@NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
        }

        @Override
        @NotNull
        public String asCodeString() {
            return "null";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/google/summit/ast/expression/LiteralExpression$StringVal;", "Lcom/google/summit/ast/expression/LiteralExpression;", "value", "", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Ljava/lang/String;Lcom/google/summit/ast/SourceLocation;)V", "getValue", "()Ljava/lang/String;", "asCodeString", "-maven_lib"})
    public static final class StringVal
    extends LiteralExpression {
        @NotNull
        private final String value;

        public StringVal(@NotNull String value, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String asCodeString() {
            return '\'' + this.value + '\'';
        }
    }
}

