/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast.statement;

import com.google.summit.ast.Node;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.TypeRef;
import com.google.summit.ast.declaration.VariableDeclarationGroup;
import com.google.summit.ast.expression.Expression;
import com.google.summit.ast.statement.Statement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/google/summit/ast/statement/SwitchStatement;", "Lcom/google/summit/ast/statement/Statement;", "condition", "Lcom/google/summit/ast/expression/Expression;", "whenClauses", "", "Lcom/google/summit/ast/statement/SwitchStatement$When;", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Lcom/google/summit/ast/expression/Expression;Ljava/util/List;Lcom/google/summit/ast/SourceLocation;)V", "getCondition", "()Lcom/google/summit/ast/expression/Expression;", "getWhenClauses", "()Ljava/util/List;", "getChildren", "Lcom/google/summit/ast/Node;", "When", "WhenElse", "WhenType", "WhenValue", "-maven_lib"})
public final class SwitchStatement
extends Statement {
    @NotNull
    private final Expression condition;
    @NotNull
    private final List<When> whenClauses;

    public SwitchStatement(@NotNull Expression condition, @NotNull List<? extends When> whenClauses, @NotNull SourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(whenClauses, (String)"whenClauses");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        super(loc, null);
        this.condition = condition;
        this.whenClauses = whenClauses;
    }

    @NotNull
    public final Expression getCondition() {
        return this.condition;
    }

    @NotNull
    public final List<When> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    @NotNull
    public List<Node> getChildren() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.condition), (Iterable)this.whenClauses);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/google/summit/ast/statement/SwitchStatement$When;", "Lcom/google/summit/ast/Node;", "statement", "Lcom/google/summit/ast/statement/Statement;", "(Lcom/google/summit/ast/statement/Statement;)V", "getStatement", "()Lcom/google/summit/ast/statement/Statement;", "getSourceLocation", "Lcom/google/summit/ast/SourceLocation;", "Lcom/google/summit/ast/statement/SwitchStatement$WhenElse;", "Lcom/google/summit/ast/statement/SwitchStatement$WhenType;", "Lcom/google/summit/ast/statement/SwitchStatement$WhenValue;", "-maven_lib"})
    public static abstract class When
    extends Node {
        @NotNull
        private final Statement statement;

        private When(Statement statement) {
            this.statement = statement;
        }

        @NotNull
        public final Statement getStatement() {
            return this.statement;
        }

        @Override
        @NotNull
        public SourceLocation getSourceLocation() {
            return SourceLocation.Companion.getUNKNOWN();
        }

        public /* synthetic */ When(Statement statement, DefaultConstructorMarker $constructor_marker) {
            this(statement);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/google/summit/ast/statement/SwitchStatement$WhenElse;", "Lcom/google/summit/ast/statement/SwitchStatement$When;", "statement", "Lcom/google/summit/ast/statement/Statement;", "(Lcom/google/summit/ast/statement/Statement;)V", "getChildren", "", "Lcom/google/summit/ast/Node;", "-maven_lib"})
    public static final class WhenElse
    extends When {
        public WhenElse(@NotNull Statement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            super(statement, null);
        }

        @Override
        @NotNull
        public List<Node> getChildren() {
            return CollectionsKt.listOf((Object)this.getStatement());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/google/summit/ast/statement/SwitchStatement$WhenType;", "Lcom/google/summit/ast/statement/SwitchStatement$When;", "type", "Lcom/google/summit/ast/TypeRef;", "downcast", "Lcom/google/summit/ast/declaration/VariableDeclarationGroup;", "statement", "Lcom/google/summit/ast/statement/Statement;", "(Lcom/google/summit/ast/TypeRef;Lcom/google/summit/ast/declaration/VariableDeclarationGroup;Lcom/google/summit/ast/statement/Statement;)V", "getDowncast", "()Lcom/google/summit/ast/declaration/VariableDeclarationGroup;", "getType", "()Lcom/google/summit/ast/TypeRef;", "getChildren", "", "Lcom/google/summit/ast/Node;", "-maven_lib"})
    public static final class WhenType
    extends When {
        @NotNull
        private final TypeRef type;
        @NotNull
        private final VariableDeclarationGroup downcast;

        public WhenType(@NotNull TypeRef type, @NotNull VariableDeclarationGroup downcast, @NotNull Statement statement) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)downcast, (String)"downcast");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            super(statement, null);
            this.type = type;
            this.downcast = downcast;
        }

        @NotNull
        public final TypeRef getType() {
            return this.type;
        }

        @NotNull
        public final VariableDeclarationGroup getDowncast() {
            return this.downcast;
        }

        @Override
        @NotNull
        public List<Node> getChildren() {
            Object[] objectArray = new Node[]{this.type, this.downcast, this.getStatement()};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/google/summit/ast/statement/SwitchStatement$WhenValue;", "Lcom/google/summit/ast/statement/SwitchStatement$When;", "values", "", "Lcom/google/summit/ast/expression/Expression;", "statement", "Lcom/google/summit/ast/statement/Statement;", "(Ljava/util/List;Lcom/google/summit/ast/statement/Statement;)V", "getValues", "()Ljava/util/List;", "getChildren", "Lcom/google/summit/ast/Node;", "-maven_lib"})
    public static final class WhenValue
    extends When {
        @NotNull
        private final List<Expression> values;

        public WhenValue(@NotNull List<? extends Expression> values, @NotNull Statement statement) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            super(statement, null);
            this.values = values;
        }

        @NotNull
        public final List<Expression> getValues() {
            return this.values;
        }

        @Override
        @NotNull
        public List<Node> getChildren() {
            return CollectionsKt.plus((Collection)this.values, (Iterable)CollectionsKt.listOf((Object)this.getStatement()));
        }
    }
}

