/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast.statement;

import com.google.summit.ast.Node;
import com.google.summit.ast.NodeWithSourceLocation;
import com.google.summit.ast.SourceLocation;
import com.google.summit.ast.declaration.VariableDeclarationGroup;
import com.google.summit.ast.statement.Statement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/google/summit/ast/statement/TryStatement;", "Lcom/google/summit/ast/statement/Statement;", "catchBlocks", "", "Lcom/google/summit/ast/statement/TryStatement$CatchBlock;", "body", "finallyBlock", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Ljava/util/List;Lcom/google/summit/ast/statement/Statement;Lcom/google/summit/ast/statement/Statement;Lcom/google/summit/ast/SourceLocation;)V", "getBody", "()Lcom/google/summit/ast/statement/Statement;", "getCatchBlocks", "()Ljava/util/List;", "getFinallyBlock", "getChildren", "Lcom/google/summit/ast/Node;", "CatchBlock", "-maven_lib"})
public final class TryStatement
extends Statement {
    @NotNull
    private final List<CatchBlock> catchBlocks;
    @NotNull
    private final Statement body;
    @Nullable
    private final Statement finallyBlock;

    public TryStatement(@NotNull List<CatchBlock> catchBlocks, @NotNull Statement body, @Nullable Statement finallyBlock, @NotNull SourceLocation loc) {
        Intrinsics.checkNotNullParameter(catchBlocks, (String)"catchBlocks");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        super(loc, null);
        this.catchBlocks = catchBlocks;
        this.body = body;
        this.finallyBlock = finallyBlock;
    }

    @NotNull
    public final List<CatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    @NotNull
    public final Statement getBody() {
        return this.body;
    }

    @Nullable
    public final Statement getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    @NotNull
    public List<Node> getChildren() {
        Object[] objectArray = new Statement[]{this.body, this.finallyBlock};
        return CollectionsKt.plus((Collection)this.catchBlocks, (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/google/summit/ast/statement/TryStatement$CatchBlock;", "Lcom/google/summit/ast/statement/Statement;", "exception", "Lcom/google/summit/ast/declaration/VariableDeclarationGroup;", "body", "loc", "Lcom/google/summit/ast/SourceLocation;", "(Lcom/google/summit/ast/declaration/VariableDeclarationGroup;Lcom/google/summit/ast/statement/Statement;Lcom/google/summit/ast/SourceLocation;)V", "getBody", "()Lcom/google/summit/ast/statement/Statement;", "getException", "()Lcom/google/summit/ast/declaration/VariableDeclarationGroup;", "getChildren", "", "Lcom/google/summit/ast/Node;", "-maven_lib"})
    public static final class CatchBlock
    extends Statement {
        @NotNull
        private final VariableDeclarationGroup exception;
        @NotNull
        private final Statement body;

        public CatchBlock(@NotNull VariableDeclarationGroup exception, @NotNull Statement body, @NotNull SourceLocation loc) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            super(loc, null);
            this.exception = exception;
            this.body = body;
        }

        @NotNull
        public final VariableDeclarationGroup getException() {
            return this.exception;
        }

        @NotNull
        public final Statement getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public List<Node> getChildren() {
            Object[] objectArray = new NodeWithSourceLocation[]{this.exception, this.body};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

