/*
 * Decompiled with CFR 0.152.
 */
package com.google.summit.ast.traversal;

import com.google.summit.ast.Node;
import com.google.summit.ast.traversal.DfsWalker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/google/summit/ast/traversal/DfsWalker;", "Ljava/util/function/Supplier;", "Lcom/google/summit/ast/traversal/DfsWalker$NodeAndDoneFlag;", "start", "Lcom/google/summit/ast/Node;", "ordering", "Lcom/google/summit/ast/traversal/DfsWalker$Ordering;", "skipBelow", "Lkotlin/Function1;", "", "Lcom/google/summit/ast/traversal/NodePredicate;", "(Lcom/google/summit/ast/Node;Lcom/google/summit/ast/traversal/DfsWalker$Ordering;Lkotlin/jvm/functions/Function1;)V", "getOrdering", "()Lcom/google/summit/ast/traversal/DfsWalker$Ordering;", "getSkipBelow", "()Lkotlin/jvm/functions/Function1;", "stack", "", "Lcom/google/summit/ast/traversal/DfsWalker$NodeAndStatus;", "getStart", "()Lcom/google/summit/ast/Node;", "get", "pushChildrenUnlessSkipped", "", "parent", "stream", "Ljava/util/stream/Stream;", "NodeAndDoneFlag", "NodeAndStatus", "Ordering", "Status", "-maven_lib"})
public final class DfsWalker
implements Supplier<NodeAndDoneFlag> {
    @NotNull
    private final Node start;
    @NotNull
    private final Ordering ordering;
    @NotNull
    private final Function1<Node, Boolean> skipBelow;
    @NotNull
    private final List<NodeAndStatus> stack;

    public DfsWalker(@NotNull Node start, @NotNull Ordering ordering, @NotNull Function1<? super Node, Boolean> skipBelow) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
        Intrinsics.checkNotNullParameter(skipBelow, (String)"skipBelow");
        this.start = start;
        this.ordering = ordering;
        this.skipBelow = skipBelow;
        Object[] objectArray = new NodeAndStatus[]{new NodeAndStatus(this.start, Status.UNVISITED)};
        this.stack = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public /* synthetic */ DfsWalker(Node node, Ordering ordering, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ordering = Ordering.POST_ORDER;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(node, ordering, (Function1<? super Node, Boolean>)function1);
    }

    @NotNull
    public final Node getStart() {
        return this.start;
    }

    @NotNull
    public final Ordering getOrdering() {
        return this.ordering;
    }

    @NotNull
    public final Function1<Node, Boolean> getSkipBelow() {
        return this.skipBelow;
    }

    @NotNull
    public final Stream<Node> stream() {
        Stream<Node> stream2 = Stream.generate(this).takeWhile(stream.1.INSTANCE).map(stream.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"generate(this).takeWhile\u2026it.done }.map { it.node }");
        return stream2;
    }

    /*
     * WARNING - void declaration
     */
    private final void pushChildrenUnlessSkipped(Node parent) {
        if (!((Boolean)this.skipBelow.invoke((Object)parent)).booleanValue()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.asReversed(parent.getChildren());
            List<NodeAndStatus> list = this.stack;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new NodeAndStatus((Node)it, Status.UNVISITED));
            }
            list.addAll((List)destination$iv$iv);
        }
    }

    @Override
    @NotNull
    public NodeAndDoneFlag get() {
        while (!this.stack.isEmpty()) {
            NodeAndStatus element = (NodeAndStatus)CollectionsKt.removeLast(this.stack);
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordering.ordinal()]) {
                case 1: {
                    this.pushChildrenUnlessSkipped(element.getNode());
                    return new NodeAndDoneFlag(element.getNode(), false);
                }
                case 2: {
                    if (element.getStatus() == Status.IN_PROGRESS) {
                        return new NodeAndDoneFlag(element.getNode(), false);
                    }
                    this.stack.add(new NodeAndStatus(element.getNode(), Status.IN_PROGRESS));
                    this.pushChildrenUnlessSkipped(element.getNode());
                }
            }
        }
        return new NodeAndDoneFlag(this.start, true);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/google/summit/ast/traversal/DfsWalker$NodeAndDoneFlag;", "", "node", "Lcom/google/summit/ast/Node;", "done", "", "(Lcom/google/summit/ast/Node;Z)V", "getDone", "()Z", "getNode", "()Lcom/google/summit/ast/Node;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "-maven_lib"})
    public static final class NodeAndDoneFlag {
        @NotNull
        private final Node node;
        private final boolean done;

        public NodeAndDoneFlag(@NotNull Node node, boolean done) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.done = done;
        }

        @NotNull
        public final Node getNode() {
            return this.node;
        }

        public final boolean getDone() {
            return this.done;
        }

        @NotNull
        public final Node component1() {
            return this.node;
        }

        public final boolean component2() {
            return this.done;
        }

        @NotNull
        public final NodeAndDoneFlag copy(@NotNull Node node, boolean done) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new NodeAndDoneFlag(node, done);
        }

        public static /* synthetic */ NodeAndDoneFlag copy$default(NodeAndDoneFlag nodeAndDoneFlag, Node node, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                node = nodeAndDoneFlag.node;
            }
            if ((n & 2) != 0) {
                bl = nodeAndDoneFlag.done;
            }
            return nodeAndDoneFlag.copy(node, bl);
        }

        @NotNull
        public String toString() {
            return "NodeAndDoneFlag(node=" + this.node + ", done=" + this.done + ')';
        }

        public int hashCode() {
            int result = this.node.hashCode();
            int n = this.done ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeAndDoneFlag)) {
                return false;
            }
            NodeAndDoneFlag nodeAndDoneFlag = (NodeAndDoneFlag)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)nodeAndDoneFlag.node)) {
                return false;
            }
            return this.done == nodeAndDoneFlag.done;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/google/summit/ast/traversal/DfsWalker$NodeAndStatus;", "", "node", "Lcom/google/summit/ast/Node;", "status", "Lcom/google/summit/ast/traversal/DfsWalker$Status;", "(Lcom/google/summit/ast/Node;Lcom/google/summit/ast/traversal/DfsWalker$Status;)V", "getNode", "()Lcom/google/summit/ast/Node;", "getStatus", "()Lcom/google/summit/ast/traversal/DfsWalker$Status;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "-maven_lib"})
    private static final class NodeAndStatus {
        @NotNull
        private final Node node;
        @NotNull
        private final Status status;

        public NodeAndStatus(@NotNull Node node, @NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.node = node;
            this.status = status;
        }

        @NotNull
        public final Node getNode() {
            return this.node;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @NotNull
        public final Node component1() {
            return this.node;
        }

        @NotNull
        public final Status component2() {
            return this.status;
        }

        @NotNull
        public final NodeAndStatus copy(@NotNull Node node, @NotNull Status status) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new NodeAndStatus(node, status);
        }

        public static /* synthetic */ NodeAndStatus copy$default(NodeAndStatus nodeAndStatus, Node node, Status status, int n, Object object) {
            if ((n & 1) != 0) {
                node = nodeAndStatus.node;
            }
            if ((n & 2) != 0) {
                status = nodeAndStatus.status;
            }
            return nodeAndStatus.copy(node, status);
        }

        @NotNull
        public String toString() {
            return "NodeAndStatus(node=" + this.node + ", status=" + (Object)((Object)this.status) + ')';
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.status.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeAndStatus)) {
                return false;
            }
            NodeAndStatus nodeAndStatus = (NodeAndStatus)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)nodeAndStatus.node)) {
                return false;
            }
            return this.status == nodeAndStatus.status;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/google/summit/ast/traversal/DfsWalker$Ordering;", "", "(Ljava/lang/String;I)V", "PRE_ORDER", "POST_ORDER", "-maven_lib"})
    public static final class Ordering
    extends Enum<Ordering> {
        public static final /* enum */ Ordering PRE_ORDER = new Ordering();
        public static final /* enum */ Ordering POST_ORDER = new Ordering();
        private static final /* synthetic */ Ordering[] $VALUES;

        public static Ordering[] values() {
            return (Ordering[])$VALUES.clone();
        }

        public static Ordering valueOf(String value) {
            return Enum.valueOf(Ordering.class, value);
        }

        static {
            $VALUES = orderingArray = new Ordering[]{Ordering.PRE_ORDER, Ordering.POST_ORDER};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/google/summit/ast/traversal/DfsWalker$Status;", "", "(Ljava/lang/String;I)V", "UNVISITED", "IN_PROGRESS", "-maven_lib"})
    private static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status UNVISITED = new Status();
        public static final /* enum */ Status IN_PROGRESS = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.UNVISITED, Status.IN_PROGRESS};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Ordering.values().length];
            try {
                nArray[Ordering.PRE_ORDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Ordering.POST_ORDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

